package me.chatgame.uisdk.activity.view;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.GridView;

import java.util.ArrayList;
import java.util.List;

import me.chatgame.mobilecg.activity.view.BaseRelativeLayout;
import me.chatgame.mobilecg.adapter.ViewPagerAdapter;
import me.chatgame.mobilecg.listener.ItemClickListener;
import me.chatgame.mobilecg.views.CustomViewPager;
import me.chatgame.uisdk.R;
import me.chatgame.uisdk.activity.adapter.FunctionMenuPanelAdapter;
import me.chatgame.mobilecg.bean.FunctionMenuData;

/**
 * Created by star on 16/8/2.
 */
public class FunctionMenuView extends BaseRelativeLayout {
    private static int NUMBER_PER_ROW = 4;
    private static int NUMBER_PER_PAGE = 8;

    private CustomViewPager viewPager;
    private ViewPagerAdapter pagerAdapter;
    private List<FunctionMenuData> menuDatas;
    private List<FunctionMenuPanelAdapter> adapters;

    public FunctionMenuView(Context context) {
        super(context);
        init();
    }

    public FunctionMenuView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public FunctionMenuView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
    }

    private void init() {
        inflate(getContext(), R.layout.handwin_function_menu_view, this);
        setBackgroundResource(R.color.handwin_A4);

        viewPager = (CustomViewPager) findViewById(R.id.handwin_pager_menu_panel);
        pagerAdapter = ViewPagerAdapter.getInstance_();
        pagerAdapter.init();
        viewPager.setAdapter(pagerAdapter);

    }

    /**
     * Configure function menus
     * @param datas function menu datas to configure
     * @param clickListener click listener to call back
     */
    public void configMenuDatas(List<FunctionMenuData> datas, ItemClickListener<FunctionMenuData> clickListener) {
        this.menuDatas = datas;
        if (menuDatas == null) {
            return;
        }

        int pageNumber = (int) Math.ceil(menuDatas.size() * 1.0f / NUMBER_PER_PAGE);
        List<View> pageViews = new ArrayList<>(pageNumber);
        adapters = new ArrayList<>(pageNumber);
        for (int i = 0; i < pageNumber; i++) {
            GridView gridView = createGridView();
            int start = i * NUMBER_PER_PAGE;
            int end = start + NUMBER_PER_PAGE;
            if (end > menuDatas.size()) {
                end = menuDatas.size();
            }
            List<FunctionMenuData> pageDatas = menuDatas.subList(start, end);
            FunctionMenuPanelAdapter functionMenuPanelAdapter = new FunctionMenuPanelAdapter(getContext());
            functionMenuPanelAdapter.setClickListener(clickListener);
            functionMenuPanelAdapter.addAll(pageDatas);
            gridView.setAdapter(functionMenuPanelAdapter);
            pageViews.add(gridView);

            adapters.add(functionMenuPanelAdapter);
        }

        pagerAdapter.removeAll();
        pagerAdapter.addAll(pageViews);

    }

    /**
     * Enable specified function menus by menu codes
     * @param menuCodes
     */
    public void enableMenus(int... menuCodes) {
        setMenusDisabled(false, menuCodes);
    }

    /**
     * Disable spceified function menus by menu codes
     * @param menuCodes
     */
    public void disableMenus(int... menuCodes) {
        setMenusDisabled(true, menuCodes);
    }

    private void setMenusDisabled(boolean disable, int... menuCodes) {
        if (menuDatas == null || menuDatas.size() == 0 || menuCodes == null || menuCodes.length == 0) {
            return;
        }

        for (FunctionMenuData menuData : menuDatas) {
            for (int menuCode : menuCodes) {
                if (menuData.getCode() == menuCode) {
                    menuData.setDisable(disable);
                }
            }
        }

        refreshUI();
    }

    /**
     * Refresh UI - notify data set changed for all adapters
     */
    public void refreshUI() {
        if (adapters != null) {
            for (FunctionMenuPanelAdapter adapter : adapters) {
                adapter.notifyDataSetChanged();
            }
        }
    }

    private GridView createGridView() {
        GridView gridView = new GridView(getContext());
        gridView.setNumColumns(NUMBER_PER_ROW);
        gridView.setVerticalSpacing(getResources().getDimensionPixelSize(R.dimen.handwin_function_gridview_v_space));
        gridView.setHorizontalSpacing(getResources().getDimensionPixelSize(R.dimen.handwin_function_gridview_h_space));
        gridView.setSelector(new ColorDrawable(Color.TRANSPARENT));
        gridView.setCacheColorHint(Color.TRANSPARENT);
        int paddingTop = getResources().getDimensionPixelSize(R.dimen.handwin_function_gridview_padding_top);
        int paddingLeft = getResources().getDimensionPixelSize(R.dimen.handwin_function_gridview_padding_left);
        gridView.setPadding(paddingLeft, paddingTop, paddingLeft, paddingTop);
        return gridView;
    }

}
