package me.chatgame.uisdk.activity.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.StateListDrawable;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.GridView;
import android.widget.PopupWindow;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.facebook.drawee.drawable.ScalingUtils;
import com.facebook.drawee.generic.GenericDraweeHierarchy;
import com.facebook.drawee.generic.GenericDraweeHierarchyBuilder;

import java.util.ArrayList;
import java.util.List;

import me.chatgame.mobilecg.adapter.FaceGridAdapter;
import me.chatgame.mobilecg.adapter.FacePagerAdapter;
import me.chatgame.mobilecg.adapter.FaceSwitchAdapter;
import me.chatgame.mobilecg.handler.FileHandler;
import me.chatgame.mobilecg.handler.interfaces.IFileHandler;
import me.chatgame.mobilecg.listener.OnPageChangeListenerAdapter;
import me.chatgame.mobilecg.model.FaceSwitch;
import me.chatgame.mobilecg.sdk.CGSDKClientImpl;
import me.chatgame.mobilecg.sdk.EmoticonHandler;
import me.chatgame.mobilecg.sdk.EmoticonHandler.EmoticonData;
import me.chatgame.mobilecg.sdk.EmoticonHandler.EmoticonTab;
import me.chatgame.mobilecg.sdk.EmoticonHandler.GifEmotionData;
import me.chatgame.mobilecg.sdk.EmoticonHandler.SmallEmotionData;
import me.chatgame.mobilecg.util.FaceUtils;
import me.chatgame.mobilecg.util.ImageUtils;
import me.chatgame.mobilecg.util.Utils;
import me.chatgame.mobilecg.util.interfaces.IFaceUtils;
import me.chatgame.mobilecg.util.interfaces.IImageUtils;
import me.chatgame.mobilecg.views.CGImageView;
import me.chatgame.uisdk.R;

/**
 * Created by star on 15/11/3.
 */
public class EmojiPanel extends RelativeLayout {
    private static final String SMALL_EMOJI = "small_emo";
    private static final String GIF_EMOJI = "gif";

    private static final int SMALL_EMOJI_NUMBER_PER_PAGE = 20;
    private static final int GIF_NUMBER_PER_PAGE = 8;

    public interface DynamicEmojiSelectListener {
        void onDynamicEmojiSelected(GifEmotionData gifEmotionData);
    }

    RecyclerView listFaceSwitch;
    RadioGroup groupIndicator;
    ViewPager pagerFaces;

    FaceSwitchAdapter switchAdapter;
    IFaceUtils faceUtils;
    IImageUtils imageUtils;
    IFileHandler fileHandler;

    private LayoutInflater layoutInflater;
    private LinearLayoutManager layoutManagerFace;
    private PopupWindow preViewGifpopupWindow;
    private ArrayList<RadioButton> indiBtns;
    private SparseArray<FacePagerAdapter> facePagerAdapterSparseArray;
    private DynamicEmojiSelectListener dynamicEmojiSelectListener;

    private EditText editChat;

    private boolean needInit = true;
    private boolean isSendingGif = false;

    protected long preClickTime;

    private boolean alreadyInflated_ = false;

    public EmojiPanel(Context context) {
        super(context);
        init_();
    }

    public EmojiPanel(Context context, AttributeSet attrs) {
        super(context, attrs);
        init_();
    }

    public EmojiPanel(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init_();
    }

    public static EmojiPanel build(Context context) {
        EmojiPanel instance = new EmojiPanel(context);
        instance.onFinishInflate();
        return instance;
    }

    /**
     * The mAlreadyInflated_ hack is needed because of an Android bug
     * which leads to infinite calls of onFinishInflate()
     * when inflating a layout with a parent and using
     * the <merge /> tag.
     *
     */
    @Override
    public void onFinishInflate() {
        if (!alreadyInflated_) {
            alreadyInflated_ = true;
            inflate(getContext(), R.layout.handwin_layout_chat_face, this);
            onViewChanged(this);
        }
        super.onFinishInflate();
    }

    private void init_() {
    }

    public static EmojiPanel build(Context context, AttributeSet attrs) {
        EmojiPanel instance = new EmojiPanel(context, attrs);
        instance.onFinishInflate();
        return instance;
    }

    public static EmojiPanel build(Context context, AttributeSet attrs, int defStyleAttr) {
        EmojiPanel instance = new EmojiPanel(context, attrs, defStyleAttr);
        instance.onFinishInflate();
        return instance;
    }

    public void onViewChanged(View hasViews) {
        listFaceSwitch = ((RecyclerView) hasViews.findViewById(R.id.list_face_switch));
        pagerFaces = ((ViewPager) hasViews.findViewById(R.id.pager_faces));
        groupIndicator = ((RadioGroup) hasViews.findViewById(R.id.group_indicator));
        afterViews();
    }



    public void setEditText(EditText editChat) {
        this.editChat = editChat;
    }

    public void setDynamicEmojiSelectListener(DynamicEmojiSelectListener dynamicEmojiSelectListener) {
        this.dynamicEmojiSelectListener = dynamicEmojiSelectListener;
    }

    public void afterViews() {
        fileHandler = FileHandler.getInstance_(getContext()) ;
        imageUtils = ImageUtils.getInstance_(getContext()) ;
        faceUtils = FaceUtils.getInstance_(getContext()) ;
        switchAdapter = FaceSwitchAdapter.getInstance_(getContext()) ;

        setBackgroundResource(R.color.handwin_A4);
        layoutInflater = LayoutInflater.from(this.getContext());
        facePagerAdapterSparseArray = new SparseArray<>();
    }

    /**
     * 初始化表情分类
     */
    public void initEmojiPanel() {
        if (!needInit) {
            return;
        }

        switchAdapter.init((parent, view, position, id) -> {
            FaceSwitch faceSwitch = switchAdapter.getItem(position);
            switchAdapter.changeSelected(position);
            fillFaceData(faceSwitch, position);
        });
        layoutManagerFace = new LinearLayoutManager(this.getContext(),
                LinearLayoutManager.HORIZONTAL, false);
        listFaceSwitch.setLayoutManager(layoutManagerFace);
        listFaceSwitch.setAdapter(switchAdapter);

        ArrayList<FaceSwitch> temps = new ArrayList<FaceSwitch>();

        EmoticonHandler emoticonHandler = CGSDKClientImpl.getInternalInstance().getEmoticonHandler();
        boolean addDefaultSmallEmoji = true;
        if (emoticonHandler != null) {
            List<EmoticonTab<SmallEmotionData>> emojiTabs = emoticonHandler.getSmallEmoticons();
            int index = 0;
            if (emojiTabs != null && emojiTabs.size() > 0) {
                addDefaultSmallEmoji = false;
                for (EmoticonTab emojiTab : emojiTabs) {
                    temps.add(new FaceSwitch(index, SMALL_EMOJI, emojiTab, false));
                    index++;
                }
            }
            List<EmoticonTab<GifEmotionData>> gifTabs = emoticonHandler.getGifEmoticons();
            if (gifTabs != null && gifTabs.size() > 0) {
                index = addDefaultSmallEmoji ? 1 : index;
                for (EmoticonTab gifTab : gifTabs) {
                    temps.add(new FaceSwitch(index, GIF_EMOJI, gifTab, false));
                    index++;
                }
            }
        }

        if (addDefaultSmallEmoji) {
            temps.add(0, new FaceSwitch(0, SMALL_EMOJI, createDefaultEmojiTab(), false));
        }
        FaceSwitch firstTab = temps.get(0);
        firstTab.setSelect(true);

        switchAdapter.setDatas(temps);

        fillFaceData(firstTab, 0);

        needInit = false;
    }

    private EmoticonTab createDefaultEmojiTab() {
        EmoticonTab tab = new EmoticonTab();
        tab.setTabIconResId(R.drawable.handwin_ico_face_static);
        List<EmoticonData> emoticonDatas = new ArrayList<>();

        String[] names = this.getResources()
                .getStringArray(R.array.handwin_faces_alias);
        for (String name : names) {
            emoticonDatas.add(new SmallEmotionData(name, null));
        }
        tab.setEmoticonDatas(emoticonDatas);
        return tab;
    }

    /**
     * 填充表情数据
     */
    private void fillFaceData(FaceSwitch faceSwitch, int switchId) {
        boolean isStatic = TextUtils.equals(faceSwitch.getName(), SMALL_EMOJI);
        FacePagerAdapter adapter = facePagerAdapterSparseArray.get(switchId);
        if (adapter == null) {
            EmoticonTab<? extends EmoticonData> tab = faceSwitch.getTab();
            List<? extends EmoticonData> faceDatas = null;
            if (tab != null) {
                faceDatas = tab.getEmoticonDatas();
            }
            if (faceDatas == null) {
                faceDatas = new ArrayList<>();
            }

            int sss = 0;
            if (isStatic) {
                sss = SMALL_EMOJI_NUMBER_PER_PAGE;
            } else {
                sss = GIF_NUMBER_PER_PAGE;
            }

            ArrayList<View> views = new ArrayList<View>();
            int dataSize = faceDatas.size();
            int page = 0;
            if (dataSize % sss == 0) {
                page = dataSize / sss;
            } else {
                page = dataSize / sss + 1;
            }

            List<EmoticonData> temp;
            int p;

            for (int i = 0; i < page; i++) {
                temp = new ArrayList<>();
                for (int j = 0; j < sss; j++) {
                    p = i * sss + j;
                    if (p < dataSize) {
                        temp.add(faceDatas.get(p));
                    }
                }
                views.add(addOnePager(temp, isStatic));
                temp.clear();
            }
            adapter = new FacePagerAdapter();
            adapter.removeAll();
            adapter.addAll(views);
            facePagerAdapterSparseArray.put(switchId, adapter);
        }
        pagerFaces.removeAllViews();
        pagerFaces.setAdapter(adapter);

        final int viewSize = adapter.getCount();
        if (viewSize > 1) {
            indiBtns = new ArrayList<>();
            groupIndicator.setVisibility(View.VISIBLE);
            fillIndicator(indiBtns, viewSize);
        } else {
            groupIndicator.setVisibility(View.GONE);
        }
        pagerFaces.clearOnPageChangeListeners();
        pagerFaces.addOnPageChangeListener(new OnPageChangeListenerAdapter() {
            @Override
            public void onPageSelected(int page) {
                if (viewSize > 1) {
                    indiBtns.get(page).setChecked(true);
                }
            }

            @Override
            public void onPageScrolled(int position, float positionOffset,
                                       int positionOffsetPixels) {
                dismissPreViewGifpopupWindow();
            }
        });
        if (viewSize > 1) {
            indiBtns.get(0).setChecked(true);
        }
    }

    @SuppressLint({"InflateParams", "ClickableViewAccessibility"})
    private View addOnePager(List<EmoticonData> datas, final boolean isStatic) {
        View v = layoutInflater.inflate(R.layout.handwin_item_faces, null);
        GridView grid = (GridView) v.findViewById(R.id.grid_faces);
        grid.setSelector(R.drawable.handwin_selector_emoji_grid_item_bg);
        if (isStatic) {
            grid.setNumColumns(7);
        } else {
            grid.setNumColumns(4);
        }
        final FaceGridAdapter adapter = FaceGridAdapter.getInstance_(this
                .getContext());
        adapter.init(isStatic);
        grid.setAdapter(adapter);
        adapter.removeAll();
        adapter.addAll(datas);
        grid.setOnItemClickListener((parent, view, position, id) -> {
            List<EmoticonData> faces = adapter.getAllDatas();
            String alias = null;
            if (isStatic) {
                // 发送静态表情
                Object tag = view.getTag();
                if (tag instanceof String && TextUtils.equals((CharSequence) tag, "Del")) {
                    // delete event
                    BaseSendEditorView.deleteEmojiOrCharInEditText(editChat);
                } else if (tag instanceof SmallEmotionData) {
                    SmallEmotionData data = (SmallEmotionData) tag;
                    alias = data.getName();
//                    // 发送特殊含义表情，追加字符串
//                    if (alias.equals(getFaceNames()[0])) {
//                        alias = alias
//                                + " "
//                                + getContext().getString(
//                                R.string.handwin_tips_video_icu) + " ";
//                    }
                    addOneFaceText(alias);
                }

            } else {
                // 发送动态表情
                if (isSendingGif) {
                    Utils.debug("isSendingGif return ...");
                    return;
                }
                isSendingGif = true;
                EmoticonData emoticonData = faces.get(position);
                if (dynamicEmojiSelectListener != null && emoticonData instanceof GifEmotionData) {
                    dynamicEmojiSelectListener.onDynamicEmojiSelected((GifEmotionData) emoticonData);
                }
                // 延迟300ms后，可以发送下一个
                postDelayed(() -> isSendingGif = false, 300);
                dismissPreViewGifpopupWindow();
            }
        });
        grid.setOnItemLongClickListener((parent, view, position, id) -> {
            Object data = adapter.getItem(position);
            if (data instanceof SmallEmotionData) {
                previewEmoji(((SmallEmotionData)data).getName(), view);
            } else if (data instanceof GifEmotionData){
                GifEmotionData gifEmotionData = (GifEmotionData) data;
                // 预览该动态表情
                previewGif(gifEmotionData.getUrl(), view);
            }
            return true;
        });
        grid.setOnTouchListener((v1, event) -> {
            if (event.getAction() == MotionEvent.ACTION_UP) {
                dismissPreViewGifpopupWindow();
            }
            return false;
        });
        return v;
    }

    /**
     * 填充表情指示器
     *
     * @param btns
     * @param size
     */
    private void fillIndicator(ArrayList<RadioButton> btns, int size) {
        groupIndicator.removeAllViews();
        RadioButton btn;
        int width;
        for (int i = 0; i < size; i++) {
            btn = new RadioButton(this.getContext());
            imageUtils.setBackgroundResShape(btn,
                    R.drawable.handwin_selector_check_indi);
            btn.setButtonDrawable(new StateListDrawable());
            width = getResources().getDimensionPixelSize(
                    R.dimen.handwin_chat_face_indi_ico_w);
            android.widget.RadioGroup.LayoutParams lp = new android.widget.RadioGroup.LayoutParams(
                    width, width);
            lp.setMargins(width, width, width, width);
            groupIndicator.addView(btn, lp);
            btns.add(btn);
        }
    }

    /**
     * 隐藏弹窗
     */
    private void dismissPreViewGifpopupWindow() {
        if (preViewGifpopupWindow != null && preViewGifpopupWindow.isShowing()) {
            preViewGifpopupWindow.dismiss();
            preViewGifpopupWindow = null;
        }
    }

    /**
     * 添加一个表情别名
     *
     * @param alias
     */
    protected void addOneFaceText(String alias) {
        String str = editChat.getText().toString();
        int start = editChat.getSelectionStart();
        int end = editChat.getSelectionEnd();
        str = str.substring(0, start) + alias + str.substring(end);
        editChat.setText(str);
        editChat.setSelection(start + alias.length());
    }

    /**
     * 长按预览Gif表情
     *
     * @param gifUrl
     * @param view
     */
    protected void previewGif(String gifUrl, View view) {
        int gifW = getResources().getDimensionPixelSize(
                R.dimen.handwin_chat_face_img_gif_w);
        showPreviewWindow(gifUrl, view, gifW, false);
    }

    protected void previewEmoji(String emojiKey, View view) {
        int gifW = getResources().getDimensionPixelSize(R.dimen.handwin_chat_face_img_preview_w);
        showPreviewWindow(emojiKey, view, gifW, true);
    }

    private void showPreviewWindow(String gifUrl, View view, int gifViewW, boolean apng) {
        int width = view.getWidth();
        int gifW = gifViewW;
        RelativeLayout outLayout = new RelativeLayout(this.getContext());

        if (apng) {
            View v = LayoutInflater.from(getContext()).inflate(R.layout.handwin_view_emoji_preivew, null);
            TextView textView = (TextView) v.findViewById(R.id.txt_gif_face);
            textView.setText(faceUtils.getFaceTextImage2(gifUrl, textView, true, false, false));
            LayoutParams lpGif = new LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
            outLayout.addView(v, lpGif);
        } else {
            LayoutParams lpGif = new LayoutParams(gifW, (int) (gifW * 1.1));
            lpGif.addRule(RelativeLayout.CENTER_HORIZONTAL);
            GenericDraweeHierarchy hierarchy = GenericDraweeHierarchyBuilder.newInstance(getResources()).setFadeDuration(0)
                    .setActualImageScaleType(ScalingUtils.ScaleType.FIT_CENTER).build();
            CGImageView gifView = new CGImageView(getContext(), hierarchy);
            outLayout.addView(gifView, lpGif);
            gifView.load(gifUrl);
        }
        outLayout.setBackgroundResource(R.drawable.handwin_preview_gif_bg);
        preViewGifpopupWindow = new PopupWindow(this.getContext());
        preViewGifpopupWindow.setContentView(outLayout);
        preViewGifpopupWindow.setWidth(width);
        preViewGifpopupWindow.setHeight((int) (width * 1.1));
        preViewGifpopupWindow.setFocusable(true);
        preViewGifpopupWindow.setBackgroundDrawable(new ColorDrawable(
                Color.TRANSPARENT));
        preViewGifpopupWindow.setOnDismissListener(() -> preClickTime = System.currentTimeMillis());
        int[] location = new int[2];
        view.getLocationInWindow(location);
        int x = location[0];
        int y = location[1] - width;
        preViewGifpopupWindow.showAtLocation(view, Gravity.NO_GRAVITY, x, y);
    }

}
