package me.chatgame.uisdk.activity.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.Rect;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import android.widget.RelativeLayout;
import android.widget.TextView;

import java.io.File;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

import me.chatgame.mobilecg.MainApp;
import me.chatgame.mobilecg.actions.FileSendManager;
import me.chatgame.mobilecg.actions.interfaces.IFileSendManager;
import me.chatgame.mobilecg.activity.view.interfaces.ILiveActivity;
import me.chatgame.mobilecg.call.CallState;
import me.chatgame.mobilecg.constant.RecorderMode;
import me.chatgame.mobilecg.constant.RecorderStatus;
import me.chatgame.mobilecg.handler.CameraHandler;
import me.chatgame.mobilecg.handler.ConfigHandler;
import me.chatgame.mobilecg.handler.FileHandler;
import me.chatgame.mobilecg.handler.SystemStatus;
import me.chatgame.mobilecg.handler.VoipImageHandler;
import me.chatgame.mobilecg.handler.interfaces.ICamera;
import me.chatgame.mobilecg.handler.interfaces.IConfig;
import me.chatgame.mobilecg.handler.interfaces.IFileHandler;
import me.chatgame.mobilecg.handler.interfaces.ISystemStatus;
import me.chatgame.mobilecg.handler.interfaces.IVoipImageHandler;
import me.chatgame.mobilecg.listener.OnVideoRecorderListener;
import me.chatgame.mobilecg.model.ShortVideoType;
import me.chatgame.mobilecg.util.BackgroundExecutor;
import me.chatgame.mobilecg.util.FileUtils;
import me.chatgame.mobilecg.util.ImageUtils;
import me.chatgame.mobilecg.util.UiThreadExecutor;
import me.chatgame.mobilecg.util.Utils;
import me.chatgame.mobilecg.util.interfaces.IFile;
import me.chatgame.mobilecg.util.interfaces.IImageUtils;
import me.chatgame.mobilecg.views.AudioRecordWaveView;
import me.chatgame.mobilecg.views.IconFontTextView;
import me.chatgame.mobilecg.views.ProgressWheel;
import me.chatgame.uisdk.R;
import me.chatgame.voip.VoipAndroid;
import me.chatgame.voip.VoipImage;

/**
 * Created by star on 16/1/5.
 */
public class BaseVideoRecorderView extends BaseRecorderView {

    IconFontTextView btnStart;
    TextView btnCancel;
    TextView sendText;


    ILiveActivity liveActivity;

    ICamera cameraHandler;
    IFileHandler fileHandler;
    IVoipImageHandler voipImageHandler;
    ISystemStatus systemStatus;
    IFileSendManager fileSendManager;
    IFile fileUtils;
	IImageUtils imageUtils;
    IConfig configHandler;

    MainApp app;


    private OnVideoRecorderListener onVideoRecordeListener;
    protected RelativeLayout previewContainer;
    private View recordPreview;
    protected IconFontTextView cameraSwitchBt;
    protected ProgressWheel btnRecordSend;
    protected AudioRecordWaveView waveView;
    protected TextView clickToRecordText;

    private AnimatorSet startButtomZoomAnim;
    private AnimatorSet startButtonRecordStartAnim;
    private String videoFileName;
    protected boolean isFrontCamera = true;
    private long recordStartTime;
    private ScheduledExecutorService executorService;
    private Future timerFuture;
    private boolean needSendVideo;
    private boolean destroyed = false;
    private boolean isPreviewShow = false;
    private String imageFile;
    protected int recorderViewHeight;
    private boolean timeOver = false;

    public BaseVideoRecorderView(Context context) {
        super(context);
        inject();
    }

    public BaseVideoRecorderView(Context context, AttributeSet attrs) {
        super(context, attrs);
        inject();
    }

    public BaseVideoRecorderView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        inject();
    }

    void afterViews() {
        super.afterViews();
        recorderViewHeight = getResources().getDimensionPixelSize(R.dimen.handwin_video_audio_recorder_view_h);
        btnRecordSend = wheelProgress;
        waveView = recordWaveView;
        clickToRecordText = tvStartDeleteRecord;

        btnStart.setText(getRecordButtonIcon());
        btnStart.setBackgroundResource(isBurned ? R.drawable.handwin_recorder_alert_inner_circle : getRecordButtonBgRes());

        btnStart.setOnTouchListener(new OnTouchListener() {
            float x;
            float y;
            boolean isCancelled;
            Rect boundRect = new Rect();

            @Override
            public boolean onTouch(View v, MotionEvent event) {
                x = event.getRawX();
                y = event.getRawY();
//                Utils.debugFormat("[VideoRecorderView] ===touch x: %f, y: %f action: %d", x, y, event.getAction());

                switch (event.getAction()) {
                    case MotionEvent.ACTION_DOWN:
                        isCancelled = false;
                        int[] locs = new int[2];
                        btnRecordSend.getLocationOnScreen(locs);
                        boundRect.left = locs[0];
                        boundRect.top = locs[1];
                        boundRect.right = boundRect.left + btnRecordSend.getWidth();
                        boundRect.bottom = boundRect.top + btnRecordSend.getHeight();
//                        Utils.debugFormat("[VideoRecorderView] === location left: %d top: %d right: %d bottom: %d", locs[0], locs[1], locs[0] + btnRecordSend.getWidth(), locs[1] + btnRecordSend.getHeight());
                        showPrepareTip();
                        onTouchDown();
                        playStartButtonZoomAnimation(true);
                        return true;
                    case MotionEvent.ACTION_MOVE:
                        if (x < boundRect.left || x > boundRect.right || y < boundRect.top || y > boundRect.bottom) {
                            if (!isCancelled && isStatus(RecorderStatus.idle)) {
                                // cancel record
                                resetUI();
                                playStartButtonZoomAnimation(false);
                            }
                            isCancelled = true;
                            return false;
                        } else {
                            return true;
                        }
                    case MotionEvent.ACTION_UP:
                        if (!isCancelled) {
                            startVideoRecording();
                            return true;
                        } else if (isStatus(RecorderStatus.idle)) {
                            resetUI();
                        }
                        break;
                    case MotionEvent.ACTION_CANCEL:
                        if (!isCancelled) {
                            playStartButtonZoomAnimation(false);
                        }
                        if (isStatus(RecorderStatus.idle)) {
                            resetUI();
                        }
                        break;
                }
                return false;
            }
        });
    }

    void inject() {
        app = MainApp.getInstance();
        fileSendManager = FileSendManager.getInstance_(getContext());
        fileUtils = FileUtils.getInstance_(getContext()) ;
        fileHandler = FileHandler.getInstance_(getContext()) ;
        systemStatus = SystemStatus.getInstance_() ;
        cameraHandler = CameraHandler.getInstance_(getContext()) ;
        imageUtils = ImageUtils.getInstance_(getContext()) ;
        voipImageHandler = VoipImageHandler.getInstance_(getContext());
        configHandler= ConfigHandler.getInstance_(getContext());
    }

    @Override
    protected void onTouchDown() {
        resumePreview(true, false);
    }

    void onBtnRecordSendClick() {
        needSendVideo = true;
        stopVideoRecording();
        invokeOnVideoRecordEndDirectly(true, false);
    }

    void onBtnRecordCancelClick() {
        cancelVideoRecording();
        fileSendManager.removeFileBlock(videoFileName);
    }

    protected void playStartButtonZoomAnimation(boolean zoomOut) {
        if (startButtomZoomAnim != null) {
            startButtomZoomAnim.cancel();
            startButtomZoomAnim = null;
        }

        float s1 = zoomOut ? 1f : 1.2f;
        float s2 = zoomOut ? 1.2f : 1f;
        ObjectAnimator zoomOutXAnim = ObjectAnimator.ofFloat(btnStart, View.SCALE_X, s1, s2);
        ObjectAnimator zoomOutYAnim = ObjectAnimator.ofFloat(btnStart, View.SCALE_Y, s1, s2);
        startButtomZoomAnim = new AnimatorSet();
        startButtomZoomAnim.setDuration(200);
        startButtomZoomAnim.setInterpolator(new DecelerateInterpolator());
        startButtomZoomAnim.playTogether(zoomOutXAnim, zoomOutYAnim);
        startButtomZoomAnim.start();
    }

    protected void startVideoRecording() {
        if (!isStatus(RecorderStatus.idle)) {
            return;
        }
        if (!cameraHandler.isActive()) {
            Utils.debug("[VideoRecorderView] camera not started");
            showAlertTips(getResources().getString(R.string.handwin_camera_not_open_pls_wait));
            playStartButtonZoomAnimation(false);
            resetClickToRecordText();
            if (videoAudioRecorderView != null) {
                videoAudioRecorderView.enableBurnCheck(true);
                videoAudioRecorderView.setImgButtonVisiabe(true);
            }
            return;
        }
        Utils.debug("[VideoRecorderView] startVideoRecording");
        setRecorderStatus(RecorderStatus.recording);
        playRecordStartAnimation();
        disableParentTouch();

        if (videoAudioRecorderView != null) {
            videoAudioRecorderView.enableBurnCheck(false);
            videoAudioRecorderView.setImgButtonVisiabe(false);
        }

        videoFileName = fileHandler
                .getCacheDirByType(IFileHandler.CacheDir.VIDEO) + "mv_" + System.currentTimeMillis() + ".ts";
        recordStartTime = System.currentTimeMillis();
        voipAndroidManager.setVideoMessageMaxDuration(MAX_DURATION);
        final String localFileName=videoFileName;
        voipAndroidManager.startRecordingVideoMessage(videoFileName, new VoipAndroid.VideoMsgRecorderCallback() {
            private int blockId = 1;

            @Override
            public void videoMsgRecorderNotify(int code) {
                Utils.debugFormat("[VideoRecorderView] videoMsgRecorderNotify code: %d", code);
                handleMsgRecorderNotify(code);
            }

            @Override
            public void videoMsgData(byte[] data, int len, boolean isFileEnd) {
                if (data != null) {
                    Utils.debugFormat("[VideoRecorderView] videoMsgData data: %d,isFileHeader:%s", data.length, isFileEnd ? "true" : "false");
                    fileSendManager.uploadFileBlock(localFileName, data, len, isFileEnd, blockId++);
                } else {
                    fileSendManager.uploadFileBlock(localFileName, new byte[0], 0, isFileEnd, blockId++);
                }
            }

            @Override
            public void videoMsgFirstFrame(VoipImage image) {
                Utils.debugFormat("[VideoRecorderView] videoMsgFirstFrame userid: %d rotation: %d", image.userId, image.rotation);
                imageFile = fileHandler
                        .getCacheDirByType(IFileHandler.CacheDir.IMAGE) + "mvt_" + System.currentTimeMillis() + ".jpg";
                try {
                    voipImageHandler.convertToImage(imageFile, image);
                    byte[] fileData = fileUtils.readFile(imageFile);
                    fileSendManager.uploadFileBlock(imageFile, fileData, fileData.length, true, 1);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        startTimer();
        cameraHandler.addAudioListenser(this);
    }

    void handleMsgRecorderNotify(final int code) {
        BackgroundExecutor.execute(()->handleMsgRecorderNotify_(code), BackgroundExecutor.ThreadType.CALCULATION);
    }
    void handleMsgRecorderNotify_(final int code) {
        Utils.debugFormat("[VideoRecorderView] handleMsgRecorderNotify code: %d", code);
        if (isStatus(RecorderStatus.recording)) {
            if (code == -4) {
                // reach the max record time
                processRecordTimeOut(false);
            } else if (code < 0) {
                onVideoRecordEnd(false, false);
            }
        }
    }

    @Override
    synchronized void processRecordTimeOut(boolean stopVOIPRecord) {
        Utils.debug("[VideoRecorderView] processRecordTimeOut");
        sendVideoOnTimeOver(stopVOIPRecord);
    }

    void sendVideoOnTimeOver(boolean stopVOIPRecord) {
        if (!timeOver) {
            timeOver = true;
            needSendVideo = true;
            if (stopVOIPRecord) {
                voipAndroidManager.stopRecordingVideoMessage();
            }
            onVideoRecordEnd(true, true);
        }
    }

    private void playRecordStartAnimation() {
        if (cameraSwitchBt != null) {
            animUtils.animFadeView(cameraSwitchBt, false);
        }

        clickToRecordText.setVisibility(View.GONE);
        waveView.setVisibility(View.VISIBLE);
        sendText.setVisibility(View.VISIBLE);
        btnRecordSend.setClickable(true);
        btnRecordSend.setProgress(0);
        waveView.updateCurrTime(0);

        if (startButtonRecordStartAnim != null) {
            startButtonRecordStartAnim.removeAllListeners();
            startButtonRecordStartAnim.cancel();
            startButtonRecordStartAnim = null;
        }

        float s2 = 1.2f;
        float s3 = 0.7f;
        ObjectAnimator zoomInXAnim = ObjectAnimator.ofFloat(btnStart, View.SCALE_X, s2, s3);
        ObjectAnimator zoomInYAnim = ObjectAnimator.ofFloat(btnStart, View.SCALE_Y, s2, s3);
        ObjectAnimator fadeOutAnim = ObjectAnimator.ofFloat(btnStart, View.ALPHA, 1f, 0f);
        startButtonRecordStartAnim = new AnimatorSet();
        startButtonRecordStartAnim.setDuration(200);
        startButtonRecordStartAnim.setInterpolator(new DecelerateInterpolator());
        startButtonRecordStartAnim.playTogether(zoomInXAnim, zoomInYAnim, fadeOutAnim);
        startButtonRecordStartAnim.addListener(new AnimatorListenerAdapter() {
            @Override
            public void onAnimationEnd(Animator animation) {
                if (!isStatus(RecorderStatus.idle)) {
                    btnStart.setVisibility(View.GONE);
                }
            }
        });
        startButtonRecordStartAnim.start();

        float s1 = 0.6f;
        s2 = 1f;
        btnCancel.setScaleX(s1);
        btnCancel.setScaleY(s1);
        btnCancel.setRotation(-60f);
        btnCancel.setAlpha(0f);
        ObjectAnimator zoomOutXAnim = ObjectAnimator.ofFloat(btnCancel, View.SCALE_X, s1, s2);
        ObjectAnimator zoomOutYAnim = ObjectAnimator.ofFloat(btnCancel, View.SCALE_Y, s1, s2);
        ObjectAnimator rotateAnim = ObjectAnimator.ofFloat(btnCancel, View.ROTATION, -60f, 0f);
        ObjectAnimator fadeInAnim = ObjectAnimator.ofFloat(btnCancel, View.ALPHA, 0, 1);
        AnimatorSet cancelBtnAnim = new AnimatorSet();
        cancelBtnAnim.setDuration(200);
        cancelBtnAnim.setStartDelay(100);
        cancelBtnAnim.setInterpolator(new DecelerateInterpolator());
        cancelBtnAnim.playTogether(zoomOutXAnim, zoomOutYAnim, rotateAnim, fadeInAnim);
        cancelBtnAnim.addListener(new AnimatorListenerAdapter() {
            @Override
            public void onAnimationStart(Animator animation) {
                btnCancel.setVisibility(View.VISIBLE);
            }
        });

        cancelBtnAnim.start();

        playRecordPreviewAnimation(true);
    }

    protected void playRecordPreviewAnimation(boolean recordStart) {
        // implemented by sub classes
    }

    void invokeOnVideoRecordEndDirectly(boolean success, boolean reachMaxTime) {
        Utils.debugFormat("[cgtest] onVideoRecordEnd success: %s reachMaxTime: %s", success, reachMaxTime);
        setRecorderStatus(RecorderStatus.idle);
        stopTimer();
        resetUI();
        cameraHandler.removeAudioListener(this);
        if (!success || videoFileName == null) {
            if (!TextUtils.isEmpty(videoFileName)) {
                File file = new File(videoFileName);
                deleteFile(file);
            }
            videoFileName = null;
            return;
        }
        File file = new File(videoFileName);
        if (file.exists()) {
            Utils.debug("[VideoRecorderView] video file exist");
            int duration = voipAndroidManager.getVideoMessageDuration(videoFileName);
            if (duration < 1) {
                showAlertTips(getResources().getString(R.string.handwin_tips_video_record_failed));
                deleteFile(file);
                videoFileName = null;
                return;
            }
            if (needSendVideo) {
                RecorderMode recorderMode = RecorderMode.NORMAL;
                if (videoAudioRecorderView != null) {
                    recorderMode = videoAudioRecorderView.getRecorderMode();
                }
				if (recorderMode != RecorderMode.LOCAL_CONTACT) {
					playSendSound();
				}

				if (recorderMode == RecorderMode.NORMAL
                        || recorderMode == RecorderMode.SHARE) {
                    hidePreviewView(false);
                }

                if (reachMaxTime) {
                    duration = MAX_DURATION;
                }
                duration = duration > 1 ? duration : 1;

                if (onVideoRecordeListener != null) {
                    Utils.debugFormat("[VideoRecorderView] send video - duration: %d file: %s", duration, videoFileName);
                    onVideoRecordeListener.onVideoRecorded(videoFileName, imageFile, duration, isBurned, getVideoType(), isFrontCamera());
                }

            } else {
                deleteFile(file);
            }
        }
        videoFileName = null;
    }

    void onVideoRecordEnd(boolean success, boolean reachMaxTime) {
        UiThreadExecutor.runTask(()->onVideoRecordEnd_(success, reachMaxTime));
    }
    void onVideoRecordEnd_(boolean success, boolean reachMaxTime) {
        invokeOnVideoRecordEndDirectly(success, reachMaxTime);
    }

    protected int getVideoType() {
        return ShortVideoType.NORMAL;
    }

    private void deleteFile(File file) {
        if (file.exists()) {
            File delFile = new File(file.getAbsolutePath() + ".del");
            file.renameTo(delFile);
            delFile.delete();
        }
    }

    private void stopVideoRecording() {
        if (isStatus(RecorderStatus.idle) || isStatus(RecorderStatus.stoping)) {
            return;
        }
        if (isStatus(RecorderStatus.recording)) {
            setRecorderStatus(RecorderStatus.stoping);
        }
        playRecordPreviewAnimation(false);
//        resetRecordView();
        voipAndroidManager.stopRecordingVideoMessage();

        setRecorderStatus(RecorderStatus.idle);
    }

    public void cancelVideoRecording() {
        Utils.debug("[VideoRecorderView] cancelVideoRecording");
        needSendVideo = false;
        stopVideoRecording();
        invokeOnVideoRecordEndDirectly(false, false);
    }

    public void setVideoRecorder(boolean isBurned) {
        // 改变形象 设置video属性
        this.isBurned = isBurned;
        changeAvatar(isBurned);
        configViewColor(isBurned ? getResources().getColor(R.color.handwin_record_alert_color) : getConfigColor());
        btnStart.setBackgroundResource(isBurned ? R.drawable.handwin_recorder_alert_inner_circle : getRecordButtonBgRes());
    }

    protected void changeAvatar(boolean isBurned) {
        // implemented by sub classes
    }

    private synchronized void startTimer() {
        Utils.debug("[VideoRecorderView] startTimer");
        timeOver = false;
        if (executorService == null) {
            executorService = Executors.newSingleThreadScheduledExecutor();
        }
        timerFuture = executorService.scheduleAtFixedRate(() -> {
            if (isStatus(RecorderStatus.recording) && !timeOver) {
                onRecordProgress((int) (System.currentTimeMillis() - recordStartTime));
            }
        }, 0, 10, TimeUnit.MILLISECONDS);
    }

    private synchronized void stopTimer() {
        if (timerFuture != null) {
            Utils.debug("[VideoRecorderView] stopTimer");
            timerFuture.cancel(true);
            timerFuture = null;
        }
    }

    void onRecordProgress(int elapseTime) {
        if (isStatus(RecorderStatus.recording)) {
            elapseTime = elapseTime >= 0 ? elapseTime : 0;
            setRecordProgress(elapseTime);
        }
    }

    protected void resetClickToRecordText() {
        clickToRecordText.setVisibility(View.VISIBLE);
        clickToRecordText.setText(getRecordStartInfoText());
        clickToRecordText.setTextColor(getResources().getColor(R.color.handwin_recorder_title));
    }

    private void resetUI() {
        if (startButtomZoomAnim != null) {
            startButtomZoomAnim.removeAllListeners();
            startButtomZoomAnim.cancel();
            startButtomZoomAnim = null;
        }
        if (startButtonRecordStartAnim != null) {
            startButtonRecordStartAnim.removeAllListeners();
            startButtonRecordStartAnim.cancel();
            startButtonRecordStartAnim = null;
        }

        btnStart.setVisibility(View.VISIBLE);
        btnStart.setAlpha(1);
        btnStart.setScaleX(1);
        btnStart.setScaleY(1);
        btnCancel.setVisibility(View.GONE);
        btnCancel.setScaleX(1);
        btnCancel.setScaleY(1);
        btnCancel.setRotation(0);
        resetClickToRecordText();
        waveView.setVisibility(View.GONE);
        btnRecordSend.setClickable(false);
        btnRecordSend.setProgress(0);
        sendText.setVisibility(View.GONE);

        if (recordPreview != null) {
            recordPreview.setScaleX(1);
            recordPreview.setScaleY(1);
        }
        enableParentTouch();
        if (videoAudioRecorderView != null) {
            videoAudioRecorderView.enableBurnCheck(true);
            videoAudioRecorderView.setImgButtonVisiabe(true);
        }
        if (cameraSwitchBt != null) {
            animUtils.animFadeView(cameraSwitchBt, true);
        }
    }

    public void initPreviewView(OnClickListener clickListener, boolean needShow) {
        destroyed = false;
        if (chatView == null) return;

        if (previewContainer == null) {
            previewContainer = new RelativeLayout(getContext());
            recordPreview = createPreviewView();
            recordPreview.setVisibility(View.INVISIBLE);


            if (needSetContainerPaddingBottom()) {
                previewContainer.setPadding(0, 0, 0, recorderViewHeight);
            }
            int height=(configHandler.getScreenHeight()-recorderViewHeight)*2/3;
            int width=height*3/4;
            previewContainer.addView(recordPreview);
            setPreviewSize(width,height);

            cameraSwitchBt = createCameraSwitchButton();
            if (cameraSwitchBt != null) {
                int w = getResources().getDimensionPixelSize(R.dimen.handwin_video_record_camera_swich_w);
                LayoutParams cameraLp = new LayoutParams(w, w);
                cameraLp.addRule(RelativeLayout.ALIGN_PARENT_RIGHT);
                cameraLp.addRule(RelativeLayout.ALIGN_PARENT_TOP);
                cameraLp.setMargins(0, getResources().getDimensionPixelSize(R.dimen.handwin_video_record_camera_switch_bt_m_t),
                        getResources().getDimensionPixelSize(R.dimen.handwin_video_record_camera_switch_bt_m_l),
                        0);
                previewContainer.addView(cameraSwitchBt, cameraLp);
                cameraSwitchBt.setOnClickListener(v -> switchCamera());
            }

            LayoutParams lp = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT);
            chatView.addView(previewContainer, lp);
            previewContainer.setOnClickListener(clickListener);
            previewContainer.setBackgroundColor(getPreviewContainerColor());

            if (sendEditorView != null) {
                sendEditorView.bringToFront();
            }

            if (needShow) {
                playFadeAinimation(previewContainer, true);
            } else {
                previewContainer.setVisibility(View.INVISIBLE);
            }
        }
    }

    protected boolean needSetContainerPaddingBottom() {
        return true;
    }

    protected View createPreviewView() {
        return new View(getContext());
    }

    protected IconFontTextView createCameraSwitchButton() {
        IconFontTextView iconFontTextView = IconFontTextView.build(getContext());
        iconFontTextView.setText(R.string.handwin_font_img_camera_switch);
        iconFontTextView.setTextColor(getResources().getColorStateList(R.color.handwin_selector_video_record_camera_switch_bt));
        iconFontTextView.setTextSize(TypedValue.COMPLEX_UNIT_PX, getResources().getDimension(R.dimen.handwin_video_record_camera_switch_button_textsize));
        iconFontTextView.setBackgroundResource(R.drawable.handwin_selector_font_background);
        iconFontTextView.setGravity(Gravity.CENTER);
        return iconFontTextView;
    }

    protected int getPreviewContainerColor() {
        return getResources().getColor(R.color.handwin_recorder_preview_bg);
    }

    protected void playFadeAinimation(View view, boolean show) {
        Utils.debugFormat("[CGTEST] playFadeAinimation view : %s show: %s", view, show);
        float s1 = show ? 0 : 1;
        float s2 = show ? 1 : 0;

        view.setVisibility(show ? View.VISIBLE : View.GONE);
        AlphaAnimation alphaAnimation = new AlphaAnimation(s1, s2);
        alphaAnimation.setInterpolator(new LinearInterpolator());
        alphaAnimation.setDuration(show ? 300 : 200);
        view.startAnimation(alphaAnimation);
    }

    /**
     * Do show animation and start camera
     */
    public void showPreviewView(boolean startCamera, boolean forceFrontCamera) {
        // implemented by sub classes
    }

    public void hidePreviewView(boolean stopCamera) {
        // implemented by sub classes
    }

    public void destroyPreviewView(boolean stopCamera) {
        destroyed = true;
        resetUI();
        setIsPreviewShow(false);
        if (chatView == null) return;

        cancelVideoRecording();
        if (stopCamera) {
            stopPreview();
            setIsFrontCamera(true);
        } else {
            if (!isFrontCamera()) {
                switchCamera(true);
            }
        }

        if (previewContainer != null) {
            chatView.removeView(previewContainer);
            previewContainer = null;
            recordPreview = null;
            cameraSwitchBt = null;
        }
        if (executorService != null) {
            executorService.shutdown();
            executorService = null;
        }
    }

    void startPreview(boolean startCamera) {
        if (destroyed || !isPreviewShow() || !startCamera) return;
        cameraHandler.startCamera(null, false, true);
    }

    void stopPreview() {
        cameraHandler.stopCamera(null);
    }

    public void pausePreview(boolean stopCamera) {
        hidePreviewView(stopCamera);
    }

    public void resumePreview(boolean startCamera, boolean forceFrontCamera) {
        Utils.debugFormat("[CGTEST] resume gameVideoPreview - isPreviewShow: %s", isPreviewShow());
        if (previewContainer != null && !isPreviewShow()) {
            playFadeAinimation(previewContainer, true);
        }
        showPreviewView(startCamera, forceFrontCamera);
    }

    public void setOnVideoRecordeListener(OnVideoRecorderListener onVideoRecordeListener) {
        this.onVideoRecordeListener = onVideoRecordeListener;
    }

    @Override
    public void onResume() {
        super.onResume();
        if (!destroyed && isPreviewShow() && !isFrontCamera()) {
            switchCamera(isFrontCamera());
        }
        if (CallState.getInstance().isIdle()) {
            startPreview(true);
        }
    }

    @Override
    public void onPause() {
        super.onPause();
        cancelVideoRecording();
        if (CallState.getInstance().isIdle()) {
            stopPreview();
        }
    }

    public boolean isPreviewShow() {
        return isPreviewShow;
    }

    public void setIsPreviewShow(boolean isPreviewShow) {
        this.isPreviewShow = isPreviewShow;
        systemStatus.setIsShowVideoPreview(isPreviewShow);
    }

    private void showAlertTips(String text) {
        if (videoAudioRecorderView != null) {
            videoAudioRecorderView.showRecordAlertTips(text, getAlertBgResId());
        }
    }


	@Override
	protected String getNeedLongPressTipText() {
		return "";
	}

	@Override
	protected String getRecordStartInfoText() {
		return getResources().getString(
				isLocalContact
						? R.string.handwin_tips_video_need_long_press_local
						: R.string.handwin_click_to_record);
	}

    protected void switchCamera() {
        if(isStatus(RecorderStatus.idle)) {
            switchCamera(!isFrontCamera());
        }
    }

    public void switchCamera(boolean isFrontCamera) {
        Utils.debugFormat("[BaseVideoRecorderView] switch camera - front camera: %s", isFrontCamera);
        setIsFrontCamera(isFrontCamera);
        voipAndroidManager.switchCameraFrontBack(isFrontCamera);
        int width=0;
        int height=0;
        if(isFrontCamera){
            height=(configHandler.getScreenHeight()-recorderViewHeight)*2/3;
            width=height*3/4;
        }else{
            width=configHandler.getScreenWidth()*2/3;
            height=width*3/4;
        }
        setPreviewSize(width,height);
    }

    private void setPreviewSize(int width,int height){
        RelativeLayout.LayoutParams frameLp = new RelativeLayout.LayoutParams(width, height);
        frameLp.addRule(RelativeLayout.CENTER_HORIZONTAL);
        frameLp.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
        frameLp.bottomMargin=(configHandler.getScreenHeight()-recorderViewHeight-height)/2;
        recordPreview.setLayoutParams(frameLp);
    }
    private synchronized void setIsFrontCamera(boolean isFrontCamera) {
        this.isFrontCamera = isFrontCamera;
    }

    public synchronized boolean isFrontCamera() {
        return isFrontCamera;
    }

    @Override
    protected String getRecordButtonIcon() {
        return getResources().getString(R.string.handwin_font_img_short_video);
    }

    @Override
    protected void configViewColor(int color) {
        super.configViewColor(color);
        sendText.setTextColor(color);
        btnCancel.setTextColor(color);
    }
}
