package me.chatgame.uisdk.activity.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.app.Fragment;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.style.ReplacementSpan;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.RelativeLayout;
import android.widget.TextView;

import java.util.ArrayList;
import java.util.List;

import me.chatgame.mobilecg.MainApp;
import me.chatgame.mobilecg.actions.DuduMessageActions;
import me.chatgame.mobilecg.actions.InitializeAction;
import me.chatgame.mobilecg.actions.interfaces.IDuduMessageActions;
import me.chatgame.mobilecg.actions.interfaces.IInitializeAction;
import me.chatgame.mobilecg.activity.ImageChooseActivity;
import me.chatgame.mobilecg.activity.view.BaseRelativeLayout;
import me.chatgame.mobilecg.activity.view.interfaces.ILiveActivity;
import me.chatgame.mobilecg.activity.view.interfaces.KeyboardStateListener;
import me.chatgame.mobilecg.call.CallState;
import me.chatgame.mobilecg.constant.Constant;
import me.chatgame.mobilecg.constant.ExtraInfo;
import me.chatgame.mobilecg.constant.MessageType;
import me.chatgame.mobilecg.constant.MsgStatus;
import me.chatgame.mobilecg.constant.RecorderMode;
import me.chatgame.mobilecg.constant.ReqCode;
import me.chatgame.mobilecg.constant.SceneConstant;
import me.chatgame.mobilecg.database.entity.ConversationType;
import me.chatgame.mobilecg.database.entity.DuduContact;
import me.chatgame.mobilecg.database.entity.DuduMessage;
import me.chatgame.mobilecg.handler.ConfigHandler;
import me.chatgame.mobilecg.handler.DBHandler;
import me.chatgame.mobilecg.handler.GroupVideoHandler;
import me.chatgame.mobilecg.handler.interfaces.IConfig;
import me.chatgame.mobilecg.handler.interfaces.IDBHandler;
import me.chatgame.mobilecg.handler.interfaces.IGroupVideoHandler;
import me.chatgame.mobilecg.listener.ItemClickListener;
import me.chatgame.mobilecg.listener.OnAudioRecordedListener;
import me.chatgame.mobilecg.listener.OnVideoRecorderListener;
import me.chatgame.mobilecg.listener.SceneStatusListener;
import me.chatgame.mobilecg.model.TextMessageData;
import me.chatgame.mobilecg.richedit.TagAt;
import me.chatgame.mobilecg.richedit.spans.AtSpan;
import me.chatgame.mobilecg.sdk.EmoticonHandler.GifEmotionData;
import me.chatgame.mobilecg.spans.SizableImageSpan;
import me.chatgame.mobilecg.util.AudioRecordHelper;
import me.chatgame.mobilecg.util.BackgroundExecutor;
import me.chatgame.mobilecg.util.FaceUtils;
import me.chatgame.mobilecg.util.FuncList;
import me.chatgame.mobilecg.util.HexUtil;
import me.chatgame.mobilecg.util.SequenceGenerator;
import me.chatgame.mobilecg.util.UiThreadExecutor;
import me.chatgame.mobilecg.util.Utils;
import me.chatgame.mobilecg.util.interfaces.IAudioRecordHelper;
import me.chatgame.mobilecg.util.interfaces.IFaceUtils;
import me.chatgame.mobilecg.util.interfaces.ISequenceGenerator;
import me.chatgame.mobilecg.viewinterfaces.IMessageView;
import me.chatgame.mobilecg.views.IconFontTextView;
import me.chatgame.mobilecg.views.MonitoringEditText;
import me.chatgame.uisdk.R;
import me.chatgame.uisdk.constants.FunctionMenuCode;
import me.chatgame.mobilecg.bean.FunctionMenuData;

/**
 * Created by star on 15/11/3.
 */
public abstract class BaseSendEditorView extends BaseRelativeLayout implements OnAudioRecordedListener, EmojiPanel.DynamicEmojiSelectListener,
        OnVideoRecorderListener, MonitoringEditText.OnKeyPreImeListener, MonitoringEditText.OnSelectionChangeListener,
        ItemClickListener<FunctionMenuData>, IMessageView {
    private static final int DUR_ANIM_OPEN = 200;
    protected boolean isKeyboardShow = false;
    protected KeyboardStateListener keyboardStateListener;
    protected EmojiPanelListener emojiPnanelListener;
    protected SceneStatusListener sceneStatusListener;
    protected FunctionMenuViewListener functionMenuViewListener;
    protected RecorderMode recorderMode = RecorderMode.NORMAL;
    protected int editChatMaxHeight;
    protected boolean cancelBatch = false;
    private boolean exit = false;
    private boolean videoChatMode = false;

    public interface MessageAddListener {
        void onAddOneMessage(DuduMessage message);
    }

    public interface EmojiPanelListener {
        void onEmojiPannelShow();
        void onEmojiPannelHide();
    }

    public interface FunctionMenuViewListener {
        void onFunctionMenuViewShow();
        void onFunctionMenuViewHide();
    }

//    TextView btnChatImage;         // image select button

    View funcInputSwitchView;
    View funcPptView;
    TextView startPptBtn;

    MainApp app;

    IFaceUtils faceUtils;
    IInitializeAction mInitializeAction;
    ISequenceGenerator sequenceGenerator;
    IDuduMessageActions duduMessageAction;
	IDBHandler dbHandler;
    IGroupVideoHandler groupVideoHandler;
    IConfig config;

    InputMethodManager imm;


    protected ILiveActivity liveActivity;

    protected Activity activity;
    protected EmojiPanel baseEmojiPanel;
    protected MonitoringEditText baseEditChat;
    protected TextView baseBtnEmoji;
    protected View baseBtnFunctionMenu;
    protected TextView baseBtnSend;
    protected VideoAudioRecorderView videoAudioRecorderView;
    protected MessageAddListener messageAddListener;
    protected FunctionMenuView functionMenuView;
    protected TextView audioRecordBtn ;
    protected IconFontTextView audioOrInputBtn ;
    IAudioRecordHelper audioRecordHelper;

    protected View baseEditRegion;
    protected View baseFunctionRegion;

    protected BaseChatView chatView;

    private boolean isHardKeyboard;
    private boolean isAddEmoji = false;
    private boolean isAddRecorderView = false;
    private boolean isAddFunctionMenuView = false;

    private int[] recorderTabConfigArray = new int[]{/*Constant.TAB_RECORD_FACE,*/ Constant.TAB_RECORD_VIDEO/*, Constant.TAB_RECORD_AUDIO*/};
    protected int rootHeight = 0;
    private TextWatcher textWatcher;
    protected boolean isEditTextReady = false;


    public BaseSendEditorView(Context context) {
        super(context);
        init() ;

    }

    public BaseSendEditorView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init() ;

    }

    public BaseSendEditorView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init() ;

    }

    protected void initAudioRecorderButton(View button) {
        if (button == null) {
            return;
        }
        audioRecordHelper = new AudioRecordHelper(getContext()) ;
        audioRecordHelper.initAudioRecorderButton(button);
        audioRecordHelper.setOnAudioRecordedListener(this);
    }


    public void setKeyboardStateListener(KeyboardStateListener keyboardStateListener) {
        this.keyboardStateListener = keyboardStateListener;
    }

    public void setEmojiPanelStateListener(EmojiPanelListener emojiPnanelListener){
        this.emojiPnanelListener = emojiPnanelListener;
    }

    public void setSceneStatusListener(SceneStatusListener sceneStatusListener) {
        this.sceneStatusListener = sceneStatusListener;
    }

    public void setFunctionMenuViewListener(FunctionMenuViewListener functionMenuViewListener) {
        this.functionMenuViewListener = functionMenuViewListener;
    }

    public void afterViews() {
        editChatMaxHeight = getResources().getDimensionPixelSize(R.dimen.handwin_chat_bottom_edit_h_max);
        initEditText(baseEditChat);
        initAudioRecorderButton(audioRecordBtn) ;
        initAudioOrInputButton(audioOrInputBtn,audioRecordBtn,baseEditChat) ;
        enableEditTextMultiLine(false);
        setClickable(true);
        activity = (Activity) getContext();
        setVideoChatMode(false);
        isEditTextReady = false;
        baseEditChat.setSelectionChangeListener(this);
        setAudioRecordEnable(CallState.getInstance().isIdle());
    }

    private void initAudioOrInputButton(IconFontTextView audioOrInputBtn, TextView audioRecordBtn, MonitoringEditText baseEditChat) {
        if (audioOrInputBtn == null || audioRecordBtn == null || baseEditChat == null) {
            return;
        }
        audioOrInputBtn.setText(R.string.handwin_font_img_audio);
        audioRecordBtn.setVisibility(GONE);
        baseEditChat.setVisibility(VISIBLE);
        audioOrInputBtn.setOnClickListener(v -> {
            if (isButtonInAudioState()) {
                showInputUI();
            } else {
                showAudioUI();
            }
        });
    }

    private void showInputUI() {
        if(isFunctionMenuViewShow()){
            showOrHideFunctionMenuView(false, true);
        } else if(isFaceShow()) {
            showOrHideFacesView(false) ;
        }
        openKeyboard(baseEditChat);
        if (!TextUtils.isEmpty(baseEditChat.getText())) {
            showTextSendButton(true,false);
        }
        showInputEditViewDirectly();
    }

    private boolean isButtonInAudioState() {
        return audioRecordBtn != null && audioRecordBtn.getVisibility() == View.VISIBLE;
    }

    private void showAudioUI() {
        if (isKeyboardShow) {
            Utils.autoCloseKeyboard(activity, baseEditChat);
        } else if(isFunctionMenuViewShow()){
            showOrHideFunctionMenuView(false, true,false);
        } else if(isFaceShow()) {
            showOrHideFacesView(false,true,false) ;
        }
        showTextSendButton(false,false) ;
        showAudioRecordViewDirectly();
    }


    private void showInputEditViewDirectly() {
        audioOrInputBtn.setText(R.string.handwin_font_img_audio);
        audioRecordBtn.setVisibility(GONE);
        baseEditChat.setVisibility(VISIBLE);
    }

    private void showAudioRecordViewDirectly() {
        audioOrInputBtn.setText(R.string.handwin_font_img_keyboard);
        audioRecordBtn.setVisibility(VISIBLE);
        baseEditChat.setVisibility(GONE);
    }

    private void init() {
        app = MainApp.getInstance();
        config = ConfigHandler.getInstance_(getContext()) ;
        mInitializeAction = InitializeAction.getInstance_(getContext());
        duduMessageAction = DuduMessageActions.getInstance_(getContext(), this);
        faceUtils = FaceUtils.getInstance_(getContext()) ;
        sequenceGenerator = SequenceGenerator.getInstance_();
        groupVideoHandler = GroupVideoHandler.getInstance_();
        dbHandler = DBHandler.getInstance_(getContext());
    }

    protected void configFuncButtons() {

    }

    void btnImageClick() {
        if (Utils.isFastDoubleClick("ChatActivity_image_add_click")) {
            return;
        }
        onChooseImageButtonClick();
    }

    void btnStartPpt() {
        CallState callState = CallState.getInstance();

        if (sceneStatusListener != null) {
            sceneStatusListener.onPrepareScene(SceneConstant.SLIDE_SCENE);
        }
    }

    protected void createEmojiPanel() {
        if (baseEmojiPanel == null) {
            baseEmojiPanel = EmojiPanel.build(getContext());
            baseEmojiPanel.setEditText(baseEditChat);
            baseEmojiPanel.setDynamicEmojiSelectListener(this);

            int height = getResources().getDimensionPixelSize(R.dimen.handwin_chat_face_out_h);
            RelativeLayout.LayoutParams lp = new LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, height);
            lp.addRule(RelativeLayout.BELOW, R.id.id_edit_region);
            addView(baseEmojiPanel, lp);
            baseEmojiPanel.setVisibility(View.GONE);
        }
    }


    protected void initVideoAudioRecorderView() {
        if (videoAudioRecorderView == null) {
            videoAudioRecorderView = VideoAudioRecorderView.build(getContext());
            videoAudioRecorderView.setRecorderMode(recorderMode);
            int h = getResources().getDimensionPixelSize(R.dimen.handwin_video_audio_recorder_view_h);
            LayoutParams lp = new LayoutParams(LayoutParams.MATCH_PARENT, h);
            lp.addRule(RelativeLayout.BELOW, R.id.id_edit_region);
            addView(videoAudioRecorderView, lp);
            videoAudioRecorderView.setVisibility(View.GONE);
            videoAudioRecorderView.configTabs(recorderTabConfigArray);

            AudioRecordView audioRecordView = videoAudioRecorderView.getAudioRecordView();
            if (audioRecordView != null) {
                audioRecordView.setOnAudioRecordedListener(this);
            }
            VideoRecorderView videoRecorderView = videoAudioRecorderView.getVideoRecorderView();
            if (videoRecorderView != null) {
                videoRecorderView.setOnVideoRecordeListener(this);
            }
            if (chatView != null) {
                videoAudioRecorderView.setChatView(chatView);
            }
            videoAudioRecorderView.setEditView(this);
        }
    }

    /**
     * Called when video button is pressed
     *
     * @param button
     */
    protected void onVideoButtonPressed(View button) {

    }

    /**
     * Called when video button is normal state
     *
     * @param button
     */
    protected void onVideoButtonBeNormal(View button) {

    }


    void delayRestoreVideoButtonState(View button) {
        UiThreadExecutor.runTask(()->delayRestoreVideoButtonState_(button),800);
    }
    void delayRestoreVideoButtonState_(View button) {
        onVideoButtonBeNormal(button);
    }


    @Override
    public void onAudioRecorded(int duration, String audioPath) {
        Utils.debugFormat("onAudioRecorded duration: %d audio path: %s", duration, audioPath);
    }

    void btnMoreItemInputClick() {
        if (Utils.isFastDoubleClick("open_keyboard") || liveActivity.isCalling()) {
            return;
        }
        openKeyboard(baseEditChat);
    }
    public void onAtContactsSelected(int resultCode, Intent data) {
        delayOpenKeyboard(isVideoChatMode() ? 600 : 500);
        if (resultCode == Activity.RESULT_OK) {
            List<DuduContact> contacts = (List<DuduContact>) data
                    .getSerializableExtra(ExtraInfo.SELECTED_CONTACTS);
            if (contacts != null) {
                FuncList.from(contacts).iterate(this::addAtContactInEditText);
            }
        }
    }

    protected void delayOpenKeyboard(long delayTime) {
        postDelayed(this::openKeyboard, delayTime);
    }

    protected void openKeyboard() {
        if (baseEditChat == null){
            return;
        }
        imm.toggleSoftInputFromWindow(baseEditChat.getWindowToken(),
                InputMethodManager.SHOW_FORCED,
                InputMethodManager.HIDE_NOT_ALWAYS);
        delayToRequestEditFocusAndSetSelectionCursor(baseEditChat);
    }

    void delayToRequestEditFocusAndSetSelectionCursor(EditText editText) {
        UiThreadExecutor.runTask(()->delayToRequestEditFocusAndSetSelectionCursor_(editText));
    }

    void delayToRequestEditFocusAndSetSelectionCursor_(EditText editText) {
        int cursorPos = editText.getSelectionStart();
        editText.requestFocus();
        editText.setSelection(cursorPos);
    }

    protected void addAtContactInEditText(DuduContact contact) {
        int cursorPos = baseEditChat.getSelectionStart();
        String text = baseEditChat.getText().toString();
        Editable editable = baseEditChat.getEditableText();
        // compose @ string
        String atStr = new TagAt().setContact(contact).getXml();
        //Utils.debugFormat("[CGTEST] addAtContactInEditText at str: %s", atStr);
        if (cursorPos > 0) {
            int indexOfAt = cursorPos - 1;
            char charAtCursor = text.charAt(indexOfAt);

            if (charAtCursor == '@') {
                editable.replace(indexOfAt, cursorPos, atStr);
            } else {
                editable.insert(cursorPos, atStr);
            }
        } else {
            editable.insert(cursorPos, atStr);
        }
    }
    /**
     * 打开键盘
     */
    protected void openKeyboard(EditText editText) {
        if (editText == null) return;
        imm.toggleSoftInputFromWindow(editText.getWindowToken(),
                InputMethodManager.SHOW_FORCED,
                InputMethodManager.HIDE_NOT_ALWAYS);
        delayToRequestFocus(editText);
    }

    void delayToRequestFocus(EditText editText) {
        UiThreadExecutor.runTask(()->delayToRequestFocus_(editText));
    }
    void delayToRequestFocus_(EditText editText) {
        editText.requestFocus();
        editText.setSelection(editText.length());
    }

    @Override
    public void onDynamicEmojiSelected(GifEmotionData gifEmotionData) {
    }

    protected void initEditText(MonitoringEditText editText) {
        faceUtils.filterEditTextWithLength(editText, Constant.MAX_LEN_CHAT);
        editText.setKeyPreImeListener(this);
        editText.setOnKeyListener((v, keyCode, event) -> {
            if (isHardKeyboard && (keyCode == KeyEvent.KEYCODE_ENTER)
                    && (event.getAction() == KeyEvent.ACTION_UP)) {
                sendOneTextMessage(editText);
                return true;
            }
            return false;
        });
        editText.setCopyPasteListener(new MonitoringEditText.CopyPasteListener() {

            @Override
            public void onTextPaste() {
                editText.setText(faceUtils.decodeTextInEditText(editText.getText(), editText, true));
                editText.setSelection(editText.getText().length());
            }

            @Override
            public void onTextCut() {

            }

            @Override
            public void onTextCopy() {

            }
        });

        textWatcher = new TextWatcher() {
            @java.lang.Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            @java.lang.Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                onTextChange(editText);
            }

            @java.lang.Override
            public void afterTextChanged(Editable s) {
                afterTextChange(editText);
            }
        };
        editText.addTextChangedListener(textWatcher);
    }

    /**
     * 当前是否是硬件键盘
     *
     * @param isHardKeyboard
     */
    public void setHardKeyboard(boolean isHardKeyboard) {
        this.isHardKeyboard = isHardKeyboard;
    }

    protected void sendOneTextMessage(EditText editText) {
        if (editText == null) {
            return;
        }
        String str = editText.getText().toString();
        if (TextUtils.isEmpty(str)) {
            app.toast(R.string.handwin_need_content);
            return;
        }
        sendTextMessage(str);
        // 如果发送成功，清空（此方法不会影响输入法锁定）
        editText.getText().clear();
        // 清理输入法备选词
        imm.restartInput(editText);
    }

    void btnSendMsgClick() {
        if (Utils.isFastDoubleClick("ChatActivity_audio_add_click")) {
            return;
        }
        // 发送文本内容
        sendOneTextMessage(baseEditChat);
    }

    void btnEmojiClick() {
        if (Utils.isFastDoubleClick("ChatActivity_emoji_add_click")) {
            return;
        }
        onEmojiButtonClick();
    }

    protected void btnFunctionMenuEntryClick() {
        if (Utils.isFastDoubleClick("ChatActivity_function_menu_btn_click")) {
            return;
        }
        onFunctionMenuEntryButtonClick();
    }

    /**
     * 测试批量发送数据
     */
    void testBatchSendMessage() {
        BackgroundExecutor.execute(this::testBatchSendMessage_, BackgroundExecutor.ThreadType.NETWORK);
    }

    void testBatchSendMessage_() {
		for (int i = 0; i < 1000; i++) {
			Utils.debug("debug:sendMessage testBatchSendMessage : " + i);
			sendTextMessage(String.valueOf(i) + "[smile][video]");
			Utils.sleep(50);
			if (cancelBatch) {
				Utils.debug("debug:sendMessage testBatchSendMessage cancel : "
						+ i);
				return;
			}
		}
    }


    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        cancelBatch = true;
    }

    /**
     * Called when sending text msg
     *
     * @param str
     */
    protected void sendTextMessage(String str) {
    }

    /**
     * 显示隐藏，表情选取界面
     *
     * @param show
     */
    public void showOrHideFacesView(boolean show) {
        showOrHideFacesView(show, true);
    }
    /**
     * 显示隐藏，表情选取界面
     *
     * @param show
     * @param needAnim
     */
    public void showOrHideFacesView(final boolean show, boolean needAnim) {
        showOrHideFacesView(show, needAnim, true);
    }

    public void showOrHideFacesView(final boolean show, boolean needAnim, boolean openKeyboardOnFaceHide) {
        createEmojiPanel();
        showOrHideAudioButton(false) ;
        //检查表情文件是否存在
        mInitializeAction.checkEmoji();
        isAddEmoji = show;
        // 第一次打开，需要初始化
        baseEmojiPanel.initEmojiPanel();
        boolean isFaceVisible = isFaceShow();
        if (show && isFaceVisible) {
            return;
        }
        if (!show && !isFaceVisible) {
            return;
        }

        doMoreWorkOnEmojiPanelShowOrHide(show);

        if (show && null != emojiPnanelListener){
            emojiPnanelListener.onEmojiPannelShow();
        }else if (!show && null != emojiPnanelListener){
            emojiPnanelListener.onEmojiPannelHide();
        }

        if (!needAnim) {
            setTranslationY(0);
            baseEmojiPanel.setVisibility(show ? View.VISIBLE : View.GONE);
            return;
        }
		final int h = app.getPxFromDp(R.dimen.handwin_chat_face_out_h);
        int tStart = show ? 0 : h;
        int tEnd = show ? h : 0;
        animatePanel(tStart, tEnd, h, new AnimatorListenerAdapter() {
            @Override
            public void onAnimationStart(Animator animation) {
                baseEmojiPanel.setVisibility(View.VISIBLE);
            }

            @Override
            public void onAnimationEnd(Animator animation) {
                if (show) {
                    return;
                }
                baseEmojiPanel.setVisibility(View.GONE);
                setChatMenuBottomMargin(0);
                setTranslationY(0);
                if (openKeyboardOnFaceHide) {
                    openKeyboard(baseEditChat);
                }
            }
        }, null);
    }

    public void showOrHideAudioButton(boolean show){
        audioRecordBtn.setVisibility(show ? VISIBLE : GONE);
    }

    private void animatePanel(int start, int end, int height, Animator.AnimatorListener listener,
                              ValueAnimator.AnimatorUpdateListener animatorUpdateListener) {
		ValueAnimator anim = ValueAnimator.ofInt(start, end);
		anim.setDuration(DUR_ANIM_OPEN);
		anim.setInterpolator(new DecelerateInterpolator());
		if (animatorUpdateListener != null) {
			anim.addUpdateListener(animatorUpdateListener);
		} else {
			anim.addUpdateListener(value -> {
				int y = (Integer) value.getAnimatedValue();
				int bottom = -(height - y);
				setChatMenuBottomMargin(bottom);
			});
		}
		anim.addListener(listener);
		anim.start();
    }

    private void setChatMenuBottomMargin(int bottom) {
        LayoutParams lp = (LayoutParams) getLayoutParams();
        lp.bottomMargin = bottom;
        setLayoutParams(lp);
    }

    protected void enableEditTextMultiLine(boolean enable) {
        EditText editText = baseEditChat;
        if (editText == null) {
            return;
        }
        int cursorPos = editText.getSelectionStart();
        if (enable) {
            editText.setSingleLine(false);
            //设置这个会导致搜狗输入法从中文切换为英文，先去掉
            //editText.setRawInputType(InputType.TYPE_TEXT_FLAG_NO_SUGGESTIONS | InputType.TYPE_TEXT_FLAG_MULTI_LINE);
            editText.setMaxHeight(editChatMaxHeight);
        } else {
            editText.setSingleLine(true);
        }
        editText.setSelection(cursorPos);
    }

    protected void doMoreWorkOnEmojiPanelShowOrHide(boolean show) {
        if (baseBtnEmoji != null) {
            int resId = show
                    ? R.string.handwin_font_img_keyboard
                    : R.string.handwin_font_img_smile_face_inner;
//            int textSize = show
//                    ? getResources().getDimensionPixelSize(R.dimen.handwin_font_size_22)
//                    : getResources().getDimensionPixelSize(R.dimen.handwin_font_size_28);
            baseBtnEmoji.setText(resId);
//            baseBtnEmoji.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSize);
        }
        if (show) {
            enableEditTextMultiLine(true);
            showFunctionBar(false);
        }
    }

    /**
     * Display unsent text message
     * @param unSendMsg
     */
    public void showUnsendMsg(String unSendMsg) {
        UiThreadExecutor.runTask(()->showUnsendMsg_(unSendMsg));
    }
    public void showUnsendMsg_(String unSendMsg) {
        onShowUnsendMsg(unSendMsg);
        TextView btnSend = baseBtnSend;
        EditText editChat = baseEditChat;
        if (btnSend == null || editChat == null) {
            return;
        }
        if (TextUtils.isEmpty(unSendMsg)) {
            btnSend.setEnabled(false);
            editChat.setText("");
            return;
        }
        editChat.getText().clear();
        isEditTextReady = false;
        editChat.getText().append(unSendMsg);
        btnSend.setEnabled(unSendMsg.length() > 0);
    }

    protected void onShowUnsendMsg(String unSendMsg) {
        if (TextUtils.isEmpty(unSendMsg)) {
            isEditTextReady = true;
        }
    }

    /**
     * 打开图片选取
     */
    protected void openImageChoose(Activity activity, Fragment fragment) {
        if (Utils.isFastDoubleClick("openImageChoose")) {
            return;
        }
        Intent intent = new Intent();
        intent.putExtra(ExtraInfo.IMAGE_PICK_MULTI, true);
        intent.putExtra(ExtraInfo.NEED_CAMERA, needCameraInImageChoose());
        try {
            if (activity != null) {
                intent.setClass(activity, ImageChooseActivity.class);
                activity.startActivityForResult(intent, ReqCode.GALLERY);
            } else if (fragment != null) {
                intent.setClass(fragment.getActivity(), ImageChooseActivity.class);
                fragment.startActivityForResult(intent, ReqCode.GALLERY);
            }
        } catch (ActivityNotFoundException e) {
            e.printStackTrace();
        }
    }

	/**
	 * 选取图片的时候，是否可以拍照
	 * 
	 * @return
	 */
	private boolean needCameraInImageChoose() {
		return CallState.getInstance().isStatus(CallState.Status.Idle);
	}

    public void onImageChooseResult(int resultCode, Intent data) {
        switch (resultCode) {
            case Activity.RESULT_OK:
                String[] paths = data.getStringArrayExtra(ExtraInfo.ALL_PATH);
                if (null == paths || paths.length < 1) {
                    app.toast(R.string.handwin_tips_image_capture_save_fail);
                    return;
                }
                sendImage(paths);
                break;
            case Activity.RESULT_CANCELED:
                break;
            default:
                app.toast(R.string.handwin_tips_image_capture_save_fail);
                break;
        }
    }

    /**
     * Called when images are chosen
     * @param paths image paths
     */
    protected void sendImage(String[] paths) {

    }

    public void dismissAudioRecordStateWindow() {
        if (null != audioRecordHelper){
            audioRecordHelper.dismissAudioRecordStateWindow();
        }
    }

    public void stopRecord(boolean cancel) {
        if (audioRecordHelper != null) {
            audioRecordHelper.stopRecord(cancel);
            audioRecordHelper.dismissAudioRecordStateWindow();
        } else if (videoAudioRecorderView != null) {
            AudioRecordView audioRecordView = videoAudioRecorderView.getAudioRecordView();
            if (audioRecordView != null) {
                audioRecordView.stopRecord(cancel);
            }
        }
    }

    public boolean isAddEmoji() {
        return isAddEmoji;
    }

    protected void setIsAddEmoji(boolean isAddEmoji) {
        this.isAddEmoji = isAddEmoji;
    }

    public EditText getEditText() {
        return baseEditChat;
    }

    public boolean isAudioRecording() {
        if (videoAudioRecorderView != null){
            AudioRecordView audioRecordView = videoAudioRecorderView.getAudioRecordView();
            if (audioRecordView != null) {
                return audioRecordView.isAudioRecording();
            }
        }
        return false;
    }

    public void setMessageAddListener(MessageAddListener messageAddListener) {
        this.messageAddListener = messageAddListener;
    }


    public boolean isFaceShow() {
        if (baseEmojiPanel == null) {
            return false;
        }
        return (baseEmojiPanel.getVisibility() == View.VISIBLE);
    }

    public void onGlobalLayout(View rootView) {
        //Utils.debug("[CGTEST] onGlobalLayout");
        // 最大的高度就是屏幕可用的高度
        if (rootView.getHeight() > rootHeight) {
            rootHeight = rootView.getHeight();
        }
        int deltaY = rootHeight
                - rootView.getHeight();
        boolean show = (deltaY > 300);
        if (show == isKeyboardShow) {
            return;
        }
        if (isProcessKeyboardShowOrHide()) {
            if (show) {
                onKeyBoardShow();
            } else {
                onKeyBoardHide();
            }
        }
    }

    protected boolean isProcessKeyboardShowOrHide() {
        return true;
    }

    public void onKeyBoardShow() {
        Utils.debug("Keyboard -----------> show");
        isKeyboardShow = true;
        // 隐藏表情选取框
        if (isFaceShow()) {
            showOrHideFacesView(false, false);
        }
        if (isRecorderViewShow()) {
            showOrHideRecorderView(false, false);
        }
        if (isFunctionMenuViewShow()) {
            showOrHideFunctionMenuView(false, false);
        }

        if (keyboardStateListener != null) {
            keyboardStateListener.onKeyboardShow();
        }
        showFunctionBar(false);
        enableEditTextMultiLine(true);
    }

    public void onKeyBoardHide() {
        Utils.debug("Keyboard -----------> hide");
        isKeyboardShow = false;
        if (keyboardStateListener != null) {
            keyboardStateListener.onKeyboardHide();
        }
        if (isAddEmoji() || isAddFunctionMenuView()) {
            showFunctionBar(false);
        } else {
            showFunctionBar(isFunctionBarShow());
        }

        enableEditTextMultiLine(isAddEmoji());
    }

    void delayToShowEmojiView() {
        UiThreadExecutor.runTask(this::delayToShowEmojiView_,200);
    }
    void delayToShowEmojiView_() {
        showOrHideFacesView(true);
    }

    protected void onEmojiButtonClick() {
        showInputEditViewDirectly();
        if (isKeyboardShow) {
            Utils.autoCloseKeyboard(activity, baseEditChat);
            setIsAddEmoji(true);
            delayToShowEmojiView();
            return;
        } else if (isFunctionMenuViewShow()) {
            showOrHideFunctionMenuView(false, false);
            setIsAddEmoji(true);
            showOrHideFacesView(true, false);
            return;
        }
        boolean show = !isFaceShow();
        showOrHideFacesView(show, true);
    }

    protected void onChooseImageButtonClick() {
        if (isKeyboardShow) {
            Utils.autoCloseKeyboard(activity, baseEditChat);
            delayToOpenImageChoose();
        } else {
            openImageChoose(activity, null);
        }
    }

    /**
     * 延迟打开图片选取
     */
    void delayToOpenImageChoose() {
        UiThreadExecutor.runTask(this::delayToOpenImageChoose_,500);
    }
    void delayToOpenImageChoose_() {
        openImageChoose(activity, null);
    }

    public boolean isKeyboardShow() {
        return isKeyboardShow;
    }

    protected void sendTextMessage(String str, String cid, int setting, ConversationType conversationType, int extraType) {
        long timestamp = System.currentTimeMillis();
        long pid = sequenceGenerator.getSequence();
        DuduMessage message = new DuduMessage()
                .setMsgUUID(Utils.getUUID())
                .setSendTime(timestamp)
                .setMsgType(MessageType.TEXT)
                .setSender(config.getUid())
                .setConversationId(cid)
                .setMessageObject(new TextMessageData(str))
                .setMsgId(pid)
                .setConversationType(conversationType)
                .setMsgStatus(MsgStatus.SENDING)
                .setNickname(config.getNickname())
                .setAvatarUrl(config.getAvatarUrl())
                .setExtraType(extraType);
        duduMessageAction.setMessageExtra(message, setting);
    }

    @Override
    public void setMessageExtraResp(DuduMessage message) {
        UiThreadExecutor.runTask(()->setMessageExtraResp_(message));
    }

    public void setMessageExtraResp_(DuduMessage message) {
        if (messageAddListener != null) {
            messageAddListener.onAddOneMessage(message);
        }

        // 文本
        if (message.getMsgType().equals(MessageType.TEXT)) {
            duduMessageAction.sendMessage(message);
            return;
        }
    }

    public boolean isSpecialViewExist() {
        if (isFaceShow()) {
            // 隐藏表情输入界面
            showOrHideFacesView(false);
            if (baseEditChat != null) {
                baseEditChat.requestFocus();
            }
            return true;
        } else if (isRecorderViewShow()) {
            showOrHideRecorderView(false, true);
            return true;
        } else if (isFunctionMenuViewShow()) {
            showOrHideFunctionMenuView(false, true, false);
            return true;
        }
        return false;
    }


    public void sendMessageResponse(DuduMessage message) {

    }

    public void onExit() {
        exit = true;
        isEditTextReady = false;
        removeCallbacks(showRecorderViewRunable);
        if (baseEditChat != null) {
            baseEditChat.setCopyPasteListener(null);
            baseEditChat.setOnKeyListener(null);
            baseEditChat.setOnClickListener(null);
            baseEditChat.setKeyPreImeListener(null);
            baseEditChat.setSelectionChangeListener(null);
            if (textWatcher != null) {
                baseEditChat.removeTextChangedListener(textWatcher);
                textWatcher = null;
            }
            ViewGroup parent = (ViewGroup) baseEditChat.getParent();
            if (parent != null) {
                parent.removeView(baseEditChat);
            }
        }

        if (baseEmojiPanel != null) {
            removeView(baseEmojiPanel);
            baseEmojiPanel = null;
        }
        if (videoAudioRecorderView != null) {
            if (!videoAudioRecorderView.isDestroy()) {
                videoAudioRecorderView.destroy(false);
            }
            removeView(videoAudioRecorderView);
            videoAudioRecorderView = null;
        }
    }

    public boolean isFunctionMenuViewShow() {
        if (functionMenuView == null) {
            return false;
        }
        return functionMenuView.getVisibility() == View.VISIBLE;
    }

    protected void onFunctionMenuEntryButtonClick() {
        showInputEditViewDirectly();
        if (isKeyboardShow) {
            Utils.autoCloseKeyboard(activity, baseEditChat);
            setAddFunctionMenuView(true);
            delayToShowFunctionMenuView();
            return;
        } else if (isFaceShow()){
            showOrHideFacesView(false, false);
            setAddFunctionMenuView(true);
            showOrHideFunctionMenuView(true, false);
            return;
        }
        boolean show = !isFunctionMenuViewShow();
        showOrHideFunctionMenuView(show, true);
    }

    void setAddFunctionMenuView(boolean isAddFunctionMenuView) {
        this.isAddFunctionMenuView = isAddFunctionMenuView;
    }

    public boolean isAddFunctionMenuView() {
        return isAddFunctionMenuView;
    }

    void delayToShowFunctionMenuView() {
        postDelayed(showFunctionMenuViewRunable, 200);
    }

    Runnable showFunctionMenuViewRunable = new Runnable() {
        @Override
        public void run() {
            if (exit) {
                return;
            }
            showOrHideFunctionMenuView(true, false);
        }
    };

    protected void showOrHideFunctionMenuView(final boolean show, boolean needAnim) {
        showOrHideFunctionMenuView(show, needAnim, true);
    }

    protected void showOrHideFunctionMenuView(final boolean show, boolean needAnim, boolean showKeyboard) {
        removeCallbacks(showFunctionMenuViewRunable);
        initFunctionMenuView();
        setAddFunctionMenuView(show);

        if (show) {
            functionMenuView.refreshUI();
        }

        boolean isFunctionViewVisible = isFunctionMenuViewShow();
        if (show && isFunctionViewVisible) {
            return;
        }
        if (!show && !isFunctionViewVisible) {
            return;
        }

        if (show && null != functionMenuViewListener){
            functionMenuViewListener.onFunctionMenuViewShow();
        }else if (!show && null != functionMenuViewListener){
            functionMenuViewListener.onFunctionMenuViewHide();
        }

        if (!needAnim) {
            setTranslationY(0);
            functionMenuView.setVisibility(show ? View.VISIBLE : View.GONE);
            return;
        }
        final int h = app.getPxFromDp(R.dimen.handwin_chat_face_out_h);
        int tStart = show ? 0 : h;
        int tEnd = show ? h : 0;
        animatePanel(tStart, tEnd, h, new AnimatorListenerAdapter() {
            @Override
            public void onAnimationStart(Animator animation) {
                functionMenuView.setVisibility(View.VISIBLE);
            }

            @Override
            public void onAnimationEnd(Animator animation) {
                if (show) {
                    return;
                }
                functionMenuView.setVisibility(View.GONE);
                setChatMenuBottomMargin(0);
                setTranslationY(0);
                if (showKeyboard) {
                    openKeyboard(baseEditChat);
                }
            }
        }, null);
    }

    private void initFunctionMenuView() {
        if (functionMenuView == null) {
            functionMenuView = new FunctionMenuView(getContext());
            functionMenuView.configMenuDatas(createFunctionMenuDatas(), this);
            functionMenuView.setVisibility(GONE);

            int height = getResources().getDimensionPixelSize(R.dimen.handwin_chat_face_out_h);
            RelativeLayout.LayoutParams lp = new LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, height);
            lp.addRule(RelativeLayout.BELOW, R.id.id_edit_region);
            addView(functionMenuView, lp);
        }
    }

    protected List<FunctionMenuData> createFunctionMenuDatas() {
        List<FunctionMenuData> menuDatas = new ArrayList<>();
        menuDatas.add(new FunctionMenuData(getResources().getString(R.string.handwin_chatgame_video_record), getResources().getString(R.string.handwin_font_img_short_video), FunctionMenuCode.VIDEO_RECORD, false));
        menuDatas.add(new FunctionMenuData(getResources().getString(R.string.handwin_image_choose), getResources().getString(R.string.handwin_font_img_background), FunctionMenuCode.IMAGE_CHOOSE, true));
        menuDatas.add(new FunctionMenuData(getResources().getString(R.string.handwin_image_capture), getResources().getString(R.string.handwin_font_img_camera), FunctionMenuCode.PHOTO_CAPTURE, false));
        return menuDatas;
    }

    @Override
    public boolean onItemClick(FunctionMenuData functionMenuData) {
        switch (functionMenuData.getCode()) {
            case FunctionMenuCode.VOICE_RECORD:
                onRecorderButtonClick(Constant.TAB_RECORD_AUDIO);
                return true;
            case FunctionMenuCode.VIDEO_RECORD:
                onRecorderButtonClick(Constant.TAB_RECORD_VIDEO);
                return true;
            case FunctionMenuCode.IMAGE_CHOOSE:
                btnImageClick();
                return true;
            case FunctionMenuCode.PHOTO_CAPTURE:
                captureImageFromCamera();
                return true;
        }
        return false;
    }

    /**
     * 相机拍摄图片发送
     */
    protected void captureImageFromCamera() {
        try {
            if (activity != null) {
                Intent intent = new Intent();
                intent.setClass(activity, ImageChooseActivity.class);
                intent.putExtra(ExtraInfo.IMAGE_PICK_MULTI, true);
                intent.putExtra(ExtraInfo.CAPTURE_PHOTO, true);
                activity.startActivityForResult(intent, ReqCode.GALLERY);
            }
        } catch (ActivityNotFoundException e) {
            e.printStackTrace();
        }
    }

    protected void onRecorderButtonClick(int targetTab) {
        if (isKeyboardShow) {
            Utils.autoCloseKeyboard(activity, baseEditChat);
            setIsAddRecorderView(true);
            delayToShowRecorderView(targetTab);
            return;
        } else if (isFaceShow()) {
            showOrHideFacesView(false, false);
            setIsAddRecorderView(true);
            showOrHideRecorderView(true, false, targetTab);
            return;
        } else if (isFunctionMenuViewShow()) {
            showOrHideFunctionMenuView(false, false);
            setIsAddRecorderView(true);
            showOrHideRecorderView(true, false, targetTab);
            return;
        }
        boolean show = !isRecorderViewShow();
        showOrHideRecorderView(show, true, targetTab);

    }

    void delayToShowRecorderView(int targetTab) {
        showRecorderViewRunable = () -> {
            if (exit) {
                return;
            }
            showOrHideRecorderView(true, false, targetTab);
        };

        postDelayed(showRecorderViewRunable, 200);
    }

    Runnable showRecorderViewRunable;

    public void setIsAddRecorderView(boolean isAddRecorderView) {
        this.isAddRecorderView = isAddRecorderView;
    }

    public void showOrHideRecorderView(boolean show, boolean needAnimation) {
        showOrHideRecorderView(show, needAnimation, Constant.TAB_RECORD_CHECK_BY_LAST);
    }

    public void showOrHideRecorderView(boolean show, boolean needAnimation, int targetRecorderTab) {
        removeCallbacks(showRecorderViewRunable);

        initVideoAudioRecorderView();
        isAddRecorderView = show;
        boolean isRecorderViewVisible = isRecorderViewShow();
        if (show && isRecorderViewVisible) {
            return;
        }
        if (!show && !isRecorderViewVisible) {
            return;
        }
        doMoreWorkOnRecorderViewShowOrHide(show, needAnimation, targetRecorderTab);
        VideoAudioRecorderView videoAudioRecorderView = this.videoAudioRecorderView;
        if(!show){
            if (videoAudioRecorderView != null) {
                videoAudioRecorderView.cancel();
            }
        }
        if (!needAnimation) {
            setTranslationY(0);
            if (videoAudioRecorderView != null) {
                videoAudioRecorderView.setVisibility(show ? View.VISIBLE : View.GONE);
            }
            if (isFunctionBarShow()) {
                if (baseFunctionRegion != null) {
                    baseFunctionRegion.setVisibility(show ? View.GONE : View.VISIBLE);
                }
                if (baseEditRegion != null) {
                    baseEditRegion.setVisibility(GONE);
                }
            } else {
                if (baseEditRegion != null) {
                    baseEditRegion.setVisibility(show ? View.GONE : View.VISIBLE);
                }
                if (baseFunctionRegion != null) {
                    baseFunctionRegion.setVisibility(GONE);
                }
            }
            int lastTab = recorderMode != RecorderMode.NORMAL ? config.getLastShareRecordTab() : config.getLastRecordTab();
            if (show && videoAudioRecorderView != null) {
                if (targetRecorderTab == Constant.TAB_RECORD_VIDEO
                        || (targetRecorderTab == Constant.TAB_RECORD_CHECK_BY_LAST && lastTab == Constant.TAB_RECORD_VIDEO)) {
                    post(() -> {
                        VideoRecorderView videoRecorderView = videoAudioRecorderView.getVideoRecorderView();
                        if (videoRecorderView != null) {
                            videoRecorderView.showPreviewView(true, true);
                        }
                    });
                }
            }
            return;
        }

        int th = getResources().getDimensionPixelSize(R.dimen.handwin_video_audio_recorder_view_h);
        if (!show && videoAudioRecorderView != null) {
            th = videoAudioRecorderView.getHeight();
        }
        final int h = th;
        int tStart = show ? 0 : h;
        int tEnd = show ? h : 0;
        animatePanel(tStart, tEnd, h, new AnimatorListenerAdapter() {
                    @Override
                    public void onAnimationStart(Animator animation) {
                        if (videoAudioRecorderView != null) {
                            videoAudioRecorderView.setVisibility(View.VISIBLE);
                        }
                    }

                    @Override
                    public void onAnimationEnd(Animator animation) {
                        if (show && !exit) {
                            int lastTab = recorderMode != RecorderMode.NORMAL ? config.getLastShareRecordTab() : config.getLastRecordTab();
                            if (videoAudioRecorderView != null) {
                                if (targetRecorderTab == Constant.TAB_RECORD_VIDEO || lastTab == Constant.TAB_RECORD_VIDEO) {
                                    VideoRecorderView videoRecorderView = videoAudioRecorderView.getVideoRecorderView();
                                    if (videoRecorderView != null) {
                                        videoRecorderView.showPreviewView(true, true);
                                    }
                                }
                            }
                            return;
                        }
                        if (videoAudioRecorderView != null) {
                            videoAudioRecorderView.destroy(true);
                            videoAudioRecorderView.setVisibility(View.GONE);
                        }
                        showFunctionBar(isFunctionBarShow());
                        setTranslationY(0);
                        setChatMenuBottomMargin(0);
                    }
                },
                value -> {
                    int y = (Integer) value.getAnimatedValue();
                    setTranslationY(h - y);
                });

    }

    protected void doMoreWorkOnRecorderViewShowOrHide(boolean show, boolean needAnimation, int preferRecordTab) {
        if (videoAudioRecorderView == null) return;
        if (show) {
            if (baseEditRegion != null) {
                baseEditRegion.setVisibility(View.GONE);
            }
            if (baseFunctionRegion != null) {
                baseFunctionRegion.setVisibility(View.GONE);
            }
        }
        if (show) {
            videoAudioRecorderView.initialize(preferRecordTab);
        } else if (needAnimation) {
            videoAudioRecorderView.hidePreviewView();
        } else {
            videoAudioRecorderView.destroy(false);
        }
        enableEditTextMultiLine(false);
    }

    public boolean isRecorderViewShow() {
        if (videoAudioRecorderView == null) {
            return false;
        }
        return videoAudioRecorderView.getVisibility() == View.VISIBLE;
    }

    public boolean isRecording() {
        if (videoAudioRecorderView == null) {
            return false;
        }
        return videoAudioRecorderView.isRecording();
    }

    public boolean isShowingVideoPreview() {
        if (videoAudioRecorderView == null) {
            return false;
        }
        return videoAudioRecorderView.isShowingPreview();
    }

    public void setChatView(BaseChatView chatView) {
        this.chatView = chatView;
        if (videoAudioRecorderView != null) {
            videoAudioRecorderView.setChatView(chatView);
        }
    }

    @Override
    public void onVideoRecorded(String videoFile, String thumbFile, int duration, boolean isBurned, int videoType, boolean frontCamera) {

    }

	public void onResume() {
        if (isRecorderViewShow()) {
            videoAudioRecorderView.onResume();
        }
    }

    public void onPause() {
        if (isRecorderViewShow()) {
            videoAudioRecorderView.onPause();
        }
    }

    public void configRecorderTabs(int... tabs) {
        recorderTabConfigArray = tabs;
    }

    public void setRecorderMode(RecorderMode recorderMode) {
        this.recorderMode = recorderMode;
    }

    void onTextChange(EditText editText) {
        String str = editText.getText().toString();
        if (str.length() > Constant.MAX_LEN_CHAT) {
            editText.setText(str.substring(0, Constant.MAX_LEN_CHAT));
            return;
        }
        boolean enable = (str.length() > 0) && !isButtonInAudioState();
        if (enable) {
            showTextSendButton(true);
        } else if (needShowRecordButtonOnTextChange()) {
            showTextSendButton(false,!isButtonInAudioState());
        }
        if (baseBtnSend != null) {
            baseBtnSend.setEnabled(enable);
        }
    }

    public void atOneContact(DuduContact contact) {
        if (contact != null) {
            addAtContactInEditText(contact);
        }
        if (isVideoChatMode()) {
            openKeyboard();
        }
    }

    protected boolean needShowRecordButtonOnTextChange() {
       return true;
    }

    /**
     * 显示隐藏文本发送按钮
     *
     * @param show
     */
    public void showTextSendButton(boolean show) {
        showTextSendButton(show,true);
    }

    public void showTextSendButton(boolean show,boolean careEditText) {
        EditText editChat = baseEditChat;
        if (editChat == null) {
            return;
        }
        int length = editChat.getText().toString().length();
        if (careEditText && length > 0 && !show) {
            show = true;
        }
        if (baseBtnSend != null) {
            baseBtnSend.setVisibility(show ? View.VISIBLE : View.INVISIBLE);
        }
        if (baseBtnFunctionMenu != null) {
            baseBtnFunctionMenu.setVisibility(show ? View.INVISIBLE : View.VISIBLE);
        }
    }

    void afterTextChange(EditText editText) {}


    /**
     * Check if need show contacts at selection page
     * @param text
     * @return
     */
    protected boolean needShowAtSelectPage(String text, int cursorPos) {
        if (cursorPos == 0) {
            return false;
        } else {
            int indexOfAt = cursorPos - 1;
            char charAtCursor = text.charAt(indexOfAt);
            //Utils.debugFormat("[CGTEST] char at cursor: %s", charAtCursor);
            if (charAtCursor == '@') {
                if (indexOfAt == 0) {
                    return true;
                } else {
                    char charBeforeAt = text.charAt(indexOfAt - 1);
                    //Utils.debugFormat("[CGTEST] charbeforeat: %s", charBeforeAt);

                    return !((charBeforeAt >= '0' && charBeforeAt <= '9') ||
                            (charBeforeAt >= 'A' && charBeforeAt <= 'Z') ||
                            (charBeforeAt >= 'a' && charBeforeAt <= 'z') ||
                            charBeforeAt == '_' || charBeforeAt == '.' || charBeforeAt == '-');
                }
            }

        }
        return false;
    }

    @Override
    public void onSelectionChanged(int selStart, int selEnd) {
        String text = baseEditChat.getText().toString();
        if (Utils.BUILD_CONFIG_DEBUG_MODE) {
            Utils.debugFormat("[CGTEST] onSelectionChanged selStart %d, selEnd: %d, text len: %d", selStart, selEnd, text.length());
            Utils.debugFormat("[CGTEST] onSelectionChanged text: %s", text);
        }
        if (selStart == selEnd && selStart > 0 && selStart < text.length()) {
            char c1 = text.charAt(selStart - 1);
            char c2 = text.charAt(selStart);
            ReplacementSpan[] spans = baseEditChat.getText().getSpans(selStart, selEnd, ReplacementSpan.class);
            if (needStepCursor(c1, c2, spans)) {
                baseEditChat.setSelection(selStart + 1);
            }
        } else if (selStart < selEnd) {
//            char charStart = text.charAt(selStart);
            if (Utils.BUILD_CONFIG_DEBUG_MODE) {
                Utils.debugFormat("[CGTEST] onSelectionChanged selectedText: %s", text.substring(selStart, selEnd));
            }
            if (!checkAndStepCursor(baseEditChat, selStart, selEnd)) {
                if (selEnd == text.length()) {
                    if (selStart > 2) {
                        String leftText = text.substring(0, selStart + 1);
                        if (Utils.BUILD_CONFIG_DEBUG_MODE) {
                            Utils.debugFormat("[CGTEST] onSelectionChanged leftText: %s len: %d", leftText, leftText.length());
                        }
                        ReplacementSpan[] spans = baseEditChat.getEditableText().getSpans(selStart, selStart, ReplacementSpan.class);
                        if ((leftText.endsWith("/>") || (leftText.endsWith("]") && !leftText.endsWith("/>]") && !leftText.endsWith("]]")))
                                && spans != null && spans.length > 0) {
                            if (Utils.BUILD_CONFIG_DEBUG_MODE) {
                                Utils.debug("[CGTEST] onSelectionChanged find span " + spans[0]);
                            }
                            baseEditChat.setSelection(selStart + 1, selEnd);
                        }
                    }
                } else if (selEnd - selStart == 1) {
                    char charEnd = text.charAt(selEnd);
                    if (Utils.BUILD_CONFIG_DEBUG_MODE) {
                        Utils.debugFormat("[CGTEST] onSelectionChanged char selEnd: %s", charEnd);
                    }
                    String rightText = text.substring(selStart);
                    ReplacementSpan[] spans = baseEditChat.getEditableText().getSpans(selStart, selStart, ReplacementSpan.class);
                    if ((rightText.startsWith("<") || (rightText.startsWith("[") && !rightText.startsWith("[<") && !rightText.startsWith("[[")))
                            && spans != null && spans.length > 0) {
                        if (Utils.BUILD_CONFIG_DEBUG_MODE) {
                            Utils.debug("[CGTEST] onSelectionChanged find span: " + spans[0]);
                        }
                        baseEditChat.setSelection(selStart);
                    }
                }
            }
        }
    }

    private boolean needStepCursor(char c1, char c2, ReplacementSpan[] spans) {
        if (Utils.BUILD_CONFIG_DEBUG_MODE) {
            Utils.debugFormat("[CGTEST] needStepCursor char at cursor: %s, %s", c1, c2);
            if (spans != null) {
                for (ReplacementSpan span : spans) {
                    Utils.debugFormat("[cgtest] needStepCursor span: %s", span);
                }
            }
        }
        return (c1 == '/' && c2 == '>' && hasSpecifiedSpan(AtSpan.class, spans)) ||
                (c2 == ']' && hasSpecifiedSpan(SizableImageSpan.class, spans)) ||
                (faceUtils.containEmoji(HexUtil.charArrayToHexString(new char[]{c1, c2})));
    }


    private boolean hasSpecifiedSpan(Class spanClass, ReplacementSpan[] spans) {
        if (spans == null || spans.length == 0) return false;

        return spans[0].getClass() == spanClass;
    }



    private boolean checkAndStepCursor(EditText editText, int selStart, int selEnd) {
        if (Utils.BUILD_CONFIG_DEBUG_MODE) {
            Utils.debugFormat("[cgtest] checkAndStepCursor selstart: %d selend: %d", selStart, selEnd);
        }
        String text = editText.getText().toString();
        if (selEnd < text.length() - 1) {
            char cStart = text.charAt(selStart);
            char cEnd = text.charAt(selEnd);
            if (Utils.BUILD_CONFIG_DEBUG_MODE) {
                Utils.debugFormat("[cgtest] checkAndStepCursor cStart: %s cEnd: %s", cStart, cEnd);
            }
            ReplacementSpan[] spansEnd = editText.getText().getSpans(selEnd, selEnd, ReplacementSpan.class);
            char cEnd1 = text.charAt(selEnd - 1);
            boolean needStepEnd = needStepCursor(cEnd1, cEnd, spansEnd);
            if (Utils.BUILD_CONFIG_DEBUG_MODE) {
                Utils.debugFormat("[cgtest] checkAndStepCursor needStepEnd: %s", needStepEnd);
            }
            if (selStart == 0) {
                if (needStepEnd) {
                    editText.setSelection(selStart, selEnd + 1);
                    return true;
                }
            } else {
                char cStart1 = text.charAt(selStart - 1);
                ReplacementSpan[] spansStart = editText.getText().getSpans(selStart, selStart, ReplacementSpan.class);
                boolean needStepStart = needStepCursor(cStart1, cStart, spansStart);
                if (Utils.BUILD_CONFIG_DEBUG_MODE) {
                    Utils.debugFormat("[cgtest] checkAndStepCursor needStepStart: %s", needStepStart);
                }
                if (needStepStart || needStepEnd) {
                    int newStart = needStepStart ? selStart + 1 : selStart;
                    int newEnd = needStepEnd ? selEnd + 1 : selEnd;
                    editText.setSelection(newStart, newEnd);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean onEditTextKeyPreIme(int keyCode, KeyEvent event) {
        EditText editText = baseEditChat;
        if (editText == null) {
            return false;
        }

        if (event.getAction() == KeyEvent.ACTION_DOWN) {
            switch (keyCode) {
                case KeyEvent.KEYCODE_DEL:
                    deleteEmojiOrCharInEditText(editText);
                    return true;
                case KeyEvent.KEYCODE_ENTER:
                    addEnterInText(editText);
                    return true;
            }
        } else if (event.getAction() == KeyEvent.ACTION_UP) {
            switch (keyCode) {
                case KeyEvent.KEYCODE_DEL:
                case KeyEvent.KEYCODE_ENTER:
                    return true;
            }
        }
        return false;
    }

    private void addEnterInText(EditText editText) {
        Editable editable = editText.getText();
        int selectionStart = editText.getSelectionStart();// 获取光标的位置
        int selectionEnd = editText.getSelectionEnd();
        editable.replace(selectionStart, selectionEnd, "\n");
    }

    public void setVideoChatMode(boolean videoChatMode) {
        this.videoChatMode = videoChatMode;

        if (functionMenuView != null) {
            if (videoChatMode) {
                functionMenuView.disableMenus(FunctionMenuCode.VIDEO_RECORD, FunctionMenuCode.VOICE_RECORD, FunctionMenuCode.PHOTO_CAPTURE);
            } else {
                functionMenuView.enableMenus(FunctionMenuCode.VIDEO_RECORD, FunctionMenuCode.VOICE_RECORD, FunctionMenuCode.PHOTO_CAPTURE);
            }
        }

        setAudioRecordEnable(!videoChatMode);

        if (isRecorderViewShow()) {
            return;
        }
        if (isAddEmoji() || isFaceShow() || isAddFunctionMenuView() || isFunctionMenuViewShow()) {
            showFunctionBar(false);
            return;
        }
        if (isKeyboardShow()) {
            showFunctionBar(false);
        } else {
            showFunctionBar(isFunctionBarShow());
        }
    }

    protected boolean isFunctionBarShow(){
        return false;
    }
    public boolean isVideoChatMode() {
        return videoChatMode;
    }

    protected void showFunctionBar(boolean show) {
        if (baseEditRegion != null) {
            baseEditRegion.setVisibility(show ? View.GONE : View.VISIBLE);
        }
        if (baseFunctionRegion != null) {
            baseFunctionRegion.setVisibility(show ? View.VISIBLE : View.GONE);
        }
    }

    public void showPptOngoingProgress(boolean show) {
        if (startPptBtn != null) {
            startPptBtn.setBackgroundResource(show ? R.drawable.handwin_selector_func_btn_bg_going : R.drawable.handwin_selector_font_background_chat_more);
            startPptBtn.setTextColor(getResources().getColor(show ? R.color.handwin_bg_white : R.color.handwin_G1));
        }
        showFunctionBar(isFunctionBarShow());
    }

    @Override
    public void batchSendMessageResponse(DuduMessage curUserMsg, String msgType, String currenChattingUser, Runnable callback) {
    }

    @Override
    public void compressImagesResp(boolean hasChatting) {
    }

    public static void deleteEmojiOrCharInEditText(EditText editText) {
        if (Utils.BUILD_CONFIG_DEBUG_MODE) {
            Utils.debug("[CGTEST] deleteEmojiOrCharInEditText");
        }
        int selectionStart = editText.getSelectionStart();// 获取光标的位置
        int selectionEnd = editText.getSelectionEnd();
        String msg = editText.getText().toString();
        if (selectionEnd - selectionStart > 0) {
            if (Utils.BUILD_CONFIG_DEBUG_MODE) {
                String selectedText = msg.substring(selectionStart, selectionEnd);
                Utils.debugFormat("[CGTEST] deleteEmojiOrCharInEditText - selection start: %d end: %d section: %s", selectionStart, selectionEnd, selectedText);
            }
            editText.getText().delete(selectionStart, selectionEnd);
        } else if (selectionStart > 0 && !TextUtils.isEmpty(msg)) {

            String leftText = msg.substring(0, selectionStart);
            int deletionStart = leftText.length() - 1;
            int deletionEnd = selectionStart;
            Editable editable = editText.getText();
            ReplacementSpan[] spans = editable.getSpans(deletionStart, deletionStart, ReplacementSpan.class);
            if ((leftText.endsWith("/>") || (leftText.endsWith("]") && !leftText.endsWith("/>]") && !leftText.endsWith("]]")))
                    && spans != null && spans.length > 0) {
                if (Utils.BUILD_CONFIG_DEBUG_MODE) {
                    Utils.debugFormat("[CGTEST] deleteEmojiOrCharInEditText obj at cursor : %s", spans[0]);
                }
                deletionStart = editable.getSpanStart(spans[0]);
                deletionEnd = editable.getSpanEnd(spans[0]);
            } else if (leftText.length() >= 2) {
                // check if it's system standard emoji
                char c1 = leftText.charAt(leftText.length() - 2);
                char c2 = leftText.charAt(leftText.length() - 1);
                String emojiCode = HexUtil.charArrayToHexString(new char[]{
                        c1, c2});
                if (Utils.BUILD_CONFIG_DEBUG_MODE) {
                    Utils.debug("emoji code: " + emojiCode);
                }
                if (FaceUtils.getInstance_(MainApp.getInstance()).containEmoji(emojiCode)) {
                    // delete system emoji
                    deletionStart = leftText.length() - 2;
                }
            }

            editable.delete(deletionStart, deletionEnd);
        }
    }

    public void setAudioRecordEnable(boolean enable) {
        if (audioOrInputBtn != null) {
            audioOrInputBtn.setEnabled(enable);
            audioOrInputBtn.setAlpha(enable ? 1.0f : 0.5f);
        }
    }

}
