package me.chatgame.uisdk.activity.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.RelativeLayout;
import android.widget.TextView;

import me.chatgame.mobilecg.constant.RecorderStatus;
import me.chatgame.mobilecg.database.entity.DuduContact;
import me.chatgame.mobilecg.handler.VoipAndroidManager;
import me.chatgame.mobilecg.handler.interfaces.IAudioWindCallback;
import me.chatgame.mobilecg.handler.interfaces.IVoipAndroidManager;
import me.chatgame.mobilecg.util.AnimUtils;
import me.chatgame.mobilecg.util.AudioUtils;
import me.chatgame.mobilecg.util.UiThreadExecutor;
import me.chatgame.mobilecg.util.Utils;
import me.chatgame.mobilecg.util.interfaces.IAnimUtils;
import me.chatgame.mobilecg.util.interfaces.IAudioUtils;
import me.chatgame.mobilecg.views.AudioRecordWaveView;
import me.chatgame.mobilecg.views.ProgressWheel;
import me.chatgame.uisdk.R;

/**
 * Created by star on 15/12/24.
 */
public class BaseRecorderView extends RelativeLayout implements IAudioWindCallback {
    static final int MAX_DURATION = 60; // seconds
    static final int MAX_DURATION_MS = MAX_DURATION * 1000;

    protected VideoAudioRecorderView videoAudioRecorderView;
    protected RelativeLayout chatView;
    protected RecorderStatus recorderStatus = RecorderStatus.idle;
    protected BaseSendEditorView sendEditorView;

    protected boolean isUiReset = true;
    protected boolean isPlayedZoomAnim = false;
    protected float touchX;
    protected int scaledTouchSlop;
    protected boolean isBurned = false;

    ProgressWheel wheelProgress;
    AudioRecordWaveView recordWaveView;
    TextView tvStartDeleteRecord;

    IAudioUtils audioUtils;
    IVoipAndroidManager voipAndroidManager;
    IAnimUtils animUtils;


	protected boolean isLocalContact = false;
	
    public BaseRecorderView(Context context) {
        super(context);
        initialize();
    }

    public BaseRecorderView(Context context, AttributeSet attrs) {
        super(context, attrs);
        initialize();
    }

    public BaseRecorderView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initialize();
    }

    void initialize() {
        voipAndroidManager = VoipAndroidManager.getInstance_(getContext());
        audioUtils = AudioUtils.getInstance_(getContext()) ;
        animUtils = AnimUtils.getInstance_(getContext());

    }

    void afterViews() {
        scaledTouchSlop = ViewConfiguration.get(getContext()).getScaledTouchSlop();

        tvStartDeleteRecord.setText(getRecordStartInfoText());
        configViewColor(getConfigColor());

    }

    public void setChatView(RelativeLayout chatView) {
        this.chatView = chatView;
    }

    public void setVideoAudioRecorderView(VideoAudioRecorderView videoAudioRecorderView) {
        this.videoAudioRecorderView = videoAudioRecorderView;
    }

    public void onResume() {

    }

    public void onPause() {

    }

    protected void playSendSound() {
        if (videoAudioRecorderView != null) {
            videoAudioRecorderView.playRecordSendSound();
        }
    }

    protected void stopVideoAudioPlay() {
        if (videoAudioRecorderView != null) {
            videoAudioRecorderView.stopVideoAudioPlay();
        }
    }

    protected void restartVideoPlay() {
        if (videoAudioRecorderView != null) {
            videoAudioRecorderView.restartVideoPlay();
        }
    }

    public synchronized boolean isStatus(RecorderStatus status) {
        return status == recorderStatus;
    }

    protected synchronized void setUiResetFlag(boolean uiResetFlag) {
        Utils.debugFormat("[cgtest] setUiResetFlag %s", uiResetFlag);
        this.isUiReset = uiResetFlag;
    }

    protected synchronized boolean isUiReset() {
        return isUiReset;
    }






    protected void setRecordProgressOnView(int progress) {
        wheelProgress.setProgress(progress);
    }

    protected void updataTimeDuration(int currentDuration) {
        recordWaveView.updateCurrTime(currentDuration);
    }


    protected void enableParentTouch() {
        UiThreadExecutor.runTask(this::enableParentTouch_);
    }
    protected void enableParentTouch_() {
        requestDisallowInterceptTouchEvent(false);
        if (videoAudioRecorderView != null) {
            videoAudioRecorderView.enableViewPagerTouch();
        }
        if (recordWaveView != null) {
            recordWaveView.cancelBlinkAnimation();
        }
    }

    protected void disableParentTouch() {
        UiThreadExecutor.runTask(this::disableParentTouch_);
    }
    protected void disableParentTouch_() {
        requestDisallowInterceptTouchEvent(true);
        if (videoAudioRecorderView != null) {
            videoAudioRecorderView.disableViewPagerTouch();
        }
    }

    public synchronized void setRecorderStatus(RecorderStatus recorderStatus) {
        Utils.debugFormat("[%s] set recorder status: %s", this.getClass().getSimpleName(), recorderStatus);
        this.recorderStatus = recorderStatus;
    }

    public void setSendEditorView(BaseSendEditorView sendEditorView) {
        this.sendEditorView = sendEditorView;

		if (sendEditorView instanceof SingleChatSendEditorView) {
			DuduContact contact = ((SingleChatSendEditorView) sendEditorView)
					.getContact();
			if (contact != null) {
				isLocalContact = contact.isLocal();
            }
        }
        tvStartDeleteRecord.setText(getRecordStartInfoText());

	}

    public void setInfoTextAlpha(float alpha) {
        tvStartDeleteRecord.setAlpha(alpha);
    }

    protected void showPrepareTip() {
        if (isStatus(RecorderStatus.idle)) {
            tvStartDeleteRecord.setVisibility(View.VISIBLE);
            tvStartDeleteRecord.setTextColor(isBurned ? getResources().getColor(R.color.handwin_record_alert_color) : getConfigColor());
            tvStartDeleteRecord.setText(R.string.handwin_preparing);
            if (null != videoAudioRecorderView) {
                videoAudioRecorderView.setImgButtonVisiabe(false);
            }
        }
    }

    protected void onTouchDown() {

    }

    void showNeedLongPressTips() {
        UiThreadExecutor.runTask(this::showNeedLongPressTips_);
    }
    void showNeedLongPressTips_() {
        if (null != videoAudioRecorderView) {
            videoAudioRecorderView.showRecordAlertTips(getNeedLongPressTipText(), getAlertBgResId());
        }
    }

    protected String getNeedLongPressTipText() {
        return getResources().getString(R.string.handwin_tips_video_audio_record_need_long_press);
    }

    protected String getRecordStartInfoText() {
        return getResources().getString(R.string.handwin_audio_record_start);
    }

    protected int getConfigColor() {
        return getResources().getColor(R.color.handwin_G2);
    }

    protected int getDeleteColor() {
        return getResources().getColor(R.color.handwin_record_alert_color);
    }

    protected int getDeleteBgRes() {
        return R.drawable.handwin_recorder_alert_inner_circle;
    }

    protected String getRecordButtonIcon() {
        return getResources().getString(R.string.handwin_font_img_audio_record);
    }

    protected int getRecordButtonBgRes() {
        return R.drawable.handwin_audio_recorder_inner_circle;
    }

    protected int getAlertBgResId() {
        return R.drawable.handwin_shape_bg_audio_record_toast;
    }

    public ColorStateList getTabColor() {
        return getResources().getColorStateList(R.color.handwin_selector_color_audio_recorder_bottom_text);
    }

    protected void setRecordProgress(final int value) {
        int progress = (int) Math.ceil(value * 360f / MAX_DURATION_MS);
        int currentDuration = value / 1000;
        if (currentDuration > MAX_DURATION) {
            processRecordTimeOut(false);
            return;
        }
        setRecordProgressOnView(progress);
        updataTimeDuration(currentDuration);
    }

    protected void changeMicViewByVolume(int volume) {
        recordWaveView.updateVolumeValue(volume);
    }

    void processRecordTimeOut(boolean stopVOIPRecord) {
    }

    @Override
    public void audioIsWind(boolean isWind) {

    }

    @Override
    public void audioDB(int dB) {
        changeMicViewByVolume(dB);
    }

    @Override
    public void audioNotification(int code) {

    }

    protected void configViewColor(int color) {
        recordWaveView.setColor(color);
        wheelProgress.setBarColor(color);
    }

}
