package me.chatgame.uisdk.activity.view;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.app.Activity;
import android.app.Fragment;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.LinearInterpolator;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;

import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import me.chatgame.mobilecg.IMService;
import me.chatgame.mobilecg.MainApp;
import me.chatgame.mobilecg.actions.ConversationActions;
import me.chatgame.mobilecg.actions.DuduMessageActions;
import me.chatgame.mobilecg.actions.SceneActions;
import me.chatgame.mobilecg.actions.interfaces.IConversationActions;
import me.chatgame.mobilecg.actions.interfaces.IDuduMessageActions;
import me.chatgame.mobilecg.actions.interfaces.ISceneActions;
import me.chatgame.mobilecg.activity.ImageChooseActivity;
import me.chatgame.mobilecg.activity.view.BaseRelativeLayout;
import me.chatgame.mobilecg.activity.view.ShortVideoView;
import me.chatgame.mobilecg.activity.view.interfaces.IChatEvent;
import me.chatgame.mobilecg.activity.view.interfaces.ILiveActivity;
import me.chatgame.mobilecg.activity.view.interfaces.KeyboardStateListener;
import me.chatgame.mobilecg.adapter.BaseChatListAdapter;
import me.chatgame.mobilecg.adapter.viewholder.AudioViewHolder;
import me.chatgame.mobilecg.adapter.viewholder.VideoViewHolder;
import me.chatgame.mobilecg.call.CallState;
import me.chatgame.mobilecg.constant.CallSceneCommandType;
import me.chatgame.mobilecg.constant.Constant;
import me.chatgame.mobilecg.constant.ErrorCode;
import me.chatgame.mobilecg.constant.ExtraInfo;
import me.chatgame.mobilecg.constant.MessageType;
import me.chatgame.mobilecg.constant.ReqCode;
import me.chatgame.mobilecg.constant.SceneConstant;
import me.chatgame.mobilecg.database.entity.BaseContact;
import me.chatgame.mobilecg.database.entity.DuduContact;
import me.chatgame.mobilecg.database.entity.DuduMessage;
import me.chatgame.mobilecg.events.CallSceneInfo;
import me.chatgame.mobilecg.events.DeleteChatMsgEvent;
import me.chatgame.mobilecg.events.HidePresentationViewEvent;
import me.chatgame.mobilecg.events.LivingStartEvent;
import me.chatgame.mobilecg.events.MsgStatusChangeEvent;
import me.chatgame.mobilecg.events.NewMessageEvent;
import me.chatgame.mobilecg.events.SendMsgFromOutsideEvent;
import me.chatgame.mobilecg.events.ShowUnsentMsgEvent;
import me.chatgame.mobilecg.handler.AudioHandler;
import me.chatgame.mobilecg.handler.CameraHandler;
import me.chatgame.mobilecg.handler.ConfigHandler;
import me.chatgame.mobilecg.handler.DBHandler;
import me.chatgame.mobilecg.handler.EventSender;
import me.chatgame.mobilecg.handler.GroupVideoHandler;
import me.chatgame.mobilecg.handler.SlideSceneHandler;
import me.chatgame.mobilecg.handler.SpeakerHandler;
import me.chatgame.mobilecg.handler.UserHandler;
import me.chatgame.mobilecg.handler.VoipAndroidManager;
import me.chatgame.mobilecg.handler.interfaces.IAudioHandler;
import me.chatgame.mobilecg.handler.interfaces.ICamera;
import me.chatgame.mobilecg.handler.interfaces.IConfig;
import me.chatgame.mobilecg.handler.interfaces.IDBHandler;
import me.chatgame.mobilecg.handler.interfaces.IEventSender;
import me.chatgame.mobilecg.handler.interfaces.IGroupVideoHandler;
import me.chatgame.mobilecg.handler.interfaces.ISlideSceneHandler;
import me.chatgame.mobilecg.handler.interfaces.ISpeakerHandler;
import me.chatgame.mobilecg.handler.interfaces.IUserHandler;
import me.chatgame.mobilecg.handler.interfaces.IVideoMessagePlayUtils;
import me.chatgame.mobilecg.handler.interfaces.IVoipAndroidManager;
import me.chatgame.mobilecg.layoutmanager.ChatLayoutManager;
import me.chatgame.mobilecg.listener.ChatListEventListener;
import me.chatgame.mobilecg.listener.SceneStatusListener;
import me.chatgame.mobilecg.model.ActivityResult;
import me.chatgame.mobilecg.model.MessageCache;
import me.chatgame.mobilecg.net.image.ImageMemoryCache;
import me.chatgame.mobilecg.net.protocol.VideoSceneInfo;
import me.chatgame.mobilecg.util.AnimUtils;
import me.chatgame.mobilecg.util.AudioMessagePlayUtils;
import me.chatgame.mobilecg.util.BackgroundExecutor;
import me.chatgame.mobilecg.util.DialogHandle;
import me.chatgame.mobilecg.util.FaceUtils;
import me.chatgame.mobilecg.util.GroupCacheManager;
import me.chatgame.mobilecg.util.NotifyUtils;
import me.chatgame.mobilecg.util.UiThreadExecutor;
import me.chatgame.mobilecg.util.UnsentMessageCacheManager;
import me.chatgame.mobilecg.util.Utils;
import me.chatgame.mobilecg.util.VideoMessagePlayUtils;
import me.chatgame.mobilecg.util.interfaces.IAnimUtils;
import me.chatgame.mobilecg.util.interfaces.IAudioMessagePlayUtils;
import me.chatgame.mobilecg.util.interfaces.IDialogHandle;
import me.chatgame.mobilecg.util.interfaces.IFaceUtils;
import me.chatgame.mobilecg.util.interfaces.IGroupCacheManager;
import me.chatgame.mobilecg.util.interfaces.INotifyUtils;
import me.chatgame.mobilecg.util.interfaces.IUnsentMessageCacheManager;
import me.chatgame.mobilecg.viewinterfaces.IConversationView;
import me.chatgame.mobilecg.viewinterfaces.IMessageView;
import me.chatgame.mobilecg.views.refresh.PullToRefreshRecyclerView;
import me.chatgame.uisdk.R;
import me.chatgame.voip.VoipAndroid;

/**
 * Created by star on 15/11/5.
 */
public class BaseChatView<ADAPTER extends BaseChatListAdapter, CHAT_ENTITY extends BaseContact> extends BaseRelativeLayout implements ChatListEventListener, BaseSendEditorView.MessageAddListener,
        KeyboardStateListener, BaseSendEditorView.EmojiPanelListener, SceneStatusListener, BaseChatPresentationView.PresentationActionListener,
        IMessageView, IConversationView, BaseSendEditorView.FunctionMenuViewListener {

    protected static final float scaleStart = 0.9f;
    protected static final float scaleEnd = 1.0f;

    public static final int SIZE = 20;
    static final float alphaStart = 0.0f;
    static final float alphaEnd = 1f;

    private static final long DOUBLE_CLICK_INTERNAL = 300L;
    private static final float MAX_MOVE_DISTANCE = 20.0f;
    protected boolean ready;
    protected boolean exiting = false;
    private boolean needOpenRecorderViewOnEnter = false;

    protected MainApp app;

    protected TextView txtIconBack;
    protected PullToRefreshRecyclerView listDatas;
    protected TextView tvNewMessage;
    protected View newTipLayout;
    protected ProgressBar ivChatLoading;

    protected IAnimUtils animUtils;
    protected IFaceUtils faceUtils;
    protected IAudioHandler audioHandler;
    protected IDBHandler dbHandler;
    protected INotifyUtils notifyUtils;
    protected ICamera cameraHandler;
    protected IGroupCacheManager groupCacheManager;
    protected IDuduMessageActions duduMessageAction;
    protected IUserHandler userHandler;
    protected ISpeakerHandler speakerHandler;
    protected IVideoMessagePlayUtils videoMessagePlayUtils;
    protected IVoipAndroidManager voipAndroidManager;
    protected IAudioMessagePlayUtils audioMessagePlayUtils;
    protected IMService imService;
    protected IDialogHandle dialogHandle;
    protected IUnsentMessageCacheManager unsentMessageCacheManager;
    protected IGroupVideoHandler groupVideoHandler;
    public IEventSender eventSender;
    protected IConversationActions conversationActions;
    public ISceneActions sceneActions;
    protected ISlideSceneHandler slideSceneHandler;
    public IConfig configHandler;

    protected IChatEvent chatEvent;

    protected ILiveActivity liveActivity;

    protected VideoSceneInfo videoSceneInfo;

    protected ADAPTER adapter;

    protected Activity activity;

    private LinearLayoutManager layoutManager;
    protected RecyclerView datasView;
    protected MessageCache messageCache = null;
    protected BaseSendEditorView baseSendEditorView;
    protected ImageView baseImgEmpty;
    protected BaseChatPresentationView chatPresentationView;
    protected boolean emojiShow = false;
    private boolean isSlideSceneMode = false;
    private boolean isPrepareScene = false;

    protected boolean isActivityDestroy = false;
    private int loadCount;
    private float perTouchX = 0;
    private float perTouchY = 0;
    private long touchDownTime = 0;
    private long preClickTime;

    private boolean isAddMoreImages = false;

    // 上方显示未读信息的用户Id
    protected String unReadMessageUser = null;

    protected String otherFrom;
    protected long startTime;
    protected String curConversationType;
    protected long messageId = Long.MAX_VALUE;
    //private boolean isLoudSpeaker = true;
    private boolean scrollToBottomOnExitPresentation = false;

    protected DuduMessage[] tempFirstLoadedMessages;

    protected OnTouchListener recyclerViewOnTouchListener = new OnTouchListener() {
        @Override
        public boolean onTouch(View v, MotionEvent event) {
            switch (event.getAction()) {
                case MotionEvent.ACTION_DOWN:
                    perTouchX = event.getRawX();
                    perTouchY = event.getRawY();
                    touchDownTime = System.currentTimeMillis();
                    break;
                case MotionEvent.ACTION_MOVE:
                    processOneClick();
                    return false;
                case MotionEvent.ACTION_UP:
                    float touchUpX = event.getRawX();
                    float touchUpY = event.getRawY();
                    if (Math.abs(touchUpX - perTouchX) > MAX_MOVE_DISTANCE
                            || Math.abs(touchUpY - perTouchY) > MAX_MOVE_DISTANCE) {
                        return false;// 移动
                    }
                    long nowTime = System.currentTimeMillis();
                    if (nowTime - touchDownTime > 500) {// 长按
                        return false;
                    }
                    if (nowTime - preClickTime < DOUBLE_CLICK_INTERNAL) {
                        // 双击
                        processDoubleClick();
                    } else {
                        // 单击
                        preClickTime = nowTime;
                        postDelayed(() -> {
                            if (!isActivityDestroy) {
                                processOneClick();
                            }
                        }, DOUBLE_CLICK_INTERNAL);
                    }
                    break;
            }
            return false;
        }
    };


    public BaseChatView(Context context) {
        super(context);
    }

    public BaseChatView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public BaseChatView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }


    protected void init() {
        app = MainApp.getInstance();
        configHandler = ConfigHandler.getInstance_(getContext());
        voipAndroidManager = VoipAndroidManager.getInstance_(getContext());
        duduMessageAction = DuduMessageActions.getInstance_(getContext(), this);
        conversationActions = ConversationActions.getInstance_(getContext(), this);
        sceneActions = SceneActions.getInstance_(getContext());
        eventSender = EventSender.getInstance_();
        cameraHandler = CameraHandler.getInstance_(getContext());
        faceUtils = FaceUtils.getInstance_(getContext());
        animUtils = AnimUtils.getInstance_(getContext());
        audioMessagePlayUtils = AudioMessagePlayUtils.getInstance_(getContext());
        dialogHandle = DialogHandle.getInstance_();
        speakerHandler = SpeakerHandler.getInstance_(getContext());
        notifyUtils = NotifyUtils.getInstance_(getContext());
        groupCacheManager = GroupCacheManager.getInstance_(getContext());
        slideSceneHandler = SlideSceneHandler.getInstance_(getContext());
        unsentMessageCacheManager = UnsentMessageCacheManager.getInstance_(getContext());
        groupVideoHandler = GroupVideoHandler.getInstance_();
        audioHandler = AudioHandler.getInstance_(getContext());
        dbHandler = DBHandler.getInstance_(getContext());
        userHandler = UserHandler.getInstance_(getContext());
        imService = IMService.getInstance_(getContext()) ;
        videoMessagePlayUtils = VideoMessagePlayUtils.getInstance_(getContext());
    }

    public void setBaseImgEmpty(ImageView baseImgEmpty) {
        this.baseImgEmpty = baseImgEmpty;
    }

    protected void afterViews() {
//        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
//            setFitsSystemWindows(true);
//        }
        init();
        activity = (Activity) getContext();
        this.setOnTouchListener((v, event) -> {
            // 拦截触摸事件
            return true;
        });

        messageCache = new MessageCache();

        initChatList();
        initKeyboardEvent();

    }

    protected void initSendEditorView() {
        if (baseSendEditorView == null) {
            baseSendEditorView = createSendEditorView();
            if (baseSendEditorView != null) {
                baseSendEditorView.registerLifeCycle();
                if (chatPresentationView != null) {
                    chatPresentationView.bringToFront();
                }
                baseSendEditorView.setVisibility(View.INVISIBLE);
                playSendEditorAnimation();

                baseSendEditorView.setMessageAddListener(this);
                baseSendEditorView.setKeyboardStateListener(this);
                baseSendEditorView.setEmojiPanelStateListener(this);
                baseSendEditorView.setFunctionMenuViewListener(this);
                baseSendEditorView.setSceneStatusListener(this);
                baseSendEditorView.setChatView(this);
            }
        }
    }

    public void onEnter(CHAT_ENTITY chatEntity) {
        if (adapter != null) {
            adapter.removeAll();
        }
        registerLifeCycle();
        exiting = false;
        initSendEditorView();
    }

    void playSendEditorAnimation() {
        UiThreadExecutor.runTask(this::playSendEditorAnimation_,50);
    }
    void playSendEditorAnimation_() {
        View sendEditorView = baseSendEditorView;
        if (sendEditorView != null && !exiting) {
            sendEditorView.setVisibility(View.VISIBLE);
            AnimationSet set = new AnimationSet(true);
            set.setInterpolator(new LinearInterpolator());
            set.setDuration(300);
            AlphaAnimation alphaAnimation = new AlphaAnimation(0.5f, 1f);
            set.addAnimation(alphaAnimation);
            sendEditorView.startAnimation(set);
        }
    }

    protected BaseSendEditorView createSendEditorView() {
        return null;
    }

    private void initChatList() {
        setBackgroundResource(R.color.handwin_bg_chat_list);
        datasView = listDatas.getRefreshableView();

        listDatas.setOnRefreshListener(refreshView -> {
            Utils.debug("onRefresh more");
            refreshTalkDatas(true, true);
        });

        layoutManager = new ChatLayoutManager(this.getContext(),
                LinearLayoutManager.VERTICAL, true, () -> {
        });

        datasView.setLayoutManager(layoutManager);

        datasView.addOnScrollListener(new RecyclerView.OnScrollListener() {

            @Override
            public void onScrollStateChanged(RecyclerView recyclerView,
                                             int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                // 滑动停止的时候，检查是否在最底部
                if (newState == RecyclerView.SCROLL_STATE_IDLE) {
                    if (!isAtListBottom()) {
                        return;
                    }
                    // 隐藏新消息提示文字
                    if (newTipLayout != null && newTipLayout.getVisibility() == View.VISIBLE) {
                        newTipLayout.setVisibility(View.GONE);
                    }
                }
            }

        });

        datasView.setOnTouchListener(recyclerViewOnTouchListener);

        adapter = createAdapter();
        initChatListAdapter(datasView, adapter);
    }

    protected ADAPTER createAdapter() {
        return null;
    }

    protected void initChatListAdapter(RecyclerView recyclerView, ADAPTER adapter) {
    }

    public void setAdapter() {
        if (datasView != null && adapter != null) {
            datasView.setAdapter(adapter);
        }
        // 检查是否登录状态
        boolean isLogin = imService.messageServerIsLogined();
        showNetLoadingAnim(!isLogin);
    }

    public void resetAdapter() {
        if (adapter != null) {
            adapter.removeAll();
        }
        if (datasView != null) {
            datasView.setAdapter(adapter);
        }
    }

    public void refresh() {
        UiThreadExecutor.runTask(this::refresh_);
    }
    public void refresh_() {
        datasView.getAdapter().notifyDataSetChanged();
    }

    protected boolean isAtListBottom() {
        //int pComplete = layoutManager.findFirstCompletelyVisibleItemPosition();
        //int p = layoutManager.findFirstVisibleItemPosition();
        return (layoutManager.findFirstVisibleItemPosition() <= 0);
    }

    /**
     * 刷新聊天消息记录
     *
     * @param more true, load more data; false, load first page of data
     */
    public synchronized void refreshTalkDatas(boolean more, boolean needLoadData) {
        if (needLoadData) {
            loadCount++;
            if (!more) {
                loadCount = 0;
                messageId = Long.MAX_VALUE;
            }
            loadData(more, messageId, SIZE);
        } else {
            refreshDataSet();
        }
    }

    void refreshDataSet() {
        UiThreadExecutor.runTask(this::refreshDataSet_,10);
    }

    void refreshDataSet_() {
        // 延时，等CallWaitCloseView隐藏后再刷新，否则看不到item增加的效果
        adapter.notifyDataSetChanged();
    }

    protected synchronized void setReady(boolean ready) {
        this.ready = ready;
    }

    public synchronized boolean isReady() {
        return ready;
    }

    public void hideChatList() {
        listDatas.setVisibility(View.INVISIBLE);
    }

    protected void showChatList() {
        listDatas.setVisibility(View.VISIBLE);
    }

    public void prepareToEnter() {
        setReady(false);
        hideChatList();
    }

    public synchronized void show(boolean playAnimator) {
        if (playAnimator) {
            datasView.setScaleX(scaleStart);
            datasView.setScaleY(scaleStart);
            datasView.setAlpha(alphaStart);
        }
        doAfterViews();
        messageId = Long.MAX_VALUE;
    }

    void doAfterViews() {
        showUnsentMsg();
    }

    void showUnsentMsg() {
        BackgroundExecutor.execute(()->showUnsentMsg_(),"","unsent_msg", BackgroundExecutor.ThreadType.IO);
    }

    void showUnsentMsg_() {
        String cid = getConversationId();
        BaseSendEditorView sendEditorView = baseSendEditorView;
        if (cid != null && sendEditorView != null) {
            String unSendMsg = unsentMessageCacheManager.getUnsentMessage(cid);
            sendEditorView.showUnsendMsg(unSendMsg);
        }
    }

    @Subscribe
    public void onShowUnsentMsgEvent(ShowUnsentMsgEvent event) {
        showUnsentMsg();
    }

    public void playEnterAnimation() {
        AnimatorSet set = new AnimatorSet();
        set.setDuration(200);
        set.playTogether(ObjectAnimator.ofFloat(datasView, View.SCALE_X,
                scaleStart, scaleEnd), ObjectAnimator.ofFloat(datasView,
                View.SCALE_Y, scaleStart, scaleEnd), ObjectAnimator.ofFloat(
                datasView, View.ALPHA, alphaStart, alphaEnd));
        set.setStartDelay(100);
        set.addListener(new AnimatorListenerAdapter() {
            @Override
            public void onAnimationEnd(Animator animation) {
                cameraHandler.resume();
            }
        });
        set.start();
    }

    /**
     * Load data
     *
     * @param more
     * @param size
     */
    protected void loadData(boolean more, long messageId, int size) {

    }

    protected void loadData(String cid, boolean more, long messageId, int size) {
        BackgroundExecutor.execute(()->loadData_(cid, more, messageId, size),"",0,"load_chat_data", BackgroundExecutor.ThreadType.IO);
    }

    protected void loadData_(String cid, boolean more, long messageId, int size) {
        DuduMessage[] messages = conversationActions.getChatDatas(more, cid,
                messageId, size);
        showChatDatas(more, messages);
    }

    protected void showChatDatas(boolean more, DuduMessage[] messages) {
        UiThreadExecutor.runTask(()->showChatDatas_(more, messages));
    }
    protected void showChatDatas_(boolean more, DuduMessage[] messages) {
        if (getChatEntity() == null || messages == null) {
            onListRefreshComplete(0, true);
            return;
        }
        if (!more && !isReady()) {
//            Utils.debug("cgtest cache chat tempFirstLoadedMessages");
            tempFirstLoadedMessages = messages;
            return;
        }

        synchronized (this) {
            for (DuduMessage message : messages) {
                if (message.getPid() < messageId) {
                    messageId = message.getPid();
                }
            }
        }
        setDatas(messages, more);
    }

    /**
     * Refresh data
     *
     * @param cid
     */
    public synchronized void refreshData(String cid) {
        adapter.removeAll();
        scrollToBottom();
        messageId = Long.MAX_VALUE;
        loadData(cid, false, messageId, SIZE);
    }


    protected void onListRefreshComplete(int msgSize, boolean smoothScroll) {
        listDatas.onRefreshComplete(smoothScroll);
        listDatas.setPullToRefreshEnabled(msgSize >= SIZE);
    }

    @Override
    public void onVoiceClick(DuduMessage message, boolean isMine) {
        // 如果响应了实体键盘返回，则不再播放音频
        if (this.getVisibility() != VISIBLE) {
            return;
        }
        audioHandler.playOneAudioMessage(adapter, message, isMine);
    }

    public void onPause() {
        stopRecord(true);
        adapter.onPause();
        stopAllPlayingVideo(false);
    }

    public void onResume() {
        stopRecord(true);
        adapter.onResume();

        if (!isPresentationViewShow()
                && (baseSendEditorView == null || !baseSendEditorView.isShowingVideoPreview())) {
            restartAllVideoPlaying();
        }
    }

    private void stopRecord(boolean canceled) {
        if (baseSendEditorView != null) {
            baseSendEditorView.stopRecord(canceled);
        }
    }

    /**
     * 当前是否是硬件键盘
     *
     * @param isHardKeyboard
     */
    public void setHardKeyboard(boolean isHardKeyboard) {
        if (baseSendEditorView != null) {
            baseSendEditorView.setHardKeyboard(isHardKeyboard);
        }
    }

    public void showNetLoadingAnim(boolean start) {
        if (start) {
            ivChatLoading.setVisibility(View.VISIBLE);
        } else {
            ivChatLoading.setVisibility(View.GONE);
        }
    }

    public void onImageChooseResult(int resultCode, Intent data) {
        if (baseSendEditorView != null) {
            baseSendEditorView.onImageChooseResult(resultCode, data);
        }
    }

    public void onPPTImageChooseResult(int resultCode, Intent data) {
        if (isSelectImageForScene()) {
            dialogHandle.showProgressDialog(getContext(), R.string.handwin_tip_dialog_waiting);
            isPrepareScene = false;
            if (!isAddMoreImages) {
                slideSceneHandler.clearAllImages();
            }
            processSelectImagesResult(resultCode, data);
            if (!isAddMoreImages) {
                if (resultCode == Activity.RESULT_OK) {
                    onSceneCreate(SceneConstant.SLIDE_SCENE);
                } else {
                    dialogHandle.closeProgressDialog();
                    Utils.debug("CallSceneDebug onImageChooseResult with fail.");
                }
            } else {
                dialogHandle.closeProgressDialog();
            }
        } else {
            if (isPrepareScene || isAddMoreImages) {
                isPrepareScene = false;
                isAddMoreImages = false;
                if (resultCode == Activity.RESULT_OK) {
                    app.toast(R.string.handwin_start_image_share_fail);
                }
                return;
            }
        }
    }

    private boolean isSelectImageForScene() {
        return (isPrepareScene && !isSlideSceneMode())
                || isSlideSceneMode();
    }

    private void processSelectImagesResult(int resultCode, Intent data) {
        switch (resultCode) {
            case Activity.RESULT_OK:
                String[] paths = data.getStringArrayExtra(ExtraInfo.ALL_PATH);
                if (null == paths || paths.length < 1) {
                    app.toast(R.string.handwin_tips_image_load_fail);
                    return;
                }
                uploadImage(paths);
                break;
            case Activity.RESULT_CANCELED:
                break;
            default:
                app.toast(R.string.handwin_tips_image_load_fail);
                break;
        }
    }

    void uploadImage(String[] paths) {
        BackgroundExecutor.execute(()->uploadImage_(paths), BackgroundExecutor.ThreadType.IO);
    }
    void uploadImage_(String[] paths) {
        if (paths == null) {
            return;
        }
        if (isAddMoreImages) {
            slideSceneHandler.addMoreSlideImages(paths);
            updateSceneView();
        } else {
            slideSceneHandler.addSlideImages(paths);
        }
    }

    void updateSceneView() {
        UiThreadExecutor.runTask(()->updateSceneView_());
    }
    void updateSceneView_() {
        if (null == this.chatPresentationView) {
            return;
        }
        this.chatPresentationView.updateAllViewsAfterAddMore();
    }

    public boolean isPresentationViewShow() {
        View presentationView = chatPresentationView;
        if (presentationView == null) {
            return false;
        }
        return presentationView.getVisibility() == View.VISIBLE;
    }

    @Override
    public void onAddOneMessage(DuduMessage message) {
        addOneDataToList(message);
    }

    protected void addOneDataToList(DuduMessage message) {
        boolean presentationViewShow = isPresentationViewShow();
        adapter.addOne(message, !presentationViewShow);
        if (!presentationViewShow) {
            scrollToBottom();
        } else {
            scrollToBottomOnExitPresentation = true;
        }
    }

    private void checkEmptyTips() {
        if (baseImgEmpty == null || exiting) return;

        boolean show = (adapter.getItemCount() == 0);
        baseImgEmpty.setImageResource(show ? R.drawable.handwin_chat_default : 0);
        baseImgEmpty.setVisibility(show ? View.VISIBLE : View.GONE);
    }

    /**
     * 滑动列表到最底部
     */
    public void scrollToBottom() {
        if (datasView != null) {
            datasView.scrollToPosition(0);
        }
        if (newTipLayout != null) {
            Animation anim = newTipLayout.getAnimation();
            if (anim != null) {
                anim.cancel();
            }
            newTipLayout.setVisibility(View.GONE);
        }

        hideEmptyTips();
    }

    protected void initKeyboardEvent() {
        getViewTreeObserver().addOnGlobalLayoutListener(
                () -> {
                    if (baseSendEditorView != null) {
                        baseSendEditorView.onGlobalLayout(BaseChatView.this);
                    }
                });
    }

    @Override
    public void onKeyboardShow() {
        hideEmptyTips();
    }

    @Override
    public void onKeyboardHide() {
        delayToCheckEmptyTips();
        playRecyclerViewAnimator();
    }

    private void playRecyclerViewAnimator() {
        if (adapter.getItemCount() == 0) {
            return;
        }
        AnimatorSet set = new AnimatorSet();
        set.setDuration(500);
        set.playTogether(ObjectAnimator.ofFloat(datasView, View.ALPHA,
                alphaStart, alphaEnd));
        set.start();
    }

    void delayToCheckEmptyTips() {
        UiThreadExecutor.runTask(this::checkEmptyTips,200);
    }

    /**
     * 双击空白区域
     */
    protected boolean processDoubleClick() {
        if (exiting || !isReady() || Utils.isFastDoubleClick("processDoubleClick")) {
            return false;
        }
        if (baseSendEditorView != null && baseSendEditorView.isAudioRecording()) {
            // 如果正在录音，不需要处理
            return true;
        }
        if (CallState.getInstance().isNotStatus(CallState.Status.Idle)) {
            // 正在通话，不需要处理
            if (this instanceof GroupChatView) {
                if (!couldBack()) {
                    return true;
                }
            } else return true;
        }
        isActivityDestroy = true;
        performExitChat(true, true);
        return false;
    }

    protected void showMessage(DuduMessage[] messages) {
        boolean presentationViewShow = isPresentationViewShow();
        for (DuduMessage data : messages) {
            if (adapter.addOne(data, !presentationViewShow)) {
                if (isSlideSceneMode && presentationViewShow) {
                    chatPresentationView.onAddOneMessage(data, false);
                }
            }
        }
        boolean bottom = isAtListBottom();
        if (bottom) {
            if (presentationViewShow) {
                scrollToBottomOnExitPresentation = true;
            } else {
                scrollToBottom();
            }
        }
    }

    protected void asyncSaveUnsentMessage(String cid, String message) {
        BackgroundExecutor.execute(()->asyncSaveUnsentMessage_(cid, message),"",0,"unsent_msg", BackgroundExecutor.ThreadType.IO);
    }

    void asyncSaveUnsentMessage_(String cid, String message) {
        unsentMessageCacheManager.saveUnsentMessage(cid, message);
    }

    public void changeMessageStatus(String msg_uuid, long uuid,
                                    DuduMessage message) {
        VoipAndroid.VideoMsgPlayerCallback callback = voipAndroidManager.getVideoMsgPlayerCallback();
        if (callback != null && callback instanceof ShortVideoView.VideoMsgCallback) {
            ShortVideoView.VideoMsgCallback videoMsgCallback = (ShortVideoView.VideoMsgCallback) callback;
            if (TextUtils.equals(msg_uuid, videoMsgCallback.getMsgUUID())) {
                videoMsgCallback.setMsgStatus(message.getMsgStatus());
            }
        }

        this.adapter.changeMessageStatus(msg_uuid, uuid, message, !isPresentationViewShow());
    }

    void deleteDataByUUID(String uuid) {
        adapter.deleteDataByUUID(uuid);
        this.audioHandler.stopPlayingDeletedAudio(uuid);
        this.videoMessagePlayUtils.stopPlayingDeletedVideo(uuid);
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onDeleteChatMsgEvent(DeleteChatMsgEvent event) {
        deleteDataByUUID(event.getData());
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onChangeMsgStatus(MsgStatusChangeEvent event) {
        changeMessageStatus(event.getMsgUUid(), event.getUUid(), event.getMessage());
    }

    /**
     * 刷新消息记录
     *
     * @param uuid
     */
    public void updateMessage(String uuid) {
        if (null == adapter) {
            return;
        }
        adapter.refreshOneItemByUUID(uuid, !isPresentationViewShow());
    }

    /**
     * 图片上传中（显示进度）
     *
     * @param message
     */
    public void imageUploading(DuduMessage message) {
        adapter.imageUploading(message, !isPresentationViewShow());
    }

    /**
     * 执行退出聊天
     */
    protected void performExitChat(boolean doubleClick, boolean force) {
        if (baseSendEditorView != null && baseSendEditorView.isKeyboardShow()) {
            Utils.autoCloseKeyboard((Activity) getContext(), baseSendEditorView.getEditText());
            delayToExitChat(doubleClick, force);
        } else {
            chatEvent.exitChat(BaseChatView.this, doubleClick, force);
        }
    }

    void delayToExitChat(boolean doubleClick, boolean force) {
        UiThreadExecutor.runTask(()->delayToExitChat_(doubleClick, force),300);
    }
    void delayToExitChat_(boolean doubleClick, boolean force) {
        chatEvent.exitChat(BaseChatView.this, doubleClick, force);
    }

    public void setDatas(DuduMessage[] messages, boolean more) {
        if (!more) {
            adapter.removeAll();
        }
        List<DuduMessage> datas = filterMessages(Arrays.asList(messages));
        if (!more && messages.length == 0 && getChatEntity() instanceof DuduContact && ((DuduContact) getChatEntity()).getDuduUid().equals(Constant.FRIEND_INVITE_ID)) {
            DuduMessage message = createLocalShareMessage();
            if (null != message) {
                datas.add(message);
            }
        }
        adapter.addAll(datas);
        onListRefreshComplete(messages.length, !more || datas.size() == 0);
        if (more) {
            showEmptyImageTips(false);
            if (datas.size() > 0) {
                int pullToRefreshHeaderH = listDatas.getHeaderSize();
                datasView.scrollBy(0, -pullToRefreshHeaderH);
            }
        } else {
            showEmptyImageTips(datas.size() == 0);
        }
        if (!more && datas.size() > 0) {
            scrollToBottom();
        }
    }

    protected DuduMessage createLocalShareMessage() {
        return null;
    }

    @Override
    @Deprecated
    public void showOfOfflineMessages(int number) {

    }

    @Override
    public List<DuduMessage> getShowingMessages() {
        return adapter.getDatas();
    }

    public boolean isRecordingAudio() {
        return baseSendEditorView != null && baseSendEditorView.isAudioRecording();
    }

    /**
     * 执行单击操作
     */
    protected boolean processOneClick() {
        if (Utils.isFastDoubleClick("processOneClick")) {
            return true;
        }
        if (baseSendEditorView == null) return false;
        if (baseSendEditorView.isAudioRecording()) {
            // 如果正在录音，不处理
            return true;
        }
        if (baseSendEditorView.isRecorderViewShow()) {
            baseSendEditorView.showOrHideRecorderView(false, true);
            baseSendEditorView.onKeyBoardHide();
            return true;
        }
        if (baseSendEditorView.isFaceShow()) {
            baseSendEditorView.showOrHideFacesView(false, false);
            baseSendEditorView.onKeyBoardHide();
            return true;
        }
        if (baseSendEditorView.isFunctionMenuViewShow()) {
            baseSendEditorView.showOrHideFunctionMenuView(false, false);
            baseSendEditorView.onKeyBoardHide();
            return true;
        }
        if (!baseSendEditorView.isKeyboardShow()) {
            // 键盘关闭，不处理
            return true;
        }

        Utils.autoCloseKeyboard((Activity) getContext(), baseSendEditorView.getEditText());
        baseSendEditorView.showOrHideFacesView(false);
        EditText editText = baseSendEditorView.getEditText();
        if (editText != null) {
            editText.clearFocus();
        }
        return false;
    }

    /**
     * 切换按钮动画
     */
    protected void showButtonsAnimation(View view) {
        view.setVisibility(View.VISIBLE);
        AnimatorSet animT = (AnimatorSet) AnimatorInflater.loadAnimator(
                this.getContext(), R.animator.handwin_bottom_bar_in);
        animT.setTarget(view);
        animT.start();
    }

    /**
     * 内容为空提示
     *
     * @param forceClear
     */
    public void showEmptyImageTips(boolean forceClear) {

        if (forceClear) {
            newTipLayout.setVisibility(View.GONE);
            adapter.removeAll();
        }

        if (baseImgEmpty == null || baseSendEditorView == null) {
            return;
        }

        boolean hide = ((adapter.getItemCount() > 0) || baseSendEditorView.isKeyboardShow()
                || baseSendEditorView.isAddEmoji());
        baseImgEmpty.setImageResource(hide ? 0 : R.drawable.handwin_chat_default);
        baseImgEmpty.setVisibility(hide ? View.GONE : View.VISIBLE);
        float s = hide ? 1 : 0;
        float e = hide ? 0 : 1;
        AlphaAnimation alphaAnimation = new AlphaAnimation(s, e);
        alphaAnimation.setDuration(300);
        alphaAnimation.setInterpolator(new LinearInterpolator());

        Animation oldAnim = baseImgEmpty.getAnimation();
        if (oldAnim != null && !oldAnim.hasEnded()) {
            oldAnim.cancel();
        }
        baseImgEmpty.startAnimation(alphaAnimation);
    }

    protected void hideEmptyTips() {
        if (baseImgEmpty != null && baseImgEmpty.getVisibility() == View.VISIBLE) {
            baseImgEmpty.setVisibility(View.GONE);
        }
    }

    protected void titleBackClick() {
        // 统计，左上角按钮返回
        if (!couldBack() || exiting) {
            return;
        }
        if (isReady()) {
            performExitChat(false, true);
        }
    }

    public boolean couldBack() {
        return true;
    }


    protected void newMessageTipsClicked() {
        if (Utils.isFastDoubleClick() || Utils.isNull(this.otherFrom)) {
            return;
        }
        chatEvent.enterChat(curConversationType, this.otherFrom);
        tvNewMessage.setVisibility(View.GONE);
    }

    /**
     * 聊天界面退出
     *
     * @param force
     * @return true failed to exit, false exit successfully
     */
    public boolean exit(boolean force) {
        if (baseSendEditorView != null) {
            baseSendEditorView.dismissAudioRecordStateWindow();
            Utils.autoCloseKeyboard((Activity) getContext(), baseSendEditorView);
        }
        if (force) {
            if (baseSendEditorView != null) {
                if (baseSendEditorView.isFaceShow()) {
                    baseSendEditorView.showOrHideFacesView(false, false);
                }
                if (baseSendEditorView.isFunctionMenuViewShow()) {
                    baseSendEditorView.showOrHideFunctionMenuView(false, false);
                }
                baseSendEditorView.onKeyBoardHide();
            }
            doExit();
            return false;
        }
        if (baseSendEditorView != null && baseSendEditorView.isSpecialViewExist()) {
            return true;
        }
        doExit();
        return false;
    }

    protected void doExit() {
        if (exiting) {
            return;
        }
        exiting = true;

        eventSender.unregister(this);
        unregisterLifeCycle();

        tempFirstLoadedMessages = null;

        ImageMemoryCache.shortVideoTextureCache.evictAll();
//        faceUtils.clearEmojiCache();

        clearTvNewMessage();
        audioHandler.stopPlay();
//        stopAllPlayingVideo(true);
        videoMessagePlayUtils.stopPlayCurrentVideoAudio();
        videoMessagePlayUtils.clearAudioPlayingVideo();
        // 保存未发送的消息
        saveUnSendMessage();
        resetAdapter();
        if (newTipLayout != null) {
            newTipLayout.setVisibility(View.GONE);
        }
        if (baseImgEmpty != null) {
            baseImgEmpty.setImageResource(0);
            baseImgEmpty.setVisibility(View.GONE);
        }
        if (baseSendEditorView != null) {
            baseSendEditorView.onExit();
            removeView(baseSendEditorView);
            baseSendEditorView.unregisterLifeCycle();
            baseSendEditorView = null;
        }
        if (chatPresentationView != null) {
            chatPresentationView.onExit();
            removeView(chatPresentationView);
            chatPresentationView = null;
        }
        dialogHandle.closeProgressDialog();
        dialogHandle.closeShareDialog();
        cleanDestroyMsg();
        setIsSlideSceneMode(false);
    }

    void cleanDestroyMsg() {
        BackgroundExecutor.execute(this::cleanDestroyMsg_, BackgroundExecutor.ThreadType.IO);
    }
    void cleanDestroyMsg_() {
        dbHandler.cleanDestroyedMsg();
    }

    void stopAllPlayingVideo(boolean removeAll) {
        BackgroundExecutor.execute(()->stopAllPlayingVideo_(removeAll),"",0,"short_video", BackgroundExecutor.ThreadType.CALCULATION);
    }

    void stopAllPlayingVideo_(boolean removeAll) {
        voipAndroidManager.stopAllPlayingVideoMessage(removeAll);
    }

    protected void restartAllVideoPlaying() {
        BackgroundExecutor.execute(this::restartAllVideoPlaying_, BackgroundExecutor.ThreadType.CALCULATION);
    }
    void restartAllVideoPlaying_() {
        voipAndroidManager.restartAllPlayingVideoMessage();
    }

    /**
     * 保存编辑框中未发送的消息
     */
    public void saveUnSendMessage() {
        saveUnSendMessage(true);
    }

    /**
     * 保存编辑框中未发送的消息
     *
     * @param clearEditText true 清除编辑框中的内容, false 不清除
     */
    public void saveUnSendMessage(boolean clearEditText) {

    }

    protected List<DuduMessage> filterMessages(List<DuduMessage> datas) {
        return datas;
    }

    /**
     * 显示转发成功提示对话框
     */
    void showForwardSuccessDialog(String type) {
        String tipsStr;
        if (MessageType.AUDIO_SM.equals(type)) {
            tipsStr = this.getResources().getString(R.string.handwin_tips_audio_forwarding);
        } else if (MessageType.VIDEO_SM.equals(type)) {
            tipsStr = this.getResources().getString(R.string.handwin_tips_video_forwarding);
        } else if (MessageType.PIC_URL.equals(type)) {
            tipsStr = this.getResources().getString(R.string.handwin_tips_image_forwarding);
        } else {
            tipsStr = this.getResources().getString(R.string.handwin_tips_text_forwarding);
        }
        app.toast(tipsStr);
    }

    @Override
    public void batchSendMessageResponse(DuduMessage message, String type,
                                         String currentChattingUser, Runnable callback) {
//        UiThreadExecutor.runTask(()->batchSendMessageResponse_(message, type, currentChattingUser, callback));
    }

    @Override
    @Deprecated
    public void sendMessageResponse(DuduMessage message) {
        // no use
    }

    @Override
    @Deprecated
    public void setMessageExtraResp(DuduMessage message) {
        // no use
    }

    @Override
    @Deprecated
    public void compressImagesResp(boolean hasChatting) {
        // no use
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onSendMsgFromOutsideEvent(SendMsgFromOutsideEvent event) {
        if (TextUtils.equals(getConversationId(), event.getCurrentChatUser())) {
            Utils.debug("debug:sendMessage add message to list");
            showForwardSuccessDialog(event.getMsgType());
            if (event.getMsg() != null) {
                addOneDataToList(event.getMsg());
            }
        }
    }

//    public void batchSendMessageResponse_(DuduMessage message, String type,
//                                         String currentUser, Runnable callback) {
//        if (TextUtils.equals(getConversationId(), currentUser)) {
//            Utils.debug("debug:sendMessage add message to list");
//            showForwardSuccessDialog(type);
//            if (message != null) {
//                addOneDataToList(message);
//            }
//        }
//        if (callback != null) {
//            callback.run();
//        }
//    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void newMessage(NewMessageEvent event) {
        addNewMessage(event.getData().getMessages(), event.getData().isNeedPlusOne());
    }

    public void addNewMessage(DuduMessage[] datas, boolean needReadPlusOne) {
        if (!checkAddNewMessageCondition(datas)) {
            return;
        }
        // filter messages for current conversation
        List<DuduMessage> msgs = new ArrayList<>();
        for (DuduMessage message : datas) {
            if (TextUtils.equals(getConversationId(), message.getConversationId())) {
                msgs.add(message);
            }
        }
        if (msgs.size() == 0) {
            return;
        }
        datas = msgs.toArray(new DuduMessage[msgs.size()]);

        String sender = datas[0].getSender();
        boolean isMine = sender.equals(configHandler.getUid());
        if (!isMine && !isAtListBottom() && adapter.getItemCount() != 0 && newTipLayout.getVisibility() != View.VISIBLE) {
            animUtils.animFadeView(newTipLayout, true);
        }
        hideEmptyTips();
        showMessage(datas);
    }

    protected boolean checkAddNewMessageCondition(DuduMessage[] datas) {
        CHAT_ENTITY chatEntity = getChatEntity();
        return !((datas == null) || (datas.length == 0) || (chatEntity == null)
                || (null == datas[0]));
    }

    public void batchSend(DuduMessage message, BaseContact[] baseContacts) {

    }

    protected void newMessageTipClick() {
        // 列表滑动到最底部
        int pos = layoutManager.findFirstCompletelyVisibleItemPosition();
        if (pos > 15) {
            datasView.scrollToPosition(0);
        } else {
            datasView.smoothScrollToPosition(0);
        }
        animUtils.animFadeView(newTipLayout, false);
    }

    public void clearTvNewMessage() {
        tvNewMessage.setVisibility(View.GONE);
    }


    public void clearEditFocus() {
        EditText editText = getEditText();
        if (editText != null) {
            editText.clearFocus();
        }
    }

    protected EditText getEditText() {
        return null;
    }

    public void cancelRecordAudio() {
        if (baseSendEditorView != null) {
            baseSendEditorView.stopRecord(true);
            baseSendEditorView.dismissAudioRecordStateWindow();
        }
    }

    public void cancelRecordVideo() {
        if (baseSendEditorView != null && baseSendEditorView.isRecorderViewShow()) {
            baseSendEditorView.showOrHideRecorderView(false, false);
        }
    }

    public void showRecorderView(int recordTab) {
        UiThreadExecutor.runTask(()->showRecorderView_(recordTab),100);
    }
    public void showRecorderView_(int recordTab) {
        if (baseSendEditorView != null && !baseSendEditorView.isRecorderViewShow()) {
            baseSendEditorView.showOrHideRecorderView(true, true, recordTab);
        }
    }

    public void setNeedOpenRecorderViewOnEnter(boolean needOpenRecorderViewOnEnter) {
        this.needOpenRecorderViewOnEnter = needOpenRecorderViewOnEnter;
    }

    public boolean isNeedOpenRecorderViewOnEnter() {
        return needOpenRecorderViewOnEnter;
    }

    public void plugHeadset(boolean isEarPhone) {
        if (!showHideHeadSet(isEarPhone, true)) {
            showHideHeadSet(isEarPhone, false);
        }
    }

    private String getAudioPlayingMsgUUID() {
        if (!audioHandler.isPlaying()) {
            return null;
        }
        DuduMessage message = audioMessagePlayUtils.getPlayingMessage();
        if (message == null) {
            return null;
        }
        return message.getMsgUUID();
    }

    private String getVideoPlayingMsgUUID() {
        if (!videoMessagePlayUtils.isAudioPlaying()) {
            return null;
        }
        return videoMessagePlayUtils.getAudioPlayingMsgUUID();
    }

    private View getHeadSetView(int playingPosition) {
        View switchHeadPhone = null;
        RecyclerView.ViewHolder viewHolder = datasView.findViewHolderForAdapterPosition(playingPosition);

        if (viewHolder instanceof AudioViewHolder) {
            switchHeadPhone = ((AudioViewHolder) viewHolder).getHeadPhoneSwitch();
        } else if (viewHolder instanceof VideoViewHolder) {
            switchHeadPhone = ((VideoViewHolder) viewHolder).getHeadPhoneSwitch();
        }
        return switchHeadPhone;
    }

    private boolean showHideHeadSet(boolean isEarPhone, boolean isAudioPlaying) {
        String msgUUID = isAudioPlaying ? getAudioPlayingMsgUUID() : getVideoPlayingMsgUUID();
        if (msgUUID == null) {
            return false;
        }
        int playingPosition = adapter.getItemPositionByMsgUUID(msgUUID);

        View switchHeadPhone = getHeadSetView(playingPosition);
        if (switchHeadPhone == null) {
            return false;
        }

        if (isEarPhone) {
            animUtils.showEarImage(switchHeadPhone, false, true);
        } else {
            if (isAudioPlaying) {
                animUtils.showEarImage(switchHeadPhone, audioHandler.isPlaying() ? true : false, true);
            } else {
                animUtils.showEarImage(switchHeadPhone, videoMessagePlayUtils.isAudioPlaying() ? true : false, true);
            }
        }
        return true;
    }

    public boolean isShowingVideoPreview() {
        if (baseSendEditorView != null) {
            return baseSendEditorView.isShowingVideoPreview();
        }
        return false;
    }

    public boolean isRecordingVideoOrAudio() {
        if (baseSendEditorView != null) {
            return baseSendEditorView.isRecording();
        }
        return false;
    }

    public String getConversationId() {
        return null;
    }

    public void refreshOfflineData() {
    }

    protected void cleanUnreadAndRefreshConversation(String cid) {
        BackgroundExecutor.execute(()->cleanUnreadAndRefreshConversation_(cid), BackgroundExecutor.ThreadType.IO);
    }
    void cleanUnreadAndRefreshConversation_(String cid) {
        dbHandler.cleanUnread(cid);
    }

    @Override
    public void onEmojiPannelShow() {
        emojiShow = true;
        Utils.debug("Keyboard EmojiPannel Show");
    }

    @Override
    public void onEmojiPannelHide() {
        emojiShow = false;
        Utils.debug("Keyboard EmojiPannel hide");
    }

    public CHAT_ENTITY getChatEntity() {
        return null;
    }

    protected void initChatPresentationView() {
        if (chatPresentationView == null) {
            chatPresentationView = createChatPresentationView();
            if (chatPresentationView != null) {
                chatPresentationView.initialize();
                chatPresentationView.setChatEntity(getChatEntity());
                chatPresentationView.setMessageAddListener(this);
                LayoutParams lp = new LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
                addView(chatPresentationView, lp);
                // 关闭键盘
                Utils.autoCloseKeyboard((Activity) getContext(), this);
            }
        }
        if (chatPresentationView != null) {
            chatPresentationView.bringToFront();
        }
        chatPresentationView.setPresentationActionListener(this);
    }

    protected BaseChatPresentationView createChatPresentationView() {
        return null;
    }

    protected void showPresentationView(boolean show) {
        if (show) {
            if (CallState.getInstance().getStatus() == CallState.Status.Idle) {
                Utils.debug("BaseChatView CallState Idle");
                return;
            }
            initChatPresentationView();
            chatPresentationView.updateVideoSceneInfo(videoSceneInfo);
            setIsSlideSceneMode(true);
            if (chatPresentationView != null) {
                chatPresentationView.setVisibility(View.VISIBLE);
            }
            doShowPresentationView();
            chatPresentationView.onEnter();
        } else if (chatPresentationView != null) {
            chatPresentationView.onExit();
            if (chatPresentationView.getVisibility() == View.VISIBLE) {
                notifyMsgAdapterOnExitPresentation();
                showUnsentMsg();
                restartAllVideoPlaying();
            }
            listDatas.setVisibility(View.VISIBLE);
            if (baseSendEditorView != null) {
                baseSendEditorView.setVisibility(View.VISIBLE);
            }
            chatPresentationView.setVisibility(View.GONE);
            this.removeView(chatPresentationView);
            chatPresentationView = null;
        }
    }

    protected void doShowPresentationView() {
        listDatas.setVisibility(View.GONE);
        saveUnSendMessage(false);
        if (baseSendEditorView != null) {
            baseSendEditorView.setVisibility(View.GONE);
        }
        eventSender.sendGifEmojiPlayEvent(false);
        stopAllPlayingVideo(false);
    }

    @Override
    public void onPrepareScene(int scene) {
        if (isSlideSceneMode()) {
            this.showPresentationView(true);
        } else {
            isPrepareScene = true;
            isAddMoreImages = false;
            this.selectSlidePictures(activity, null);
            // 统计，发起图片共享
            boolean isGroup = (null != getChatEntity() && getChatEntity()
                    .isGroup());
        }
    }

    @Override
    public void onSceneCreate(int scene) {
        if (isSlideSceneMode()) {
            dialogHandle.closeProgressDialog();
            showPresentationView(true);
            return;
        }
        if (scene == SceneConstant.SLIDE_SCENE) {
            doCreateCreateScene();
        } else {
            dialogHandle.closeProgressDialog();
        }
    }

    protected void processCreateSceneResult(VideoSceneInfo videoSceneInfo) {
        UiThreadExecutor.runTask(()->processCreateSceneResult_(videoSceneInfo));
    }
    protected void processCreateSceneResult_(VideoSceneInfo videoSceneInfo) {
        Utils.debug("CallSceneDebug processCreateSceneResult");
        dialogHandle.closeProgressDialog();

        // 服务端判定只有表演者才能发起群视频。 否则返回没有权限
        if (videoSceneInfo == null || videoSceneInfo.getResultCode() == ErrorCode.SCENE_NO_CREATE_RIGHT) {
            app.toast(R.string.handwin_start_image_share_fail);
            resetSlideInfo();
            return;
        }

        this.setVideoSceneInfo(videoSceneInfo);
        doCreateSceneSuccess(videoSceneInfo);
        Utils.debug("CallSceneDebug processCreateSceneResult get videoSceneInfo " + videoSceneInfo);
        // 自己是创建者
        CallState.getInstance().addActivityResult(ActivityResult.IMAGE_SHARE);
        CallState.getInstance().setVideoSceneInfo(videoSceneInfo);
        if (configHandler.getUid().equals(videoSceneInfo.getSponsorId())) {
            // 设置SceneId
            slideSceneHandler.setSceneId(videoSceneInfo.getSceneId());
            // 选择图片上传, 成功后跳往ppt界面
            this.setIsSlideSceneMode(true);
            this.showPresentationView(true);
        } else {
            // 自己是参与者
            slideSceneHandler.clearAllImages();
            showPresentationView(true);
        }
    }

    protected void doCreateSceneSuccess(VideoSceneInfo videoSceneInfo) {
        showPptOngoingProgress(true);
        CallState.getInstance().setVideoSceneInfo(videoSceneInfo);
    }

    protected void doCreateCreateScene() {
    }

    private void notifyMsgAdapterOnExitPresentation() {
        adapter.notifyDataSetChanged();
        if (scrollToBottomOnExitPresentation) {
            scrollToBottomOnExitPresentation = false;
            scrollToBottom();
        }
    }

    @Override
    public void onExitPresentation() {
        listDatas.setVisibility(View.VISIBLE);
        if (baseSendEditorView != null) {
            baseSendEditorView.setVisibility(View.VISIBLE);
        }
        notifyMsgAdapterOnExitPresentation();

        faceUtils.resumeAllAnimationSpans(getContext());
        liveActivity.setCanPauseLiveOnActivityPause(true);
        liveActivity.setCanSetAppLive(true);
        eventSender.sendFinishPPTMsgSendPageEvent();
        Activity activity = (Activity) getContext();
        activity.getWindow().setSoftInputMode(
                WindowManager.LayoutParams.SOFT_INPUT_ADJUST_RESIZE);
        showPptOngoingProgress(isSlideSceneMode());

        eventSender.sendGifEmojiPlayEvent(true);
        restartAllVideoPlaying();
    }

    @Override
    public void onClosePresentation() {
        faceUtils.resumeAllAnimationSpans(getContext());
    }

    @Override
    public void onAddOneImages() {
        if (slideSceneHandler.getResourcesSize() == 0) {
            isAddMoreImages = false;
        } else {
            isAddMoreImages = true;
        }
    }

    protected boolean isSlideSceneMode() {
        return isSlideSceneMode;
    }

    protected void setIsSlideSceneMode(boolean isSlideSceneMode) {
        this.isSlideSceneMode = isSlideSceneMode;
    }

    protected boolean isStartSlideSceneByMe(VideoSceneInfo videoSceneInfo) {
        if (videoSceneInfo == null) {
            return false;
        }
        return configHandler.getUid().equals(videoSceneInfo.getSponsorId());
    }

    public void handleSceneStatus(CallSceneInfo callSceneInfo) {
        int commandType = callSceneInfo.getCommandType();
        VideoSceneInfo videoSceneInfo = callSceneInfo.getVideoSceneInfo();
        switch (commandType) {
            case CallSceneCommandType.SCENE_APPLY:
                handleSceneCreate(videoSceneInfo);
                break;
            case CallSceneCommandType.SCENE_END:
                handleSceneEnd(videoSceneInfo);
                break;
            default:
                Utils.debugFormat(
                        "CallSceneDebug handleSceneStatus not handle %d",
                        commandType);
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onReceiveSceneStatusChange(CallSceneInfo callSceneInfo) {
        this.handleSceneStatus(callSceneInfo);
    }

    protected void handleSceneCreate(VideoSceneInfo videoSceneInfo) {
        showPptOngoingProgress(true);

    }

    protected void handleSceneEnd(VideoSceneInfo videoSceneInfo) {
        CallState.getInstance().setVideoSceneInfo(null);
        showPptOngoingProgress(false);
    }

    protected void setVideoSceneInfo(VideoSceneInfo videoSceneInfo) {
        this.videoSceneInfo = videoSceneInfo;
    }

    public VideoSceneInfo getVideoSceneInfo() {
        return videoSceneInfo;
    }

    protected void resetSlideInfo() {
        Utils.debug("CallSceneDebug resetSlideInfo");
        slideSceneHandler.clearAllImages();
        clearSceneInfo();
        doResetSlideInfo();
        CallState.getInstance().setVideoSceneInfo(null);
    }

    /**
     * 清除和本群相关的scene信息
     */
    protected void clearSceneInfo() {
        setVideoSceneInfo(null);
        setIsSlideSceneMode(false);
    }

    protected void doResetSlideInfo() {

    }

    /**
     * 打开图片选取
     */
    protected void selectSlidePictures(Activity activity, Fragment fragment) {
        Intent intent = new Intent();
        intent.putExtra(ExtraInfo.IMAGE_PICK_MULTI, true);
        intent.putExtra(ExtraInfo.NEED_CAMERA, false);
        intent.putExtra(ExtraInfo.MAX_IMAGE_NUMBER, Constant.MAX_IMG_SLIDE_NUMBER);
        intent.putExtra(ExtraInfo.IS_SHOW_SELECT_ORDER, true);
        intent.putExtra(ExtraInfo.NEED_SELECTED_PREVIEW, true);
        intent.putExtra(ExtraInfo.IS_GROUP, isGroupChat());
        intent.putExtra(ExtraInfo.ROOM_ID, getRoomId());
        intent.putExtra(ExtraInfo.ACTION_TEXT, app.getString(R.string.handwin_app_yes));
        try {
            if (activity != null) {
                intent.setClass(activity, ImageChooseActivity.class);
                activity.startActivityForResult(intent, ReqCode.PPT_SELECT_IMG);
            } else if (fragment != null) {
                intent.setClass(fragment.getActivity(), ImageChooseActivity.class);
                fragment.startActivityForResult(intent, ReqCode.PPT_SELECT_IMG);
            }
        } catch (ActivityNotFoundException e) {
            e.printStackTrace();
        }
    }

    protected boolean isGroupChat() {
        return false;
    }

    protected String getRoomId() {
        return null;
    }

    protected void showPptOngoingProgress(boolean isShow) {
        if (baseSendEditorView != null) {
            baseSendEditorView.showPptOngoingProgress(isShow);
        }
    }

    @Subscribe
    public void onPresentationViewHide(HidePresentationViewEvent event) {
        if (isSlideSceneMode()) {
            if (chatPresentationView != null) {
                chatPresentationView.doBackClick();
            }
        } else {
            showPresentationView(false);
        }
    }

    @Override
    public void onFunctionMenuViewShow() {

    }

    @Override
    public void onFunctionMenuViewHide() {

    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onReceiveLiving(LivingStartEvent event) {
        if (baseSendEditorView != null ) {
            if (baseSendEditorView.isFunctionMenuViewShow()){
                baseSendEditorView.functionMenuView.refreshUI();
            }
            baseSendEditorView.setAudioRecordEnable(CallState.getInstance().isIdle());
        }
    }
}
