package me.chatgame.uisdk.activity.view;

import android.app.Activity;
import android.app.Fragment;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import java.util.List;

import me.chatgame.mobilecg.MainApp;
import me.chatgame.mobilecg.actions.SceneActions;
import me.chatgame.mobilecg.actions.interfaces.ISceneActions;
import me.chatgame.mobilecg.activity.ImageChooseActivity;
import me.chatgame.mobilecg.activity.view.BasePreviewContainerView;
import me.chatgame.mobilecg.activity.view.PresentationVideoPreview;
import me.chatgame.mobilecg.activity.view.interfaces.IGroupVideoPreview;
import me.chatgame.mobilecg.activity.view.interfaces.ILiveActivity;
import me.chatgame.mobilecg.activity.view.interfaces.IOpenGLView;
import me.chatgame.mobilecg.adapter.viewholder.SlideImageHolder;
import me.chatgame.mobilecg.bean.Danmaku;
import me.chatgame.mobilecg.bean.GroupVideoRequestItem;
import me.chatgame.mobilecg.bean.SlideSceneResource;
import me.chatgame.mobilecg.call.CallState;
import me.chatgame.mobilecg.constant.Constant;
import me.chatgame.mobilecg.constant.ExtraInfo;
import me.chatgame.mobilecg.constant.ReqCode;
import me.chatgame.mobilecg.database.entity.BaseContact;
import me.chatgame.mobilecg.database.entity.DuduGroupContact;
import me.chatgame.mobilecg.database.entity.DuduMessage;
import me.chatgame.mobilecg.events.PPTDanmakuMsgEvent;
import me.chatgame.mobilecg.events.PPTDanmakuMsgSendPageCloseEvent;
import me.chatgame.mobilecg.events.PPTMsgSendPageKeyboardHideEvent;
import me.chatgame.mobilecg.events.PPTMsgSendPageKeyboardShowEvent;
import me.chatgame.mobilecg.events.PaintEvent;
import me.chatgame.mobilecg.events.SlideSceneInfo;
import me.chatgame.mobilecg.handler.ConfigHandler;
import me.chatgame.mobilecg.handler.EventSender;
import me.chatgame.mobilecg.handler.GroupVideoContactsHandler;
import me.chatgame.mobilecg.handler.GroupVideoManager;
import me.chatgame.mobilecg.handler.PaintHandler;
import me.chatgame.mobilecg.handler.SlideSceneHandler;
import me.chatgame.mobilecg.handler.SystemStatus;
import me.chatgame.mobilecg.handler.interfaces.IConfig;
import me.chatgame.mobilecg.handler.interfaces.IEventSender;
import me.chatgame.mobilecg.handler.interfaces.IGroupVideoContactsHandler;
import me.chatgame.mobilecg.handler.interfaces.IGroupVideoManager;
import me.chatgame.mobilecg.handler.interfaces.IMessage;
import me.chatgame.mobilecg.handler.interfaces.IPaintHandler;
import me.chatgame.mobilecg.handler.interfaces.ISlideSceneHandler;
import me.chatgame.mobilecg.handler.interfaces.ISystemStatus;
import me.chatgame.mobilecg.handler.message.MessageHandler;
import me.chatgame.mobilecg.listener.DialogCallback;
import me.chatgame.mobilecg.listener.GroupVideoContactsListener;
import me.chatgame.mobilecg.listener.OnPageChangeListenerAdapter;
import me.chatgame.mobilecg.model.MemberInfo;
import me.chatgame.mobilecg.net.protocol.GroupVideoResult;
import me.chatgame.mobilecg.net.protocol.VideoSceneInfo;
import me.chatgame.mobilecg.util.BackgroundExecutor;
import me.chatgame.mobilecg.util.DialogHandle;
import me.chatgame.mobilecg.util.FaceUtils;
import me.chatgame.mobilecg.util.UiThreadExecutor;
import me.chatgame.mobilecg.util.UnsentMessageCacheManager;
import me.chatgame.mobilecg.util.Utils;
import me.chatgame.mobilecg.util.UtilsImpl;
import me.chatgame.mobilecg.util.interfaces.IDialogHandle;
import me.chatgame.mobilecg.util.interfaces.IFaceUtils;
import me.chatgame.mobilecg.util.interfaces.IUnsentMessageCacheManager;
import me.chatgame.mobilecg.util.interfaces.IUtils;
import me.chatgame.mobilecg.views.CustomViewPager;
import me.chatgame.mobilecg.views.DanmakuSurfaceView;
import me.chatgame.uisdk.R;
import me.chatgame.uisdk.activity.PPTSendMsgActivity;

/**
 * Created by star on 16/3/16.
 */
public class BaseChatPresentationView<CHAT_ENTITY extends BaseContact>
		extends
		BasePreviewContainerView<IOpenGLView>
		implements
			GroupVideoContactsListener,
			PaintHandler.PaintListener {

	MainApp app;

	RelativeLayout rootLayout;
	TextView btnShowKeyBoard;
	ViewGroup videoContainer;
	TextView btnPenColor;
	CustomViewPager viewPager;
	TextView btnPenRevoke;
	TextView btnPaintClose;
	TextView btnPaintBack;
	TextView btnAddMore;
	TextView btnMoreItem;
	TextView txtPageInfo;
    LinearLayout linearCounts;
    TextView txtWatcherCount;
    GroupVideoRequestView groupVideoRequestView;

	IDialogHandle dialogHandle;
	public ISlideSceneHandler slideSceneHandler;
	IConfig configHandler;
	IGroupVideoPreview groupVideoPreview;
	public ISceneActions sceneActions;
	IEventSender eventSender;
	ISystemStatus systemStatus;
    IPaintHandler paintHandler;
    IUtils utils ;
    IMessage messageHandler;
    IGroupVideoContactsHandler groupVideoContactsHandler;
    IUnsentMessageCacheManager unsentMessageCacheManager;
	IFaceUtils faceUtils;
    IGroupVideoManager groupVideoManager;

    PPTImagePagerAdapter adapter;

	ILiveActivity liveActivity;


	private CHAT_ENTITY chatEntity;

	private BaseSendEditorView.MessageAddListener messageAddListener;

	protected PresentationActionListener presentationActionListener;

	protected VideoSceneInfo videoSceneInfo;

	protected SlideSceneResource currentSceneResource;

    private boolean isPenClose = true;
	private boolean isKeyBoardShow = false;

	private int sendEditorHeight;
	private int danmakuLeftHeight;
	
	DanmakuSurfaceView danmakuView;
	RelativeLayout danmukuRootLayout;

	public BaseChatPresentationView(Context context) {
		super(context);
	}

	public BaseChatPresentationView(Context context, AttributeSet attrs) {
		super(context, attrs);
	}

	public BaseChatPresentationView(Context context, AttributeSet attrs,
			int defStyleAttr) {
		super(context, attrs, defStyleAttr);
	}

    void init__(){
		app = MainApp.getInstance();
        configHandler = ConfigHandler.getInstance_(getContext()) ;
        messageHandler = MessageHandler.getInstance_(getContext()) ;
		sceneActions = SceneActions.getInstance_(getContext());
        systemStatus = SystemStatus.getInstance_() ;
        eventSender = EventSender.getInstance_();
        utils = UtilsImpl.getInstance_(getContext()) ;
        faceUtils = FaceUtils.getInstance_(getContext()) ;
        dialogHandle = DialogHandle.getInstance_() ;
        groupVideoContactsHandler = GroupVideoContactsHandler.getInstance_();
        paintHandler = PaintHandler.getInstance_(getContext());
        slideSceneHandler = SlideSceneHandler.getInstance_(getContext()) ;
        unsentMessageCacheManager = UnsentMessageCacheManager.getInstance_(getContext()) ;
		groupVideoManager = GroupVideoManager.getInstance_();

        groupVideoPreview = PresentationVideoPreview.getInstance_(getContext()) ;
    }

    @Override
    public void removeOneActor(MemberInfo memberInfo) {

    }

    @Override
    public void addOneActor(MemberInfo memberInfo) {

    }

    @Override
    public void addOneWatcher(DuduGroupContact duduGroupContact) {
		if (duduGroupContact.getGroupId().equals(chatEntity.getBaseId())) {
			updateGroupWatcherCounts();
		}
    }

    @Override
    public void removeOneWatcher(DuduGroupContact duduGroupContact) {
		if (duduGroupContact.getGroupId().equals(chatEntity.getBaseId())) {
			updateGroupWatcherCounts();
		}
    }

    /**
     * 更新观看者数量
     */
    void updateGroupWatcherCounts() {
        UiThreadExecutor.runTask(this::updateGroupWatcherCounts_);
    }

    void updateGroupWatcherCounts_() {
		List<DuduGroupContact> datas = groupVideoContactsHandler
				.getAllWatchers(chatEntity.getBaseId());
		int size = (null == datas) ? 0 : datas.size();
        Utils.debugFormat("updateGroupWatcherCounts %d", size);
		txtWatcherCount.setText(String.valueOf(size));
    }

    public void memberCameraStatusChange(int innerId, boolean isVideoPause) {
        groupVideoPreview.memberCameraStateChanged(innerId,!isVideoPause);
    }

    public interface PresentationActionListener {
		void onExitPresentation();

		void onClosePresentation();

		void onAddOneImages();
	}

	public void setPresentationActionListener(
			PresentationActionListener listener) {
		this.presentationActionListener = listener;
	}

	@Override
	protected ViewGroup getSurfaceViewContainer() {
		return videoContainer;
	}

	/**
	 * Do initialization here
	 */
	public void initialize() {
		sendEditorHeight = app.getPxFromDp(R.dimen.handwin_chat_bottom_h)
				+ app.getPxFromDp(R.dimen.handwin_chat_bottom_edit_m);
		initVideoPreview();
		setClickable(true);
	}

	public void updateVideoSceneInfo(VideoSceneInfo videoSceneInfo) {
		this.videoSceneInfo = videoSceneInfo;
		if (videoSceneInfo != null) {
			CallState.getInstance().setSceneId(videoSceneInfo.getSceneId());
			String text = isStartSlideSceneByMe() ? getContext().getResources()
					.getString(R.string.handwin_font_img_paint_more) : getContext()
					.getResources().getString(R.string.handwin_font_img_ppt_back_left);
			btnMoreItem.setText(text);
		}
	}

	protected void initAdapter() {
        if (adapter == null) {
			adapter = new PPTImagePagerAdapter();
			viewPager.setAdapter(adapter);
			viewPager.addOnPageChangeListener(new OnPageChangeListenerAdapter() {
				@Override
				public void onPageSelected(int page) {
					handlePagerSelected(page);
				}
			});
		}

		slideSceneHandler.setSceneId(videoSceneInfo.getSceneId());

		adapter.setResourceSize(slideSceneHandler.getResourcesSize());
		adapter.notifyDataSetChanged();

		int currentPage = getCurrentPage();
		viewPager.setCurrentItem(currentPage);
		showAddMoreBtnOrNot(currentPage);
	}

    void loadOtherPagerInBackground(int page) {
        BackgroundExecutor.execute(()->loadOtherPagerInBackground_(page), BackgroundExecutor.ThreadType.IO);
    }

    void loadOtherPagerInBackground_(int page) {
        SlideSceneResource resource = slideSceneHandler
                .getOneResourceByPage(page);
		if (null == resource) {
			return;
		}
        currentSceneResource = resource;
        setPageIndexInfo();
    }

    /**
     * 新增图片后，刷新界面
     */
    public void updateAllViewsAfterAddMore() {
		if (adapter != null) {
			adapter.setResourceSize(slideSceneHandler.getResourcesSize());
			adapter.notifyDataSetChanged();
		}
        int currentItem=getCurrentPage() + 1;
        viewPager.setCurrentItem(currentItem);
        if (!isPenClose) {
            // 如果笔触打开的，关闭笔触
            btnPenColorClick();
        }
    }

    /**
     * 处理页面选中
     * 
     * @param page
     */
	private void handlePagerSelected(int page) {
		showAddMoreBtnOrNot(page);
		loadOtherPagerInBackground(page);
	}

	private void showAddMoreBtnOrNot(int page) {
		Utils.debug("AddMoreTest showAddMoreBtnOrNot page " + page);
		// 最后一页，显示更多图标
		boolean showMore = needShowMoreButton(page);

		btnAddMore.setVisibility(showMore ? VISIBLE : GONE);

        // 处理阿拉伯语按钮在左边的情况，使用旋转180度的按钮
        if (btnAddMore.getVisibility() == VISIBLE){
            btnAddMore.post(() -> {
                // 如果按钮居左
                if (btnAddMore.getLeft() == 0){
                    btnAddMore.setBackgroundResource(R.drawable.handwin_selector_bg_ppt_more_img_arab);
                }
            });
        }
	}

	private boolean needShowMoreButton(int page) {
		if (!isStartSlideSceneByMe()) {
			return false;
		}
		if (adapter.getCount() == 0) {
			return true;
		}

		return ((page == (adapter.getCount() - 1)));
	}

	/**
	 * 设置页面页码显示信息
	 */
    void setPageIndexInfo() {
        UiThreadExecutor.runTask(this::setPageIndexInfo_);
    }
    void setPageIndexInfo_() {
		if (null == currentSceneResource) {
			return;
		}
		txtPageInfo.setVisibility(VISIBLE);
		String pageInfo = (getCurrentPage() + 1) + "/" + getCurrentPageTotal();
		txtPageInfo.setText(pageInfo);
		SlideImageHolder holder = adapter
				.getViewByPosition(getCurrentPage());
		if (null != holder) {
			slideSceneHandler.addOneResource(currentSceneResource);
			holder.bind(getCurrentPage(), isStartSlideSceneByMe(),
					getChatEntity().isGroup());
            holder.setDrawEnable(!isPenClose);
        }
	}

	private void initVideoPreview() {
		int padding = getResources().getDimensionPixelSize(R.dimen.one_dp);
        int videoHeight = utils.getVideoPreviewHeight() ;
		ViewGroup.LayoutParams layoutParams = videoContainer.getLayoutParams();
		layoutParams.height = videoHeight + padding * 2;
		videoContainer.setLayoutParams(layoutParams);
		onInitVideoPreview(padding, padding);
	}

	protected void onInitVideoPreview(int paddingHorizontal, int paddingVertical) {

	}

	private void addDanmakuView() {
		danmukuRootLayout = (RelativeLayout) LayoutInflater.from(getContext())
				.inflate(R.layout.handwin_view_danmaku, null);
		danmakuView = (DanmakuSurfaceView) danmukuRootLayout
				.findViewById(R.id.danmaku_view);
		danmakuView.setVisibility(View.VISIBLE);

		RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(
				RelativeLayout.LayoutParams.MATCH_PARENT,
				RelativeLayout.LayoutParams.MATCH_PARENT);
		lp.addRule(BELOW, R.id.id_presentation_video_container);
		rootLayout.addView(danmukuRootLayout, lp);
	}

	// 避免同时出现两个SurfaceView，即使其中一个为GONE状态也不行
	private void removeDanmakuView() {
        danmakuView.setVisibility(View.GONE);
		rootLayout.removeView(danmukuRootLayout);
	}
	
	@Override
	protected void onDetachedFromWindow() {
		super.onDetachedFromWindow();
		if (getVisibility() == View.VISIBLE) {
			hideSurfaceView();
		}
		currentSceneResource = null;
		paintHandler.setPaintListener(null);
	}

    public void onEnter() {
        eventSender.register(this);
		paintHandler.setPaintListener(this);
		registerLifeCycle();
		if (isStartSlideSceneByMe()) {
			loadImage();
		}
		faceUtils.pauseAllAnimationSpans(getContext());
		showSurfaceView();
		addDanmakuView();
		initAdapter();

		boolean isStartByMe = isStartSlideSceneByMe();
		int visible = isStartByMe ? VISIBLE : GONE;
		btnPenColor.setVisibility(visible);
		btnPenColor.setBackgroundResource(isPenClose
				? R.drawable.handwin_selector_btn_paint_rect
				: R.drawable.handwin_selector_btn_paint_lock);
		btnPenRevoke.setVisibility(visible);
		viewPager.setPagingEnabled(isStartByMe && isPenClose);

		setPenStatus(isPenClose);
		
		boolean isGroup = getChatEntity().isGroup();
		linearCounts.setVisibility(isGroup ? VISIBLE : GONE);

        if (isGroup) {
            groupVideoContactsHandler.addListener(this);
            updateGroupWatcherCounts();
        }

		getStatusbarColorSetter().setStatusBarBackgroundColor(getResources().getColor(R.color.handwin_group_video_background));

		Activity activity = (Activity) getContext();
		activity.getWindow().setSoftInputMode(
				WindowManager.LayoutParams.SOFT_INPUT_ADJUST_NOTHING);

		Utils.autoCloseKeyboard(activity, this);
	}

	/**
	 * Do clearing here
	 */
	public void onExit() {
		Utils.debug("CallSceneDebug ChatPresentationView onExit");
		faceUtils.resumeAllAnimationSpans(getContext());
		liveActivity.setCanPauseLiveOnActivityPause(true);
		liveActivity.setCanSetAppLive(true);
		eventSender.sendFinishPPTMsgSendPageEvent();
		if (getVisibility() == View.VISIBLE) {
			hideSurfaceView();
		}
        eventSender.unregister(this);
		unregisterLifeCycle();
        groupVideoContactsHandler.removeListener(this);
		BackgroundExecutor.cancelAll("send_slide_info_period", true);

		Activity activity = (Activity) getContext();
		activity.getWindow().setSoftInputMode(
				WindowManager.LayoutParams.SOFT_INPUT_ADJUST_RESIZE);

		eventSender.sendGifEmojiPlayEvent(true);
	}

	void loadImage() {
        BackgroundExecutor.execute(this::loadImage_, BackgroundExecutor.ThreadType.IO);
    }
	void loadImage_() {
        dialogHandle.showProgressDialog(getContext(),
                R.string.handwin_tip_dialog_waiting);
		Utils.debug("CurrentPage loadImage before >> " + currentSceneResource);
		SlideSceneResource resource = slideSceneHandler
				.getCurrentPageSlidImage();
		if (null == resource) {
			return;
		}
		dialogHandle.showProgressDialog(getContext(),
				R.string.handwin_tip_dialog_waiting);
		this.currentSceneResource = resource;
		Utils.debug("CurrentPage loadImage after >> " + currentSceneResource);
		showImage(currentSceneResource);
	}

	void showImage(SlideSceneResource slideSceneResource) {
        UiThreadExecutor.runTask(()->showImage_(slideSceneResource));
    }
	void showImage_(SlideSceneResource slideSceneResource) {
		dialogHandle.closeProgressDialog();
		if (isResourceReady(slideSceneResource)) {
			setPageIndexInfo();
		} else {
			// TODO: url没有获取到，异常情况，需要重新上传，3/18/16 try again
		}
	}

	private boolean isResourceReady(SlideSceneResource slideSceneResource) {
		if (slideSceneResource == null) {
			return false;
		}
		if (isStartSlideSceneByMe()) {
			return true;
		}
		return slideSceneResource.isResourceReady();
	}

    /**
     * 处理对方幻灯片页面信息
     * 
     * @param slideSceneInfo
     */
	@Subscribe(threadMode = ThreadMode.MAIN)
	public void processSlideSceneInfo(SlideSceneInfo slideSceneInfo) {
		if (isNotValidSceneImage(slideSceneInfo)) {
			// 页面信息不正常，忽视
			return;
		}
		SlideSceneResource targetResource = createNewResourceFromSlideInfo(slideSceneInfo);
		this.currentSceneResource = targetResource;
		boolean result = slideSceneHandler.addOneResource(currentSceneResource);
		if (result) {
			// 添加成功才重新创建
			if (adapter != null) {
				adapter.setResourceSize(slideSceneHandler.getResourcesSize());
				adapter.notifyDataSetChanged();
			}
		}
        if(getCurrentPage() == targetResource.getPageNumber()){
            handlePagerSelected(getCurrentPage());
        }
		viewPager.setCurrentItem(targetResource.getPageNumber());
	}

    /**
     * 幻灯片图片是否不可用
     *
     * @param slideSceneInfo
     * @return
     */
	private boolean isNotValidSceneImage(SlideSceneInfo slideSceneInfo) {
		if (this.videoSceneInfo == null) {
			return true;
		}
		if (!slideSceneInfo.getSceneId().equals(
				this.videoSceneInfo.getSceneId())) {
			Utils.debug("CallSceneDebug processSlideSceneInfo : "
					+ slideSceneInfo);
			return true;
		}
		if (isStartSlideSceneByMe()) {
			Utils.debug("CallSceneDebug processSlideSceneInfo : "
					+ slideSceneInfo);
			return true;
		}
		return false;
	}

	/**
	 * 处理涂鸦绘图事件，对方传过来的
	 *
	 * @param paintEvent
	 */
	@Override
	public void handleNewPaintEvent(PaintEvent paintEvent) {
		Utils.debugFormat("PaintDebug BaseChatPresentation handleNewPaintEvent index %d", paintEvent.getIndex(), paintEvent.toString());
		SlideImageHolder holder = adapter
				.getViewByPosition(getCurrentPage());
		if (null == holder) {
			Utils.debug("PaintDebug BaseChatPresentation just save it");
			paintHandler.savePaintEvent(paintEvent);
		} else {
			Utils.debug("PaintDebug BaseChatPresentation holder will handle the event");
            holder.handlePaintEvent(paintEvent);
        }
	}

	private int getCurrentPage() {
		return (null == currentSceneResource) ? 0 : currentSceneResource
				.getPageNumber();
	}

	private int getCurrentPageTotal() {
		return (null == currentSceneResource) ? 0 : currentSceneResource
				.getTotalPageNumber();
	}

	public void setMessageAddListener(
			BaseSendEditorView.MessageAddListener messageAddListener) {
		this.messageAddListener = messageAddListener;
	}

	void btnPaintBackClick() {
		doBackClick();
	}

	public void doBackClick(){
		showMoreItems(false);
		if (presentationActionListener != null) {
			presentationActionListener.onExitPresentation();
		}
		removeDanmakuView();
		this.setVisibility(View.GONE);
		eventSender.sendShowUnsentMsgEvent();
	}

	void btnPaintCloseClick() {
		if (Utils.isFastDoubleClick("paint_close_click")) {
			return;
		}
		showMoreItems(false);
		Utils.debug("CallSceneDebug close paint click");
		dialogHandle.showNormalDialog(getContext(),
				R.string.handwin_tip_dialog_title_normal,
				R.string.handwin_ppt_share_close_dialog_content, R.string.handwin_app_ok,
				R.string.handwin_app_cancel, true, new DialogCallback() {
					@Override
					public void onOkClick() {
						exitPresentation();
					}

					@Override
					public void onCancelClick() {
					}
				});
	}

	private void exitPresentation() {
		Utils.debug("CallSceneDebug exitPresentation " + presentationActionListener);
		dialogHandle.showProgressDialog(getContext(), getResources().getString(R.string.handwin_tip_dialog_waiting));
		removeDanmakuView();

		if (presentationActionListener != null) {
			presentationActionListener.onClosePresentation();
		} else {
			dialogHandle.closeProgressDialog();
		}
	}

	void btnMoreItemsClick() {
		if (Utils.isFastDoubleClick("more_item_click")) {
			return;
		}
		boolean show = (btnPaintClose.getVisibility() == GONE);
		if (isStartSlideSceneByMe()) {
			showMoreItems(show);
		} else {
			btnPaintBackClick();
		}
	}

	private void showMoreItems(boolean isShow) {
		int visible = isShow ? VISIBLE : GONE;
		btnPaintClose.setVisibility(visible);
		btnPaintBack.setVisibility(visible);
		btnMoreItem.animate().rotation(isShow ? 180 : 0);
	}

	void btnAddMoreClick() {
		if (Utils.isFastDoubleClick("add_item_click")) {
			return;
		}
		if (presentationActionListener != null) {
			presentationActionListener.onAddOneImages();
		}
		selectSlidePictures((Activity) getContext(), null);
	}

	void showKeyBoard() {
		if (Utils.isFastDoubleClick("showKeyBoard")) {
			return;
		}

		showImgButton(false);
		liveActivity.setCanPauseLiveOnActivityPause(false);
		liveActivity.setCanSetAppLive(false);
		Intent intent = new Intent(getContext(), PPTSendMsgActivity.class);
		intent.putExtra(ExtraInfo.ALLOW_START_IN_LIVE, true);
		intent.putExtra(ExtraInfo.FROM_ENTITY, getChatEntity());
		getContext().startActivity(intent);
	}

	@Subscribe
	public void onMsgSendPageCloseEvent(PPTDanmakuMsgSendPageCloseEvent event) {
		showImgButton(true);
		liveActivity.setCanSetAppLive(true);
		liveActivity.setCanPauseLiveOnActivityPause(true);
	}

	void btnPenColorClick() {
		if (Utils.isFastDoubleClick()) {
			return;
		}
		isPenClose = !isPenClose;
		setPenStatus(isPenClose);

		SlideImageHolder holder = adapter
				.getViewByPosition(getCurrentPage());
		if (null != holder) {
			holder.setDrawEnable(!isPenClose);
		}
		viewPager.setPagingEnabled(isPenClose);
	}

	private void setPenStatus(boolean isPenClose) {
		int resId = isPenClose
				? R.drawable.handwin_selector_btn_paint_rect
				: R.drawable.handwin_selector_btn_paint_lock;
        int penColor = isPenClose ? getContext().getResources().getColor(android.R.color.white) : getContext().getResources().getColor(R.color.handwin_R1);
		btnPenColor.setBackgroundResource(resId);
        btnPenColor.setTextColor(penColor);
	}
	
	void btnPenRevokeClick() {
		SlideImageHolder holder = adapter
				.getViewByPosition(getCurrentPage());
		if (null != holder) {
            holder.revokeOneStep();
        }
	}

	private void showImgButton(boolean show) {
		int visible = show ? VISIBLE : GONE;
		btnShowKeyBoard.setVisibility(visible);
		if (isStartSlideSceneByMe()) {
			btnPenColor.setVisibility(visible);
			btnPenRevoke.setVisibility(visible);
			btnMoreItem.setVisibility(visible);
			if (show) {
                btnMoreItem.setRotation(0);
			}else{
                btnPaintBack.setVisibility(visible);
                btnPaintClose.setVisibility(visible);
            }
		}
	}

	public void setChatEntity(CHAT_ENTITY chatEntity) {
		this.chatEntity = chatEntity;
	}

	public CHAT_ENTITY getChatEntity() {
		return chatEntity;
	}

	@Subscribe(threadMode = ThreadMode.MAIN)
	public void addOneMessageEvent(PPTDanmakuMsgEvent event) {
		onAddOneMessage(event.getData(), true);
	}

	public void onAddOneMessage(DuduMessage message, boolean callAddListener) {
		if (callAddListener && messageAddListener != null) {
			messageAddListener.onAddOneMessage(message);
		}
		asyncAddOneDanmakuMsg(message);
	}

	void asyncAddOneDanmakuMsg(DuduMessage message) {
        BackgroundExecutor.execute(()->asyncAddOneDanmakuMsg_(message),"",0,"asyncAddOneDanmakuMsg", BackgroundExecutor.ThreadType.IO);
    }

	void asyncAddOneDanmakuMsg_(DuduMessage message) {
		if (!danmakuView.isDrawing()) {
			return;
		}
		String sender = message.getNickname();
		String messageContent = messageHandler.getNotifyMessage(message);
		String danmakuContent;
		boolean isRTL = (ViewCompat.getLayoutDirection(this) == ViewCompat.LAYOUT_DIRECTION_RTL);
		if (isRTL) {
			danmakuContent = messageContent + " :" + sender;
		} else {
			danmakuContent = sender + ": " + messageContent;
		}
		if (sender == null) {
			danmakuContent = messageContent;
		}
		boolean isMine = TextUtils.equals(configHandler.getUid(),
				message.getSender());
		int color = isMine
				? app.getColorInt(R.color.handwin_txt_my_danmaku_color)
				: Color.WHITE;
		if (danmakuView.getValidPlaceHeight() == 0) {
			danmakuView.setValidPlaceHeight(isKeyBoardShow ? danmakuLeftHeight - sendEditorHeight : danmakuView.getHeight() - app.getPxFromDp(R.dimen.handwin_ppt_btn_out_h));
		}
        danmakuView.addDanmaku(new Danmaku(danmakuContent, color));
	}

	protected boolean isStartSlideSceneByMe() {
		if (videoSceneInfo == null) {
			return false;
		}
        return configHandler.getUid().equals(videoSceneInfo.getSponsorId());
    }

	@Subscribe
	public void onPPTMsgSendPageKeyboardShowEvent(PPTMsgSendPageKeyboardShowEvent event) {
		Utils.debug("BaseChatPresentation onKeyboardShow");
		isKeyBoardShow = true;
		danmakuLeftHeight = event.getData() - videoContainer.getHeight();
		danmakuView.setValidPlaceHeight(danmakuLeftHeight - sendEditorHeight);
	}

	@Subscribe
	public void onPPTMsgSendPageKeyboardHideEvent(PPTMsgSendPageKeyboardHideEvent event) {
		Utils.debug("BaseChatPresentation onKeyboardHide");
		isKeyBoardShow = false;
		danmakuView.setValidPlaceHeight(danmakuView.getHeight() - app.getPxFromDp(R.dimen.handwin_ppt_btn_out_h));
	}

	private SlideSceneResource createNewResourceFromSlideInfo(
			SlideSceneInfo slideSceneInfo) {
		SlideSceneResource slideSceneResource = new SlideSceneResource(
				slideSceneInfo.getUrl(), slideSceneInfo.getSceneId(),
				slideSceneInfo.getPage(), slideSceneInfo.getTotalPage());
		return slideSceneResource;
	}

	/**
	 * 打开图片选取
	 */
	protected void selectSlidePictures(Activity activity, Fragment fragment) {
		Intent intent = new Intent();
		intent.putExtra(ExtraInfo.IMAGE_PICK_MULTI, true);
		intent.putExtra(ExtraInfo.NEED_CAMERA, false);
		intent.putExtra(ExtraInfo.MAX_IMAGE_NUMBER,
				Constant.MAX_IMG_SLIDE_NUMBER);
		intent.putExtra(ExtraInfo.IS_SHOW_SELECT_ORDER, true);
        intent.putExtra(ExtraInfo.NEED_SELECTED_PREVIEW, true) ;
        intent.putExtra(ExtraInfo.ACTION_TEXT, app.getString(R.string.handwin_app_yes));
		try {
			if (activity != null) {
				intent.setClass(activity, ImageChooseActivity.class);
				activity.startActivityForResult(intent, ReqCode.PPT_SELECT_IMG);
			} else if (fragment != null) {
				intent.setClass(fragment.getActivity(), ImageChooseActivity.class);
				fragment.startActivityForResult(intent, ReqCode.PPT_SELECT_IMG);
			}
		} catch (ActivityNotFoundException e) {
			e.printStackTrace();
		}
	}

    public void showGroupRequestView(GroupVideoResult groupVideoResult, boolean show){
        Utils.debug("BaseChatPresentationView  showGroupRequestView " + show);
        if (show){
            GroupVideoRequestItem groupVideoRequestItem = groupVideoManager.getFirstGroupVideoRequest();
            Utils.debug("BaseChatPresentationView GroupVideoDebug showGroupRequestView " + groupVideoRequestItem);
            if (groupVideoResult != null) {
                groupVideoRequestView.setRoomId(groupVideoResult.getRoomId());
                groupVideoRequestView.showView();
                groupVideoRequestView.bringToFront();
            }
        }else {
            Utils.debug("BaseChatPresentationView GroupVideoDebug showGroupRequestView hide it");
            groupVideoRequestView.setVisibility(GONE);
        }
    }

	class PPTImagePagerAdapter extends PagerAdapter {
		int resourceSize;
		private SparseArray<SlideImageHolder> viewsMap = new SparseArray<>();

		public SlideImageHolder getViewByPosition(int pos) {
			return viewsMap.get(pos);
		}

		public void setResourceSize(int resourceSize) {
			this.resourceSize = resourceSize;
		}

		@Override
		public int getCount() {
			return resourceSize;
		}

		@Override
		public boolean isViewFromObject(View view, Object object) {
			return view == object;
		}

		@Override
		public Object instantiateItem(ViewGroup container, int position) {
			SlideImageHolder holder = SlideImageHolder
					.build(getContext());
			container.addView(holder);
			viewsMap.put(position, holder);
			return holder;
		}

		@Override
		public void destroyItem(ViewGroup container, int position, Object object) {
			container.removeView((View) object);
			viewsMap.remove(position);
		}
	}
}
