package me.chatgame.uisdk.activity.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.graphics.RectF;
import android.os.Handler;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import android.widget.TextView;

import me.chatgame.mobilecg.constant.Constant;
import me.chatgame.mobilecg.constant.RecorderStatus;
import me.chatgame.mobilecg.listener.AnimCallback;
import me.chatgame.mobilecg.util.UiThreadExecutor;
import me.chatgame.mobilecg.util.Utils;
import me.chatgame.mobilecg.views.AudioRecordWaveView;
import me.chatgame.mobilecg.views.ProgressWheel;
import me.chatgame.uisdk.R;

/**
 * Created by star on 16/1/25.
 */
public class BaseAudioRecorderView extends BaseRecorderView {

    View imgRecord;
    TextView imgRecordUI;
    TextView imgDeleteAudio;

    private boolean isPlayedAnim = false;
    private int[] recordlocations = new int[2];
    private long startTime;

    private boolean alreadyInflated_ = false;

    public BaseAudioRecorderView(Context context) {
        super(context);
    }

    public BaseAudioRecorderView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public BaseAudioRecorderView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public static BaseAudioRecorderView build(Context context) {
        BaseAudioRecorderView instance = new BaseAudioRecorderView(context);
        instance.onFinishInflate();
        return instance;
    }

    /**
     * The mAlreadyInflated_ hack is needed because of an Android bug
     * which leads to infinite calls of onFinishInflate()
     * when inflating a layout with a parent and using
     * the <merge /> tag.
     *
     */
    @Override
    public void onFinishInflate() {
        if (!alreadyInflated_) {
            alreadyInflated_ = true;
            onViewChanged(this);
        }
        super.onFinishInflate();
    }

    public static BaseAudioRecorderView build(Context context, AttributeSet attrs) {
        BaseAudioRecorderView instance = new BaseAudioRecorderView(context, attrs);
        instance.onFinishInflate();
        return instance;
    }

    public static BaseAudioRecorderView build(Context context, AttributeSet attrs, int defStyleAttr) {
        BaseAudioRecorderView instance = new BaseAudioRecorderView(context, attrs, defStyleAttr);
        instance.onFinishInflate();
        return instance;
    }

    public void onViewChanged(View hasViews) {
        wheelProgress = ((ProgressWheel) hasViews.findViewById(R.id.whellprogress));
        recordWaveView = ((AudioRecordWaveView) hasViews.findViewById(R.id.record_waveview));
        tvStartDeleteRecord = ((TextView) hasViews.findViewById(R.id.tv_start_delete_record));
        imgRecordUI = ((TextView) hasViews.findViewById(R.id.icon_audio_record_ui));
        imgRecord = hasViews.findViewById(R.id.id_audio_record_bt);
        imgDeleteAudio = ((TextView) hasViews.findViewById(R.id.icon_audio_cancel));
    }


    @Override
    void afterViews() {
        super.afterViews();

        initRecordView();

        imgRecordUI.setText(getRecordButtonIcon());
        imgRecordUI.setBackgroundResource(getRecordButtonBgRes());
    }

    protected void initRecordView() {
        imgRecord.setOnTouchListener(new OnTouchListener() {

            float rawX;
            float rawY;
            boolean isClick = false;
            Handler mHandler = new Handler();

            private Runnable mRunnable = () -> {
                if (!isClick) {
                    audioUtils.stopPlay(null);
                    processRecordStart();
                }
            };

            @Override
            public boolean onTouch(View v, MotionEvent event) {
                rawX = event.getRawX();
                rawY = event.getRawY();
                switch (event.getAction()) {
                    case MotionEvent.ACTION_DOWN:
                        Utils.debug("[cgtest] touch down");
                        setUiResetFlag(false);
                        startTime = 0;
                        isClick = false;
                        isPlayedZoomAnim = false;
                        touchX = rawX;
                        onTouchDown();
                        playZoomInOrOutAnim(imgRecord, true);
                        playZoomInOrOutAnim(imgRecordUI, true);
                        playZoomInOrOutAnim(wheelProgress, true);
                        showPrepareTip();
                        startTime = System.currentTimeMillis();
                        this.mHandler.postDelayed(mRunnable,
                                Constant.LONG_CLICK_INTERNAL);
                        break;
                    case MotionEvent.ACTION_MOVE:
                        moveViewWithFinger(rawX, rawY);
                        break;
                    case MotionEvent.ACTION_CANCEL:
                        Utils.debug("[cgtest] touch cancel");
                    case MotionEvent.ACTION_UP:
                        Utils.debug("[cgtest] touch up");
                        isClick = true;
                        mHandler.removeCallbacks(mRunnable);
                        resetRecordView();
                        long deltaTime = (System.currentTimeMillis() - startTime);
                        if (deltaTime < Constant.LONG_CLICK_INTERNAL) {
                            if (Math.abs(rawX - touchX) < scaledTouchSlop) {
                                showNeedLongPressTips();
                            }

                        }
                        processRecordEnd(rawX, rawY);
                        break;
                }
                return true;
            }
        });
    }

    private void playZoomInOrOutAnim(View view, boolean show) {
        float sS = show ? 1.0f : 1.1f;
        float sE = show ? 1.1f : 1.0f;
        ObjectAnimator animator1 = ObjectAnimator.ofFloat(view, View.SCALE_X, sS, sE);
        animator1.setInterpolator(new LinearInterpolator());
        animator1.setDuration(200);

        ObjectAnimator animator2 = ObjectAnimator.ofFloat(view, View.SCALE_Y, sS, sE);
        animator2.setInterpolator(new LinearInterpolator());
        animator2.setDuration(200);

        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(animator1, animator2);
        animatorSet.start();
    }

    private void moveViewWithFinger(float rawX, float rawY) {
        if (recorderStatus == RecorderStatus.idle) {
            return;
        }

        boolean isPlayZoomAnim = isPlayZoomAnim(rawX, rawY);
        if (isPlayZoomAnim) {
            if (!isPlayedZoomAnim) {
                isPlayedZoomAnim = true;
                playZoomInOrOutAnim(imgRecord, false);
                playZoomInOrOutAnim(imgRecordUI, false);
                playZoomInOrOutAnim(wheelProgress, false);
            }
        } else if (isPlayedZoomAnim) {
            isPlayedZoomAnim = false;
            playZoomInOrOutAnim(imgRecord, true);
            playZoomInOrOutAnim(imgRecordUI, true);
            playZoomInOrOutAnim(wheelProgress, true);
        }

        boolean isShowDeleteTips = isShowDeleteTips(rawX, rawY);
        if (isShowDeleteTips) {
            recordWaveView.setVisibility(View.GONE);
            tvStartDeleteRecord.setVisibility(View.VISIBLE);
            imgDeleteAudio.setPressed(true);
            tvStartDeleteRecord.setText(getContext().getString(R.string.handwin_audio_record_cancle));
            tvStartDeleteRecord.setTextColor(getDeleteColor());
            imgRecordUI.setBackgroundResource(getDeleteBgRes());
            wheelProgress.setVisibility(View.GONE);
            if (!isPlayedAnim) {
                playScaleAnim(true, imgDeleteAudio, null);
                isPlayedAnim = true;
            }

        } else if (isPlayedAnim) {
            isPlayedAnim = false;
            imgDeleteAudio.setPressed(false);
            recordWaveView.setVisibility(View.VISIBLE);
            tvStartDeleteRecord.setVisibility(View.GONE);
            imgRecordUI.setBackgroundResource(isBurned ? R.drawable.handwin_recorder_alert_inner_circle : getRecordButtonBgRes());
            wheelProgress.setVisibility(View.VISIBLE);
        }
    }

    private boolean isPlayZoomAnim(float rawX, float rawY) {
        imgRecord.getLocationOnScreen(recordlocations);
        RectF rectF = new RectF(recordlocations[0], recordlocations[1], recordlocations[0] + imgRecord.getWidth(), recordlocations[1] + imgRecord.getHeight());
        return !rectF.contains(rawX, rawY);
    }

	protected boolean isShowDeleteTips(float rawX, float rawY) {
		imgRecord.getLocationOnScreen(recordlocations);
		RectF rectF = new RectF(recordlocations[0], recordlocations[1],
				recordlocations[0] + imgRecord.getWidth(), recordlocations[1]
						+ imgRecord.getHeight());
		return !rectF.contains(rawX, rawY)
				&& ((ViewCompat.getLayoutDirection(this) == ViewCompat.LAYOUT_DIRECTION_LTR)
						? (rawX < (getWidth() / 2))
						: (rawX > (getWidth() / 2)));
	}

    private void playScaleAnim(boolean show, View view, AnimCallback listener) {
        float sS = show ? 1.0f : 1.0f;
        float sE = show ? 1.3f : 0.6f;
        ObjectAnimator animator1 = ObjectAnimator.ofFloat(view, View.SCALE_X, sS, sE, sS);
        animator1.setInterpolator(new AccelerateDecelerateInterpolator());
        animator1.setDuration(350);
        ObjectAnimator animator2 = ObjectAnimator.ofFloat(view, View.SCALE_Y, sS, sE, sS);
        animator2.setDuration(350);
        animator2.setInterpolator(new AccelerateDecelerateInterpolator());

        AnimatorSet animSet = new AnimatorSet();
        animSet.playTogether(animator1, animator2);
        animSet.addListener(new AnimatorListenerAdapter() {
            @Override
            public void onAnimationEnd(Animator animation) {
                if (listener != null) {
                    listener.onEnd();
                }
            }
        });
        animSet.start();
    }

    protected void resetRecordView() {
        if (isUiReset()) {
            return;
        }
        Utils.debug("[cgtest] do resetRecordView");
        setUiResetFlag(true);
        if (!isPlayedZoomAnim) {
            playZoomInOrOutAnim(imgRecord, false);
            playZoomInOrOutAnim(imgRecordUI, false);
            playZoomInOrOutAnim(wheelProgress, false);
        }
        recordWaveView.setVisibility(View.GONE);
        tvStartDeleteRecord.setVisibility(View.VISIBLE);
        tvStartDeleteRecord.setText(getRecordStartInfoText());
        tvStartDeleteRecord.setTextColor(getResources().getColor(R.color.handwin_recorder_title));
        imgDeleteAudio.setPressed(false);
        showhideWheelProgressBar(false);
        if (null != videoAudioRecorderView) {
            videoAudioRecorderView.setImgButtonVisiabe(true);
        }
    }

    protected void showhideWheelProgressBar(final boolean show) {
        UiThreadExecutor.runTask(()->showhideWheelProgressBar_(show));
    }
    protected void showhideWheelProgressBar_(final boolean show) {
        if (show) {
            wheelProgress.setVisibility(View.VISIBLE);
            recordWaveView.setVisibility(View.VISIBLE);
            tvStartDeleteRecord.setVisibility(View.GONE);
            imgDeleteAudio.setVisibility(View.VISIBLE);
        } else {
            wheelProgress.setProgress(0);
            wheelProgress.setVisibility(View.GONE);
            recordWaveView.setVisibility(View.GONE);
            tvStartDeleteRecord.setVisibility(View.VISIBLE);
            imgDeleteAudio.setVisibility(View.GONE);
//            imgRecordUI.setTextColor(getConfigColor());
            imgRecordUI.setBackgroundResource(isBurned ? R.drawable.handwin_recorder_alert_inner_circle : getRecordButtonBgRes());
        }
    }

    protected void processRecordStart() {
        // to be implemented by subclasses
    }

    protected void resetRecordViewAfterRecordOver() {
        UiThreadExecutor.runTask(this::resetRecordViewAfterRecordOver_);
    }
    protected void resetRecordViewAfterRecordOver_() {
        resetRecordView();
    }

    protected void processRecordEnd(float rawX, float rawY) {
        // to be implemented by subclasses
    }

    @Override
    void processRecordTimeOut(boolean stopVOIPRecord) {
        resetRecordView();
    }
}
