package me.chatgame.uisdk.activity.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.WindowManager;
import android.widget.RelativeLayout;
import android.widget.TextView;

import java.io.File;

import me.chatgame.mobilecg.MainApp;
import me.chatgame.mobilecg.actions.FileSendManager;
import me.chatgame.mobilecg.actions.interfaces.IFileSendManager;
import me.chatgame.mobilecg.constant.RecorderStatus;
import me.chatgame.mobilecg.handler.AudioRecorder;
import me.chatgame.mobilecg.handler.CameraHandler;
import me.chatgame.mobilecg.handler.FileHandler;
import me.chatgame.mobilecg.handler.interfaces.IAudioRecorder;
import me.chatgame.mobilecg.handler.interfaces.ICamera;
import me.chatgame.mobilecg.handler.interfaces.IFileHandler;
import me.chatgame.mobilecg.listener.AudioRecordListener;
import me.chatgame.mobilecg.listener.OnAudioRecordedListener;
import me.chatgame.mobilecg.util.BackgroundExecutor;
import me.chatgame.mobilecg.util.ToastUtils;
import me.chatgame.mobilecg.util.UiThreadExecutor;
import me.chatgame.mobilecg.util.Utils;
import me.chatgame.mobilecg.util.interfaces.IToastUtils;
import me.chatgame.mobilecg.views.AudioRecordWaveView;
import me.chatgame.mobilecg.views.ProgressWheel;
import me.chatgame.uisdk.R;

/**
 * Created by scofield on 15/12/7.
 */
public class AudioRecordView extends BaseAudioRecorderView {

    MainApp mainApp;

    IAudioRecorder audioRecorder;
    ICamera cameraHandler;
    IToastUtils toastUtils;
    IFileHandler fileHandler;
    IFileSendManager fileSendManager;

    WindowManager windowManager;


    private OnAudioRecordedListener onAudioRecordedListener;

    private View emptyView;

    private boolean alreadyInflated_ = false;
    private int durationMs = 0;
    public AudioRecordView(Context context) {
        super(context);
        init_();
    }

    public AudioRecordView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init_();
    }

    public static AudioRecordView build(Context context) {
        AudioRecordView instance = new AudioRecordView(context);
        instance.onFinishInflate();
        return instance;
    }

    /**
     * The mAlreadyInflated_ hack is needed because of an Android bug
     * which leads to infinite calls of onFinishInflate()
     * when inflating a layout with a parent and using
     * the <merge /> tag.
     *
     */
    @java.lang.Override
    public void onFinishInflate() {
        if (!alreadyInflated_) {
            alreadyInflated_ = true;
            inflate(getContext(), R.layout.handwin_view_audio_record, this);
            onViewChanged(this);
        }
        super.onFinishInflate();
    }

    private void init_() {
        windowManager = ((WindowManager) getContext().getSystemService(Context.WINDOW_SERVICE));
    }

    public static AudioRecordView build(Context context, AttributeSet attrs) {
        AudioRecordView instance = new AudioRecordView(context, attrs);
        instance.onFinishInflate();
        return instance;
    }

    public void onViewChanged(View hasViews) {
        imgRecordUI = ((TextView) hasViews.findViewById(R.id.icon_audio_record_ui));
        imgRecord = hasViews.findViewById(R.id.id_audio_record_bt);
        imgDeleteAudio = ((TextView) hasViews.findViewById(R.id.icon_audio_cancel));
        tvStartDeleteRecord = ((TextView) hasViews.findViewById(R.id.tv_start_delete_record));
        wheelProgress = ((ProgressWheel) hasViews.findViewById(R.id.whellprogress));
        recordWaveView = ((AudioRecordWaveView) hasViews.findViewById(R.id.record_waveview));
        afterViews();
    }
    
    
    void afterViews() {
        mainApp = MainApp.getInstance();
        fileSendManager = FileSendManager.getInstance_(getContext());
        fileHandler = FileHandler.getInstance_(getContext()) ;
        cameraHandler = CameraHandler.getInstance_(getContext()) ;
        toastUtils = ToastUtils.getInstance_(getContext()) ;
        audioRecorder = AudioRecorder.getInstance_(getContext());

        super.afterViews();
    }


    public void setOnAudioRecordedListener(OnAudioRecordedListener onAudioRecordedListener) {
        this.onAudioRecordedListener = onAudioRecordedListener;
    }

    @Override
    protected void processRecordStart() {

        if (!isStatus(RecorderStatus.idle)) {
            return;
        }
        Utils.debug("[AudioRecordView] processRecordStart");

        disableParentTouch();
        stopVideoAudioPlay();
        initEmptyView();
        if (emptyView != null) {
            emptyView.setVisibility(View.VISIBLE);
        }

        setRecorderStatus(RecorderStatus.starting);
        final String audioFileName = fileHandler.getCacheDirByType(IFileHandler.CacheDir.AUDIO)
                + System.currentTimeMillis() + AudioRecorder.AUDIO_FILE_SUFFIX;
        audioRecorder.startRecord(audioFileName, new AudioRecordListener() {
            private int blockId = 2;

            @Override
            public void onRecordFail() {
                cameraHandler.removeAudioListener(AudioRecordView.this);
                setRecorderStatus(RecorderStatus.idle);
                showhideWheelProgressBar(false);
                enableParentTouch();
                restartVideoPlay();
                Utils.debug("startRecord : onRecordFail");
            }

            @Override
            public void onRecordData(byte[] data, int len, boolean isFileEnd) {
                if (data != null) {
                    Utils.debugFormat("[AudioRecorderView] audioMsgData data: %d,isFileHeader:%s", len, isFileEnd ? "true" : "false");
                    fileSendManager.uploadFileBlock(audioFileName, data, len, isFileEnd, isFileEnd ? 1 : blockId++);
                }
            }

            @Override
            public void onRecordProgress(int msRecord) {
                if (recorderStatus == RecorderStatus.recording) {
                    durationMs = msRecord;
                    setRecordProgress(msRecord);
                }
                if (recorderStatus == RecorderStatus.canceling) {
                    Utils.debug("Audio: stopping in recording");
                    setRecorderStatus(RecorderStatus.stoping);
                    stopRecordDelay(true);
                    durationMs = 0;
                }
            }

            @Override
            public void onVolumeChanged(int valume) {
                changeMicViewByVolume(valume);
            }

            @Override
            public void onRecordOver() {
                Utils.debug("[AUDIOHELPER] startRecord : onRecordOver");
                showhideWheelProgressBar(false);
                cameraHandler.removeAudioListener(AudioRecordView.this);
                sendAudioMessage();
                setRecorderStatus(RecorderStatus.idle);
                enableParentTouch();
                restartVideoPlay();
                resetRecordViewAfterRecordOver();
                durationMs = 0;
            }

            @Override
            public void onRecordStart() {
                cameraHandler.addAudioListenser(AudioRecordView.this);
                showhideWheelProgressBar(true);

                if (isStatus(RecorderStatus.stoping)
                        || isStatus(RecorderStatus.canceling)) {
                    Utils.debug("startRecord : onRecordStart stopRecordDelay");
                    stopRecordDelay(true);
                } else {
                    setRecorderStatus(RecorderStatus.recording);
                }
                Utils.debug("startRecord : onRecordStart");
            }
        });
    }

    @Override
    protected void processRecordEnd(float rawX, float rawY) {
        Utils.debug("[AudioRecordView] Audio: recorder status:" + recorderStatus);
        showhideWheelProgressBar(false);
        if (emptyView != null) {
            emptyView.setVisibility(View.GONE);
        }
        if (isStatus(RecorderStatus.idle) || isStatus(RecorderStatus.stoping)) {
            return;
        }
        if (isStatus(RecorderStatus.starting)) {
            setRecorderStatus(RecorderStatus.canceling);
            return;
        }

        stopRecord();

        //判断当前audio是否发送
        if (isShowDeleteTips(rawX, rawY)) {
            this.stopRecord(true);
        } else {
            stopRecord(false);
        }
    }

    private void stopRecord() {
        if (recorderStatus == RecorderStatus.recording
                || recorderStatus == RecorderStatus.starting) {
            setRecorderStatus(RecorderStatus.stoping);
        }
    }

    void processRecordTimeOut(boolean stopVOIPRecord) {
        UiThreadExecutor.runTask(()->processRecordTimeOut_(stopVOIPRecord));
    }

    void processRecordTimeOut_(boolean stopVOIPRecord) {
        super.processRecordTimeOut(stopVOIPRecord);
        if (isStatus(RecorderStatus.idle) || isStatus(RecorderStatus.stoping)) {
            return;
        }
        stopRecord();
        //自动发送
        stopRecord(false);
    }

    void stopRecordDelay(boolean canceled) {
        audioRecorder.stopRecord(canceled);
        if (canceled) {
            fileSendManager.removeFileBlock(audioRecorder.getRecordingFile());
        }
    }

    public void stopRecord(boolean canceled) {
        BackgroundExecutor.execute(()->stopRecord_(canceled), BackgroundExecutor.ThreadType.CALCULATION);
    }

    public void stopRecord_(boolean canceled) {
        audioRecorder.stopRecord(canceled);
    }

    /**
     * Called when audio is recorded
     *
     * @param duration
     * @param audioPath
     */
    protected void sendAudioMessage(int duration, String audioPath) {
        if (onAudioRecordedListener != null) {
            onAudioRecordedListener.onAudioRecorded(duration, audioPath);
        }
    }

    private void sendAudioMessage() {
        // 统计，录音成功
        if(durationMs<500){
            videoAudioRecorderView.showRecordAlertTips(getResources().getString(R.string.handwin_tips_audio_record_failed));
            return;
        }
        int duration = durationMs / 1000;
        duration = duration > 1 ? duration : 1;
        // 统计，录音时间
        String audioPath = audioRecorder.getRecordingFile();

        if (TextUtils.isEmpty(audioPath) || !new File(audioPath).exists()) {
            Utils.debug("[AudioRecordView] Record audio path is null");
            mainApp.toast(R.string.handwin_tips_audio_record_failed_1);
        } else {
            playSendSound();
            sendAudioMessage(duration, audioPath);
        }
    }

    public boolean isAudioRecording() {
        return audioRecorder.isRecording();
    }

    private void initEmptyView() {
        if (emptyView == null && chatView != null) {
            emptyView = new View(getContext());
            LayoutParams lp = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT);
            lp.addRule(RelativeLayout.ABOVE, R.id.chat_send_editor);
            chatView.addView(emptyView, lp);
            emptyView.setClickable(true);
        }
    }

    public void destroy() {
        if (emptyView != null) {
            chatView.removeView(emptyView);
            emptyView = null;
        }
        audioRecorder.releaseAudioRecordListener();
    }

    @Override
    protected int getConfigColor() {
        return getResources().getColor(R.color.handwin_G2);
    }

    @Override
    protected String getRecordButtonIcon() {
        return getResources().getString(R.string.handwin_font_img_audio_record);
    }

    @Override
    protected int getRecordButtonBgRes() {
        return R.drawable.handwin_audio_recorder_inner_circle;
    }

    public ColorStateList getTabColor() {
        return getResources().getColorStateList(R.color.handwin_selector_color_audio_recorder_bottom_text);
    }

}