package me.chatgame.uisdk.activity.adapter;

import android.content.Context;
import android.graphics.drawable.GradientDrawable;
import android.support.v7.widget.RecyclerView;
import android.text.Html;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import java.util.List;

import me.chatgame.uisdk.R;
import me.chatgame.uisdk.activity.viewholder.LivingMessageListViewHolder;
import me.chatgame.uisdk.entity.LivingMessage;


/**
 * Created by rth on 16/7/28.
 */
public class LivingMessageListAdapter extends RecyclerView.Adapter<LivingMessageListViewHolder> {

    private List<LivingMessage> data;

    private Context context;

    public LivingMessageListAdapter(List<LivingMessage> data, Context context){
        this.data = data;
        this.context = context;
    }

    @Override
    public int getItemCount() {
        return data.size();
    }

    @Override
    public void onBindViewHolder(LivingMessageListViewHolder holder, int position) {
        LivingMessage message = data.get(position);
        String levelMessage = "Lv" + " " + message.getLevel();
        holder.tvLevel.setText(levelMessage);
        GradientDrawable myGrad = (GradientDrawable)holder.tvLevel.getBackground();
        myGrad.setColor(context.getResources().getColor(message.getColorId()));
        int textColor = context.getResources().getColor(message.getColorId());
        String contentOne = "<font color=\"" + textColor + "\">" + message.getName() + "</font>";
        String contentTwo = "<font>" + " : " + message.getMessageContent() +  "</font>";
        contentOne += contentTwo;
        holder.tvNameAndContent.setText(Html.fromHtml(contentOne));
    }

    @Override
    public LivingMessageListViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.handwin_item_living_message,null);
        return new LivingMessageListViewHolder(view);
    }
}
