package me.chatgame.uisdk.activity.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import java.util.ArrayList;
import java.util.List;

import me.chatgame.mobilecg.call.CallState;
import me.chatgame.mobilecg.listener.ItemClickListener;
import me.chatgame.mobilecg.views.IconFontTextView;
import me.chatgame.uisdk.R;
import me.chatgame.mobilecg.bean.FunctionMenuData;

/**
 * Created by star on 16/8/2.
 */
public class FunctionMenuPanelAdapter extends BaseAdapter {

    private List<FunctionMenuData> datas = new ArrayList<>();
    private Context context;
    private LayoutInflater inflater;
    private ItemClickListener<FunctionMenuData> clickListener;

    public FunctionMenuPanelAdapter(Context context) {
        this.context = context;
        inflater = LayoutInflater.from(context);
    }

    @Override
    public int getCount() {
        return datas.size();
    }

    @Override
    public FunctionMenuData getItem(int position) {
        return datas.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder = null;
        if (convertView == null) {
            convertView = inflater.inflate(R.layout.handwin_function_menu_item, null);
            viewHolder = new ViewHolder();
            viewHolder.iconRl = convertView.findViewById(R.id.handwin_menu_item_icon);
            viewHolder.iconImageView = (ImageView) convertView.findViewById(R.id.handwin_menu_item_icon_img);
            viewHolder.iconFontTextView = (IconFontTextView) convertView.findViewById(R.id.handwin_menu_item_icon_font);
            viewHolder.titleView = (TextView) convertView.findViewById(R.id.handwin_menu_item_title);
            convertView.setTag(viewHolder);
        } else {
            viewHolder = (ViewHolder) convertView.getTag();
        }

        FunctionMenuData data = getItem(position);
        viewHolder.titleView.setText(data.getTitle());
        if (data.getIconResId() != null) {
            viewHolder.iconImageView.setVisibility(View.VISIBLE);
            viewHolder.iconFontTextView.setVisibility(View.GONE);
            viewHolder.iconImageView.setImageResource(data.getIconResId());
        } else {
            viewHolder.iconImageView.setVisibility(View.GONE);
            viewHolder.iconFontTextView.setVisibility(View.VISIBLE);
            viewHolder.iconFontTextView.setText(data.getIconFontChar());
        }

        boolean disableMenu = data.isDisable() || (!data.isUseInVideoLiving() && CallState.getInstance().isLiving());
        if (disableMenu) {
            viewHolder.iconRl.setOnClickListener(null);
            viewHolder.iconRl.setAlpha(0.5f);
            viewHolder.iconRl.setEnabled(false);
        } else {
            viewHolder.iconRl.setEnabled(true);
            viewHolder.iconRl.setOnClickListener(v -> {
                if (clickListener != null) {
                    clickListener.onItemClick(data);
                }
            });
            viewHolder.iconRl.setAlpha(1);
        }

        return convertView;
    }

    public void addAll(List<FunctionMenuData> menuDatas) {
        datas.clear();
        datas.addAll(menuDatas);
        notifyDataSetChanged();
    }

    public void setClickListener(ItemClickListener<FunctionMenuData> clickListener) {
        this.clickListener = clickListener;
    }

    class ViewHolder {
        View iconRl;
        ImageView iconImageView;
        IconFontTextView iconFontTextView;
        TextView titleView;
    }
}
