package me.chatgame.uisdk.activity.adapter;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.ViewGroup;

import java.util.ArrayList;
import java.util.List;

import me.chatgame.mobilecg.net.protocol.AudienceInfo;
import me.chatgame.uisdk.R;
import me.chatgame.uisdk.activity.viewholder.AudienceAvatarViewHolder;

/**
 * Created by zjchai on 16/7/26.
 */
public class AvatarAdapter extends RecyclerView.Adapter<AudienceAvatarViewHolder> {

    private Context context;

    List<AudienceInfo> datas = new ArrayList<>();

    public AvatarAdapter(Context context) {
        this.context = context ;
    }


    @Override
    public AudienceAvatarViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new AudienceAvatarViewHolder(LayoutInflater.from(context).inflate(R.layout.handwin_vh_audience_avatar,parent,false));
    }

    @Override
    public void onBindViewHolder(AudienceAvatarViewHolder holder, int position) {
        holder.bind(datas.get(position));
    }

    @Override
    public int getItemCount() {
        return datas.size();
    }

    public void addData(@NonNull AudienceInfo data){
        datas.add(data) ;
    }

    public void addDatas(@NonNull List<AudienceInfo> data){
        datas.clear();
        datas.addAll(data) ;
        notifyDataSetChanged();
    }

    public void addAllDatas(@NonNull AudienceInfo[] data){
        datas.clear();
        for (AudienceInfo audienceInfo : data) {
            datas.add(audienceInfo) ;
        }
        notifyDataSetChanged();
    }

}
