package me.chatgame.uisdk.activity;

import android.app.Activity;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

import org.greenrobot.eventbus.Subscribe;

import me.chatgame.mobilecg.activity.BaseActivity;
import me.chatgame.mobilecg.activity.view.interfaces.KeyboardStateListener;
import me.chatgame.mobilecg.constant.BroadcastActions;
import me.chatgame.mobilecg.database.entity.BaseContact;
import me.chatgame.mobilecg.database.entity.DuduContact;
import me.chatgame.mobilecg.database.entity.DuduGroup;
import me.chatgame.mobilecg.database.entity.DuduMessage;
import me.chatgame.mobilecg.events.FinishPPtSendMsgPageEvent;
import me.chatgame.mobilecg.handler.EventSender;
import me.chatgame.mobilecg.handler.interfaces.IEventSender;
import me.chatgame.mobilecg.util.BackgroundExecutor;
import me.chatgame.mobilecg.util.UnsentMessageCacheManager;
import me.chatgame.mobilecg.util.Utils;
import me.chatgame.mobilecg.util.interfaces.IUnsentMessageCacheManager;
import me.chatgame.uisdk.R;
import me.chatgame.uisdk.activity.view.BaseSendEditorView;
import me.chatgame.uisdk.activity.view.PPTBaseSendEditView;
import me.chatgame.uisdk.activity.view.PPTGroupSendEditView;
import me.chatgame.uisdk.activity.view.PPTSingleSendEditView;

/**
 * Created by star on 16/4/13.
 */
public class PPTSendMsgActivity extends BaseActivity
        implements BaseSendEditorView.MessageAddListener, KeyboardStateListener, PPTGroupSendEditView.OnAtInputListener {
    RelativeLayout layoutRoot;

    BaseContact fromEntity;

    IEventSender eventSender;
    IUnsentMessageCacheManager unsentMessageCacheManager;

    private PPTBaseSendEditView sendEditView;
    private boolean needSetAppLive = true;
    private boolean needFinishOnHide = true;


    public final static String FROM_ENTITY_EXTRA = "from_entity";

    @Override
    public void onCreate(Bundle savedInstanceState) {
        init_(savedInstanceState);
        super.onCreate(savedInstanceState);
        setContentView(R.layout.handwin_layout_ppt_send_msg);
    }

    private void init_(Bundle savedInstanceState) {
        injectExtras_();
        init();
    }

    @Override
    public void setContentView(int layoutResID) {
        super.setContentView(layoutResID);
        onViewChanged(this);
    }

    @Override
    public void setContentView(View view, ViewGroup.LayoutParams params) {
        super.setContentView(view, params);
        onViewChanged(this);
    }

    @Override
    public void setContentView(View view) {
        super.setContentView(view);
        onViewChanged(this);
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (((Build.VERSION.SDK_INT< 5)&&(keyCode == KeyEvent.KEYCODE_BACK))&&(event.getRepeatCount() == 0)) {
            onBackPressed();
        }
        return super.onKeyDown(keyCode, event);
    }

    public void onViewChanged(Activity hasViews) {
        layoutRoot = ((RelativeLayout) hasViews.findViewById(R.id.layout_root));
        afterViews();
    }

    private void injectExtras_() {
        Bundle extras_ = getIntent().getExtras();
        if (extras_!= null) {
            if (extras_.containsKey(FROM_ENTITY_EXTRA)) {
                fromEntity = ((BaseContact) extras_.getSerializable(FROM_ENTITY_EXTRA));
            }
        }
    }

    @Override
    public void setIntent(Intent newIntent) {
        super.setIntent(newIntent);
        injectExtras_();
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case  1002 :
                PPTSendMsgActivity.this.onGroupContactsSelectedForAt(resultCode, data);
                break;
        }
    }



    void afterViews() {
        setDefaultStatusBarColor();
        if (fromEntity == null) {
            finish();
            return;
        }

        if (fromEntity instanceof DuduContact) {
            sendEditView = PPTSingleSendEditView.build(this);
        } else if (fromEntity instanceof DuduGroup) {
            sendEditView = PPTGroupSendEditView.build(this);
            ((PPTGroupSendEditView)sendEditView).setAtInputListener(this);
        }

        if (sendEditView == null) {
            finish();
            return;
        }

        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
        params.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
        sendEditView.setId(R.id.chat_send_editor);

        sendEditView.setChatEntity(fromEntity);
        sendEditView.setMessageAddListener(this);
        sendEditView.setKeyboardStateListener(this);

        layoutRoot.addView(sendEditView, params);

        layoutRoot.getViewTreeObserver()
                .addOnGlobalLayoutListener(
                        () -> sendEditView.onGlobalLayout(layoutRoot));
        doShowUnSendMessage();

        eventSender.register(this);
    }

    private void init() {
        eventSender = EventSender.getInstance_();
        unsentMessageCacheManager = UnsentMessageCacheManager.getInstance_(this) ;
    }

    @Override
    public void onAddOneMessage(DuduMessage message) {
        eventSender.sendPPTDanmakumsgEvent(message);
    }

    @Override
    public void onKeyboardShow() {
        needFinishOnHide = true;
        eventSender.sendPPTMsgSendPageKeyboardShowEvent(sendEditView.getHeight());
    }

    @Override
    public void onKeyboardHide() {
        if (needFinishOnHide) {
            if (sendEditView != null) {
                sendEditView.setVisibility(View.GONE);
            }
            eventSender.sendPPTMsgSendPageKeyboardHideEvent();
            eventSender.sendOnPPTDanmakuMsgSendPageCloseEvent();
            finish();
        }
    }

    @Override
    public void finish() {
        needSetAppLive = false;
        saveUnsentMsg();
        super.finish();
    }

    protected void doShowUnSendMessage(){
        BackgroundExecutor.execute(this::doShowUnSendMessage_, BackgroundExecutor.ThreadType.IO);
    }
    protected void doShowUnSendMessage_(){
        if (sendEditView != null && fromEntity != null) {
            // 填充上次未发送的消息
            String unSendMsg = unsentMessageCacheManager.getUnsentMessage(fromEntity.getBaseId());
            sendEditView.showUnsendMsg(unSendMsg);
        }
    }

    private void saveUnsentMsg() {
        if (sendEditView != null && sendEditView.getEditText() != null && fromEntity != null) {
            String msg = sendEditView.getEditText().getText().toString().trim();
            asyncSaveMsg(fromEntity.getBaseId(), msg);
        }
    }

    void asyncSaveMsg(String cid, String msg) {
        BackgroundExecutor.execute(()->asyncSaveMsg_(cid, msg),"","unsent_msg", BackgroundExecutor.ThreadType.IO);
    }

    void asyncSaveMsg_(String cid, String msg) {
        unsentMessageCacheManager.saveUnsentMessage(cid, msg);
    }

    @Override
    protected void onPause() {
        super.onPause();
        if (needSetAppLive) {
            systemStatus.setAppAlive(false);
            this.sendLocalBroadCast(new Intent(BroadcastActions.LIVE_PAUSE));
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        systemStatus.setAppAlive(true);
        needSetAppLive = true;
        this.sendLocalBroadCast(new Intent(BroadcastActions.LIVE_RESUME));
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        eventSender.sendPPTMsgSendPageKeyboardHideEvent();
        eventSender.sendOnPPTDanmakuMsgSendPageCloseEvent();
        eventSender.unregister(this);
    }

    @Subscribe
    public void onReceiveFinishPage(FinishPPtSendMsgPageEvent event) {
        finish();
    }

    void onGroupContactsSelectedForAt(int resultCode, Intent data) {
        if (sendEditView != null) {
            sendEditView.onAtContactsSelected(resultCode, data);
        }
    }

    @Override
    public void onSelectAtContacts() {
        Utils.debug("##### onSelectAtContacts");
        needFinishOnHide = false;
    }

    @Override
    protected boolean needCamera() {
        return true;
    }
}
