package me.chatgame.uisdk.activity;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.app.Activity;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.PixelFormat;
import android.os.Build;
import android.os.Bundle;
import android.os.PowerManager;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.DecelerateInterpolator;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.palmwin.proxy.JsonProxy;
import com.xiaomi.mipush.sdk.MiPushClient;

import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import java.io.Serializable;
import java.util.ArrayList;

import me.chatgame.mobilecg.IMService;
import me.chatgame.mobilecg.MainApp;
import me.chatgame.mobilecg.MessageService;
import me.chatgame.mobilecg.actions.ConversationActions;
import me.chatgame.mobilecg.actions.DuduMessageActions;
import me.chatgame.mobilecg.actions.MessageUtils;
import me.chatgame.mobilecg.actions.SystemActions;
import me.chatgame.mobilecg.actions.interfaces.IConversationActions;
import me.chatgame.mobilecg.actions.interfaces.IDuduMessageActions;
import me.chatgame.mobilecg.actions.interfaces.IMessageUtils;
import me.chatgame.mobilecg.actions.interfaces.ISystemActions;
import me.chatgame.mobilecg.activity.PreviewActivity;
import me.chatgame.mobilecg.activity.view.interfaces.IChatEvent;
import me.chatgame.mobilecg.activity.view.interfaces.IClosable;
import me.chatgame.mobilecg.activity.view.interfaces.ILiveActivity;
import me.chatgame.mobilecg.activity.view.interfaces.ILivePreviewContainerView;
import me.chatgame.mobilecg.call.CallService;
import me.chatgame.mobilecg.call.CallState;
import me.chatgame.mobilecg.constant.BroadcastActions;
import me.chatgame.mobilecg.constant.CallSceneCommandType;
import me.chatgame.mobilecg.constant.Constant;
import me.chatgame.mobilecg.constant.ErrorCode;
import me.chatgame.mobilecg.constant.ExtraInfo;
import me.chatgame.mobilecg.constant.LoginStatus;
import me.chatgame.mobilecg.constant.MessageType;
import me.chatgame.mobilecg.constant.ResultCode;
import me.chatgame.mobilecg.database.entity.BaseContact;
import me.chatgame.mobilecg.database.entity.ContactType;
import me.chatgame.mobilecg.database.entity.DuduContact;
import me.chatgame.mobilecg.database.entity.DuduGroup;
import me.chatgame.mobilecg.database.entity.DuduMessage;
import me.chatgame.mobilecg.events.BackToDestopEvent;
import me.chatgame.mobilecg.events.CallEndEvent;
import me.chatgame.mobilecg.events.CallSceneInfo;
import me.chatgame.mobilecg.events.CallStartEvent;
import me.chatgame.mobilecg.events.CloseLiveViewEvent;
import me.chatgame.mobilecg.events.ContactRefreshAllEvent;
import me.chatgame.mobilecg.events.ContactRefreshOneEvent;
import me.chatgame.mobilecg.events.ConversationUpdateEvent;
import me.chatgame.mobilecg.events.LiveRejectByOtherEvent;
import me.chatgame.mobilecg.events.LoadingStatusEvent;
import me.chatgame.mobilecg.events.ScreenOnOffEvent;
import me.chatgame.mobilecg.events.ScreenShareEvent;
import me.chatgame.mobilecg.handler.AudioHandler;
import me.chatgame.mobilecg.handler.DBHandler;
import me.chatgame.mobilecg.handler.EventSender;
import me.chatgame.mobilecg.handler.FileHandler;
import me.chatgame.mobilecg.handler.SpeakerHandler;
import me.chatgame.mobilecg.handler.UserHandler;
import me.chatgame.mobilecg.handler.VoipAndroidManager;
import me.chatgame.mobilecg.handler.interfaces.IAudioHandler;
import me.chatgame.mobilecg.handler.interfaces.IDBHandler;
import me.chatgame.mobilecg.handler.interfaces.IEventSender;
import me.chatgame.mobilecg.handler.interfaces.IFileHandler;
import me.chatgame.mobilecg.handler.interfaces.ISpeakerHandler;
import me.chatgame.mobilecg.handler.interfaces.IUserHandler;
import me.chatgame.mobilecg.handler.interfaces.IVoipAndroidManager;
import me.chatgame.mobilecg.intent.TCPLoginIntent;
import me.chatgame.mobilecg.intent.TipInfo;
import me.chatgame.mobilecg.listener.NormalCallback;
import me.chatgame.mobilecg.model.PraiseStatus;
import me.chatgame.mobilecg.model.VideoMessageData;
import me.chatgame.mobilecg.util.AnimUtils;
import me.chatgame.mobilecg.util.AudioUtils;
import me.chatgame.mobilecg.util.BackgroundExecutor;
import me.chatgame.mobilecg.util.CallUtils;
import me.chatgame.mobilecg.util.ContactCacheManager;
import me.chatgame.mobilecg.util.Device;
import me.chatgame.mobilecg.util.FaceUtils;
import me.chatgame.mobilecg.util.FileUtils;
import me.chatgame.mobilecg.util.ImageUtils;
import me.chatgame.mobilecg.util.NetworkUtils;
import me.chatgame.mobilecg.util.NotifyUtils;
import me.chatgame.mobilecg.util.PickupDetector;
import me.chatgame.mobilecg.util.SDCard;
import me.chatgame.mobilecg.util.TimeUtils;
import me.chatgame.mobilecg.util.ToastUtils;
import me.chatgame.mobilecg.util.UiThreadExecutor;
import me.chatgame.mobilecg.util.Utils;
import me.chatgame.mobilecg.util.interfaces.IAnimUtils;
import me.chatgame.mobilecg.util.interfaces.ICallUtils;
import me.chatgame.mobilecg.util.interfaces.IContactCacheManager;
import me.chatgame.mobilecg.util.interfaces.IDevice;
import me.chatgame.mobilecg.util.interfaces.IFaceUtils;
import me.chatgame.mobilecg.util.interfaces.IFile;
import me.chatgame.mobilecg.util.interfaces.IImageUtils;
import me.chatgame.mobilecg.util.interfaces.INetwork;
import me.chatgame.mobilecg.util.interfaces.ISDCard;
import me.chatgame.mobilecg.util.interfaces.ITimeUtils;
import me.chatgame.mobilecg.util.interfaces.IToastUtils;
import me.chatgame.mobilecg.views.CommonToastView;
import me.chatgame.mobilecg.views.GlobalTouchLayout;
import me.chatgame.mobilecg.views.crop.Crop;
import me.chatgame.uisdk.R;
import me.chatgame.uisdk.activity.view.BaseChatView;
import me.chatgame.uisdk.activity.view.GroupChatView;
import me.chatgame.uisdk.activity.view.LivePreviewContainerView;
import me.chatgame.uisdk.activity.view.SingleChatView;

/**
 * 首页Activity
 *
 * @author gongyingjun
 */
public class MainActivity extends PreviewActivity
        implements PickupDetector.PickupDetectListener, ILiveActivity, IChatEvent {

    MainApp app;

    GlobalTouchLayout relativeRoot;
    TextView txtTips;
    SingleChatView singleChatView;
    GroupChatView groupChatView;
    LivePreviewContainerView livePreviewContainerView;
    RelativeLayout mainBodyLayout;
    CommonToastView toastFixed;


    ISDCard sdCard;
    IFileHandler fileHandler;
    IMService imService;

    IDevice device;
    INetwork network;
    IAnimUtils animUtils;
    ICallUtils callUtils;
    IDBHandler dbHandler;
    ISystemActions systemActions;
    IConversationActions conversationAction;
    IAudioHandler audioHandler;
    ISpeakerHandler speakerHandler;
    IImageUtils imageUtils;
    IToastUtils toastUtils;
    ITimeUtils timeUtils;
    IDuduMessageActions duduMessageAction;
    IUserHandler userHandler;
    IVoipAndroidManager voipAndroidManager;
    IFile fileUtils;
    IFaceUtils faceUtils;
    AudioUtils audioUtils;
    IEventSender eventSender;
    IContactCacheManager contactCacheManager;
    IMessageUtils messageUtils;

    String from;
    Object fromEntity;
    boolean needReconnect = false;
    boolean fromLocalList = false;
    String comeFrom;
    String chatType;
    public boolean isGroup = false;
    public boolean isFromBlackList;
    boolean needScroll;
    int offset;
    String gameMode;
    int tabIndex = 1;

    KeyguardManager keyguardManager;
    PowerManager powerManager;

    private boolean isAnimating = false;
    private boolean isNearEar = false;

    private static final long MAX_TIME_PEROID = 1000;

    private PickupDetector mDetector;

    private boolean openChatAnimatorOver = true;

    BaseChatView currentChatView;

    IClosable closable;
    String chattingUserId = null;
    String chattingGroupId = null;

    public static boolean isInMain = false;

    private DuduContact chattingContact;
    private DuduGroup chattingGroup;

    public static final String COME_FROM_CALL = "call";
    private boolean canPauseLive = true;
    private boolean canSetAppLive = true;


    public final static String FROM_EXTRA = "from";
    public final static String FROM_ENTITY_EXTRA = "from_entity";
    public final static String TAB_INDEX_EXTRA = "tab_index";
    public final static String NEED_SCROLL_EXTRA = "need_scroll";
    public final static String IS_FROM_BLACK_LIST_EXTRA = "is_from_black_list";
    public final static String CHAT_TYPE_EXTRA = "chat_type";
    public final static String GAME_MODE_EXTRA = "game_mode";
    public final static String FROM_LOCAL_LIST_EXTRA = "from_local_list";
    public final static String OFFSET_EXTRA = "offset";
    public final static String NEED_RECONNECT_EXTRA = "need_reconnect";
    public final static String COME_FROM_EXTRA = "come_from";
    public final static String IS_GROUP_EXTRA = "is_group";

    private final IntentFilter intentFilter1_ = new IntentFilter();
    private final BroadcastReceiver groupCallBusyReceiver_ = new BroadcastReceiver() {


        public void onReceive(Context context, Intent intent) {
            MainActivity.this.groupCallBusy(intent);
        }

    };
    private final IntentFilter intentFilter2_ = new IntentFilter();
    private final BroadcastReceiver costumeUseInGroupVideoReceiver_ = new BroadcastReceiver() {


        public void onReceive(Context context, Intent intent) {
            MainActivity.this.costumeUseInGroupVideo(intent);
        }

    };
    private final IntentFilter intentFilter3_ = new IntentFilter();
    private final BroadcastReceiver onReceiveSystemCallCommingReceiver_ = new BroadcastReceiver() {


        public void onReceive(Context context, Intent intent) {
            MainActivity.this.onReceiveSystemCallComming();
        }

    };
    private final IntentFilter intentFilter4_ = new IntentFilter();
    private final BroadcastReceiver emptyTipReceiverReceiver_ = new BroadcastReceiver() {


        public void onReceive(Context context, Intent intent) {
            MainActivity.this.emptyTipReceiver(intent);
        }

    };
    private final IntentFilter intentFilter5_ = new IntentFilter();
    private final BroadcastReceiver receiveDisconnectTCPReceiver_ = new BroadcastReceiver() {


        public void onReceive(Context context, Intent intent) {
            MainActivity.this.receiveDisconnectTCP(intent);
        }

    };
    private final IntentFilter intentFilter7_ = new IntentFilter();
    private final BroadcastReceiver updateProgressReceiverReceiver_ = new BroadcastReceiver() {


        public void onReceive(Context context, Intent intent) {
            MainActivity.this.updateProgressReceiver(intent);
        }

    };
    private final IntentFilter intentFilter8_ = new IntentFilter();
    private final BroadcastReceiver onReceiveBeginConnectReceiver_ = new BroadcastReceiver() {


        public void onReceive(Context context, Intent intent) {
            MainActivity.this.onReceiveBeginConnect();
        }

    };
    private final IntentFilter intentFilter9_ = new IntentFilter();
    private final BroadcastReceiver onReceiveTipReceiver_ = new BroadcastReceiver() {


        public void onReceive(Context context, Intent intent) {
            MainActivity.this.onReceiveTip(intent);
        }

    };
    private final IntentFilter intentFilter10_ = new IntentFilter();
    private final BroadcastReceiver finishReceiverReceiver_ = new BroadcastReceiver() {


        public void onReceive(Context context, Intent intent) {
            MainActivity.this.finishReceiver(intent);
        }

    };
    private final IntentFilter intentFilter11_ = new IntentFilter();
    private final BroadcastReceiver onReceiveEnterChatReceiver_ = new BroadcastReceiver() {


        public void onReceive(Context context, Intent intent) {
            MainActivity.this.onReceiveEnterChat(intent);
        }

    };
    private final IntentFilter intentFilter12_ = new IntentFilter();
    private final IntentFilter intentFilter13_ = new IntentFilter();
    private final BroadcastReceiver onReceiveHangupReceiver_ = new BroadcastReceiver() {


        public void onReceive(Context context, Intent intent) {
            MainActivity.this.onReceiveHangup(intent);
        }

    };
    private final IntentFilter intentFilter14_ = new IntentFilter();
    private final IntentFilter intentFilter15_ = new IntentFilter();
    private final BroadcastReceiver onReceiveTcpIsDisconnectedReceiver_ = new BroadcastReceiver() {


        public void onReceive(Context context, Intent intent) {
            MainActivity.this.onReceiveTcpIsDisconnected();
        }

    };
    private final IntentFilter intentFilter16_ = new IntentFilter();
    private final BroadcastReceiver bottomReceiverReceiver_ = new BroadcastReceiver() {


        public void onReceive(Context context, Intent intent) {
            MainActivity.this.bottomReceiver(intent);
        }

    };
    private final IntentFilter intentFilter17_ = new IntentFilter();
    private final BroadcastReceiver onContactDeletedReceiver_ = new BroadcastReceiver() {


        public void onReceive(Context context, Intent intent) {
            MainActivity.this.onContactDeleted(intent);
        }

    };
    private final IntentFilter intentFilter18_ = new IntentFilter();
    private final BroadcastReceiver hanndleGroupHungupReceiver_ = new BroadcastReceiver() {


        public void onReceive(Context context, Intent intent) {
            MainActivity.this.hanndleGroupHungup(intent);
        }

    };
    private final IntentFilter intentFilter19_ = new IntentFilter();
    private final BroadcastReceiver onReceiveSystemCallWhenCallingReceiver_ = new BroadcastReceiver() {


        public void onReceive(Context context, Intent intent) {
            MainActivity.this.onReceiveSystemCallWhenCalling();
        }

    };
    private final IntentFilter intentFilter20_ = new IntentFilter();
    private final BroadcastReceiver hasOfflineMessageOverReceiver_ = new BroadcastReceiver() {


        public void onReceive(Context context, Intent intent) {
            MainActivity.this.hasOfflineMessageOver();
        }

    };
    private final IntentFilter intentFilter21_ = new IntentFilter();
    private final BroadcastReceiver groupVideoStartReceiver_ = new BroadcastReceiver() {


        public void onReceive(Context context, Intent intent) {
            MainActivity.this.groupVideoStart(intent);
        }

    };
    private final IntentFilter intentFilter22_ = new IntentFilter();
    private final BroadcastReceiver receiveLoginTCPReceiver_ = new BroadcastReceiver() {


        public void onReceive(Context context, Intent intent) {
            MainActivity.this.receiveLoginTCP(intent);
        }

    };
    private final IntentFilter intentFilter23_ = new IntentFilter();
    private final BroadcastReceiver updateMessageReceiverReceiver_ = new BroadcastReceiver() {


        public void onReceive(Context context, Intent intent) {
            MainActivity.this.updateMessageReceiver(intent);
        }

    };
    private final IntentFilter intentFilter24_ = new IntentFilter();
    private final BroadcastReceiver atGroupContactReceiver_ = new BroadcastReceiver() {


        public void onReceive(Context context, Intent intent) {
            MainActivity.this.atGroupContact(intent);
        }

    };
    private final IntentFilter intentFilter25_ = new IntentFilter();
    private final BroadcastReceiver onLanguageChangeReceiver_ = new BroadcastReceiver() {


        public void onReceive(Context context, Intent intent) {
            MainActivity.this.onLanguageChange();
        }

    };
    private final IntentFilter intentFilter26_ = new IntentFilter();
    private final BroadcastReceiver onEarphoneReceiverReceiver_ = new BroadcastReceiver() {


        public void onReceive(Context context, Intent intent) {
            MainActivity.this.onEarphoneReceiver(context, intent);
        }

    };
    private boolean clickFloatVideo=false;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        init_(savedInstanceState);
        super.onCreate(savedInstanceState);
        setContentView(R.layout.handwin_activity_main);
    }

    private void init_(Bundle savedInstanceState) {
        keyguardManager = ((KeyguardManager) this.getSystemService(Context.KEYGUARD_SERVICE));
        powerManager = ((PowerManager) this.getSystemService(Context.POWER_SERVICE));
        injectExtras_();
        intentFilter1_.addAction("live.group.call.busy");
        LocalBroadcastManager.getInstance(this).registerReceiver(groupCallBusyReceiver_, intentFilter1_);
        intentFilter2_.addAction("group_video_call_info");
        LocalBroadcastManager.getInstance(this).registerReceiver(costumeUseInGroupVideoReceiver_, intentFilter2_);
        intentFilter3_.addAction("me.chatgame.open_system_incomming");
        LocalBroadcastManager.getInstance(this).registerReceiver(onReceiveSystemCallCommingReceiver_, intentFilter3_);
        intentFilter4_.addAction("me.chatgame.open_show_empty_tip_in_chat");
        LocalBroadcastManager.getInstance(this).registerReceiver(emptyTipReceiverReceiver_, intentFilter4_);
        intentFilter5_.addAction("me.chatgame.open_tcp_disconnect");
        LocalBroadcastManager.getInstance(this).registerReceiver(receiveDisconnectTCPReceiver_, intentFilter5_);
        intentFilter7_.addAction("me.chatgame.open_file_upload");
        LocalBroadcastManager.getInstance(this).registerReceiver(updateProgressReceiverReceiver_, intentFilter7_);
        intentFilter8_.addAction("live.begin.connecte");
        LocalBroadcastManager.getInstance(this).registerReceiver(onReceiveBeginConnectReceiver_, intentFilter8_);
        intentFilter9_.addAction("live.tip");
        LocalBroadcastManager.getInstance(this).registerReceiver(onReceiveTipReceiver_, intentFilter9_);
        intentFilter10_.addAction("me.chatgame.open_finish_chat_activity");
        LocalBroadcastManager.getInstance(this).registerReceiver(finishReceiverReceiver_, intentFilter10_);
        intentFilter11_.addAction("enter.chat");
        LocalBroadcastManager.getInstance(this).registerReceiver(onReceiveEnterChatReceiver_, intentFilter11_);
        intentFilter13_.addAction("live_hungup");
        LocalBroadcastManager.getInstance(this).registerReceiver(onReceiveHangupReceiver_, intentFilter13_);
        intentFilter15_.addAction("live.tcp.disconnected");
        LocalBroadcastManager.getInstance(this).registerReceiver(onReceiveTcpIsDisconnectedReceiver_, intentFilter15_);
        intentFilter16_.addAction("me.chatgame.open_chat_list_bottom");
        LocalBroadcastManager.getInstance(this).registerReceiver(bottomReceiverReceiver_, intentFilter16_);
        intentFilter17_.addAction("me.chatgame.open_contact_delete_one");
        LocalBroadcastManager.getInstance(this).registerReceiver(onContactDeletedReceiver_, intentFilter17_);
        intentFilter18_.addAction("live_group_hungup");
        LocalBroadcastManager.getInstance(this).registerReceiver(hanndleGroupHungupReceiver_, intentFilter18_);
        intentFilter19_.addAction("system.call.hungup");
        LocalBroadcastManager.getInstance(this).registerReceiver(onReceiveSystemCallWhenCallingReceiver_, intentFilter19_);
        intentFilter20_.addAction("me.chatgame.open_has_offline_msg");
        LocalBroadcastManager.getInstance(this).registerReceiver(hasOfflineMessageOverReceiver_, intentFilter20_);
        intentFilter21_.addAction("live.group.living");
        LocalBroadcastManager.getInstance(this).registerReceiver(groupVideoStartReceiver_, intentFilter21_);
        intentFilter22_.addAction("me.chatgame.open_login_tcp");
        LocalBroadcastManager.getInstance(this).registerReceiver(receiveLoginTCPReceiver_, intentFilter22_);
        intentFilter23_.addAction("me.chatgame.open_update_message_in_chat");
        LocalBroadcastManager.getInstance(this).registerReceiver(updateMessageReceiverReceiver_, intentFilter23_);
        intentFilter24_.addAction("at_contact");
        LocalBroadcastManager.getInstance(this).registerReceiver(atGroupContactReceiver_, intentFilter24_);
        intentFilter25_.addAction("setting.update.language");
        LocalBroadcastManager.getInstance(this).registerReceiver(onLanguageChangeReceiver_, intentFilter25_);
        intentFilter26_.addAction("android.intent.action.HEADSET_PLUG");
        this.registerReceiver(onEarphoneReceiverReceiver_, intentFilter26_);
        init();
    }

    @Override
    public void setContentView(int layoutResID) {
        super.setContentView(layoutResID);
        onViewChanged(this);
    }

    @Override
    public void setContentView(View view, ViewGroup.LayoutParams params) {
        super.setContentView(view, params);
        onViewChanged(this);
    }

    @Override
    public void setContentView(View view) {
        super.setContentView(view);
        onViewChanged(this);
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (((Build.VERSION.SDK_INT < 5) && (keyCode == KeyEvent.KEYCODE_BACK)) && (event.getRepeatCount() == 0)) {
            onBackPressed();
        }
        return onKeyDown_(keyCode, event);
    }

    public void onViewChanged(Activity hasViews) {
        singleChatView = ((SingleChatView) hasViews.findViewById(R.id.id_single_chat_view));
        toastFixed = ((CommonToastView) hasViews.findViewById(R.id.toast_fixed));
        groupChatView = ((GroupChatView) hasViews.findViewById(R.id.id_group_chat_view));
        mainBodyLayout = ((RelativeLayout) hasViews.findViewById(R.id.main_body_layout));
        livePreviewContainerView = ((LivePreviewContainerView) hasViews.findViewById(R.id.id_live_view_container));
        relativeRoot = ((GlobalTouchLayout) hasViews.findViewById(R.id.relative_root));
        txtTips = ((TextView) hasViews.findViewById(R.id.txt_tips));
        afterViews();
    }

    private void injectExtras_() {
        Bundle extras_ = getIntent().getExtras();
        if (extras_ != null) {
            if (extras_.containsKey(FROM_EXTRA)) {
                from = extras_.getString(FROM_EXTRA);
            }
            if (extras_.containsKey(FROM_ENTITY_EXTRA)) {
                fromEntity = ((Object) extras_.getSerializable(FROM_ENTITY_EXTRA));
            }
            if(extras_.containsKey(ExtraInfo.CLICK_FLOAT_VIDEO)){
                clickFloatVideo=extras_.getBoolean(ExtraInfo.CLICK_FLOAT_VIDEO);
            }
            if (extras_.containsKey(TAB_INDEX_EXTRA)) {
                tabIndex = extras_.getInt(TAB_INDEX_EXTRA);
            }
            if (extras_.containsKey(NEED_SCROLL_EXTRA)) {
                needScroll = extras_.getBoolean(NEED_SCROLL_EXTRA);
            }
            if (extras_.containsKey(IS_FROM_BLACK_LIST_EXTRA)) {
                isFromBlackList = extras_.getBoolean(IS_FROM_BLACK_LIST_EXTRA);
            }
            if (extras_.containsKey(CHAT_TYPE_EXTRA)) {
                chatType = extras_.getString(CHAT_TYPE_EXTRA);
            }
            if (extras_.containsKey(GAME_MODE_EXTRA)) {
                gameMode = extras_.getString(GAME_MODE_EXTRA);
            }
            if (extras_.containsKey(FROM_LOCAL_LIST_EXTRA)) {
                fromLocalList = extras_.getBoolean(FROM_LOCAL_LIST_EXTRA);
            }
            if (extras_.containsKey(OFFSET_EXTRA)) {
                offset = extras_.getInt(OFFSET_EXTRA);
            }
            if (extras_.containsKey(NEED_RECONNECT_EXTRA)) {
                needReconnect = extras_.getBoolean(NEED_RECONNECT_EXTRA);
            }
            if (extras_.containsKey(COME_FROM_EXTRA)) {
                comeFrom = extras_.getString(COME_FROM_EXTRA);
            }
            if (extras_.containsKey(IS_GROUP_EXTRA)) {
                isGroup = extras_.getBoolean(IS_GROUP_EXTRA);
            }
        }
    }

    @Override
    public void setIntent(Intent newIntent) {
        super.setIntent(newIntent);
        injectExtras_();
    }

    @Override
    public void onDestroy() {
        LocalBroadcastManager.getInstance(this).unregisterReceiver(groupCallBusyReceiver_);
        LocalBroadcastManager.getInstance(this).unregisterReceiver(costumeUseInGroupVideoReceiver_);
        LocalBroadcastManager.getInstance(this).unregisterReceiver(onReceiveSystemCallCommingReceiver_);
        LocalBroadcastManager.getInstance(this).unregisterReceiver(emptyTipReceiverReceiver_);
        LocalBroadcastManager.getInstance(this).unregisterReceiver(receiveDisconnectTCPReceiver_);
        LocalBroadcastManager.getInstance(this).unregisterReceiver(updateProgressReceiverReceiver_);
        LocalBroadcastManager.getInstance(this).unregisterReceiver(onReceiveBeginConnectReceiver_);
        LocalBroadcastManager.getInstance(this).unregisterReceiver(onReceiveTipReceiver_);
        LocalBroadcastManager.getInstance(this).unregisterReceiver(finishReceiverReceiver_);
        LocalBroadcastManager.getInstance(this).unregisterReceiver(onReceiveEnterChatReceiver_);
        LocalBroadcastManager.getInstance(this).unregisterReceiver(onReceiveHangupReceiver_);
        LocalBroadcastManager.getInstance(this).unregisterReceiver(onReceiveTcpIsDisconnectedReceiver_);
        LocalBroadcastManager.getInstance(this).unregisterReceiver(bottomReceiverReceiver_);
        LocalBroadcastManager.getInstance(this).unregisterReceiver(onContactDeletedReceiver_);
        LocalBroadcastManager.getInstance(this).unregisterReceiver(hanndleGroupHungupReceiver_);
        LocalBroadcastManager.getInstance(this).unregisterReceiver(onReceiveSystemCallWhenCallingReceiver_);
        LocalBroadcastManager.getInstance(this).unregisterReceiver(hasOfflineMessageOverReceiver_);
        LocalBroadcastManager.getInstance(this).unregisterReceiver(groupVideoStartReceiver_);
        LocalBroadcastManager.getInstance(this).unregisterReceiver(receiveLoginTCPReceiver_);
        LocalBroadcastManager.getInstance(this).unregisterReceiver(updateMessageReceiverReceiver_);
        LocalBroadcastManager.getInstance(this).unregisterReceiver(atGroupContactReceiver_);
        LocalBroadcastManager.getInstance(this).unregisterReceiver(onLanguageChangeReceiver_);
        this.unregisterReceiver(onEarphoneReceiverReceiver_);
        closeCurrentChatView();
        MainActivity.isInMain = false;
        NotifyUtils.getInstance_(this).cancelAllNotification();
        // 清理状态
        systemStatus.clear();
        messageUtils.clear();

        fixInputMethodManagerLeak(this);
        super.onDestroy();
        eventSender.unregister(this);
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 505:
                MainActivity.this.onResultOfGallery(resultCode, data);
                break;
            case 1006:
                MainActivity.this.onResultofPPTSelectImg(resultCode, data);
                break;
            case 701:
                MainActivity.this.onSetting(resultCode);
                break;
            case 1005:
                MainActivity.this.onGroupContactsSelectedForInvite(resultCode, data);
                break;
            case 1002:
                MainActivity.this.onGroupContactsSelectedForAt(resultCode, data);
                break;
            case 512:
                MainActivity.this.onResultOfForward(resultCode, data);
                break;
        }
    }


    @Override
    protected void onStart() {
        super.onStart();
        isInMain = true;
    }

    void init() {
        app = MainApp.getInstance();
        sdCard = SDCard.getInstance();
        voipAndroidManager = VoipAndroidManager.getInstance_(this);
        duduMessageAction = DuduMessageActions.getInstance_(this, this);
        conversationAction = ConversationActions.getInstance_(this, this);
        device = Device.getInstance(this);
        network = NetworkUtils.getInstance(this);
        fileUtils = FileUtils.getInstance_(this);
        fileHandler = FileHandler.getInstance_(this);
        timeUtils = TimeUtils.getInstance_(this);
        messageUtils = MessageUtils.getInstance_(this);
        systemActions = SystemActions.getInstance_(this, this);
        eventSender = EventSender.getInstance_();
        imageUtils = ImageUtils.getInstance_(this);
        faceUtils = FaceUtils.getInstance_(this);
        audioUtils = AudioUtils.getInstance_(this);
        animUtils = AnimUtils.getInstance_(this);
        callUtils = CallUtils.getInstance_(this);
        toastUtils = ToastUtils.getInstance_(this);
        speakerHandler = SpeakerHandler.getInstance_(this);
        contactCacheManager = ContactCacheManager.getInstance_(this);
        audioHandler = AudioHandler.getInstance_(this);
        dbHandler = DBHandler.getInstance_(this);
        userHandler = UserHandler.getInstance_(this);
        imService = IMService.getInstance_(this);
    }

    void afterViews() {
        setDefaultStatusBarColor();
        checkNeedReconnect(needReconnect);
        systemStatus.setChatting(null);
        systemStatus.setChattingGroup(null);
        if (app.isLogout || TextUtils.isEmpty(config.getUid())) {
            finish();
            return;
        }
        getWindow().setFormat(PixelFormat.RGBA_8888);

        // 显示权限提示对话框
        initAfterView();
        boolean needFinish=true;
        if (from != null || fromEntity != null) {
            enterChat(chatType, from, fromEntity, true);
            needFinish=false;
        }

        if (CallState.getInstance().isStatus(CallState.Status.Incoming)) {
            needFinish=false;
            onReceiveIncoming();
            sendLocalBroadCast(new Intent(BroadcastActions.LIVE_READY));
        } else {
            if(checkCall(comeFrom, from, gameMode)){
                needFinish=false;
            }else
            {
                if(clickFloatVideo && CallState.getInstance().isLiving()) {
                    livePreviewContainerView.switch2Live();
                    livePreviewContainerView.handleBack2Live();
                    CallService.getInstance().closeFloatVideo();
                    needFinish=false;
                }
            }

        }
        if(needFinish){
            Utils.debug("MainActivity nothing need to do,finish.");
            finish();
        }
        eventSender.register(this);
    }

    private void initAfterView() {
        Utils.debug("MainActivity initAfterView");
        Intent intent = new Intent(this, MessageService.class);
        startService(intent);
    }

    void onReceiveHangup(Intent intent) {
        synchronized (livePreviewContainerView) {
            String txtTip;
            txtTip = getString(R.string.handwin_tips_call_ended);
            int status = intent.getIntExtra(ExtraInfo.STATUS, 0);
            if (status == ErrorCode.DATA_TIMEOUT) {
                txtTip = getString(R.string.handwin_call_network_timeout);
            }
            CallState.getInstance().setStatus(CallState.Status.Idle);

            Utils.debugFormat("CallService LivingState: isLiving :%d,isChatLiving:%d,isCalling:%d,CallState:%s"
                    , livePreviewContainerView.isLiving() ? 1 : 0, livePreviewContainerView.isChatLiving() ? 1 : 0, livePreviewContainerView.isCalling() ? 1 : 0, CallState.getInstance().getStatus());
            if (!app.wasInBackground && livePreviewContainerView.isLiving()) {
                clearFixTip();
                int top = app.getResources()
                        .getDimensionPixelSize(R.dimen.handwin_call_tips_top);
                toastUtils.toastTop(txtTip, top);
            }
            closeLive(null);
        }
    }

    void onLanguageChange() {
        finish();
        Intent intent = new Intent(context, MainActivity.class);
        intent.setFlags(Intent.FLAG_ACTIVITY_BROUGHT_TO_FRONT | Intent.FLAG_ACTIVITY_NEW_TASK);
        context.startActivity(intent);
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void messageLoadingReceiver(LoadingStatusEvent event) {
        boolean start = event.getData();
        if (currentChatView != null) {
            currentChatView.showNetLoadingAnim(start);
        }
    }

    void onReceiveEnterChat(Intent intent) {
        UiThreadExecutor.runTask(() -> onReceiveEnterChat_(intent));
    }

    void onReceiveEnterChat_(Intent intent) {
        String from = intent.getStringExtra(ExtraInfo.FROM);
        String chatType = intent.getStringExtra(ExtraInfo.CHAT_TYPE);
        if (!app.isChating(from)) {
            enterChat(chatType, from);
        }
    }

    // 联系人删除广播
    void onContactDeleted(Intent intent) {
        String from = intent.getStringExtra(ExtraInfo.FROM);
        if (chattingContact != null
                && from.equals(chattingContact.getDuduUid())) {
            exitChat(singleChatView, false, true);
        }
    }

    void onReceiveSystemCallComming() {
        if (currentChatView != null) {
            currentChatView.cancelRecordVideo();
        }
    }

    /**
     * 联系人信息变化广播处理
     */
    @Subscribe
    public void receiveChangeContacts(ContactRefreshAllEvent event) {
        doReceiveChangeContacts();
    }

    void doReceiveChangeContacts() {
        UiThreadExecutor.runTask(this::doReceiveChangeContacts_);
    }

    void doReceiveChangeContacts_() {
        // 联系人修改也发这个广播
        if (this.chattingContact != null
                && currentChatView != null && currentChatView instanceof SingleChatView) {
            DuduContact contact = dbHandler.getDuduContact(chattingContact
                    .getDuduUid());
            // 不是删除
            if (contact != null) {
                chattingContact = contact;
                singleChatView.setContact(chattingContact);
            }
        }
    }

    /**
     * TCP断开广播处理
     *
     * @param intent
     */
    void receiveDisconnectTCP(Intent intent) {
        // 处理方式同网络断开
        Utils.debug("Disconnected from tcp");
        config.setStatus(LoginStatus.NO);
    }

    /**
     * TCP登录结果广播广播
     *
     * @param intent
     */
    void receiveLoginTCP(Intent intent) {
        TCPLoginIntent tcpIntent = TCPLoginIntent.build(intent);
        // TCP登录成功
        if (tcpIntent.isSuccess()) {
            if (currentChatView != null && currentChatView instanceof GroupChatView) {
                ((GroupChatView) currentChatView).loadGroupVideoInfo();
            }
        }
    }

    /**
     * 刷新会话数据
     */
    @Subscribe(threadMode = ThreadMode.MAIN)
    public void conversationUpdate(ConversationUpdateEvent event) {
        if (currentChatView != null && currentChatView instanceof GroupChatView) {
            ((GroupChatView) currentChatView).updateGroup();
        }
    }

    @Override
    public void onPickupDetected(boolean isPickingUp) {
    }

    /**
     * 图片共享图片选择返回
     */
    void onResultofPPTSelectImg(int resultCode, Intent data) {
        Utils.debugFormat("SlideDebugTest onPPTImageChooseResult in main " + livePreviewContainerView + "  " + currentChatView);
        if (null != currentChatView) {
            currentChatView.onPPTImageChooseResult(resultCode, data);
        }
        if (null != livePreviewContainerView) {
            livePreviewContainerView.onPPTImageChooseResult(resultCode, data);
        }
    }

    /**
     * 图库选取返回处理
     *
     * @param resultCode
     * @param data
     */
    void onResultOfGallery(int resultCode, Intent data) {
        if (currentChatView == null) return;
        currentChatView.onImageChooseResult(resultCode, data);
    }

    void onGroupContactsSelectedForAt(int resultCode, Intent data) {
        if (currentChatView != null && currentChatView instanceof GroupChatView) {
            ((GroupChatView) currentChatView).onAtContactsSelectedForAt(resultCode, data);
        }
    }

    void onGroupContactsSelectedForInvite(int resultCode, Intent data) {
        if (currentChatView != null && currentChatView instanceof GroupChatView) {
            ((GroupChatView) currentChatView).onAtContactsSelectedForInvite(resultCode, data);
        }
    }

    void changeChatting(String otherFrom, Object entity, String chatType) {
        if (Utils.isNotNull(otherFrom)) {
            this.from = otherFrom;
        }
        openChatAnimatorOver = true;
        if (TextUtils.equals(chatType, Constant.CHATTYPE_GROUP)) {
            DuduGroup group = null;
            if (entity != null && entity instanceof DuduGroup) {
                group = (DuduGroup) entity;
                this.from = group.getGroupId();
            }
            if (!TextUtils.equals(from, groupChatView.getConversationId())) {
                groupChatView.setDatas(new DuduMessage[0], false);
                groupChatView.exit(true);
                groupChatView.setGroup(null);
                if (group != null) {
                    enterGroupChat(group, true);
                } else {
                    enterGroupChat(otherFrom, true);
                }
            } else {
                groupChatView.saveUnSendMessage(false);
            }
        } else {
            DuduContact contact = null;
            if (entity != null && entity instanceof DuduContact) {
                contact = (DuduContact) entity;
                this.from = contact.getDuduUid();
            }
            if (!TextUtils.equals(from, singleChatView.getConversationId())) {
                singleChatView.setDatas(new DuduMessage[0], false);
                singleChatView.exit(true);
                singleChatView.setContact(null);
                if (contact != null) {
                    enterSingleChat(contact, true);
                } else {
                    enterSingleChat(otherFrom, true);
                }
            } else {
                singleChatView.saveUnSendMessage(false);
            }
        }
    }

    public void enterSingleChat(String cid, boolean disableAnim) {
        Utils.debugFormat("[CGTest] enterSingleChat cid: %s", cid);
        BackgroundExecutor.cancelAll("loadChattingContact", true);
        String serial = cid != null ? cid : "loadChattingContact";
        BackgroundExecutor.execute(
                new BackgroundExecutor.Task("loadChattingContact", 0, serial, BackgroundExecutor.ThreadType.IO) {
                    @Override
                    public void execute() {
                        try {
                            loadChattingContact(cid, disableAnim);
                        } catch (Throwable e) {
                            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
                        }
                    }
                }
        );
    }

    public void enterSingleChat(DuduContact contact) {
        onChattingContactLoaded(contact, false);
    }

    public void enterSingleChat(DuduContact contact, boolean disableAnim) {
        onChattingContactLoaded(contact, disableAnim);
    }

    void loadChattingContact(String uid, boolean disableAnim) {
        Utils.debugFormat("[CGTest] loadChattingContact uid: %s", uid);
        DuduContact contact = userHandler.getUserInfoAsyncQueryServer(uid, ContactType.STRANGER);
        onChattingContactLoadedInUiThread(contact, disableAnim);
    }

    void onChattingContactLoadedInUiThread(DuduContact contact, boolean disableAnim) {
        UiThreadExecutor.runTask(() -> onChattingContactLoadedInUiThread_(contact, disableAnim));
    }

    void onChattingContactLoadedInUiThread_(DuduContact contact, boolean disableAnim) {
        onChattingContactLoaded(contact, disableAnim);
    }

    void onChattingContactLoaded(DuduContact contact, boolean disableAnimation) {
        if (contact == null || !openChatAnimatorOver) {
            return;
        }

        animUtils.clearOneTimeTipAnimation();

        this.chattingContact = contact;
        singleChatView.prepareToEnter();

        singleChatView.setContact(contact);
        singleChatView.refreshTalkDatas(false, true);

        Utils.debug("[CGTest] onChattingContactLoaded " + contact.getDuduUid());
        // 打开聊天界面的时候，关闭键盘
        Utils.autoCloseKeyboard(this, null);
        if (!app.isChating()) {
            openChatAnimatorOver = false;
            this.showOrHideSingleChatView(true, disableAnimation, false, null);
        } else {
            onEnterSingleChat(contact);
        }
        openglRunning = false;
    }

    public void enterGroupChat(String groupId) {
        enterGroupChat(groupId, false);
    }

    public void enterGroupChat(String groupId, boolean disableAnim) {
        Utils.debugFormat("[CGTest] enterGroupChat groupId: %s", groupId);
        BackgroundExecutor.cancelAll("loadChattingGroup", true);
        String serial = groupId != null ? groupId : "loadChattingGroup";
        BackgroundExecutor.execute(
                new BackgroundExecutor.Task("loadChattingGroup", 0, serial, BackgroundExecutor.ThreadType.IO) {
                    @Override
                    public void execute() {
                        try {
                            loadChattingGroup(groupId, disableAnim);
                        } catch (Throwable e) {
                            Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
                        }
                    }
                }
        );
    }

    public void enterGroupChat(DuduGroup group) {
        onChattingGroupLoaded(group, false);
    }

    public void enterGroupChat(DuduGroup group, boolean disableAnim) {
        onChattingGroupLoaded(group, disableAnim);
    }

    void loadChattingGroup(String groupId, boolean disableAnim) {
        Utils.debugFormat("[CGTest] loadChattingGroup groupId: %s", groupId);
        DuduGroup group = userHandler.getGroupAsyncQueryServer(groupId);
//        DuduGroup group = dbHandler.getDuduGroup(groupId);

        onChattingGroupLoadedInUiThread(group, disableAnim);
    }

    void onChattingGroupLoadedInUiThread(DuduGroup group, boolean disableAnim) {
        UiThreadExecutor.runTask(() -> onChattingGroupLoadedInUiThread_(group, disableAnim));
    }

    void onChattingGroupLoadedInUiThread_(DuduGroup group, boolean disableAnim) {
        onChattingGroupLoaded(group, disableAnim);
    }

    void onChattingGroupLoaded(DuduGroup group, boolean disableAnim) {
        if (group == null || !openChatAnimatorOver) {
            return;
        }

        animUtils.clearOneTimeTipAnimation();

        this.chattingGroup = group;
        groupChatView.prepareToEnter();

        groupChatView.setGroup(group);
        groupChatView.refreshTalkDatas(false, true);

        Utils.debug("[CGTest] onChattingGroupLoaded " + group.getGroupId());
        // 打开聊天界面的时候，关闭键盘
        Utils.autoCloseKeyboard(this, null);
        if (systemStatus.getChattingGroup() == null) {
            openChatAnimatorOver = false;
            this.showOrHideGroupChatView(true, disableAnim, false, null);
        } else {
            onEnterGroupChat(group);
        }
        openglRunning = false;

    }

    /**
     * 消息列表为空，广播监听
     */
    void emptyTipReceiver(Intent intent) {
        boolean isForceClear = intent.getBooleanExtra(
                ExtraInfo.FORCE_CLEAR_CHAT_MESSAGE, false);
        if (currentChatView != null) {
            currentChatView.showEmptyImageTips(isForceClear);
        }
    }

    /**
     * 列表移动到最底部，广播监听
     */
    void bottomReceiver(Intent intent) {
        if (currentChatView == null) return;
        currentChatView.scrollToBottom();
    }

    /**
     * 用户信息更新广播接收器
     */
    @Subscribe(threadMode = ThreadMode.MAIN)
    public void infoRefreshReceiver(ContactRefreshOneEvent event) {
        String uid = event.getData();
        singleChatView.updateContact(uid);
    }

    /**
     * 关闭Activity 广播接收器
     */
    void finishReceiver(Intent intent) {
        if (currentChatView != null) {
            exitChat(currentChatView, false, true);
        }
    }

    @Override
    public void startActivity(Intent intent) {
        boolean allowStartInLiving = intent.getBooleanExtra(ExtraInfo.ALLOW_START_IN_LIVE, false);
        if (CallState.getInstance().isNotIdle() && !allowStartInLiving) {
            return;
        }
        super.startActivity(intent);
    }

    /**
     * 更新上传进度
     */
    void updateProgressReceiver(Intent intent) {
        DuduMessage message = (DuduMessage) intent
                .getSerializableExtra(ExtraInfo.MESSAGE);
        if (null == message || currentChatView == null) {
            return;
        }
        currentChatView.imageUploading(message);
    }

    private synchronized void onEnterSingleChat(DuduContact contact) {
        Utils.debug("enter chat " + openChatAnimatorOver);
        notifyUtils.cancelOfflineMsgDoneNotification();
        if (!openChatAnimatorOver) {
            singleChatView.setNeedOpenRecorderViewOnEnter(false);
            return;
        }
        if (contact == null) {
            singleChatView.setNeedOpenRecorderViewOnEnter(false);
            this.showOrHideSingleChatView(false, true);
            return;
        }
        eventSender.updateLivingUnRead();
        singleChatView.setNeedOpenRecorderViewOnEnter(false);
        singleChatView.onEnter(contact);
        fromLocalList = false;
        currentChatView = singleChatView;

        this.closable = (activity, force) -> exitChat(singleChatView, false, force);

        chattingUserId = contact.getDuduUid();
        getWindow().setSoftInputMode(
                WindowManager.LayoutParams.SOFT_INPUT_ADJUST_RESIZE);

        systemStatus.setChatting(contact.getDuduUid());
        openglRunning = false;

        conversationAction.cleanConversationUnread(chattingContact.getDuduUid());

    }

    private synchronized void onEnterGroupChat(DuduGroup group) {
        notifyUtils.cancelOfflineMsgDoneNotification();
        if (!openChatAnimatorOver) {
            groupChatView.setNeedOpenRecorderViewOnEnter(false);
            return;
        }
        if (group == null) {
            groupChatView.setNeedOpenRecorderViewOnEnter(false);
            this.showOrHideGroupChatView(false, true);
            return;
        }
        currentChatView = groupChatView;

        groupChatView.onEnter(group);

        this.closable = (activity, force) -> exitChat(groupChatView, false, force);

        chattingGroupId = group.getGroupId();
        getWindow().setSoftInputMode(
                WindowManager.LayoutParams.SOFT_INPUT_ADJUST_RESIZE);

        systemStatus.setChattingGroup(group.getGroupId());
        openglRunning = false;

        conversationAction.cleanConversationUnread(group.getGroupId());

    }

    public void callClick(DuduMessage message) {
        startCall(contactCacheManager.getDuduContact(message.getConversationId()));
    }

    void hasOfflineMessageOver() {
        if (currentChatView != null) {
            conversationAction.cleanConversationUnread(currentChatView.getConversationId());
        }
    }

    void onEarphoneReceiver(Context context, Intent intent) {
        /*
         * if (!audioHandler.isPlaying()) { // 如果不在播放音频，不处理 return; }
		 */
        boolean isEarPhone;
        int state = intent.getIntExtra("state", 0);
        switch (state) {
            case 0:
                isEarPhone = false; // 拔出耳机
                break;
            default:
                isEarPhone = true; // 插耳机
                break;
        }
        Utils.debug("MainActivity onEarphoneReceiver : " + isEarPhone);
        if (currentChatView != null) {
            currentChatView.plugHeadset(isEarPhone);
        }
        voipAndroidManager.resetSpecialAudioDevice();
    }

    void updateMessageReceiver(Intent intent) {
        Serializable serializable = intent
                .getSerializableExtra(ExtraInfo.MESSAGE);
        if (serializable != null && serializable instanceof DuduMessage) {
            DuduMessage data = (DuduMessage) serializable;
            if (currentChatView != null) {
                currentChatView.updateMessage(data.getMsgUUID());
            }
        }
    }

    void onResultOfForward(int resultCode, Intent data) {
        if (resultCode != RESULT_OK) {
            return;
        }
        if (currentChatView == null) return;
        ArrayList<BaseContact> uids = (ArrayList<BaseContact>) data.getSerializableExtra(ExtraInfo.SELECTED_CONTACTS);
        if (uids == null || uids.size() < 1) {
            return;
        }

        DuduMessage message = (DuduMessage) data
                .getSerializableExtra(ExtraInfo.MESSAGE);

        if (message == null) {
            return;
        }

        // 对于别人发送的短视频，需要增加转发标识
        if (message.getMsgType().equals(MessageType.VIDEO_SM)) {
            VideoMessageData videoData = JsonProxy.fromJson(
                    message.getMsgRaw(), VideoMessageData.class);
            if (null != videoData && null != videoData.getExtra()) {
                if (!message.getSender().equals(config.getUid())) {
                    videoData.getExtra().setForward(true);
                }
                videoData.getExtra().setPraise(PraiseStatus.unpraised);
                message.setMsgRaw(videoData.toJsonString());
            }
        }

        currentChatView.batchSend(message, uids.toArray(new BaseContact[0]));
    }

    public void exitChat(View chatView, boolean doubleClick, boolean force) {
        exitChat(chatView, doubleClick, force, false);
    }

    void exitChat(View chatView, boolean doubleClick, boolean force, boolean disableAnim) {
        if (CallState.getInstance().isStatus(CallState.Status.ChatLiving)) {
            return;
        }

        if (!(chatView instanceof BaseChatView)) {
            return;
        }

        boolean fail = ((BaseChatView)chatView).exit(force);
        if (fail) {
            return;
        }
        if (chatView == singleChatView) {
            systemStatus.setChatting(null);
        } else if (chatView == groupChatView) {
            systemStatus.setChattingGroup(null);
        }
        Utils.debug("Camera resume camera exit chat");

        NormalCallback callback = () -> {
            Utils.autoCloseKeyboard(MainActivity.this, null);
            closeChat(chatView, false);
        };
        openChatAnimatorOver = false;
//        if (chatView == singleChatView) {
//            this.showOrHideSingleChatView(false, disableAnim, doubleClick, callback);
//        } else if (chatView == groupChatView) {
//            this.showOrHideGroupChatView(false, disableAnim, doubleClick, callback);
//        }
        callback.onCallback();
        finish();
    }

    /**
     * 关闭当前聊天界面
     */
    public void closeCurrentChatView() {
        if (null == currentChatView) {
            return;
        }
        exitChat(currentChatView, false, true);
    }

    private void closeChat(View chatView, boolean hideView) {
        chatView.setTranslationX(0);
        if (hideView) {
            chatView.setAlpha(0);
            chatView.setVisibility(View.GONE);
        }
        this.closable = null;
        if (chatView == singleChatView) {
            systemStatus.setChatting(null);
            chattingUserId = null;
        } else if (chatView == groupChatView) {
            systemStatus.setChattingGroup(null);
            chattingGroupId = null;
        }
        currentChatView = null;
        getWindow().setSoftInputMode(
                WindowManager.LayoutParams.SOFT_INPUT_ADJUST_PAN);
    }

    private void showOrHideSingleChatView(boolean show, boolean disableAnim) {
        showOrHideSingleChatView(show, disableAnim, false, null);
    }

    private void showOrHideGroupChatView(boolean show, boolean disableAnim) {
        showOrHideGroupChatView(show, disableAnim, false, null);
    }

    private void showOrHideSingleChatView(final boolean show, boolean disableAnim,
                                          boolean doubleClick, final NormalCallback callback) {
        if (systemStatus.getChattingGroup() != null) {
            groupChatView.exit(true);
            closeChat(groupChatView, true);
        }
        if (!show && disableAnim) {
            showOrHideMainDirectly(!show);
            openChatAnimatorOver = true;
            if (callback != null) {
                callback.onCallback();
            }
            return;
        }

        playChatViewAnimation(singleChatView, show, doubleClick, new AnimatorListenerAdapter() {
            @Override
            public void onAnimationEnd(Animator animation) {
                if (null != callback) {
                    callback.onCallback();
                }
                isAnimating = false;
                openChatAnimatorOver = true;
                if (show) {
                    onEnterSingleChat(chattingContact);
                    return;
                }
            }
        }, disableAnim);
    }

    private void showOrHideGroupChatView(final boolean show, boolean disableAnim,
                                         boolean doubleClick, final NormalCallback callback) {
        if (app.isChating()) {
            singleChatView.exit(true);
            closeChat(singleChatView, true);
        }
        if (!show && disableAnim) {
            showOrHideMainDirectly(!show);
            openChatAnimatorOver = true;
            if (callback != null) {
                callback.onCallback();
            }
            return;
        }

        playChatViewAnimation(groupChatView, show, doubleClick, new AnimatorListenerAdapter() {
            @Override
            public void onAnimationEnd(Animator animation) {
                if (null != callback) {
                    callback.onCallback();
                }
                isAnimating = false;
                openChatAnimatorOver = true;
                if (show) {
                    onEnterGroupChat(chattingGroup);
                    return;
                }
            }
        }, disableAnim);
    }


    private void playChatViewAnimation(View chatView, boolean show, boolean doubleClick, Animator.AnimatorListener listener, boolean disableAnim) {
        float aS = show ? 0.0f : 1f;
        float aE = show ? 1f : 0.0f;
        float sS = show ? 0.9f : 1f;
        float sE = show ? 1f : 0.9f;
        if (show) {
            chatView.setVisibility(View.VISIBLE);
        }
        if (!disableAnim) {
            AnimatorSet set = new AnimatorSet();
            set.setDuration(300);
            ObjectAnimator chatViewShow;
            if (doubleClick) {
                float tS = !show ? 0 : chatView.getWidth();
                float tE = !show ? chatView.getWidth() : 0;
                chatViewShow = ObjectAnimator.ofFloat(chatView, View.TRANSLATION_X,
                        tS, tE);
                chatViewShow.setInterpolator(new DecelerateInterpolator());
            } else {
                chatView.setAlpha(aS);
                chatViewShow = ObjectAnimator.ofFloat(chatView, View.ALPHA, aS, aE);
            }
            set.playTogether(
                    chatViewShow
            );
            set.addListener(listener);

            isAnimating = true;
            set.start();
        } else {
            chatView.setAlpha(aE);
            if (listener != null) {
                listener.onAnimationEnd(null);
            }
        }
    }

    private void showOrHideMainDirectly(boolean show) {
        int visible = show ? View.VISIBLE : View.INVISIBLE;
        if (show) {
        }
    }

    @Override
    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        this.closable = null;
    }

    public void onSetting(int resultCode) {
        if (resultCode == ResultCode.RESULT_LOGOUT) {
            performLogout();
            Utils.clearLastUserInfo();
        }
    }

    public boolean onKeyDown_(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case KeyEvent.KEYCODE_VOLUME_UP:
                this.sendLocalBroadCast(new Intent(
                        BroadcastActions.VOLUME_KEYUP));
                return false;
            case KeyEvent.KEYCODE_VOLUME_DOWN:
                this.sendLocalBroadCast(new Intent(
                        BroadcastActions.VOLUME_KEYDOWN));
                return false;
            default:
                break;
        }
        if (keyCode == KeyEvent.KEYCODE_BACK) {

            // 正在拨打电话
            if (livePreviewContainerView.isInVideoChatting()) {
                //通话界面都禁止返回
                livePreviewContainerView.onBackKeyPress();
                return false;
            }
            if (CallState.getInstance().isNotStatus(CallState.Status.Idle)) {
                if (currentChatView instanceof GroupChatView) {
                    if (currentChatView.couldBack()) {
                        ((GroupChatView) currentChatView).titleBackClick();
                        return false;
                    } else {
                        return false;
                    }
                }

            }
            // 如果正在执行动画
            if (isAnimating) {
                return false;
            }
            if (null != currentChatView && currentChatView.isRecordingAudio()) {
                // 当前正在录音，不允许返回
                return false;
            }
            // 关闭权限提醒对话框
            if (this.closable != null) {
                closable.close(this, false);
                return false;
            }
            finish();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    @Override
    protected void onResume() {
        this.sendLocalBroadCast(new Intent(BroadcastActions.LIVE_RESUME));
        systemStatus.setAppAlive(true);
        systemActions.checkConfigUpdate();

        // 如果从后台进来，读取离线
        if (mApp.wasInBackground) {
            app.setLoadingOfflineMsg(true);
            conversationAction.getOfflineMessages();
        }
        if (currentOpenGLView != null) {
            currentOpenGLView.onResume();
        }
        super.onResume();

        MiPushClient.clearNotification(this.getApplicationContext());
        notifyUtils.cancelAllNotification();

        // 启动消息接收服务
        Intent intent = new Intent(this, MessageService.class);
        startService(intent);

        if (chattingUserId != null && CallState.getInstance().isNotStatus(CallState.Status.Living)) {
            systemStatus.setChatting(chattingUserId);
            cleanChattingUserUnreadCount(chattingUserId);
            if (chattingContact != null) {
                notifyUtils.cancelUserNotifications(chattingContact.getDuduUid());
            }
        }
        if (chattingGroupId != null) {
            systemStatus.setChattingGroup(chattingGroupId);
            cleanChattingUserUnreadCount(chattingGroupId);
            if (chattingGroup != null) {
                notifyUtils.cancelUserNotifications(chattingGroup.getGroupId());
            }
        }

        mDetector = new PickupDetector(this);
        mDetector.register(this);

        if (!imService.messageServerIsLogined()) {
            checkNeedReconnect(true);
        }
        Utils.debug(this.getClass() + " ---> Resume over");

    }

    void cleanChattingUserUnreadCount(String user) {
        if (Utils.isNull(user)) {
            return;
        }
        if (dbHandler.getUnReadSumAll(user) > 0) {
            dbHandler.cleanUnread(user);
        }
    }

    @Override
    public boolean needCamera() {
        return false;
    }

    /**
     * 执行登出操作
     */
    private void performLogout() {
        app.isLogout = true;
        finish();
    }

    public void backToDestop(BackToDestopEvent event) {
        finish();
    }

    @Override
    protected void onPause() {
        super.onPause();
        if(canPauseLive && !CallService.getInstance().isVideoFloat()) {
            cameraHandler.stopCamera(null);
        }
        if (canSetAppLive) {
            systemStatus.setAppAlive(false);
        }
        if (CallState.getInstance().isIdle()) {
            dialogHandle.closeNormalDialog();
        }
        dialogHandle.closeShareDialog();
        if (currentOpenGLView != null) {
            currentOpenGLView.onPause();
        }
        // 停止录音
        if (app.isChating() && CallState.getInstance().isStatus(CallState.Status.Idle)) {
            audioUtils.finishRecord();
        }

        // 停止正在播放(正在播放，并且不是靠近耳边)
        if (audioHandler.isPlaying() && !isNearEar) {
            audioHandler.stopPlay();
        }

        animUtils.clearOneTimeTipAnimation();

        if (mDetector != null) {
            mDetector.unRegister();
        }

        Utils.autoCloseKeyboard(this, currentChatView);
        if (canPauseLive && !CallService.getInstance().isVideoFloat()) {
            this.sendLocalBroadCast(new Intent(BroadcastActions.LIVE_PAUSE));
        }
        //releaseUnlockScreen();
        mDetector.unRegister();


    }

    /**
     * 延迟进入afterViews方法<br>
     * 注意，这个延迟的时间，需要大于等于权限提示Fragment动画时间
     */
    void initAfterViewDelay() {
        UiThreadExecutor.runTask(this::initAfterViewDelay_, 300);
    }

    void initAfterViewDelay_() {
        initAfterView();
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (currentChatView != null) {
            if (newConfig.hardKeyboardHidden == Configuration.HARDKEYBOARDHIDDEN_NO) {
                Utils.debug("HardKeyboard being connected.");
                currentChatView.setHardKeyboard(true);
            } else if (newConfig.hardKeyboardHidden == Configuration.HARDKEYBOARDHIDDEN_YES) {
                Utils.debug("HardKeyboard disconnected.");
                currentChatView.setHardKeyboard(false);
            }
        }
    }

    private void checkNeedReconnect(boolean needReconnect) {
        if (needReconnect) {
            imService.setNetwork(true, network.getNetworkType(), device.getIpAddress());
        }
    }

    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        if (app.isLogout || TextUtils.isEmpty(config.getUid())) {
            finish();
            return;
        }
        if (null == intent) {
            return;
        }
        boolean needReconnect = intent.getBooleanExtra(ExtraInfo.NEED_RECONNECT, false);
        checkNeedReconnect(needReconnect);
        if (needReconnect) {
            unlockScreen();
            setKeepScreenOn(true);
        }
        String from = intent.getStringExtra(ExtraInfo.FROM);
        String comeFrom = intent.getStringExtra(ExtraInfo.COME_FROM);
        fromLocalList = intent.getBooleanExtra(ExtraInfo.FROM_LOCAL_LIST, false);
        if (checkCall(comeFrom, from, Constant.MODE_VIDEO)) {
            return;
        }
        switch (CallState.getInstance().getStatus()) {
            case Idle:
                String chatType = intent.getStringExtra(ExtraInfo.CHAT_TYPE);
                Object entity = intent.getSerializableExtra(ExtraInfo.FROM_ENTITY);
                enterChat(chatType, from, entity, true);
                break;
            case Incoming:
                sendLocalBroadCast(new Intent(BroadcastActions.LIVE_READY));
                onReceiveIncoming();
                break;
            case Living:
                boolean isClickFloat=intent.getBooleanExtra(ExtraInfo.CLICK_FLOAT_VIDEO,false);
                if(isClickFloat) {
                    livePreviewContainerView.switch2Live();
                    livePreviewContainerView.handleBack2Live();
                    CallService.getInstance().closeFloatVideo();
                }
                break;
        }

    }

    public ILivePreviewContainerView getLivePreviewContainer() {
        return livePreviewContainerView;
    }

    /**
     * 检查是什么通话状态
     *
     * @param comeFrom
     * @param from
     * @param gameMode
     * @return
     */
    public boolean checkCall(String comeFrom, String from, String gameMode) {
        if (Utils.isNull(comeFrom)) {
            return false;
        }
        if (comeFrom.equals(COME_FROM_CALL)) {
            if (CallState.getInstance().isIdle()) {
                CallState.getInstance().setStatus(CallState.Status.Calling);
//                changeChatting(from, contactCacheManager.getDuduContact(from), Constant.CHATTYPE_SINGLE);
                showCallingView(userHandler.getUserInfo(from));
                delayCall(comeFrom, from);
                return true;
            }
        }
        return false;
    }

    void delayCall(String comeFrom, String from) {
        UiThreadExecutor.runTask(() -> delayCall_(comeFrom, from), 200);
    }

    void delayCall_(String comeFrom, String from) {
        callUtils.requestCall(from, comeFrom);
    }

    /**
     * start video call
     *
     * @param contact it's optional
     */
    public void startCall(DuduContact contact) {
        if (CallService.getInstance().isIdle()) {
            CallState.getInstance().setStatus(CallState.Status.Calling);
//            changeChatting(contact.getDuduUid(), contact, Constant.CHATTYPE_SINGLE);
            callUtils.requestCall(contact.getDuduUid(), ICallUtils.FROM_MAIN);
            showCallingView(contact);
        }
    }

    public void enterChat(String chatType, String cid) {
        enterChat(chatType, cid, null, false);
    }

    public void enterChat(String chatType, String cid, Object entity) {
        enterChat(chatType, cid, entity, false);
    }

    public void enterChat(String chatType, String cid, Object entity, boolean disableAnimation) {
        if (Utils.isNull(cid) && entity == null) {
            return;
        }
        if (TextUtils.equals(chatType, Constant.CHATTYPE_GROUP)) {
            DuduGroup group = null;
            if (entity != null && entity instanceof DuduGroup) {
                group = (DuduGroup) entity;
                cid = group.getGroupId();
            }

            if (systemStatus.getChattingGroup() != null && !TextUtils.equals(systemStatus.getChattingGroup(), cid)) {
                changeChatting(cid, entity, Constant.CHATTYPE_GROUP);
            } else if (group != null) {
                enterGroupChat(group, disableAnimation);
            } else {
                enterGroupChat(cid, disableAnimation);
            }
        } else {
            DuduContact contact = null;
            if (entity != null && entity instanceof DuduContact) {
                contact = (DuduContact) entity;
                cid = contact.getDuduUid();
            }
            if (app.isChating() && !app.isChating(cid)) {
                changeChatting(cid, entity, Constant.CHATTYPE_SINGLE);
            } else {
                if (!app.isChating(cid)) {
                    if (contact != null) {
                        enterSingleChat(contact, disableAnimation);
                    } else {
                        enterSingleChat(cid, disableAnimation);
                    }
                }
            }
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onCallStart(CallStartEvent event) {
        Utils.debug("CallService MainActivity onCallStart");
        this.unlockScreen();
        setKeepScreenOn(true);
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onCallEnd(CallEndEvent event) {
        Utils.debug("CallService MainActivity onCallEnd");
        releaseUnlockScreen();
        setKeepScreenOn(false);
        clearFixTip();
        if (app.isChating()) {
            if (singleChatView.isNeedOpenRecorderViewOnEnter()) {
                singleChatView.setNeedOpenRecorderViewOnEnter(false);
                singleChatView.showRecorderView(Constant.TAB_RECORD_VIDEO);
            } else {
                if (singleChatView.switchToEditMode()) {
                    voipAndroidManager.restartAllPlayingVideoMessage();
                }
            }
            hangupLive();
            singleChatView.switch2Full();
            //singleChatView.refreshTalkDatas(false, !needSendINeed2CUMessage);
        } else if (app.isChattingGroup() && !groupChatView.isShowingVideoPreview()
                && !groupChatView.isRecordingVideoOrAudio()) {
            voipAndroidManager.restartAllPlayingVideoMessage();
        }
    }

    void costumeUseInGroupVideo(Intent intent) {
        String costume = intent.getStringExtra(ExtraInfo.COSTUME_IN_USE);
        String groupId = intent.getStringExtra(ExtraInfo.GROUP_ID);
        String roomId = intent.getStringExtra(ExtraInfo.ROOM_ID);
        boolean isVideoPause = intent.getBooleanExtra(ExtraInfo.VIDEO_PAUSE, false);
        boolean isCustumeEnable = intent.getBooleanExtra(ExtraInfo.COSTUME_STATUS, true);
        int seq = intent.getIntExtra(ExtraInfo.CONTACT_SEQUENCE_IN_GROUP, 0);
        // int innerId, String roomId, String costume, boolean isVideoPause, boolean isCostumeEnable
        if (groupId.equals(systemStatus.getChattingGroup())) {
            groupChatView.updateGroupCallInfo(seq, roomId, costume, isVideoPause, isCustumeEnable);
        } else {
            dumpNotMatchGroupId(groupId, systemStatus.getChattingGroup());
        }
    }

    private void dumpNotMatchGroupId(String groupId, String chattingGroupId) {
        if (!TextUtils.isEmpty(groupId)) {
            Utils.debugFormat("GroupVideo groupId %s", groupId);
        } else {
            Utils.debugFormat("GroupVideo groupId is empty");
        }

        if (!TextUtils.isEmpty(chattingGroupId)) {
            Utils.debugFormat("GroupVideo chattingGroupId %s", chattingGroupId);
        } else {
            Utils.debugFormat("GroupVideo chattingGroupId is empty");
        }
    }

    // 超时被动挂断群视频
    void hanndleGroupHungup(Intent intent) {
        if (currentChatView != null && currentChatView instanceof GroupChatView) {
            String groupID = intent.getStringExtra(ExtraInfo.GROUP_ID);
            if (groupID != null
                    && groupID.equals(systemStatus.getChattingGroup())) {
                ((GroupChatView) currentChatView).handleStopVideoCall();
            }
        }
    }

    void groupVideoStart(Intent intent) {
        String groupId = intent.getStringExtra(ExtraInfo.GROUP_ID);
        boolean isJoinVideo = intent.getBooleanExtra(ExtraInfo.GROUP_CALL_IS_JOIN, false);
        if (groupId.equals(systemStatus.getChattingGroup())) {
            groupChatView.onGroupLiveStart(isJoinVideo);
        }
    }

    void groupCallBusy(Intent intent) {
        String groupId = intent.getStringExtra(ExtraInfo.GROUP_ID);
        if (groupId.equals(systemStatus.getChattingGroup())) {
            groupChatView.onGroupCallBusy();
        } else {
            Utils.debug("GroupCallTest in mainActivity groupId is not match");
            dumpNotMatchGroupId(groupId, systemStatus.getChattingGroup());
        }
    }

    public boolean isCalling() {
        return livePreviewContainerView.isCalling();
    }

    void showCallingView(DuduContact duduContact) {
        UiThreadExecutor.runTask(() -> showCallingView_(duduContact));
    }

    void showCallingView_(DuduContact duduContact) {
        synchronized (livePreviewContainerView) {
            livePreviewContainerView.handleShowCallingView(duduContact);
        }
    }

    void onReceiveIncoming() {
        Utils.debug("CallService onReceiveIncoming ");
        synchronized (livePreviewContainerView) {
            if (CallState.getInstance().isNotStatus(CallState.Status.Incoming)) {
                return;
            }
            unlockScreen();
            setKeepScreenOn(true);
            clearFixTip();
            dialogHandle.closeNormalDialog();
            dialogHandle.closeShareDialog();
            livePreviewContainerView.handleReceiveIncoming();
            if (currentChatView != null) {
                currentChatView.saveUnSendMessage(false);
            }
        }
    }

    public void clearFixTip() {
        toastFixed.clear();
    }

    public void showFixedTip(String tip) {
        toastFixed.showTip(tip);
    }

    public void hideFixedTip(String tip) {
        toastFixed.hideTip(tip);
    }

    void onReceiveTip(Intent intent) {
        TipInfo tipInfo = TipInfo.build(intent);
        if (tipInfo.isClearTip()) {
            hideFixedTip(tipInfo.getTip());
        } else {
            showFixedTip(tipInfo.getTip());
        }
    }

    @Override
    public String getFrom() {
        return from;
    }

    public void reCall() {
        DuduContact contact = CallState.getInstance().getContactInfo();
        startCall(contact);
    }

    @Override
    public void switch2Float(){
        livePreviewContainerView.switch2Float();
        String contactId = CallState.getInstance().getPeerId();
        changeChatting(contactId, null, Constant.CHATTYPE_SINGLE);
    }
    public void closeLive() {
        UiThreadExecutor.runTask(this::closeLive_);
    }

    public void closeLive_() {
        Utils.debugFormat("CallService closeLive callState:%s", this.isFinishing());
        synchronized (livePreviewContainerView) {
            showSystemUI();
            if (CallState.getInstance().isNotIdle()) {
                //已经不是Idle状态，可能在点击的时候，有新的来电进来，导致状态发生了变化，这时候就不能关闭了。
                return;
            }

            boolean isChatting = app.isChating() || app.isChattingGroup();
            livePreviewContainerView.handleCloseLive(isChatting);
            if (!isChatting) {
                closable = null;
                finish();
            } else {
                openglRunning = false;
            }
            if (app.isChating()) {
                if (singleChatView.isNeedOpenRecorderViewOnEnter()) {
                    singleChatView.setNeedOpenRecorderViewOnEnter(false);
                    singleChatView.showRecorderView(Constant.TAB_RECORD_VIDEO);
                } else {
                    if (singleChatView.switchToEditMode()) {
                        voipAndroidManager.restartAllPlayingVideoMessage();
                    }
                }
                hangupLive();
                singleChatView.switch2Full();
                //singleChatView.refreshTalkDatas(false, !needSendINeed2CUMessage);
            } else if (app.isChattingGroup() && !groupChatView.isShowingVideoPreview()
                    && !groupChatView.isRecordingVideoOrAudio()) {
                voipAndroidManager.restartAllPlayingVideoMessage();
            }

            Utils.autoCloseKeyboard(this, null);
            cleanChattingUserUnreadCount(chattingUserId);
            sendLocalBroadCast(new Intent(BroadcastActions.LIVE_CLOSED));
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void closeLive(CloseLiveViewEvent event) {
        closeLive_();
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onReceiveRejectByOther(LiveRejectByOtherEvent event) {
        clearFixTip();
        livePreviewContainerView.onReceiveCallRejectedByPeer();
    }

    void onReceiveSystemCallWhenCalling() {
        CallState.getInstance().setStatus(CallState.Status.Idle);
        closeLive();
    }


    // 拨打，5秒后判断自己网络状态
    void onReceiveTcpIsDisconnected() {
        showAlertTips(getResources().getString(
                R.string.handwin_tips_tcp_is_disconnected), null);
    }


    synchronized void onReceiveBeginConnect() {
        app.toast(getString(R.string.handwin_tips_connecting));
    }

    public void showAlertTips(String text, Runnable callback) {
        int top = app.getPxFromDp(R.dimen.handwin_call_tips_top);
        toastUtils.toastTopDelay(text, top, 1000);
        if (callback != null) {
            tipsDelay(callback);
        }
    }

    void tipsDelay(Runnable callback) {
        UiThreadExecutor.runTask(callback, 1000);
    }

    public void processSceneStatus(CallSceneInfo callSceneInfo) {
        Utils.debug("CallSceneDebug processSceneStatus status: " + CallState.getInstance().getStatus());
        synchronized (livePreviewContainerView) {
            if (CallState.getInstance().isNotStatus(CallState.Status.Living)
                    && CallState.getInstance().isNotStatus(CallState.Status.ChatLiving)) {
                return;
            }
            if (!callSceneInfo.getVideoSceneInfo().getRoomId().equals(CallState.getInstance().getRoomId())) {
                Utils.debug("CallSceneDebug processSceneStatus room id not match");
                return;
            }
            if (!app.isChating(CallState.getInstance().getPeerId())) {
                DuduContact contact = userHandler.getUserInfo(CallState.getInstance().getPeerId());
                if (contact == null) {
                    return;
                }
                Utils.debug("CallSceneDebug processSceneStatus enter chat");
                enterSingleChat(contact, true);
            }
            showPresentationChatView(callSceneInfo);
        }
    }

    void showPresentationChatView(CallSceneInfo callSceneInfo) {
        livePreviewContainerView.handleShowChatLive();
        if (singleChatView == currentChatView) {
            Utils.debugFormat("CallSceneDebug delayShowPresentationChatView command %d", callSceneInfo.getCommandType());
            if (callSceneInfo.getCommandType() == CallSceneCommandType.SCENE_APPLY) {
                livePreviewContainerView.setVisibility(View.GONE);
                singleChatView.switch2Presentation(callSceneInfo.getVideoSceneInfo());
            } else {
                singleChatView.hangupLive(true);
            }
        }
        cleanChattingUserUnreadCount(CallState.getInstance().getPeerId());
    }

    public void hideLivePreviewContainerView() {
        livePreviewContainerView.setVisibility(View.GONE);
    }

    public void cancelRecord() {
        if (currentChatView != null) {
            currentChatView.clearEditFocus();
            if (currentChatView.isRecordingAudio()) {
                currentChatView.cancelRecordAudio();
            }
            currentChatView.cancelRecordVideo();
        }
    }

    public String getNickname() {
        return CallState.getInstance().getNickName();
    }

    public void hangupLive() {
        if (currentChatView != null && currentChatView instanceof SingleChatView) {
            ((SingleChatView) currentChatView).hangupLive(true);
        }
    }

    public void switch2Chat() {
        Utils.debug("CallService switch2chat");
        synchronized (livePreviewContainerView) {
            CallState callState = CallState.getInstance();
            if (callState.isNotStatus(CallState.Status.Living)
                    && callState.isNotStatus(CallState.Status.ChatLiving)
                    && callState.isNotStatus(CallState.Status.Calling)) {
                return;
            }
            if (callState.getPeerId() != null && !callState.getPeerId().equals(systemStatus.getChatting())) {
                DuduContact contact = userHandler.getUserInfo(CallState.getInstance().getPeerId());
                if (contact == null) {
                    return;
                }
                enterSingleChat(contact, true);
            }
            editorSwitch2Chat();
        }
    }

    public void editorSwitch2Chat() {
        UiThreadExecutor.runTask(this::editorSwitch2Chat_, 20);
    }

    void editorSwitch2Chat_() {
        livePreviewContainerView.handleShowChatLive();
        if (currentChatView != null && currentChatView instanceof SingleChatView) {
            ((SingleChatView) currentChatView).switch2chat();
        }
        cleanChattingUserUnreadCount(CallState.getInstance().getPeerId());
    }

    public void back2live() {
        Utils.debug("CallService back2live " + CallState.getInstance().getStatus().toString());
        synchronized (livePreviewContainerView) {
            if (CallState.getInstance().isNotStatus(CallState.Status.ChatLiving) && CallState.getInstance().isNotStatus(CallState.Status.Living)) {
                return;
            }
            if (currentChatView != null) {
                currentChatView.saveUnSendMessage();
                if (currentChatView instanceof SingleChatView) {
                    ((SingleChatView) currentChatView).switch2Full();
                }
            }
            setDefaultStatusBarColor();
            livePreviewContainerView.handleBack2Live();
        }
    }

    private KeyguardManager.KeyguardLock myLock;
    private PowerManager.WakeLock wakeLock;

    private void unlockScreen() {
        if (myLock != null) {
            return;
        }
        Utils.debug("CallService unlockScreen");
        getWindow().addFlags(
                WindowManager.LayoutParams.FLAG_DISMISS_KEYGUARD
                        | WindowManager.LayoutParams.FLAG_SHOW_WHEN_LOCKED
        );
        //getWindow().setType(WindowManager.LayoutParams.TYPE_KEYGUARD_DIALOG);
        getWindow().setSoftInputMode(
                WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN);
        myLock = keyguardManager.newKeyguardLock("CG_LiveActivity");
        myLock.disableKeyguard();
        wakeLock = powerManager.newWakeLock((PowerManager.ACQUIRE_CAUSES_WAKEUP | PowerManager.SCREEN_DIM_WAKE_LOCK), "CG_LiveActivity");
        wakeLock.acquire();
    }

    private void releaseUnlockScreen() {
        Utils.debug("CallService release unlockScreen");
        getWindow().clearFlags(WindowManager.LayoutParams.FLAG_DISMISS_KEYGUARD
                | WindowManager.LayoutParams.FLAG_SHOW_WHEN_LOCKED
        );
        if (myLock != null) {
            myLock.reenableKeyguard();

        }

        if (wakeLock != null && wakeLock.isHeld()) {
            wakeLock.release();
        }
        myLock = null;
        wakeLock = null;
    }

    private void setKeepScreenOn(boolean keepScreenOn) {
        Utils.debug("onScreenOnOffEvent " + keepScreenOn);
        if (keepScreenOn) {
            getWindow().addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON | WindowManager.LayoutParams.FLAG_TURN_SCREEN_ON);
        } else {
            getWindow().clearFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON | WindowManager.LayoutParams.FLAG_TURN_SCREEN_ON);
        }
    }

    void atGroupContact(Intent data) {
        DuduContact contact = (DuduContact) data.getSerializableExtra(ExtraInfo.DUDU_CONTACT);
        if (currentChatView != null && currentChatView instanceof GroupChatView) {
            ((GroupChatView) currentChatView).atOneContact(contact);
        }
    }


    public void dismissPopWindow(PopupWindow popupWindow) {
        if (popupWindow != null && popupWindow.isShowing()) {
            try {
                popupWindow.dismiss();
            } catch (Exception e) {

            }
        }
    }

    public void switchToRecordVideo(String peerUid) {
        singleChatView.setNeedOpenRecorderViewOnEnter(true);
        closeLive(null);
        changeChatting(peerUid, null, Constant.CHATTYPE_SINGLE);
    }

    public int getOffset() {
        return offset;
    }

    public void setCanPauseLiveOnActivityPause(boolean needPauseLive) {
        this.canPauseLive = needPauseLive;
    }

    public void setCanSetAppLive(boolean needSetAppLive) {
        this.canSetAppLive = needSetAppLive;
    }

    /**
     * hides the system bars.
     */
    public void hideSystemUI() {
        Utils.debug("SystemUI hide");
        getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN,
                WindowManager.LayoutParams.FLAG_FULLSCREEN);
        setStatusBarColor(Color.TRANSPARENT);
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onReceiveScreenShareEvent(ScreenShareEvent event){
        if(event.isOn()){
            hideSystemUI();
        }else{
            showSystemUI();
        }
    }
    /**
     * shows the system bars.
     */
    public void showSystemUI() {
        Utils.debug("SystemUI show");
        getWindow().clearFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN);
        setStatusBarColor(getResources().getColor(R.color.handwin_statusbar_color));
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onScreenOnOffEvent(ScreenOnOffEvent event) {
        if (event.getData()) {
            setKeepScreenOn(true);
        } else {
            setKeepScreenOn(CallState.getInstance().isLiving());
        }
    }

}
