package me.chatgame.uisdk.activity;

import android.app.Application;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.Rect;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.SparseArray;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

import me.chatgame.mobilecg.MessageService;
import me.chatgame.mobilecg.actions.LiveVideoActions;
import me.chatgame.mobilecg.actions.interfaces.ILiveVideoActions;
import me.chatgame.mobilecg.activity.BaseActivity;
import me.chatgame.mobilecg.call.CallService;
import me.chatgame.mobilecg.call.ICallService;
import me.chatgame.mobilecg.call.LinePlayer;
import me.chatgame.mobilecg.call.LiveState;
import me.chatgame.mobilecg.constant.BroadcastActions;
import me.chatgame.mobilecg.constant.ExtraInfo;
import me.chatgame.mobilecg.database.entity.GenericMessage;
import me.chatgame.mobilecg.database.entity.LineHangupGenericMessage;
import me.chatgame.mobilecg.database.entity.LineResponseGenericMessage;
import me.chatgame.mobilecg.database.entity.PraiseGenericMessage;
import me.chatgame.mobilecg.database.entity.RequestGuestGenericMessage;
import me.chatgame.mobilecg.database.entity.TextGenericMessage;
import me.chatgame.mobilecg.events.CloseLiveVideoEvent;
import me.chatgame.mobilecg.events.DelayCloseLiveVideo;
import me.chatgame.mobilecg.events.ExitLineEvent;
import me.chatgame.mobilecg.events.JoinLiveRoomResult;
import me.chatgame.mobilecg.events.LineVideoStartEvent;
import me.chatgame.mobilecg.events.LiveStartEvent;
import me.chatgame.mobilecg.events.LiveStopEvent;
import me.chatgame.mobilecg.events.LivingMessageEvent;
import me.chatgame.mobilecg.events.NoLiveVideoEvent;
import me.chatgame.mobilecg.events.SendResponseEvent;
import me.chatgame.mobilecg.events.StartLiveVideoEvent;
import me.chatgame.mobilecg.events.TcpStatusEvent;
import me.chatgame.mobilecg.handler.ConfigHandler;
import me.chatgame.mobilecg.handler.EventSender;
import me.chatgame.mobilecg.handler.JsonHandler;
import me.chatgame.mobilecg.handler.VoipAndroidManager;
import me.chatgame.mobilecg.handler.interfaces.IConfig;
import me.chatgame.mobilecg.handler.interfaces.IEventSender;
import me.chatgame.mobilecg.handler.interfaces.IVoipAndroidManager;
import me.chatgame.mobilecg.listener.DialogCallback;
import me.chatgame.mobilecg.net.protocol.AudienceInfo;
import me.chatgame.mobilecg.net.protocol.LiveVideoInfo;
import me.chatgame.mobilecg.util.BackgroundExecutor;
import me.chatgame.mobilecg.util.DialogHandle;
import me.chatgame.mobilecg.util.ToastUtils;
import me.chatgame.mobilecg.util.UiThreadExecutor;
import me.chatgame.mobilecg.util.Utils;
import me.chatgame.mobilecg.views.IconFontTextView;
import me.chatgame.uisdk.BuildConfig;
import me.chatgame.uisdk.R;
import me.chatgame.uisdk.activity.adapter.AvatarAdapter;
import me.chatgame.uisdk.activity.adapter.LivingMessageListAdapter;
import me.chatgame.uisdk.activity.helper.LiveVideoHelper;
import me.chatgame.uisdk.activity.view.DivergeView;
import me.chatgame.uisdk.entity.LivingMessage;

public class LiveVideoActivity extends BaseActivity {

    int role;
    private int orientation ;

    //Beans
    ILiveVideoActions liveVideoActions ;
    ICallService callService ;
    IEventSender eventSender ;
    AvatarAdapter avatarAdapter ;
    IVoipAndroidManager voipAndroidManager ;
    IConfig config ;

    //Views
    RelativeLayout rootLayout ;
    IconFontTextView finishButton ;
    IconFontTextView messageButton ;
    IconFontTextView guestButton ;  //连麦
    IconFontTextView tvOpenGifts;
    IconFontTextView tvShare;
    IconFontTextView tvPraise;
    IconFontTextView microOnOffBtn;
    IconFontTextView cameraRotateBtn ;
    EditText messageEditText ;
    RecyclerView avatarList ;
    RecyclerView messageList ;
    TextView roomIdTextView ;
    TextView tvAuthorName;
    TextView tipTextView ;
    //发送或者取消输入的按钮
    Button btnAction;
    //点赞的动画视图
    DivergeView divergeViewPraiseAnim;
    //包裹底部动作按钮的View(点赞\推出\分享等等)
    RelativeLayout rlBottomActions;
    //包裹底部文本输入视图的View
    RelativeLayout rlBottomMessageView;

    //btnAction对应的两个值
    String cancelInputAction,sendMessageAction;

    //消息列表的adapter
    private LivingMessageListAdapter messageListAdapter;
    //消息列表
    List<LivingMessage> data = new ArrayList<>();

    //点赞动画的心形图案
    private Bitmap bmpHeartAnim;
    //动画心形图片的大小,
    private int bmpHeartAnimSize;


    private boolean tcpIsConnected = true;
    private boolean isFrontCamera = true ;

    //连麦与未连麦的文本
    private String microConnectText,microDisconnectText;
    SparseArray<Rect> lineCloseBtnRects = new SparseArray<>() ;

    public static void start(Context context,int role,String chatRoomId,int orientation){
        Intent intent = new Intent(context,LiveVideoActivity.class) ;
        intent.putExtra(ExtraInfo.LIVE_SHOW_ROLE, role) ;
        intent.putExtra(ExtraInfo.LIVE_SHOW_ROOM_ID, chatRoomId) ;
        intent.putExtra(ExtraInfo.LIVE_ORIENTATION, orientation) ;
        if (context instanceof Application || context instanceof Service){
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        }
        context.startActivity(intent);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.handwin_activity_live_video);
        init();
        initViews();
        afterViews();
    }

    private void initViews() {
        rootLayout = (RelativeLayout) findViewById(R.id.rl_root) ;
        finishButton = (IconFontTextView) findViewById(R.id.btn_finish);
        messageButton = (IconFontTextView) findViewById(R.id.btn_message);
        tvOpenGifts = (IconFontTextView) findViewById(R.id.tv_live_gift);
        tvShare = (IconFontTextView) findViewById(R.id.tv_live_share);
        tvPraise = (IconFontTextView) findViewById(R.id.tv_live_praise);
        messageEditText = (EditText) findViewById(R.id.et_message);
        avatarList = (RecyclerView) findViewById(R.id.audience_list);
        messageList = (RecyclerView) findViewById(R.id.message_list);
        guestButton = (IconFontTextView) findViewById(R.id.guest);
        roomIdTextView = (TextView) findViewById(R.id.room_id) ;
        btnAction = (Button) findViewById(R.id.btn_action_living);
        tvAuthorName = (TextView) findViewById(R.id.txt_author_number);
        microOnOffBtn = (IconFontTextView) findViewById(R.id.btn_mute_on_off);
        cameraRotateBtn = (IconFontTextView) findViewById(R.id.btn_camera_rotate) ;

        //暂时写死
        tvAuthorName.setText("世界第一");
        tipTextView = (TextView) findViewById(R.id.txt_tips);
        divergeViewPraiseAnim = (DivergeView) findViewById(R.id.divergeView_living);
        divergeViewPraiseAnim.post(() -> {
            divergeViewPraiseAnim.setEndPoint(new PointF(divergeViewPraiseAnim.getMeasuredWidth()/2,0));
            divergeViewPraiseAnim.setDivergeViewProvider((Object o) -> bmpHeartAnim);
        });
        rlBottomActions = (RelativeLayout) findViewById(R.id.rl_bottom_actions);
        rlBottomMessageView = (RelativeLayout) findViewById(R.id.rl_bottom_message);
        if(!tcpIsConnected) tipTextView.setVisibility(View.VISIBLE);

    }

    private void afterViews() {
        setDefaultStatusBarColor();
        switch (role) {
            case LiveState.ANCHOR:
                doAnchorAfterViews();
                break;
            case LiveState.AUDIENCE:
                doAudienceAfterViews();
                break;
        }
        cameraRotateBtn.setOnClickListener(v -> cameraRotateClick());
        microOnOffBtn.setOnClickListener(v -> microOnOffClick());
        microOnOffBtn.setSelected(false);
        finishButton.setOnClickListener(v -> closeLiveVideo());
        messageButton.setOnClickListener(v -> showMessageEditView());
        messageEditText.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

            }

            @Override
            public void afterTextChanged(Editable editable) {
                //转换动作按钮
                btnAction.setText(TextUtils.isEmpty(editable.toString()) ? cancelInputAction : sendMessageAction);
            }
        });
        messageList.setLayoutManager(new LinearLayoutManager(LiveVideoActivity.this, LinearLayoutManager.VERTICAL,true));
        messageList.setHasFixedSize(true);
        guestButton.setOnClickListener(v -> guestActions());
        btnAction.setOnClickListener((View v) -> handleBtnAction());
        tvOpenGifts.setOnClickListener(v -> openGitfView());
        tvShare.setOnClickListener(v -> shareLive());
        tvPraise.setOnClickListener(v -> sendPraise());
        config.setLiveLevel(new Random().nextInt(10)+1);
        getWindow().addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);
        rootLayout.setOnTouchListener((v, event) -> handleRootLayoutTouch(event));
    }

    private boolean handleRootLayoutTouch(MotionEvent event) {
        if (event.getAction() == MotionEvent.ACTION_DOWN) {
            if (rlBottomMessageView.getVisibility() != View.VISIBLE) {
                if (filterTouchGetOutLine(event)){
                    return true ;
                } else {
                    sendPraise();
                    return true ;
                }
            } else {
                hideMessageEditView();
                return true ;
            }
        }
        return false;
    }

    private boolean filterTouchGetOutLine(MotionEvent event) {
        int role = LiveState.getInstance().getRole();
        if (role == LiveState.ANCHOR) {
            LinkedList<LinePlayer> linePlayers = LiveState.getInstance().getLinePlayers();
            int size = linePlayers.size();
            for (int i = 0; i < size; i++) {
                Rect rect = lineCloseBtnRects.get(i);
                if (rect == null) {
                    rect = LiveVideoHelper.getLineCloseBtnRect(i,config.getScreenWidth(),config.getScreenHeight()) ;
                    lineCloseBtnRects.put(i,rect);
                }
                if (rect.contains((int)event.getX(),(int)event.getY())) {
                    getOutOneLinePlayer(linePlayers.get(i)) ;
                    return true;
                }
            }
        }
        return false;
    }

    private void getOutOneLinePlayer(LinePlayer player) {
        callService.getOutOneLinePlayer(player.getUserId(),player.getCsrc()) ;
    }

    private void cameraRotateClick() {
        isFrontCamera = !isFrontCamera ;
        voipAndroidManager.switchCameraFrontBack(isFrontCamera) ;
    }

    private void microOnOffClick() {
        boolean isOn = microOnOffBtn.isSelected();  //使用Selected状态来存储按钮开关的状态
        microOnOffBtn.setSelected(!isOn); //设置成相反的状态
        microOnOffBtn.setText(getString(
                !isOn ? R.string.handwin_font_img_micro_on : R.string.handwin_font_img_micro_off));
        if (isOn) {
            voipAndroidManager.unmuteMicrophone();
        } else {
            voipAndroidManager.muteMicrophone();
        }
    }

    /**
     * 给主播送赞
     */
    private void sendPraise() {
        BackgroundExecutor.execute(() -> {
            PraiseGenericMessage praiseGenericMessage = new PraiseGenericMessage();
            praiseGenericMessage.setLevel(config.getLiveLevel());
            praiseGenericMessage.setPraiseUserId(config.getUid());
            praiseGenericMessage.setPraiseUsername(config.getNickname());

            GenericMessage genericMessage = new GenericMessage();
            genericMessage.setType(GenericMessage.TYPE_LIVE_PRAISE);
            genericMessage.setData(praiseGenericMessage.toJson());

            liveVideoActions.sendMessage(genericMessage,LiveState.getInstance().getChatRoomId());
        }, BackgroundExecutor.ThreadType.NETWORK);
        sendPraiseSuccess();
    }

    /**
     * 点赞成功后的处理
     */
    private void sendPraiseSuccess() {
        //心的动画
        divergeViewPraiseAnim.startDiverges(0);
        updateMessageList(new LivingMessage(config.getLiveLevel()+"","送出一个赞!",config.getNickname()));
    }

    private void shareLive() {
        ToastUtils.getInstance_(this).toast("还不知道怎么分享!");
    }

    private void openGitfView() {
        ToastUtils.getInstance_(this).toast("还没有礼物!");
    }

    /**
     * 处理按钮的动作事件
     */
    public void handleBtnAction() {
        final String currentAction = btnAction.getText().toString();
        if(currentAction.equals(sendMessageAction)) {
            sendInputText(messageEditText.getText().toString());
        }else if(currentAction.equals(cancelInputAction)){
            hideMessageEditView();
        }
    }

    private void guestActions() {
        final String microText = guestButton.getText().toString();
        if (microText.equals(microDisconnectText)) {
            //连麦
            callService.requestLineMicro();
        }else if(microText.equals(microConnectText)) {
            //退出连麦
            callService.exitLineMicro();
            guestButton.setText(microDisconnectText);
        }
    }

    /**
     * 发送用户输入的文本
     */
    private void sendInputText(final String text) {
        if(TextUtils.isEmpty(text)) return;
        BackgroundExecutor.execute(() -> {
            TextGenericMessage textGenericMessage = new TextGenericMessage()
                    .setMessage(text)
                    .setLevel(config.getLiveLevel())
                    .setName(config.getNickname()) ;

            GenericMessage message = new GenericMessage()
                    .setType(GenericMessage.TYPE_TEXT)
                    .setData(textGenericMessage.toJson());
            liveVideoActions.sendMessage(message,LiveState.getInstance().getChatRoomId());
        },BackgroundExecutor.ThreadType.NETWORK);
        sendTextSuccess(text);
    }

    public void getChatRoomAudiences(){
        BackgroundExecutor.execute(()->{
            AudienceInfo[] audiences = liveVideoActions.getChatRoomAudiences(LiveState.getInstance().getChatRoomId());
            initAvatarList(audiences);
        },BackgroundExecutor.ThreadType.NETWORK);
    }

    private void initAvatarList(AudienceInfo[] audiences) {
        UiThreadExecutor.runTask(()-> initAvatarList_(audiences));
    }

    private void initAvatarList_(AudienceInfo[] audiences) {
        if (audiences == null) {
            Toast.makeText(this,"加载观众列表失败",Toast.LENGTH_LONG).show();
            return;
        } else {
            Toast.makeText(this,"加载观众列表成功",Toast.LENGTH_LONG).show();
        }
        avatarAdapter = new AvatarAdapter(this) ;
        avatarList.setLayoutManager(new LinearLayoutManager(this,LinearLayoutManager.HORIZONTAL,false));
        avatarList.setAdapter(avatarAdapter);
        avatarAdapter.addAllDatas(audiences);
    }


    private void showMessageEditView() {
        rlBottomActions.setVisibility(View.INVISIBLE);
        rlBottomMessageView.setVisibility(View.VISIBLE);
        messageEditText.requestFocus() ;
        openInputMethod();
    }

    private void openInputMethod() {
        InputMethodManager inputMethodManager = (InputMethodManager)getSystemService(Context.INPUT_METHOD_SERVICE);
        inputMethodManager.showSoftInput(messageEditText,0);
    }

    private void hideMessageEditView() {
        hideInputMethod();
        rlBottomMessageView.setVisibility(View.INVISIBLE);
        rlBottomActions.setVisibility(View.VISIBLE);
    }

    private void hideInputMethod() {
        InputMethodManager inputMethodManager = (InputMethodManager)getSystemService(Context.INPUT_METHOD_SERVICE);
        inputMethodManager.hideSoftInputFromWindow(messageEditText.getWindowToken(),0);
    }


    private void closeLiveVideo() {
        callService.doLiveVideoHangup();
        eventSender.sendDelayCloseLiveVideoEvent();
    }

    /**
     * 观众的afterViews
     */
    private void doAudienceAfterViews() {
        microOnOffBtn.setVisibility(View.GONE);
        cameraRotateBtn.setVisibility(View.GONE);
        joinChatRoom();
    }

    /**
     * 观众加入聊天室
     */
    private void joinChatRoom() {
        String chatRoomId = LiveState.getInstance().getChatRoomId();
        if (chatRoomId != null) {
            callService.joinLiveVideo(chatRoomId);
            //roomIdTextView.setText(chatRoomId);
        } else {
            Toast.makeText(this,"该房间不存在!",Toast.LENGTH_LONG).show();
        }
    }

    /**
     * 主播afterViews
     */
    private void doAnchorAfterViews() {
        guestButton.setVisibility(View.GONE);
        createChatRoom();
    }

    private void createChatRoom() {
        callService.startLiveVideoCall() ;
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void

    handleStartLiveVideoEvent(StartLiveVideoEvent event) {
        Toast.makeText(this,"开启直播成功",Toast.LENGTH_LONG).show();
        Utils.debugFormat("LiveVideoActivity 开始加入聊天室 %s",LiveState.getInstance().getChatRoomId());
        if (BuildConfig.DEBUG) {
            String text = "";
            try {
                if(LiveState.getInstance().getRole() == LiveState.ANCHOR) {
                    text = LiveState.getInstance().getLiveVideoInfo().getRtmpServer()[0];
                }else {
                    text = LiveState.getInstance().getWatchRtmpServer()[0];
                }
                text += "\n udp:"+LiveState.getInstance().getLiveVideoInfo().getUdpServer()[0]
                        + "\n roomId:" + LiveState.getInstance().getChatRoomId();
            } catch (Exception e) {
                e.printStackTrace();
            }
            roomIdTextView.setText(text);
        } else {
            //roomIdTextView.setVisibility(View.GONE);
        }
        getChatRoomAudiences();
    }

    private void init() {
        startService(new Intent(this, MessageService.class));

        Intent intent = getIntent();
        role = intent.getIntExtra(ExtraInfo.LIVE_SHOW_ROLE, LiveState.NO_SET);
        orientation = intent.getIntExtra(ExtraInfo.LIVE_ORIENTATION, LiveState.VERTICAL) ;
        String roomId = intent.getStringExtra(ExtraInfo.LIVE_SHOW_ROOM_ID);
        LiveState state = LiveState.getInstance() ;
        state.setRole(role);
        state.setOrientation(orientation) ;
        if(roomId != null) state.setChatRoomId(roomId);

        liveVideoActions = LiveVideoActions.getInstance(this) ;
        callService = CallService.getInstance() ;
        voipAndroidManager = VoipAndroidManager.getInstance_(this) ;
        eventSender = EventSender.getInstance_() ;
        config = ConfigHandler.getInstance_(this) ;

        eventSender.register(this);

        cancelInputAction = getString(R.string.handwin_cancel);
        sendMessageAction = getString(R.string.handwin_send);
        microConnectText = getString(R.string.handwin_font_img_micro_connect);
        microDisconnectText = getString(R.string.handwin_font_img_micro_disconnect);

        bmpHeartAnimSize = getResources().getDimensionPixelSize(R.dimen.handwin_dimen_heart_anim_size);
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        bmpHeartAnim = BitmapFactory.decodeResource(getResources(),R.drawable.handwin_red_heart,options);
        float sample = (Math.max(options.outHeight,options.outWidth) / (float)bmpHeartAnimSize + 0.5f);
        if(sample <=1 ) sample = 2;
        options.inJustDecodeBounds = false;
        options.inSampleSize = (int) sample;
        bmpHeartAnim = BitmapFactory.decodeResource(getResources(),R.drawable.handwin_red_heart,options);

        Matrix m = new Matrix() ;
        m.postScale(bmpHeartAnimSize * 1f / options.outWidth,bmpHeartAnimSize*1f / options.outHeight) ;
        bmpHeartAnim = Bitmap.createBitmap(bmpHeartAnim,0,0,bmpHeartAnim.getWidth(),bmpHeartAnim.getHeight(),m,false) ;
    }

    /**
     * 接收到其他人发送的消息
     * @param event 包含消息的Event
     */
    @Subscribe(threadMode = ThreadMode.MAIN)
    public void receiveMessage(LivingMessageEvent event) {
        GenericMessage message = event.getMessage() ;
        Utils.debugFormat("LiveVideoActivity 接收到消息 %s",message.toString());
        String type = message.getType();
        switch (type) {
            case GenericMessage.TYPE_TEXT:
                handleReceiveTextMessage(message.getData()) ;
                break;
            case GenericMessage.TYPE_LIVE_PRAISE:
                handleReceivePraiseMessage(message.getData());
                break;
            case GenericMessage.TYPE_REQUEST_LINE:
                handleRequestLineMessage(message.getData());
                break;
            case GenericMessage.TYPE_RESPONSE_LINE:
                handleResponseLineMessage(message.getData());
                break;
            case GenericMessage.TYPE_LINE_HANGUP:
                handleLineHangupMessage(message.getData()) ;
                break;
            case GenericMessage.TYPE_ANCHOR_RESUME:
                handleAnchorResumeMessage(message.getData()) ;
                break;

        }

    }

    private void handleAnchorResumeMessage(String data) {
        int state = LiveState.getInstance().getState();
        if (state == LiveState.STATE_WATCHING || state == LiveState.STATE_REQUEST_LINE) {
            eventSender.sendLiveStartEvent();
        }
    }

    private void handleLineHangupMessage(String data) {
        LineHangupGenericMessage message = LineHangupGenericMessage.fromJson(data);
        callService.hangupOnLine(message.getUserId(), message.getInnerId(),message.getStopLinkUserId() ) ;
    }

    /**
     * 主播确认的连麦信息,观众检查身份
     * @param data
     */
    private void handleResponseLineMessage(String data) {
        if(LiveState.getInstance().getRole() == LiveState.ANCHOR) return;
        LineResponseGenericMessage message = LineResponseGenericMessage.fromJson(data);
        if(message.getUserId().equals(config.getUid())) {
            int result = message.getResult();
            switch (result) {
                case LineResponseGenericMessage.ACCEPT:
                    ToastUtils.getInstance_(this).toast("主播同意连麦!");
                    doOnAcceptLineRequest(message) ;
                    return;
                case LineResponseGenericMessage.UP_LIMIT:
                    ToastUtils.getInstance_(this).toast("连麦人数达到上限!");
                    doOnRejectLineRequest(message) ;
                    return;
                case LineResponseGenericMessage.NETWORK_FAIL:
                    ToastUtils.getInstance_(this).toast("主播同意连麦失败!");
                    doOnRejectLineRequest(message) ;
                    return;
                case LineResponseGenericMessage.ERROR:
                    ToastUtils.getInstance_(this).toast("发生异常请重试!");
                    doOnRejectLineRequest(message) ;
                    return;
                case LineResponseGenericMessage.REJECT:
                    ToastUtils.getInstance_(this).toast("主播拒绝与你连麦!");
                    doOnRejectLineRequest(message) ;
                    return;
                default:
                    Utils.debugFormat("CallService not know message result type");
                    doOnRejectLineRequest(message) ;
                    return;
            }
        }
    }

    private void doOnRejectLineRequest(LineResponseGenericMessage message) {
        callService.rejectLineMicroRequest();
    }

    private void doOnAcceptLineRequest(LineResponseGenericMessage message) {
        microOnOffBtn.setVisibility(View.VISIBLE);
        cameraRotateBtn.setVisibility(View.VISIBLE);
        initMuteOnOffBtn() ;
        LiveVideoInfo liveVideoInfo = message.getLiveVideoInfo();
        LiveState.getInstance().setLiveVideoInfo(liveVideoInfo);
        LiveState.getInstance().setAnchorId(message.getAnchorId());
        eventSender.sendLineVideoStartEvent();
        callService.startLineVideo(liveVideoInfo);
    }

    private void initMuteOnOffBtn() {
        microOnOffBtn.setSelected(true);
        microOnOffBtn.setText(R.string.handwin_font_img_micro_off);
    }


    /**
     * 处理观众的连麦请求
     * @param data
     */
    private void handleRequestLineMessage(String data) {
        if(LiveState.getInstance().getRole() != LiveState.ANCHOR) return;
        RequestGuestGenericMessage message = RequestGuestGenericMessage.fromJson(data);
        DialogHandle.getInstance_().showNormalDialog(this, "连麦请求", message.getRequestNickname() + "请求和连麦,是否接受?", "确定", "取消", true, false, true, new DialogCallback() {
            @Override
            public void onOkClick() {
                //确认和该观众连麦
                callService.startLineMicro(LiveState.getInstance().getChatRoomId(),message.getRequestId());
            }

            @Override
            public void onCancelClick() {
                rejectLineRequest(message);
            }
        });
    }

    /**
     * 拒绝连麦
     */
    private void rejectLineRequest(RequestGuestGenericMessage message) {
        LineResponseGenericMessage lineResponseGenericMessage = new LineResponseGenericMessage();
        lineResponseGenericMessage.setResult(LineResponseGenericMessage.REJECT) ;
        lineResponseGenericMessage.setUserId(message.getRequestId());

        GenericMessage messageResponse = new GenericMessage();
        messageResponse.setType(GenericMessage.TYPE_RESPONSE_LINE);
        messageResponse.setData(lineResponseGenericMessage.toJson());

        BackgroundExecutor.execute(()->{
            liveVideoActions.sendMessage(messageResponse,LiveState.getInstance().getChatRoomId());
        }, BackgroundExecutor.ThreadType.NETWORK);
    }

    /**
     * 收到点赞消息的处理
     * @param data 点赞的消息内容
     */
    private void handleReceivePraiseMessage(String data) {
        PraiseGenericMessage praiseGenericMessage = JsonHandler.getInstance().fromJson(data,PraiseGenericMessage.class);
        if(praiseGenericMessage.getLevel() == 0) praiseGenericMessage.setLevel(9);
        updateMessageList(new LivingMessage(String.valueOf(praiseGenericMessage.getLevel()),"送出一个赞.",praiseGenericMessage.getPraiseUsername()));
        divergeViewPraiseAnim.startDiverges(0);
    }

    private void handleReceiveTextMessage(String data) {
        TextGenericMessage message = JsonHandler.getInstance().fromJson(data,TextGenericMessage.class) ;
        if(message.getLevel() == 0) message.setLevel(9);
        if (message.getMessage() == null) {return;}
        updateMessageList(new LivingMessage(String.valueOf(message.getLevel()),message.getMessage(),message.getName()));
    }

    /**
     * 发送消息成功与否的结果
     * @param event 包含发送消息结果的Event
     */
    @Subscribe(threadMode = ThreadMode.MAIN)
    public void handleSendMessageResponse(SendResponseEvent event) {
        if(event.getCode() == GenericMessage.RESPONSE_CODE_SUCCESS) {
            return;
        }else {
            String id = event.getId();
            LiveState state = LiveState.getInstance();
            GenericMessage message = state.removeMessageFromCache(id);
            String type = message.getType();
            Utils.debugFormat("LiveVideoActivity send message fail ,message id : %s, type:%s",id,type);
            switch (type) {
                case GenericMessage.TYPE_LIVE_PRAISE:
                    ToastUtils.getInstance_(LiveVideoActivity.this)
                            .toast("您送出的赞失败,请检查网络再为主播加油.");
                    break;
                case GenericMessage.TYPE_TEXT:
                    String data = message.getData();
                    TextGenericMessage msg = TextGenericMessage.fromJson(data) ;
                    ToastUtils.getInstance_(LiveVideoActivity.this)
                            .toast(String.format("您发送的%s失败,请检查网络.",msg.getMessage()));
                    break;
            }


        }
    }

    private void sendTextSuccess(String message) {
        Utils.debugFormat("LiveVideoActivity 发送消息成功: %s",message);
        updateMessageList(new LivingMessage(String.valueOf(config.getLiveLevel()),message,config.getNickname()));
        messageEditText.setText("");
    }

    /**
     * 更新消息列表
     * 消息列表最多只有100条数据,超过的删掉以前的数据
     * @param message 发送或者接收的消息
     */
    private void updateMessageList(LivingMessage message) {
        if(data.size() > 100) {
            data.remove(data.size()-1);
        }
        data.add(0,message);
        if(messageListAdapter == null) {
            messageListAdapter = new LivingMessageListAdapter(data,this);
            messageList.setAdapter(messageListAdapter);
        }else {
            messageListAdapter.notifyItemInserted(0);
            messageList.scrollToPosition(0);
        }
    }

    @Override
    protected void onDestroy() {
        eventSender.unregister(this);
        bmpHeartAnim.recycle();
        super.onDestroy();
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case KeyEvent.KEYCODE_BACK:
                closeLiveVideo();
                return true ;
        }
        return super.onKeyDown(keyCode, event);
    }

    @Subscribe(threadMode = ThreadMode.MAIN,priority = 1)
    public void handleLiveCloseEvent(CloseLiveVideoEvent event){
        Utils.debugFormat("CallService handleLiveCloseEvent event code : %d",event.getCode());
        UiThreadExecutor.cancelAll("close_live_video");
        String content = null;
        switch (event.getCode()) {
            case CloseLiveVideoEvent.CREATE_CHAT_ROOM_FAIL:
                content = "创建聊天室失败,请稍后重试!";
                break;
            case CloseLiveVideoEvent.CREATE_LIVE_ROOM_FAIL:
                content = "创建直播室失败,请稍后重试!";
                break;
            case CloseLiveVideoEvent.JOIN_CHAT_ROOM_FAIL:
                content = "加入聊天室失败,请稍后重试!";
                break;
        }
        if (content == null) {
            finish();
        }else {
            DialogHandle.getInstance_().showOkDialog(this, "操作不成功", content, "确定", false, new DialogCallback() {
                @Override
                public void onOkClick() {
                    LiveVideoActivity.this.finish();
                }

                @Override
                public void onCancelClick() {

                }
            });
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void handleLiveStopEvent(LiveStopEvent event) {
        Utils.debugFormat("CallService handleLiveStopEvent");
        ToastUtils.getInstance_(this).toast("直播停止!");
        microOnOffBtn.setVisibility(View.GONE);
        cameraRotateBtn.setVisibility(View.GONE);
        guestButton.setText(microDisconnectText);
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void handleLiveStartEvent(LiveStartEvent event){
        Utils.debugFormat("CallService handleLiveStartEvent");
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void handleNoLiveVideoEvent(NoLiveVideoEvent event){
        Utils.debugFormat("CallService handleNoLiveVideoEvent");
        ToastUtils.getInstance_(this).toast("没有直播内容");
    }


    @Subscribe(threadMode = ThreadMode.MAIN)
    public void handleJoinLiveResult(JoinLiveRoomResult result) {
        boolean success = result.isResult();
        int state = LiveState.getInstance().getState();
        Utils.debugFormat("CallService handleJoinLiveResult result:%s,state:%d",success,state);
        if (success) {
            ToastUtils.getInstance_(this).toast("加入直播成功!");
            if (BuildConfig.DEBUG) {
                String text = "";
                try {
                    if(LiveState.getInstance().getRole() == LiveState.ANCHOR) {
                        text = LiveState.getInstance().getLiveVideoInfo().getRtmpServer()[0];
                    }else {
                        text = LiveState.getInstance().getWatchRtmpServer()[0];
                    }
                    text += "\n roomId:" + LiveState.getInstance().getChatRoomId();
                } catch (Exception e) {
                    e.printStackTrace();
                }
                roomIdTextView.setText(text);
            }
            getChatRoomAudiences();
        } else {
            ToastUtils.getInstance_(this).toast("加入直播失败!");
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void handleLineVideoStart(LineVideoStartEvent event) {
        ToastUtils.getInstance_(this).toast("连麦直播完成!");
        guestButton.setText(microConnectText);
    }

    @Subscribe(priority = 1)
    public void handleDelayCloseLiveVideoEvent(DelayCloseLiveVideo event){
        UiThreadExecutor.runTask("close_live_video",()->{
            Utils.debugFormat("CallService handleDelayCloseLiveVideoEvent");
            finish();
            callService.resetLiveVideoState();
        },700);
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void handleMicroOvertime() {
        ToastUtils.getInstance_(this).toast("连麦已断开!");
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void handleTcpStatusEvent(TcpStatusEvent event) {
        tcpIsConnected = event.isConnect();
        switch (LiveState.getInstance().getState()) {
            case LiveState.STATE_JOIN:
                notifyTcpDisconnectMessage("加入失败","网络原因,加入直播失败,请稍后尝试!",true);
                break;
            case LiveState.STATE_CREATE:
                notifyTcpDisconnectMessage("创建失败","网络原因,创建直播失败,请稍后尝试!",true);
                break;
            case LiveState.STATE_LINING:
            case LiveState.STATE_LIVING:
            case LiveState.STATE_WATCHING:
                tipTextView.setVisibility(tcpIsConnected ? View.GONE : View.VISIBLE);
                break;
            case LiveState.STATE_REQUEST_LINE:
                callService.setState(callService.getWatchLivingHandler());
                notifyTcpDisconnectMessage("请求失败","网络原因,请求连麦失败,请稍后尝试!",false);
                break;
            default:
                if(tipTextView != null) {
                    tipTextView.setVisibility(tcpIsConnected ? View.GONE : View.VISIBLE);
                }
                break;
        }
    }

    private void notifyTcpDisconnectMessage(String title,String content,boolean needExit) {
        DialogHandle.getInstance_().showOkDialog(this, title , content, "好的", false, new DialogCallback() {
            @Override
            public void onOkClick() {
                if (needExit) closeLiveVideo();
            }

            @Override
            public void onCancelClick() {

            }
        });
    }

    @Override
    protected void onResume() {
        super.onResume();
        LocalBroadcastManager.getInstance(this).sendBroadcast(new Intent(BroadcastActions.LIVE_RESUME)) ;
    }

    @Override
    protected void onPause() {
        super.onPause();
        Utils.debugFormat("LiveVideoActivity onpause");
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void handleExitLineEvent(ExitLineEvent event) {
        microOnOffBtn.setVisibility(View.GONE);
        cameraRotateBtn.setVisibility(View.GONE);
        guestButton.setText(microDisconnectText);
    }

}
