package me.chatgame.uisdk.activity;

import android.app.Application;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.graphics.Rect;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.Gravity;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.Toast;

import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import java.util.ArrayList;
import java.util.List;

import me.chatgame.mobilecg.MessageService;
import me.chatgame.mobilecg.activity.PreviewActivity;
import me.chatgame.mobilecg.call.LiveState;
import me.chatgame.mobilecg.constant.ExtraInfo;
import me.chatgame.mobilecg.events.CloseLiveVideoEvent;
import me.chatgame.mobilecg.events.DelayCloseLiveVideo;
import me.chatgame.mobilecg.events.ExitWatchLivingEvent;
import me.chatgame.mobilecg.events.JoinLiveRoomResult;
import me.chatgame.mobilecg.events.LinePlayerChangeEvent;
import me.chatgame.mobilecg.events.LineVideoStartEvent;
import me.chatgame.mobilecg.events.LiveStartEvent;
import me.chatgame.mobilecg.events.LiveStopEvent;
import me.chatgame.mobilecg.handler.EventSender;
import me.chatgame.mobilecg.handler.VoipAndroidManager;
import me.chatgame.mobilecg.handler.interfaces.IEventSender;
import me.chatgame.mobilecg.handler.interfaces.IVoipAndroidManager;
import me.chatgame.mobilecg.sdk.CGSDKClient;
import me.chatgame.mobilecg.util.UiThreadExecutor;
import me.chatgame.mobilecg.util.Utils;
import me.chatgame.mobilecg.views.IconFontTextView;
import me.chatgame.uisdk.R;
import me.chatgame.uisdk.activity.helper.LiveVideoHelper;
import me.chatgame.uisdk.activity.view.LiveVideoPreviewContainerView;
import me.chatgame.voip.VoipAndroid;
import me.chatgame.voip.VoipImage;

public class BackLiveVideoActivity extends PreviewActivity {

    int role;
    String roomId;
    int orientation ;
    boolean first = true;
    boolean startVideo = false ;

    List<View> closeLineBtn = new ArrayList<>() ;


    IEventSender eventSender ;
    IVoipAndroidManager voipAndroidManager ;

    //GLViews
    LiveVideoPreviewContainerView liveVideoPreview ;
    FrameLayout frameLayout ;


    VoipAndroid.VideoMsgPlayerCallback callback = new VoipAndroid.VideoMsgPlayerCallback() {
        @Override
        public void videoMsgPlayerNotify(String fileName, int code) {
            Utils.debugFormat("CallService videoMsgPlayerNotify fileName :%s code : %d",fileName,code);
            resetVoipPlayVideo(fileName);
            eventSender.sendNoLiveVideoEvent(fileName,code) ;
        }

        @Override
        public void videoMsgDecodedImage(VoipImage image) {
            if (first) {
                Utils.debugFormat("CallService videoMsgDecodedImage image is null : %s",image == null);
                first = false ;
            }
            liveVideoPreview.render(image,false);
        }
    } ;

    public static void start(Context context ,int role ,String chatRoomId,int orientation) {
        Intent starter = new Intent(context, BackLiveVideoActivity.class);
        starter.putExtra(ExtraInfo.LIVE_SHOW_ROLE, role) ;
        starter.putExtra(ExtraInfo.LIVE_SHOW_ROOM_ID,chatRoomId);
        starter.putExtra(ExtraInfo.LIVE_ORIENTATION,orientation) ;
        if (context instanceof Application) {
            starter.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK) ;
        }
        context.startActivity(starter);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        init();
        super.onCreate(savedInstanceState);
        setContentView(R.layout.handwin_activity_back_live_video);
        initViews();
        afterViews();
    }

    private void init() {
        Intent intent1 = new Intent(this, MessageService.class);
        startService(intent1);

        Intent intent = getIntent();
        role = intent.getIntExtra(ExtraInfo.LIVE_SHOW_ROLE, LiveState.NO_SET);
        roomId = intent.getStringExtra(ExtraInfo.LIVE_SHOW_ROOM_ID);
        orientation = intent.getIntExtra(ExtraInfo.LIVE_ORIENTATION, LiveState.VERTICAL) ;

        LiveState.getInstance().setRole(role);
        if (roomId != null) LiveState.getInstance().setChatRoomId(roomId);

        voipAndroidManager = VoipAndroidManager.getInstance_(this) ;

        eventSender = EventSender.getInstance_() ;
        eventSender.register(this);
    }

    private void afterViews() {
        setDefaultStatusBarColor();
        liveVideoPreview.showSurfaceView();

        LiveVideoActivity.start(this,role,roomId,orientation);
    }

    private void initViews() {
        liveVideoPreview = (LiveVideoPreviewContainerView) findViewById(R.id.live_video_container);
        frameLayout = (FrameLayout) findViewById(R.id.fl_container) ;

        initCloseLineBtns();
    }

    @Override
    protected void onDestroy() {
        liveVideoPreview.stopLive();
        liveVideoPreview.destroy();
        eventSender.unregister(this);
        super.onDestroy();
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void handleLiveCloseEvent(CloseLiveVideoEvent event){
        finish();
    }



    @Subscribe(threadMode = ThreadMode.MAIN)
    public void handleJoinLiveResult(JoinLiveRoomResult result) {
        boolean success = result.isResult();
        if (success) {
            String[] rtmpServer = LiveState.getInstance().getWatchRtmpServer();
            if (rtmpServer != null && rtmpServer.length > 0) {
                String url = rtmpServer[0] ;
                startPlayLiveVideo(url);
            } else {
                Toast.makeText(this,"该房间直播无法观看,你可以留在这里聊天.",Toast.LENGTH_LONG).show();
                //eventSender.sendJoinLiveRoomResult(false);
            }
        }
    }


    @Subscribe(threadMode = ThreadMode.MAIN)
    public void handleExitWatchLiving(ExitWatchLivingEvent event){
        String rtmpUrl = event.getRtmpUrl();
        if (!TextUtils.isEmpty(rtmpUrl)) {
            resetVoipPlayVideo(rtmpUrl);
        }
    }

    @Override
    protected void onRestart() {
        super.onRestart();
        LiveState liveState = LiveState.getInstance();
        int role = liveState.getRole();
        switch (role) {
            case LiveState.ANCHOR:
                doAnchorRestart();
                break;

        }
    }

    private void doAnchorRestart() {
        Log.d(BackLiveVideoActivity.class.getSimpleName(), "doAnchorRestart: ");
        LiveState liveState = LiveState.getInstance();
        int state = liveState.getState();
        if (state == LiveState.STATE_LIVING) {
            liveVideoPreview.startLive();
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void handleLiveStopEvent(LiveStopEvent event) {
        String[] rtmpServer = LiveState.getInstance().getWatchRtmpServer();
        if (rtmpServer.length>0) {
            resetVoipPlayVideo(rtmpServer[0]);
            Utils.debugFormat("CallService handleLiveStopEvent stop live rtmpserver is %s",rtmpServer[0]);
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void handleLiveStartEvent(LiveStartEvent event) {
        String[] rtmpServer = LiveState.getInstance().getWatchRtmpServer();
        if (rtmpServer.length>0) {
            startPlayLiveVideo(rtmpServer[0]) ;
            Utils.debugFormat("CallService handleLiveStartEvent start live rtmpserver is %s",rtmpServer[0]);
        }
    }


    /**
     * 连麦请求完成的处理
     * 停止观看时的rtmpserver,即停止接收之前的视频数据
     */
    @Subscribe
    public void handleLineVideoStart(LineVideoStartEvent event) {
        String[] rtmpServer = LiveState.getInstance().getWatchRtmpServer();
        if(rtmpServer != null && rtmpServer.length>0) {
            Utils.debugFormat("CallService BackLiveVideoActivity stop pre live");
            liveVideoPreview.startLive();
            resetVoipPlayVideo(rtmpServer[0]);
        }
    }

    @Subscribe
    public void handleDelayCloseLiveVideoEvent(DelayCloseLiveVideo event){
        UiThreadExecutor.runTask("close_live_video",this::finish,500);
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void handleLinePlayerChangeEvent(LinePlayerChangeEvent event){
        liveVideoPreview.linePlayerChanged(LiveState.getInstance().getLinePlayers()) ;
        showCloseLineBtns() ;
    }

    private void showCloseLineBtns() {
        hideAllCloseLineBtns() ;
        int size = LiveState.getInstance().getLinePlayers().size();
        for (int i = 0; i < size; i++) {
            closeLineBtn.get(i).setVisibility(View.VISIBLE);
        }
    }

    private void hideAllCloseLineBtns() {
        for (View view : closeLineBtn) {
            view.setVisibility(View.GONE);
        }
    }

    public void startPlayLiveVideo(String rtmpServer){
        resetVoipPlayVideo(rtmpServer) ;
        startVideo = true ;
        voipAndroidManager.startLiveVideo(rtmpServer,callback) ;
    }

    public void resetVoipPlayVideo(String rtmpServer){
        liveVideoPreview.resetOpenGLViews();
        if ( startVideo ) {
            voipAndroidManager.stopLiveVideo(rtmpServer,callback) ;
            startVideo = false ;
        } else {
            return;
        }
    }

    private void initCloseLineBtns() {
        for (int i = 0; i < LiveVideoHelper.MAX_LINE; i++) {
            IconFontTextView iconFontTextView = new IconFontTextView(this) ;

            Rect rect = LiveVideoHelper.getLineCloseBtnRect(i, config.getScreenWidth(), config.getScreenHeight());

            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(rect.width(),rect.height()) ;
            params.topMargin = rect.top ;
            params.leftMargin = rect.left ;

            iconFontTextView.setGravity(Gravity.CENTER);
            iconFontTextView.setLayoutParams(params);
            iconFontTextView.setText(R.string.handwin_font_img_cross);
            iconFontTextView.setTextColor(getResources().getColor(R.color.handwin_bg_white));
            iconFontTextView.setTextSize(rect.width()/6);
            iconFontTextView.setVisibility(View.GONE);

            closeLineBtn.add(iconFontTextView) ;
            frameLayout.addView(iconFontTextView);
        }
    }



}
