package me.chatgame.uisdk;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;

import me.chatgame.mobilecg.constant.Constant;
import me.chatgame.mobilecg.constant.ExtraInfo;
import me.chatgame.mobilecg.sdk.UILogicHandler;
import me.chatgame.uisdk.activity.MainActivity;

/**
 * Created by star on 16/7/25.
 */
public class DefaultUILogicHandler implements UILogicHandler {

    protected Context context;
    public DefaultUILogicHandler(Context context) {
        this.context = context;
    }

    @Override
    public void showSingleChatPage(String contactV5Id) {
        Intent intent = new Intent(context, MainActivity.class);
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.putExtra(ExtraInfo.FROM, contactV5Id);
        intent.putExtra(ExtraInfo.CHAT_TYPE, Constant.CHATTYPE_SINGLE);
        context.startActivity(intent);
    }

    @Override
    public void showGroupChatPage(String groupV5Id) {
        Intent intent = new Intent(context, MainActivity.class);
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.putExtra(ExtraInfo.FROM, groupV5Id);
        intent.putExtra(ExtraInfo.CHAT_TYPE, Constant.CHATTYPE_GROUP);
        context.startActivity(intent);
    }

    @Override
    public void showVideoCallingPage(String contactV5Id) {
        Intent intent = new Intent(context, MainActivity.class);
        intent.putExtra(ExtraInfo.FROM, contactV5Id);
        intent.putExtra(ExtraInfo.COME_FROM, MainActivity.COME_FROM_CALL);
        intent.setFlags(Intent.FLAG_ACTIVITY_BROUGHT_TO_FRONT
                | Intent.FLAG_ACTIVITY_NEW_TASK);
        context.startActivity(intent);
    }

    @Override
    public void showVideoIncomingPage(boolean reconnect) {
        Intent intent = new Intent(context, MainActivity.class);
        intent.putExtra(ExtraInfo.NEED_RECONNECT, reconnect);
        intent.setFlags(Intent.FLAG_ACTIVITY_BROUGHT_TO_FRONT
                | Intent.FLAG_ACTIVITY_NEW_TASK);
        context.startActivity(intent);
    }

    @Override
    public void showVideoLivingPage(boolean clickFloatVideo) {
        Intent intent = new Intent(context, MainActivity.class);
        intent.setFlags(Intent.FLAG_ACTIVITY_BROUGHT_TO_FRONT
                | Intent.FLAG_ACTIVITY_NEW_TASK);
        intent.putExtra(ExtraInfo.CLICK_FLOAT_VIDEO,clickFloatVideo);
        context.startActivity(intent);
    }

    @Override
    public Class<? extends Activity> getActivityForChat() {
        return MainActivity.class;
    }
}
