package me.chatgame.uisdk;

import android.content.Context;
import android.content.Intent;

import me.chatgame.mobilecg.call.LiveState;
import me.chatgame.mobilecg.constant.ExtraInfo;
import me.chatgame.mobilecg.sdk.LiveShowUILogicHandler;
import me.chatgame.uisdk.activity.BackLiveVideoActivity;

/**
 * Created by rth on 16/8/9.
 */
public class DefaultLiveShowUILogicHandler implements LiveShowUILogicHandler {

    private Context context ;

    public DefaultLiveShowUILogicHandler(Context context) {
        this.context = context;
    }

    @Override
    public void startLiveShow(String chatRoomId,int orientation) {
        BackLiveVideoActivity.start(context,LiveState.ANCHOR,chatRoomId,orientation);
    }

    @Override
    public void playLiveShow(String chatRoomId){
        Intent intent = new Intent(context,BackLiveVideoActivity.class);
        intent.putExtra(ExtraInfo.LIVE_SHOW_ROLE, LiveState.AUDIENCE);
        intent.putExtra(ExtraInfo.LIVE_SHOW_ROOM_ID,chatRoomId);
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        context.startActivity(intent);
    }
}
