package me.chatgame.uisdk;

import android.content.Context;

import me.chatgame.mobilecg.sdk.CGSDKClient;
import me.chatgame.mobilecg.sdk.CGSDKClientImpl;
import me.chatgame.mobilecg.sdk.ChatViewHolderHandler;
import me.chatgame.mobilecg.sdk.EmoticonHandler;
import me.chatgame.mobilecg.sdk.FileUploadHandler;
import me.chatgame.mobilecg.sdk.LiveShowUILogicHandler;
import me.chatgame.mobilecg.sdk.FunctionMenuHandler;
import me.chatgame.mobilecg.sdk.UILogicHandler;
import me.chatgame.mobilecg.sdk.defaults.DefaultFileUploadHandler;

/**
 * Created by star on 16/7/25.
 */
public class CGSDKClientCreator {

    private Context context;
    private UILogicHandler uiLogicHandler;
    private LiveShowUILogicHandler liveShowUILogicHandler ;
    private FileUploadHandler fileUploadHandler;
    private FunctionMenuHandler functionMenuHandler;
    private ChatViewHolderHandler chatViewHolderHandler;
    private EmoticonHandler emoticonHandler;

    private String xiaomiAppId;
    private String xiaomiAppKey;

    private String pushConfigName;

    public CGSDKClientCreator(Context context) {
        this.context = context.getApplicationContext();
    }

//    /**
//     * Configure customized UILogicHandler
//     * @param handler
//     * @return creator
//     */
//    public CGSDKClientCreator configUILogicHandler(UILogicHandler handler) {
//        uiLogicHandler = handler;
//        return this;
//    }

    /**
     * Configure customized FileUploadHandler
     * @param handler
     * @return creator
     */
    public CGSDKClientCreator configFileUploadHandler(FileUploadHandler handler) {
        fileUploadHandler = handler;
        return this;
    }

    /**
     * you can config N push configs in admin's console, you can choose to use which one in App.
     * @param pushConfigName
     * @return
     */
    public CGSDKClientCreator configPushConfigName(String pushConfigName){
        this.pushConfigName = pushConfigName;
        return this;
    }
    public CGSDKClientCreator configFunctionMenuHandler(FunctionMenuHandler handler) {
        functionMenuHandler = handler;
        return this;
    }

    public CGSDKClientCreator configChatViewHolderHandler(ChatViewHolderHandler handler) {
        chatViewHolderHandler = handler;
        return this;
    }

    public CGSDKClientCreator configEmoticonHandler(EmoticonHandler handler) {
        emoticonHandler = handler;
        return this;
    }

    /**
     * Configure xiaomi app id and app key
     * @param xiaomiAppId
     * @param xiaomiAppKey
     * @return creator
     */
    public CGSDKClientCreator configXiaomiPush(String xiaomiAppId, String xiaomiAppKey) {
        this.xiaomiAppId = xiaomiAppId;
        this.xiaomiAppKey = xiaomiAppKey;
        return this;
    }

    /**
     * Get CGSDKClient instance
     * @return CGSDKClient instance
     */
    public CGSDKClient create() {
        CGSDKClient client = CGSDKClientImpl.getInstance();
        client.setUiLogicHandler(uiLogicHandler != null ? uiLogicHandler : new DefaultUILogicHandler(context));
        client.setFileUploadHandler(fileUploadHandler != null ? fileUploadHandler : new DefaultFileUploadHandler());
        client.setLiveShowUILogicHandler(liveShowUILogicHandler != null ? liveShowUILogicHandler : new DefaultLiveShowUILogicHandler(context));
        client.setFunctionMenuHandler(functionMenuHandler);
        client.setChatViewHolderHandler(chatViewHolderHandler);
        client.setEmoticonHandler(emoticonHandler);
        client.setPushConfigName(pushConfigName);
        client.configXiaomiPush(xiaomiAppId, xiaomiAppKey);
        return client;
    }
}
