/*
 * Decompiled with CFR 0.152.
 */
package me.bo0tzz.opennotify4j.requests.framework;

import com.google.gson.Gson;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import me.bo0tzz.opennotify4j.requests.framework.ISSRequest;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public abstract class AbstractISSRequest<T>
implements ISSRequest<T> {
    public static String API_URL = "http://api.open-notify.org/";
    protected static final Gson GSON = new Gson();
    private static final OkHttpClient client = new OkHttpClient();
    private static final ExecutorService executorService = Executors.newCachedThreadPool();
    protected final String endpoint;
    protected final Consumer<T> callback;
    protected final Class<T> callbackType;

    protected Request getRequest() {
        return new Request.Builder().url(API_URL + this.endpoint).build();
    }

    protected String getBody(Response response) throws IOException {
        return response == null ? null : response.body().string();
    }

    @Override
    public String getEndpoint() {
        return this.endpoint;
    }

    protected void handleResponse(Response response) throws IOException {
        String body = this.getBody(response);
        if (body != null && this.callback != null) {
            this.callback.accept(GSON.fromJson(body, this.callbackType));
        }
    }

    @Override
    public void perform() {
        executorService.submit(() -> {
            try {
                Response response = client.newCall(this.getRequest()).execute();
                this.handleResponse(response);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    @ConstructorProperties(value={"endpoint", "callback", "callbackType"})
    protected AbstractISSRequest(String endpoint, Consumer<T> callback, Class<T> callbackType) {
        this.endpoint = endpoint;
        this.callback = callback;
        this.callbackType = callbackType;
    }
}

