/*
 * Decompiled with CFR 0.152.
 */
package me.bo0tzz.opennotify4j.bean;

import lombok.NonNull;

public class Location {
    private final Float latitude;
    private final Float longitude;

    protected Location(@NonNull Float latitude, @NonNull Float longitude) {
        if (latitude == null) {
            throw new NullPointerException("latitude");
        }
        if (longitude == null) {
            throw new NullPointerException("longitude");
        }
        if (latitude.floatValue() < -90.0f || latitude.floatValue() > 90.0f) {
            throw new IllegalArgumentException("Latitude must be between -90.0 and +90.0!");
        }
        if (longitude.floatValue() < -180.0f || longitude.floatValue() > 180.0f) {
            throw new IllegalArgumentException("Longitude must be between -90.0 and +90.0!");
        }
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public static LocationBuilder builder() {
        return new LocationBuilder();
    }

    public Float getLatitude() {
        return this.latitude;
    }

    public Float getLongitude() {
        return this.longitude;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Location)) {
            return false;
        }
        Location other = (Location)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Float this$latitude = this.getLatitude();
        Float other$latitude = other.getLatitude();
        if (this$latitude == null ? other$latitude != null : !((Object)this$latitude).equals(other$latitude)) {
            return false;
        }
        Float this$longitude = this.getLongitude();
        Float other$longitude = other.getLongitude();
        return !(this$longitude == null ? other$longitude != null : !((Object)this$longitude).equals(other$longitude));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Location;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Float $latitude = this.getLatitude();
        result = result * 59 + ($latitude == null ? 43 : ((Object)$latitude).hashCode());
        Float $longitude = this.getLongitude();
        result = result * 59 + ($longitude == null ? 43 : ((Object)$longitude).hashCode());
        return result;
    }

    public String toString() {
        return "Location(latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ")";
    }

    public static class LocationBuilder {
        private Float latitude;
        private Float longitude;

        LocationBuilder() {
        }

        public LocationBuilder latitude(Float latitude) {
            this.latitude = latitude;
            return this;
        }

        public LocationBuilder longitude(Float longitude) {
            this.longitude = longitude;
            return this;
        }

        public Location build() {
            return new Location(this.latitude, this.longitude);
        }

        public String toString() {
            return "Location.LocationBuilder(latitude=" + this.latitude + ", longitude=" + this.longitude + ")";
        }
    }
}

