/*
 * Decompiled with CFR 0.152.
 */
package me.bo0tzz.opennotify4j.api;

import com.google.gson.annotations.SerializedName;
import me.bo0tzz.opennotify4j.api.ISSEvent;
import me.bo0tzz.opennotify4j.bean.Location;

public class ISSLocation
extends ISSEvent {
    private final long timestamp;
    @SerializedName(value="iss_position")
    private final Location location;

    private ISSLocation(String message, long timestamp, Location location) {
        super(message);
        this.timestamp = timestamp;
        this.location = location;
    }

    public static ISSLocationBuilder builder() {
        return new ISSLocationBuilder();
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Location getLocation() {
        return this.location;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ISSLocation)) {
            return false;
        }
        ISSLocation other = (ISSLocation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        Location this$location = this.getLocation();
        Location other$location = other.getLocation();
        return !(this$location == null ? other$location != null : !((Object)this$location).equals(other$location));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ISSLocation;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        Location $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ISSLocation(timestamp=" + this.getTimestamp() + ", location=" + this.getLocation() + ")";
    }

    public static class ISSLocationBuilder {
        private String message;
        private long timestamp;
        private Location location;

        ISSLocationBuilder() {
        }

        public ISSLocationBuilder message(String message) {
            this.message = message;
            return this;
        }

        public ISSLocationBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public ISSLocationBuilder location(Location location) {
            this.location = location;
            return this;
        }

        public ISSLocation build() {
            return new ISSLocation(this.message, this.timestamp, this.location);
        }

        public String toString() {
            return "ISSLocation.ISSLocationBuilder(message=" + this.message + ", timestamp=" + this.timestamp + ", location=" + this.location + ")";
        }
    }
}

