/*
 * Decompiled with CFR 0.152.
 */
package me.bo0tzz.opennotify4j.requests;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import me.bo0tzz.opennotify4j.api.ISSPass;
import me.bo0tzz.opennotify4j.bean.Location;
import me.bo0tzz.opennotify4j.requests.framework.GetISSRequest;

public class ISSPassRequest
extends GetISSRequest<ISSPass> {
    private ISSPassRequest(Consumer<ISSPass> callback, Map<String, String> queryParams) {
        super("iss-pass.json", callback, ISSPass.class, queryParams);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Map<String, String> queryParams = new HashMap<String, String>();
        private Consumer<ISSPass> callback;

        private Builder() {
        }

        public Builder callback(Consumer<ISSPass> callback) {
            this.callback = callback;
            return this;
        }

        public Builder location(Location location) {
            return this.latitude(location.getLatitude()).longitude(location.getLongitude());
        }

        public Builder latitude(Float latitude) {
            if (latitude.floatValue() < -90.0f || latitude.floatValue() > 90.0f) {
                throw new IllegalArgumentException("Latitude must be between -90.0 and +90.0!");
            }
            this.queryParams.put("lat", latitude.toString());
            return this;
        }

        public Builder longitude(Float longitude) {
            if (longitude.floatValue() < -180.0f || longitude.floatValue() > 180.0f) {
                throw new IllegalArgumentException("Longitude must be between -90.0 and +90.0!");
            }
            this.queryParams.put("lon", longitude.toString());
            return this;
        }

        public Builder altitude(Float altitude) {
            if (altitude.floatValue() < 0.0f || altitude.floatValue() > 10000.0f) {
                throw new IllegalArgumentException("Altitude must be between 0.0 and 10000.0!");
            }
            this.queryParams.put("alt", altitude.toString());
            return this;
        }

        public Builder count(Integer count) {
            this.queryParams.put("n", count.toString());
            return this;
        }

        public ISSPassRequest build() {
            if (!this.queryParams.containsKey("lat")) {
                throw new NullPointerException("Latitude cannot be null!");
            }
            if (!this.queryParams.containsKey("lon")) {
                throw new NullPointerException("Longitude cannot be null!");
            }
            return new ISSPassRequest(this.callback, this.queryParams);
        }
    }
}

