/*
 * Decompiled with CFR 0.152.
 */
package me.alidg.errors.handlers;

import java.util.ArrayList;
import java.util.Collections;
import me.alidg.errors.Argument;
import me.alidg.errors.HandledException;
import me.alidg.errors.WebErrorHandler;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.MissingMatrixVariableException;
import org.springframework.web.bind.MissingRequestCookieException;
import org.springframework.web.bind.MissingRequestHeaderException;

public class MissingRequestParametersWebErrorHandler
implements WebErrorHandler {
    public static final String MISSING_HEADER = "web.missing_header";
    public static final String MISSING_COOKIE = "web.missing_cookie";
    public static final String MISSING_MATRIX_VARIABLE = "web.missing_matrix_variable";

    @Override
    public boolean canHandle(Throwable exception) {
        return exception instanceof MissingRequestHeaderException || exception instanceof MissingRequestCookieException || exception instanceof MissingMatrixVariableException;
    }

    @Override
    @NonNull
    public HandledException handle(Throwable exception) {
        ArrayList<Argument> arguments = new ArrayList<Argument>();
        String errorCode = "unknown_error";
        if (exception instanceof MissingRequestHeaderException) {
            MissingRequestHeaderException headerException = (MissingRequestHeaderException)exception;
            arguments.add(Argument.arg("name", headerException.getHeaderName()));
            arguments.add(Argument.arg("expected", this.getType(headerException.getParameter())));
            errorCode = MISSING_HEADER;
        } else if (exception instanceof MissingRequestCookieException) {
            MissingRequestCookieException cookieException = (MissingRequestCookieException)exception;
            arguments.add(Argument.arg("name", cookieException.getCookieName()));
            arguments.add(Argument.arg("expected", this.getType(cookieException.getParameter())));
            errorCode = MISSING_COOKIE;
        } else if (exception instanceof MissingMatrixVariableException) {
            MissingMatrixVariableException variableException = (MissingMatrixVariableException)exception;
            arguments.add(Argument.arg("name", variableException.getVariableName()));
            arguments.add(Argument.arg("expected", this.getType(variableException.getParameter())));
            errorCode = MISSING_MATRIX_VARIABLE;
        }
        return new HandledException(errorCode, HttpStatus.BAD_REQUEST, Collections.singletonMap(errorCode, arguments));
    }

    private String getType(MethodParameter parameter) {
        if (parameter == null) {
            return null;
        }
        return parameter.getParameterType().getSimpleName();
    }
}

