/*
 * Decompiled with CFR 0.152.
 */
package me.alidg.errors.handlers;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import me.alidg.errors.Argument;
import me.alidg.errors.HandledException;
import me.alidg.errors.WebErrorHandler;
import me.alidg.errors.handlers.ConstraintViolationArgumentsExtractor;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;

public class ConstraintViolationWebErrorHandler
implements WebErrorHandler {
    @Override
    public boolean canHandle(Throwable exception) {
        return exception instanceof ConstraintViolationException && this.hasAtLeastOneViolation(exception);
    }

    @Override
    @NonNull
    public HandledException handle(Throwable exception) {
        ConstraintViolationException violationException = (ConstraintViolationException)exception;
        Set<String> errorCodes = this.extractErrorCodes(violationException);
        Map<String, List<Argument>> arguments = this.extractArguments(violationException);
        return new HandledException(errorCodes, HttpStatus.BAD_REQUEST, arguments);
    }

    private boolean hasAtLeastOneViolation(Throwable exception) {
        Set violations = ((ConstraintViolationException)exception).getConstraintViolations();
        return violations != null && !violations.isEmpty();
    }

    private Map<String, List<Argument>> extractArguments(ConstraintViolationException violationException) {
        Map<String, List<Argument>> args = violationException.getConstraintViolations().stream().collect(Collectors.toMap(this::errorCode, ConstraintViolationArgumentsExtractor::extract, (v1, v2) -> v1));
        args.entrySet().removeIf(e -> ((List)e.getValue()).isEmpty());
        return args;
    }

    private Set<String> extractErrorCodes(ConstraintViolationException violationException) {
        return violationException.getConstraintViolations().stream().map(this::errorCode).collect(Collectors.toSet());
    }

    private String errorCode(ConstraintViolation<?> violation) {
        return violation.getMessageTemplate().replace("{", "").replace("}", "");
    }
}

