/*
 * Decompiled with CFR 0.152.
 */
package me.alidg.errors.handlers;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.alidg.errors.Argument;
import me.alidg.errors.HandledException;
import me.alidg.errors.WebErrorHandler;
import me.alidg.errors.annotation.ExceptionMapping;
import me.alidg.errors.annotation.ExposeAsArg;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;

public class AnnotatedWebErrorHandler
implements WebErrorHandler {
    private final Comparator<AnnotatedElement> byExposedIndex = Comparator.comparing(e -> e.getAnnotation(ExposeAsArg.class).value());

    @Override
    public boolean canHandle(Throwable exception) {
        if (exception == null) {
            return false;
        }
        return exception.getClass().isAnnotationPresent(ExceptionMapping.class);
    }

    @Override
    @NonNull
    public HandledException handle(Throwable exception) {
        ExceptionMapping exceptionMapping = exception.getClass().getAnnotation(ExceptionMapping.class);
        String errorCode = exceptionMapping.errorCode();
        HttpStatus httpStatus = exceptionMapping.statusCode();
        List<Argument> arguments = this.getExposedValues(exception);
        return new HandledException(errorCode, httpStatus, Collections.singletonMap(errorCode, arguments));
    }

    private List<Argument> getExposedValues(Throwable exception) {
        ArrayList<AnnotatedElement> members = new ArrayList<AnnotatedElement>();
        members.addAll(this.getExposedFields(exception));
        members.addAll(this.getExposedMethods(exception));
        members.sort(this.byExposedIndex);
        return members.stream().map(e -> this.getArgument((AnnotatedElement)e, exception)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Argument getArgument(AnnotatedElement element, Throwable exception) {
        try {
            if (element instanceof Field) {
                Field f = (Field)element;
                f.setAccessible(true);
                return Argument.arg(this.getExposedName(f), f.get(exception));
            }
            if (element instanceof Method) {
                Method m = (Method)element;
                m.setAccessible(true);
                return Argument.arg(this.getExposedName(m), m.invoke((Object)exception, new Object[0]));
            }
        }
        catch (Exception exception2) {
            // empty catch block
        }
        return null;
    }

    private List<Field> getExposedFields(Throwable exception) {
        return Stream.of(exception.getClass().getDeclaredFields()).filter(f -> f.isAnnotationPresent(ExposeAsArg.class)).collect(Collectors.toList());
    }

    private List<Method> getExposedMethods(Throwable exception) {
        return Stream.of(exception.getClass().getMethods()).filter(m -> this.annotationIsPresent((Method)m) && this.hasReturnType((Method)m) && this.hasNoParameters((Method)m)).collect(Collectors.toList());
    }

    private <T extends AnnotatedElement & Member> String getExposedName(T member) {
        ExposeAsArg annotation = member.getAnnotation(ExposeAsArg.class);
        if (annotation != null && !annotation.name().trim().isEmpty()) {
            return annotation.name();
        }
        return ((Member)member).getName();
    }

    private boolean hasNoParameters(Method m) {
        return m.getParameterCount() == 0;
    }

    private boolean hasReturnType(Method m) {
        return m.getReturnType() != Void.TYPE;
    }

    private boolean annotationIsPresent(Method m) {
        return m.isAnnotationPresent(ExposeAsArg.class);
    }
}

