/*
 * Decompiled with CFR 0.152.
 */
package me.alidg.errors.conf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import me.alidg.errors.ExceptionLogger;
import me.alidg.errors.ExceptionRefiner;
import me.alidg.errors.FingerprintProvider;
import me.alidg.errors.WebErrorHandler;
import me.alidg.errors.WebErrorHandlerPostProcessor;
import me.alidg.errors.WebErrorHandlers;
import me.alidg.errors.WebErrorHandlersBuilder;
import me.alidg.errors.adapter.DefaultHttpErrorAttributesAdapter;
import me.alidg.errors.adapter.HttpErrorAttributesAdapter;
import me.alidg.errors.conf.ErrorsProperties;
import me.alidg.errors.fingerprint.UuidFingerprintProvider;
import me.alidg.errors.handlers.AnnotatedWebErrorHandler;
import me.alidg.errors.handlers.ConstraintViolationWebErrorHandler;
import me.alidg.errors.handlers.MissingRequestParametersWebErrorHandler;
import me.alidg.errors.handlers.ResponseStatusWebErrorHandler;
import me.alidg.errors.handlers.ServletWebErrorHandler;
import me.alidg.errors.handlers.SpringSecurityWebErrorHandler;
import me.alidg.errors.handlers.SpringValidationWebErrorHandler;
import me.alidg.errors.handlers.TypeMismatchWebErrorHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.web.context.WebApplicationContext;

@ConditionalOnWebApplication
@EnableConfigurationProperties(value={ErrorsProperties.class})
public class ErrorsAutoConfiguration {
    private static final List<WebErrorHandler> BUILT_IN_HANDLERS = Arrays.asList(new SpringValidationWebErrorHandler(), new ConstraintViolationWebErrorHandler(), new AnnotatedWebErrorHandler(), new TypeMismatchWebErrorHandler());

    @Bean
    @ConditionalOnMissingBean
    public WebErrorHandlers webErrorHandlers(MessageSource messageSource, @Autowired(required=false) List<WebErrorHandler> customHandlers, @Qualifier(value="defaultWebErrorHandler") @Autowired(required=false) WebErrorHandler defaultWebErrorHandler, ExceptionRefiner exceptionRefiner, ExceptionLogger exceptionLogger, @Autowired(required=false) List<WebErrorHandlerPostProcessor> webErrorHandlerPostProcessors, FingerprintProvider fingerprintProvider, ErrorsProperties errorsProperties, ApplicationContext context) {
        ArrayList<WebErrorHandler> handlers = new ArrayList<WebErrorHandler>(BUILT_IN_HANDLERS);
        if (this.isServletApplication(context)) {
            handlers.add(new ServletWebErrorHandler());
        }
        if (customHandlers != null && !customHandlers.isEmpty()) {
            customHandlers.remove(defaultWebErrorHandler);
            customHandlers.removeIf(Objects::isNull);
            customHandlers.sort((Comparator<WebErrorHandler>)AnnotationAwareOrderComparator.INSTANCE);
            handlers.addAll(customHandlers);
        }
        WebErrorHandlersBuilder builder = WebErrorHandlers.builder(messageSource).withErrorsProperties(errorsProperties).withErrorHandlers(handlers).withExceptionRefiner(exceptionRefiner).withExceptionLogger(exceptionLogger).withFingerprintProvider(fingerprintProvider);
        if (defaultWebErrorHandler != null) {
            builder.withDefaultWebErrorHandler(defaultWebErrorHandler);
        }
        if (webErrorHandlerPostProcessors != null) {
            builder.withPostProcessors(webErrorHandlerPostProcessors);
        }
        return builder.build();
    }

    @Bean
    @ConditionalOnBean(value={WebErrorHandlers.class})
    @ConditionalOnMissingBean(value={HttpErrorAttributesAdapter.class})
    public HttpErrorAttributesAdapter httpErrorAttributesAdapter(ErrorsProperties errorsProperties) {
        return new DefaultHttpErrorAttributesAdapter(errorsProperties);
    }

    @Bean
    @ConditionalOnBean(value={WebErrorHandlers.class})
    @ConditionalOnClass(name={"org.springframework.security.access.AccessDeniedException"})
    public SpringSecurityWebErrorHandler springSecurityWebErrorHandler() {
        return new SpringSecurityWebErrorHandler();
    }

    @Bean
    @ConditionalOnBean(value={WebErrorHandlers.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @ConditionalOnClass(name={"org.springframework.web.bind.MissingRequestHeaderException"})
    public MissingRequestParametersWebErrorHandler missingRequestParametersWebErrorHandler() {
        return new MissingRequestParametersWebErrorHandler();
    }

    @Bean
    @ConditionalOnBean(value={WebErrorHandlers.class})
    @ConditionalOnClass(name={"org.springframework.web.server.ResponseStatusException"})
    public ResponseStatusWebErrorHandler responseStatusWebErrorHandler() {
        return new ResponseStatusWebErrorHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={WebErrorHandlers.class})
    public ExceptionRefiner exceptionRefiner() {
        return ExceptionRefiner.NoOp.INSTANCE;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={WebErrorHandlers.class})
    public ExceptionLogger exceptionLogger() {
        return ExceptionLogger.NoOp.INSTANCE;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={WebErrorHandlers.class})
    public FingerprintProvider fingerprintProvider() {
        return new UuidFingerprintProvider();
    }

    private boolean isServletApplication(ApplicationContext context) {
        return context instanceof WebApplicationContext;
    }
}

