/*
 * Decompiled with CFR 0.152.
 */
package me.alidg.errors;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import me.alidg.errors.Argument;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class HandledException {
    private final Set<String> errorCodes;
    private final HttpStatus statusCode;
    private final Map<String, List<Argument>> arguments;

    public HandledException(@NonNull Set<String> errorCodes, @NonNull HttpStatus statusCode, @Nullable Map<String, List<Argument>> arguments) {
        this.enforcePreconditions(errorCodes, statusCode);
        this.errorCodes = errorCodes;
        this.statusCode = statusCode;
        this.arguments = arguments == null ? Collections.emptyMap() : arguments;
    }

    public HandledException(@NonNull String errorCode, @NonNull HttpStatus statusCode, @Nullable Map<String, List<Argument>> arguments) {
        this(Collections.singleton(errorCode), statusCode, arguments);
    }

    @NonNull
    public Set<String> getErrorCodes() {
        return this.errorCodes;
    }

    @NonNull
    public HttpStatus getStatusCode() {
        return this.statusCode;
    }

    @NonNull
    public Map<String, List<Argument>> getArguments() {
        return this.arguments;
    }

    private void enforcePreconditions(Set<String> errorCodes, HttpStatus statusCode) {
        Objects.requireNonNull(errorCodes, "Error codes is required");
        Objects.requireNonNull(statusCode, "Status code is required");
        if (errorCodes.isEmpty()) {
            throw new IllegalArgumentException("At least one error code should be provided");
        }
        if (errorCodes.size() == 1 && errorCodes.contains(null)) {
            throw new NullPointerException("The single error code can't be null");
        }
    }
}

