/*
 * Decompiled with CFR 0.152.
 */
package me.alidg.errors.handlers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import me.alidg.errors.HandledException;
import me.alidg.errors.WebErrorHandler;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.lang.NonNull;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.multipart.support.MissingServletRequestPartException;
import org.springframework.web.servlet.NoHandlerFoundException;

public class SpringMvcWebErrorHandler
implements WebErrorHandler {
    public static final String INVALID_OR_MISSING_BODY = "web.invalid_or_missing_body";
    public static final String NOT_ACCEPTABLE = "web.not_acceptable";
    public static final String NOT_SUPPORTED = "web.unsupported_media_type";
    public static final String METHOD_NOT_ALLOWED = "web.method_not_allowed";
    public static final String MISSING_PARAMETER = "web.missing_parameter";
    public static final String MISSING_PART = "web.missing_part";
    public static final String NO_HANDLER = "web.no_handler";

    @Override
    public boolean canHandle(Throwable exception) {
        return exception instanceof HttpMediaTypeNotAcceptableException || exception instanceof HttpMediaTypeNotSupportedException || exception instanceof HttpRequestMethodNotSupportedException || exception instanceof MissingServletRequestParameterException || exception instanceof MissingServletRequestPartException || exception instanceof NoHandlerFoundException || exception instanceof HttpMessageNotReadableException;
    }

    @Override
    @NonNull
    public HandledException handle(Throwable exception) {
        if (exception instanceof HttpMessageNotReadableException) {
            return new HandledException(INVALID_OR_MISSING_BODY, HttpStatus.BAD_REQUEST, null);
        }
        if (exception instanceof HttpMediaTypeNotAcceptableException) {
            List types = ((HttpMediaTypeNotAcceptableException)exception).getSupportedMediaTypes();
            return new HandledException(NOT_ACCEPTABLE, HttpStatus.NOT_ACCEPTABLE, Collections.singletonMap(NOT_ACCEPTABLE, types));
        }
        if (exception instanceof HttpMediaTypeNotSupportedException) {
            MediaType contentType = ((HttpMediaTypeNotSupportedException)exception).getContentType();
            return new HandledException(NOT_SUPPORTED, HttpStatus.UNSUPPORTED_MEDIA_TYPE, Collections.singletonMap(NOT_SUPPORTED, Collections.singletonList(contentType)));
        }
        if (exception instanceof HttpRequestMethodNotSupportedException) {
            String method = ((HttpRequestMethodNotSupportedException)exception).getMethod();
            return new HandledException(METHOD_NOT_ALLOWED, HttpStatus.METHOD_NOT_ALLOWED, Collections.singletonMap(METHOD_NOT_ALLOWED, Collections.singletonList(method)));
        }
        if (exception instanceof MissingServletRequestParameterException) {
            MissingServletRequestParameterException actualException = (MissingServletRequestParameterException)exception;
            String name = actualException.getParameterName();
            String type = actualException.getParameterType();
            return new HandledException(MISSING_PARAMETER, HttpStatus.BAD_REQUEST, Collections.singletonMap(MISSING_PARAMETER, Arrays.asList(name, type)));
        }
        if (exception instanceof MissingServletRequestPartException) {
            String name = ((MissingServletRequestPartException)exception).getRequestPartName();
            return new HandledException(MISSING_PART, HttpStatus.BAD_REQUEST, Collections.singletonMap(MISSING_PART, Collections.singletonList(name)));
        }
        if (exception instanceof NoHandlerFoundException) {
            String url = ((NoHandlerFoundException)exception).getRequestURL();
            return new HandledException(NO_HANDLER, HttpStatus.NOT_FOUND, Collections.singletonMap(NO_HANDLER, Collections.singletonList(url)));
        }
        return new HandledException("unknown_error", HttpStatus.INTERNAL_SERVER_ERROR, null);
    }
}

