/*
 * Decompiled with CFR 0.152.
 */
package me.alidg.errors.handlers;

import java.util.Collections;
import java.util.List;
import me.alidg.errors.HandledException;
import me.alidg.errors.WebErrorHandler;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;
import org.springframework.web.bind.MissingMatrixVariableException;
import org.springframework.web.bind.MissingRequestCookieException;
import org.springframework.web.bind.MissingRequestHeaderException;

public class MissingRequestParametersWebErrorHandler
implements WebErrorHandler {
    public static final String MISSING_HEADER = "web.missing_header";
    public static final String MISSING_COOKIE = "web.missing_cookie";
    public static final String MISSING_MATRIX_VARIABLE = "web.missing_matrix_variable";

    @Override
    public boolean canHandle(Throwable exception) {
        return exception instanceof MissingRequestHeaderException || exception instanceof MissingRequestCookieException || exception instanceof MissingMatrixVariableException;
    }

    @Override
    @NonNull
    public HandledException handle(Throwable exception) {
        List<String> arguments = null;
        String errorCode = "unknown_error";
        if (exception instanceof MissingRequestHeaderException) {
            arguments = Collections.singletonList(((MissingRequestHeaderException)exception).getHeaderName());
            errorCode = MISSING_HEADER;
        } else if (exception instanceof MissingRequestCookieException) {
            arguments = Collections.singletonList(((MissingRequestCookieException)exception).getCookieName());
            errorCode = MISSING_COOKIE;
        } else if (exception instanceof MissingMatrixVariableException) {
            arguments = Collections.singletonList(((MissingMatrixVariableException)exception).getVariableName());
            errorCode = MISSING_MATRIX_VARIABLE;
        }
        return new HandledException(errorCode, HttpStatus.BAD_REQUEST, Collections.singletonMap(errorCode, arguments));
    }
}

