/*
 * Decompiled with CFR 0.152.
 */
package me.alidg.errors.handlers;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import me.alidg.errors.HandledException;
import me.alidg.errors.WebErrorHandler;
import org.springframework.http.HttpStatus;

public class ConstraintViolationWebErrorHandler
implements WebErrorHandler {
    @Override
    public boolean canHandle(Throwable exception) {
        return exception instanceof ConstraintViolationException && this.hasAtLeastOneViolation(exception);
    }

    @Override
    @Nonnull
    public HandledException handle(Throwable exception) {
        ConstraintViolationException violationException = (ConstraintViolationException)exception;
        Set<String> errorCodes = this.extractErrorCodes(violationException);
        Map<String, List<?>> arguments = this.extractArguments(violationException);
        return new HandledException(errorCodes, HttpStatus.BAD_REQUEST, arguments);
    }

    private boolean hasAtLeastOneViolation(Throwable exception) {
        Set violations = ((ConstraintViolationException)exception).getConstraintViolations();
        return violations != null && !violations.isEmpty();
    }

    private Map<String, List<?>> extractArguments(ConstraintViolationException violationException) {
        return violationException.getConstraintViolations().stream().filter(this::hasAnyArguments).collect(Collectors.toMap(this::errorCode, this::filterAndSortArguments));
    }

    private Set<String> extractErrorCodes(ConstraintViolationException violationException) {
        return violationException.getConstraintViolations().stream().map(this::errorCode).collect(Collectors.toSet());
    }

    private boolean hasAnyArguments(ConstraintViolation<?> violation) {
        List<String> nonArguments = Arrays.asList("groups", "payload", "message");
        return violation.getConstraintDescriptor().getAttributes().keySet().stream().anyMatch(v -> !nonArguments.contains(v));
    }

    private List<?> filterAndSortArguments(ConstraintViolation violation) {
        HashMap attributes = new HashMap(violation.getConstraintDescriptor().getAttributes());
        attributes.remove("groups");
        attributes.remove("payload");
        attributes.remove("message");
        if (attributes.isEmpty()) {
            return Collections.emptyList();
        }
        return attributes.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    private String errorCode(ConstraintViolation<?> violation) {
        return violation.getMessageTemplate().replace("{", "").replace("}", "");
    }
}

