/*
 * Decompiled with CFR 0.152.
 */
package me.alidg.errors.mvc;

import java.util.Locale;
import java.util.Objects;
import me.alidg.errors.HttpError;
import me.alidg.errors.WebErrorHandlers;
import me.alidg.errors.adapter.HttpErrorAttributesAdapter;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public abstract class ErrorsControllerAdvice {
    private final WebErrorHandlers errorHandlers;
    private final HttpErrorAttributesAdapter httpErrorAttributesAdapter;

    public ErrorsControllerAdvice(WebErrorHandlers errorHandlers, HttpErrorAttributesAdapter httpErrorAttributesAdapter) {
        Objects.requireNonNull(errorHandlers, "Error handlers is required");
        Objects.requireNonNull(httpErrorAttributesAdapter, "Adapter is required");
        this.httpErrorAttributesAdapter = httpErrorAttributesAdapter;
        this.errorHandlers = errorHandlers;
    }

    @ExceptionHandler
    public ResponseEntity<?> handleException(Throwable exception, Locale locale) {
        HttpError httpError = this.errorHandlers.handle(exception, locale);
        return ResponseEntity.status((HttpStatus)httpError.getHttpStatus()).body(this.httpErrorAttributesAdapter.adapt(httpError));
    }
}

