/*
 * Decompiled with CFR 0.152.
 */
package me.alidg.errors;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import me.alidg.errors.HandledException;
import me.alidg.errors.HttpError;
import me.alidg.errors.WebErrorHandler;
import me.alidg.errors.handlers.LastResortWebErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class WebErrorHandlers {
    private static final Logger log = LoggerFactory.getLogger(WebErrorHandlers.class);
    private final MessageSource messageSource;
    private final List<WebErrorHandler> implementations;
    private WebErrorHandler defaultWebErrorHandler = LastResortWebErrorHandler.INSTANCE;

    public WebErrorHandlers(@NonNull MessageSource messageSource, @NonNull List<WebErrorHandler> implementations, @Nullable WebErrorHandler defaultWebErrorHandler) {
        this.enforcePreconditions(messageSource, implementations);
        this.messageSource = messageSource;
        this.implementations = implementations;
        if (defaultWebErrorHandler != null) {
            this.defaultWebErrorHandler = defaultWebErrorHandler;
        }
    }

    @NonNull
    public HttpError handle(@Nullable Throwable exception, @Nullable Locale locale) {
        if (locale == null) {
            locale = Locale.ROOT;
        }
        log.debug("About to handle an exception", exception);
        WebErrorHandler handler = this.findHandler(exception);
        log.debug("The '{}' is going to handle the '{}' exception", (Object)this.className(handler), (Object)this.className(exception));
        HandledException handled = handler.handle(exception);
        List<HttpError.CodedMessage> codeWithMessages = this.translateErrors(handled, locale);
        return new HttpError(codeWithMessages, handled.getStatusCode());
    }

    private List<HttpError.CodedMessage> translateErrors(HandledException handled, Locale locale) {
        return handled.getErrorCodes().stream().map(code -> this.withMessage((String)code, this.getArgumentsFor(handled, (String)code), locale)).collect(Collectors.toList());
    }

    private void enforcePreconditions(MessageSource messageSource, List<WebErrorHandler> webErrorHandlers) {
        Objects.requireNonNull(messageSource, "We need a MessageSource implementation to message translation");
        Objects.requireNonNull(webErrorHandlers, "Collection of error handlers is required");
        if (webErrorHandlers.isEmpty()) {
            throw new IllegalArgumentException("We need at least one error handler");
        }
    }

    private HttpError.CodedMessage withMessage(String code, Object[] args, Locale locale) {
        try {
            String message = this.messageSource.getMessage(code, args, locale);
            return new HttpError.CodedMessage(code, message);
        }
        catch (Exception e) {
            return new HttpError.CodedMessage(code, null);
        }
    }

    private WebErrorHandler findHandler(Throwable exception) {
        if (exception == null) {
            return this.defaultWebErrorHandler;
        }
        return this.implementations.stream().filter(p -> p.canHandle(exception)).findFirst().orElse(this.defaultWebErrorHandler);
    }

    private String className(Object toInspect) {
        if (toInspect == null) {
            return "null";
        }
        return toInspect.getClass().getName();
    }

    private Object[] getArgumentsFor(HandledException handled, String errorCode) {
        return handled.getArguments().getOrDefault(errorCode, Collections.emptyList()).toArray();
    }
}

