/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.tck.command;

import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import java.nio.charset.Charset;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import me.ahoo.wow.api.command.CommandMessage;
import me.ahoo.wow.api.messaging.TopicKind;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.command.CommandBus;
import me.ahoo.wow.command.CommandFactoryKt;
import me.ahoo.wow.command.CommandGateway;
import me.ahoo.wow.command.CommandResultException;
import me.ahoo.wow.command.DefaultCommandGateway;
import me.ahoo.wow.command.DuplicateRequestIdException;
import me.ahoo.wow.command.ServerCommandExchange;
import me.ahoo.wow.command.wait.CommandStage;
import me.ahoo.wow.command.wait.CommandWaitEndpoint;
import me.ahoo.wow.command.wait.SimpleCommandWaitEndpoint;
import me.ahoo.wow.command.wait.SimpleWaitSignal;
import me.ahoo.wow.command.wait.SimpleWaitStrategyRegistrar;
import me.ahoo.wow.command.wait.WaitSignal;
import me.ahoo.wow.command.wait.WaitStrategyRegistrar;
import me.ahoo.wow.configuration.MetadataSearcherKt;
import me.ahoo.wow.id.GlobalIdGenerator;
import me.ahoo.wow.infra.idempotency.AggregateIdempotencyCheckerProvider;
import me.ahoo.wow.infra.idempotency.BloomFilterIdempotencyChecker;
import me.ahoo.wow.infra.idempotency.DefaultAggregateIdempotencyCheckerProvider;
import me.ahoo.wow.infra.idempotency.IdempotencyChecker;
import me.ahoo.wow.tck.messaging.MessageBusSpec;
import me.ahoo.wow.tck.mock.MockCreateAggregate;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import reactor.core.publisher.Mono;
import reactor.kotlin.test.StepVerifierExtensionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u00002\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\f\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0014J\b\u0010\u0018\u001a\u00020\u0019H$J\b\u0010\u001a\u001a\u00020\u0004H\u0014J\b\u0010\u001b\u001a\u00020\u001cH\u0007J\b\u0010\u001d\u001a\u00020\u001cH\u0007J\b\u0010\u001e\u001a\u00020\u001cH\u0007J\b\u0010\u001f\u001a\u00020\u001cH\u0007J\b\u0010 \u001a\u00020\u001cH\u0007R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006!"}, d2={"Lme/ahoo/wow/tck/command/CommandGatewaySpec;", "Lme/ahoo/wow/tck/messaging/MessageBusSpec;", "Lme/ahoo/wow/api/command/CommandMessage;", "Lme/ahoo/wow/command/ServerCommandExchange;", "Lme/ahoo/wow/command/CommandGateway;", "<init>", "()V", "topicKind", "Lme/ahoo/wow/api/messaging/TopicKind;", "getTopicKind", "()Lme/ahoo/wow/api/messaging/TopicKind;", "namedAggregate", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "getNamedAggregate", "()Lme/ahoo/wow/api/modeling/NamedAggregate;", "createMessage", "waitStrategyRegistrar", "Lme/ahoo/wow/command/wait/SimpleWaitStrategyRegistrar;", "getWaitStrategyRegistrar", "()Lme/ahoo/wow/command/wait/SimpleWaitStrategyRegistrar;", "idempotencyChecker", "Lme/ahoo/wow/infra/idempotency/IdempotencyChecker;", "getIdempotencyChecker", "()Lme/ahoo/wow/infra/idempotency/IdempotencyChecker;", "createCommandBus", "Lme/ahoo/wow/command/CommandBus;", "createMessageBus", "sendAndWaitForSent", "", "sendAndWaitForProcessed", "sendAndWaitForSnapshot", "sendGivenDuplicate", "sendThenWaitingForAggregate", "wow-tck"})
@SourceDebugExtension(value={"SMAP\nCommandGatewaySpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandGatewaySpec.kt\nme/ahoo/wow/tck/command/CommandGatewaySpec\n+ 2 MetadataSearcher.kt\nme/ahoo/wow/configuration/MetadataSearcherKt\n*L\n1#1,154:1\n113#2:155\n*S KotlinDebug\n*F\n+ 1 CommandGatewaySpec.kt\nme/ahoo/wow/tck/command/CommandGatewaySpec\n*L\n51#1:155\n*E\n"})
public abstract class CommandGatewaySpec
extends MessageBusSpec<CommandMessage<?>, ServerCommandExchange<?>, CommandGateway> {
    @NotNull
    private final SimpleWaitStrategyRegistrar waitStrategyRegistrar = SimpleWaitStrategyRegistrar.INSTANCE;
    @NotNull
    private final IdempotencyChecker idempotencyChecker;

    public CommandGatewaySpec() {
        Duration duration = Duration.ofSeconds(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        this.idempotencyChecker = (IdempotencyChecker)new BloomFilterIdempotencyChecker(duration, CommandGatewaySpec::idempotencyChecker$lambda$0);
    }

    @NotNull
    public TopicKind getTopicKind() {
        return TopicKind.COMMAND;
    }

    @Override
    @NotNull
    public NamedAggregate getNamedAggregate() {
        boolean $i$f$requiredNamedAggregate = false;
        return MetadataSearcherKt.requiredNamedAggregate(MockCreateAggregate.class);
    }

    @Override
    @NotNull
    protected CommandMessage<?> createMessage() {
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateAsString(...)");
        String string2 = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"generateAsString(...)");
        return CommandFactoryKt.toCommandMessage$default((Object)new MockCreateAggregate(string, string2), null, null, null, null, null, null, null, (long)0L, (int)255, null);
    }

    @NotNull
    protected final SimpleWaitStrategyRegistrar getWaitStrategyRegistrar() {
        return this.waitStrategyRegistrar;
    }

    @NotNull
    protected final IdempotencyChecker getIdempotencyChecker() {
        return this.idempotencyChecker;
    }

    @NotNull
    protected abstract CommandBus createCommandBus();

    @Override
    @NotNull
    protected CommandGateway createMessageBus() {
        return (CommandGateway)new DefaultCommandGateway((CommandWaitEndpoint)new SimpleCommandWaitEndpoint(""), this.createCommandBus(), (AggregateIdempotencyCheckerProvider)new DefaultAggregateIdempotencyCheckerProvider(arg_0 -> CommandGatewaySpec.createMessageBus$lambda$1(this, arg_0)), (WaitStrategyRegistrar)this.waitStrategyRegistrar);
    }

    @Test
    public final void sendAndWaitForSent() {
        CommandMessage<?> message = this.createMessage();
        this.verify(arg_0 -> CommandGatewaySpec.sendAndWaitForSent$lambda$2(message, arg_0));
    }

    @Test
    public final void sendAndWaitForProcessed() {
        CommandMessage<?> message = this.createMessage();
        this.verify(arg_0 -> CommandGatewaySpec.sendAndWaitForProcessed$lambda$3(message, arg_0));
    }

    @Test
    public final void sendAndWaitForSnapshot() {
        CommandMessage<?> message = this.createMessage();
        this.verify(arg_0 -> CommandGatewaySpec.sendAndWaitForSnapshot$lambda$4(message, arg_0));
    }

    @Test
    public final void sendGivenDuplicate() {
        CommandMessage<?> message = this.createMessage();
        this.verify(arg_0 -> CommandGatewaySpec.sendGivenDuplicate$lambda$6(message, arg_0));
    }

    @Test
    public final void sendThenWaitingForAggregate() {
        CommandMessage<?> message = this.createMessage();
        this.verify(arg_0 -> CommandGatewaySpec.sendThenWaitingForAggregate$lambda$9(message, this, arg_0));
    }

    private static final BloomFilter idempotencyChecker$lambda$0() {
        BloomFilter bloomFilter = BloomFilter.create((Funnel)Funnels.stringFunnel((Charset)Charsets.UTF_8), (int)1000000);
        Intrinsics.checkNotNullExpressionValue((Object)bloomFilter, (String)"create(...)");
        return bloomFilter;
    }

    private static final IdempotencyChecker createMessageBus$lambda$1(CommandGatewaySpec this$0, NamedAggregate it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.idempotencyChecker;
    }

    private static final Unit sendAndWaitForSent$lambda$2(CommandMessage $message, CommandGateway $this$verify) {
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        Intrinsics.checkNotNullParameter((Object)$this$verify, (String)"$this$verify");
        StepVerifierExtensionsKt.test((Mono)$this$verify.sendAndWaitForSent($message)).expectNextCount(1L).verifyComplete();
        return Unit.INSTANCE;
    }

    private static final Unit sendAndWaitForProcessed$lambda$3(CommandMessage $message, CommandGateway $this$verify) {
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        Intrinsics.checkNotNullParameter((Object)$this$verify, (String)"$this$verify");
        Mono mono = $this$verify.sendAndWaitForProcessed($message).timeout(Duration.ofMillis(100L));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"timeout(...)");
        StepVerifierExtensionsKt.test((Mono)mono).verifyTimeout(Duration.ofMillis(150L));
        return Unit.INSTANCE;
    }

    private static final Unit sendAndWaitForSnapshot$lambda$4(CommandMessage $message, CommandGateway $this$verify) {
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        Intrinsics.checkNotNullParameter((Object)$this$verify, (String)"$this$verify");
        Mono mono = $this$verify.sendAndWaitForSnapshot($message).timeout(Duration.ofMillis(100L));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"timeout(...)");
        StepVerifierExtensionsKt.test((Mono)mono).verifyTimeout(Duration.ofMillis(150L));
        return Unit.INSTANCE;
    }

    private static final void sendGivenDuplicate$lambda$6$lambda$5(Throwable it) {
        MatcherAssert.assertThat((Object)it, (Matcher)Matchers.instanceOf(CommandResultException.class));
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type me.ahoo.wow.command.CommandResultException");
        CommandResultException commandResultException = (CommandResultException)it;
        MatcherAssert.assertThat((Object)commandResultException.getCommandResult().getErrorCode(), (Matcher)Matchers.equalTo((Object)"DuplicateRequestId"));
        MatcherAssert.assertThat((Object)commandResultException.getCause(), (Matcher)Matchers.instanceOf(DuplicateRequestIdException.class));
    }

    private static final Unit sendGivenDuplicate$lambda$6(CommandMessage $message, CommandGateway $this$verify) {
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        Intrinsics.checkNotNullParameter((Object)$this$verify, (String)"$this$verify");
        StepVerifierExtensionsKt.test((Mono)$this$verify.sendAndWaitForSent($message)).expectNextCount(1L).verifyComplete();
        StepVerifierExtensionsKt.test((Mono)$this$verify.sendAndWaitForSent($message)).consumeErrorWith(CommandGatewaySpec::sendGivenDuplicate$lambda$6$lambda$5).verify();
        return Unit.INSTANCE;
    }

    private static final Boolean sendThenWaitingForAggregate$lambda$9$lambda$8$lambda$7(CommandGatewaySpec this$0, CommandMessage $message) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        return this$0.waitStrategyRegistrar.next((WaitSignal)new SimpleWaitSignal($message.getCommandId(), CommandStage.PROCESSED, $message.getContextName(), "", false, null, null, null, null, 496, null));
    }

    private static final void sendThenWaitingForAggregate$lambda$9$lambda$8(CommandGatewaySpec this$0, CommandMessage $message, long it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        Mono.fromCallable(() -> CommandGatewaySpec.sendThenWaitingForAggregate$lambda$9$lambda$8$lambda$7(this$0, $message)).delaySubscription(Duration.ofMillis(10L)).subscribe();
    }

    private static final Unit sendThenWaitingForAggregate$lambda$9(CommandMessage $message, CommandGatewaySpec this$0, CommandGateway $this$verify) {
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$this$verify, (String)"$this$verify");
        Mono mono = $this$verify.sendAndWaitForProcessed($message).doOnRequest(arg_0 -> CommandGatewaySpec.sendThenWaitingForAggregate$lambda$9$lambda$8(this$0, $message, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doOnRequest(...)");
        StepVerifierExtensionsKt.test((Mono)mono).expectNextCount(1L).verifyComplete();
        return Unit.INSTANCE;
    }
}

