/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.tck.modeling.command;

import jakarta.validation.Validator;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.command.CommandBus;
import me.ahoo.wow.command.CommandFactoryKt;
import me.ahoo.wow.command.CommandGateway;
import me.ahoo.wow.command.CommandResult;
import me.ahoo.wow.command.DefaultCommandGateway;
import me.ahoo.wow.command.InMemoryCommandBus;
import me.ahoo.wow.command.validation.NoOpValidator;
import me.ahoo.wow.command.wait.CommandWaitEndpoint;
import me.ahoo.wow.command.wait.CommandWaitNotifier;
import me.ahoo.wow.command.wait.LocalCommandWaitNotifier;
import me.ahoo.wow.command.wait.ProcessedNotifierFilter;
import me.ahoo.wow.command.wait.SimpleCommandWaitEndpoint;
import me.ahoo.wow.command.wait.SimpleWaitStrategyRegistrar;
import me.ahoo.wow.command.wait.WaitStrategyRegistrar;
import me.ahoo.wow.event.DomainEventBus;
import me.ahoo.wow.event.InMemoryDomainEventBus;
import me.ahoo.wow.eventsourcing.EventSourcingStateAggregateRepository;
import me.ahoo.wow.eventsourcing.EventStore;
import me.ahoo.wow.eventsourcing.InMemoryEventStore;
import me.ahoo.wow.eventsourcing.snapshot.InMemorySnapshotRepository;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotRepository;
import me.ahoo.wow.filter.Filter;
import me.ahoo.wow.filter.FilterChain;
import me.ahoo.wow.filter.FilterChainBuilder;
import me.ahoo.wow.id.GlobalIdGenerator;
import me.ahoo.wow.infra.idempotency.BloomFilterIdempotencyChecker;
import me.ahoo.wow.infra.idempotency.IdempotencyChecker;
import me.ahoo.wow.ioc.ServiceProvider;
import me.ahoo.wow.ioc.SimpleServiceProvider;
import me.ahoo.wow.metrics.Metrics;
import me.ahoo.wow.modeling.MaterializedNamedAggregateKt;
import me.ahoo.wow.modeling.annotation.AggregateMetadataParserKt;
import me.ahoo.wow.modeling.command.AggregateProcessorFactory;
import me.ahoo.wow.modeling.command.AggregateProcessorFilter;
import me.ahoo.wow.modeling.command.CommandAggregateFactory;
import me.ahoo.wow.modeling.command.CommandDispatcher;
import me.ahoo.wow.modeling.command.CommandHandler;
import me.ahoo.wow.modeling.command.DefaultCommandHandler;
import me.ahoo.wow.modeling.command.RetryableAggregateProcessorFactory;
import me.ahoo.wow.modeling.command.SendDomainEventStreamFilter;
import me.ahoo.wow.modeling.command.SimpleCommandAggregateFactory;
import me.ahoo.wow.modeling.matedata.AggregateMetadata;
import me.ahoo.wow.modeling.state.ConstructorStateAggregateFactory;
import me.ahoo.wow.modeling.state.StateAggregateFactory;
import me.ahoo.wow.modeling.state.StateAggregateRepository;
import me.ahoo.wow.tck.metrics.LoggingMeterRegistryInitializer;
import me.ahoo.wow.tck.mock.MockChangeAggregate;
import me.ahoo.wow.tck.mock.MockCommandAggregate;
import me.ahoo.wow.tck.mock.MockCreateAggregate;
import me.ahoo.wow.tck.mock.MockStateAggregate;
import me.ahoo.wow.tck.modeling.command.CommandDispatcherSpec;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.kotlin.core.publisher.FluxExtensionsKt;
import reactor.kotlin.test.StepVerifierExtensionsKt;

@ExtendWith(value={LoggingMeterRegistryInitializer.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010O\u001a\u00020\u00142\u0006\u0010-\u001a\u00020.H\u0004J\b\u0010P\u001a\u00020\u001aH\u0014J\b\u0010Q\u001a\u00020(H\u0014J\b\u0010R\u001a\u00020.H\u0014J\b\u0010S\u001a\u00020<H\u0014J \u0010T\u001a\u00020F2\u0006\u0010A\u001a\u00020B2\u0006\u0010;\u001a\u00020<2\u0006\u0010-\u001a\u00020.H\u0004J\u000e\u0010U\u001a\b\u0012\u0004\u0012\u00020W0VH\u0014J\b\u0010X\u001a\u00020YH\u0002J\b\u0010Z\u001a\u00020YH\u0007J\b\u0010[\u001a\u00020YH\u0017J\b\u0010\\\u001a\u00020YH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0006R\u001a\u0010'\u001a\u00020(X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020.X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u0014\u00103\u001a\u000204X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0014\u00107\u001a\u000208X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u001a\u0010;\u001a\u00020<X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u0014\u0010A\u001a\u00020BX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010DR\u001a\u0010E\u001a\u00020FX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010H\"\u0004\bI\u0010JR\u0014\u0010K\u001a\u00020LX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010N\u00a8\u0006]"}, d2={"Lme/ahoo/wow/tck/modeling/command/CommandDispatcherSpec;", "", "()V", "aggregateCount", "", "getAggregateCount", "()I", "aggregateMetadata", "Lme/ahoo/wow/modeling/matedata/AggregateMetadata;", "Lme/ahoo/wow/tck/mock/MockCommandAggregate;", "Lme/ahoo/wow/tck/mock/MockStateAggregate;", "getAggregateMetadata", "()Lme/ahoo/wow/modeling/matedata/AggregateMetadata;", "aggregateProcessorFactory", "Lme/ahoo/wow/modeling/command/AggregateProcessorFactory;", "getAggregateProcessorFactory", "()Lme/ahoo/wow/modeling/command/AggregateProcessorFactory;", "setAggregateProcessorFactory", "(Lme/ahoo/wow/modeling/command/AggregateProcessorFactory;)V", "commandAggregateFactory", "Lme/ahoo/wow/modeling/command/CommandAggregateFactory;", "getCommandAggregateFactory", "()Lme/ahoo/wow/modeling/command/CommandAggregateFactory;", "setCommandAggregateFactory", "(Lme/ahoo/wow/modeling/command/CommandAggregateFactory;)V", "commandBus", "Lme/ahoo/wow/command/CommandBus;", "getCommandBus", "()Lme/ahoo/wow/command/CommandBus;", "setCommandBus", "(Lme/ahoo/wow/command/CommandBus;)V", "commandGateway", "Lme/ahoo/wow/command/CommandGateway;", "getCommandGateway", "()Lme/ahoo/wow/command/CommandGateway;", "setCommandGateway", "(Lme/ahoo/wow/command/CommandGateway;)V", "concurrency", "getConcurrency", "domainEventBus", "Lme/ahoo/wow/event/DomainEventBus;", "getDomainEventBus", "()Lme/ahoo/wow/event/DomainEventBus;", "setDomainEventBus", "(Lme/ahoo/wow/event/DomainEventBus;)V", "eventStore", "Lme/ahoo/wow/eventsourcing/EventStore;", "getEventStore", "()Lme/ahoo/wow/eventsourcing/EventStore;", "setEventStore", "(Lme/ahoo/wow/eventsourcing/EventStore;)V", "idempotencyChecker", "Lme/ahoo/wow/infra/idempotency/IdempotencyChecker;", "getIdempotencyChecker", "()Lme/ahoo/wow/infra/idempotency/IdempotencyChecker;", "serviceProvider", "Lme/ahoo/wow/ioc/ServiceProvider;", "getServiceProvider", "()Lme/ahoo/wow/ioc/ServiceProvider;", "snapshotRepository", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotRepository;", "getSnapshotRepository", "()Lme/ahoo/wow/eventsourcing/snapshot/SnapshotRepository;", "setSnapshotRepository", "(Lme/ahoo/wow/eventsourcing/snapshot/SnapshotRepository;)V", "stateAggregateFactory", "Lme/ahoo/wow/modeling/state/StateAggregateFactory;", "getStateAggregateFactory", "()Lme/ahoo/wow/modeling/state/StateAggregateFactory;", "stateAggregateRepository", "Lme/ahoo/wow/modeling/state/StateAggregateRepository;", "getStateAggregateRepository", "()Lme/ahoo/wow/modeling/state/StateAggregateRepository;", "setStateAggregateRepository", "(Lme/ahoo/wow/modeling/state/StateAggregateRepository;)V", "waitStrategyRegistrar", "Lme/ahoo/wow/command/wait/SimpleWaitStrategyRegistrar;", "getWaitStrategyRegistrar", "()Lme/ahoo/wow/command/wait/SimpleWaitStrategyRegistrar;", "createCommandAggregateFactory", "createCommandBus", "createEventBus", "createEventStore", "createSnapshotRepository", "createStateAggregateRepository", "onCommandSeek", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "orchestra", "", "run", "setup", "warmUp", "wow-tck"})
@SourceDebugExtension(value={"SMAP\nCommandDispatcherSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandDispatcherSpec.kt\nme/ahoo/wow/tck/modeling/command/CommandDispatcherSpec\n+ 2 AggregateMetadataParser.kt\nme/ahoo/wow/modeling/annotation/AggregateMetadataParserKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,251:1\n142#2:252\n1655#3,8:253\n*S KotlinDebug\n*F\n+ 1 CommandDispatcherSpec.kt\nme/ahoo/wow/tck/modeling/command/CommandDispatcherSpec\n*L\n74#1:252\n197#1:253,8\n*E\n"})
public abstract class CommandDispatcherSpec {
    @NotNull
    private final AggregateMetadata<MockCommandAggregate, MockStateAggregate> aggregateMetadata;
    @NotNull
    private final ServiceProvider serviceProvider;
    @NotNull
    private final IdempotencyChecker idempotencyChecker;
    @NotNull
    private final StateAggregateFactory stateAggregateFactory;
    @NotNull
    private final SimpleWaitStrategyRegistrar waitStrategyRegistrar;
    protected AggregateProcessorFactory aggregateProcessorFactory;
    protected CommandBus commandBus;
    protected CommandGateway commandGateway;
    protected EventStore eventStore;
    protected SnapshotRepository snapshotRepository;
    protected StateAggregateRepository stateAggregateRepository;
    protected CommandAggregateFactory commandAggregateFactory;
    protected DomainEventBus domainEventBus;
    private final int concurrency;
    private final int aggregateCount;

    public CommandDispatcherSpec() {
        boolean $i$f$aggregateMetadata = false;
        this.aggregateMetadata = AggregateMetadataParserKt.aggregateMetadata(MockCommandAggregate.class);
        this.serviceProvider = (ServiceProvider)new SimpleServiceProvider();
        Duration duration2 = Duration.ofSeconds(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
        this.idempotencyChecker = (IdempotencyChecker)new BloomFilterIdempotencyChecker(duration2, (Function0)idempotencyChecker.1.INSTANCE);
        this.stateAggregateFactory = (StateAggregateFactory)ConstructorStateAggregateFactory.INSTANCE;
        this.waitStrategyRegistrar = SimpleWaitStrategyRegistrar.INSTANCE;
        this.concurrency = 100;
        this.aggregateCount = 200;
    }

    @NotNull
    protected final AggregateMetadata<MockCommandAggregate, MockStateAggregate> getAggregateMetadata() {
        return this.aggregateMetadata;
    }

    @NotNull
    protected final ServiceProvider getServiceProvider() {
        return this.serviceProvider;
    }

    @NotNull
    protected final IdempotencyChecker getIdempotencyChecker() {
        return this.idempotencyChecker;
    }

    @NotNull
    protected final StateAggregateFactory getStateAggregateFactory() {
        return this.stateAggregateFactory;
    }

    @NotNull
    protected final SimpleWaitStrategyRegistrar getWaitStrategyRegistrar() {
        return this.waitStrategyRegistrar;
    }

    @NotNull
    protected final AggregateProcessorFactory getAggregateProcessorFactory() {
        AggregateProcessorFactory aggregateProcessorFactory = this.aggregateProcessorFactory;
        if (aggregateProcessorFactory != null) {
            return aggregateProcessorFactory;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"aggregateProcessorFactory");
        return null;
    }

    protected final void setAggregateProcessorFactory(@NotNull AggregateProcessorFactory aggregateProcessorFactory) {
        Intrinsics.checkNotNullParameter((Object)aggregateProcessorFactory, (String)"<set-?>");
        this.aggregateProcessorFactory = aggregateProcessorFactory;
    }

    @NotNull
    protected final CommandBus getCommandBus() {
        CommandBus commandBus = this.commandBus;
        if (commandBus != null) {
            return commandBus;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"commandBus");
        return null;
    }

    protected final void setCommandBus(@NotNull CommandBus commandBus) {
        Intrinsics.checkNotNullParameter((Object)commandBus, (String)"<set-?>");
        this.commandBus = commandBus;
    }

    @NotNull
    protected final CommandGateway getCommandGateway() {
        CommandGateway commandGateway = this.commandGateway;
        if (commandGateway != null) {
            return commandGateway;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"commandGateway");
        return null;
    }

    protected final void setCommandGateway(@NotNull CommandGateway commandGateway) {
        Intrinsics.checkNotNullParameter((Object)commandGateway, (String)"<set-?>");
        this.commandGateway = commandGateway;
    }

    @NotNull
    protected final EventStore getEventStore() {
        EventStore eventStore = this.eventStore;
        if (eventStore != null) {
            return eventStore;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"eventStore");
        return null;
    }

    protected final void setEventStore(@NotNull EventStore eventStore) {
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"<set-?>");
        this.eventStore = eventStore;
    }

    @NotNull
    protected final SnapshotRepository getSnapshotRepository() {
        SnapshotRepository snapshotRepository = this.snapshotRepository;
        if (snapshotRepository != null) {
            return snapshotRepository;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"snapshotRepository");
        return null;
    }

    protected final void setSnapshotRepository(@NotNull SnapshotRepository snapshotRepository) {
        Intrinsics.checkNotNullParameter((Object)snapshotRepository, (String)"<set-?>");
        this.snapshotRepository = snapshotRepository;
    }

    @NotNull
    protected final StateAggregateRepository getStateAggregateRepository() {
        StateAggregateRepository stateAggregateRepository = this.stateAggregateRepository;
        if (stateAggregateRepository != null) {
            return stateAggregateRepository;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"stateAggregateRepository");
        return null;
    }

    protected final void setStateAggregateRepository(@NotNull StateAggregateRepository stateAggregateRepository) {
        Intrinsics.checkNotNullParameter((Object)stateAggregateRepository, (String)"<set-?>");
        this.stateAggregateRepository = stateAggregateRepository;
    }

    @NotNull
    protected final CommandAggregateFactory getCommandAggregateFactory() {
        CommandAggregateFactory commandAggregateFactory = this.commandAggregateFactory;
        if (commandAggregateFactory != null) {
            return commandAggregateFactory;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"commandAggregateFactory");
        return null;
    }

    protected final void setCommandAggregateFactory(@NotNull CommandAggregateFactory commandAggregateFactory) {
        Intrinsics.checkNotNullParameter((Object)commandAggregateFactory, (String)"<set-?>");
        this.commandAggregateFactory = commandAggregateFactory;
    }

    @NotNull
    protected final DomainEventBus getDomainEventBus() {
        DomainEventBus domainEventBus = this.domainEventBus;
        if (domainEventBus != null) {
            return domainEventBus;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"domainEventBus");
        return null;
    }

    protected final void setDomainEventBus(@NotNull DomainEventBus domainEventBus) {
        Intrinsics.checkNotNullParameter((Object)domainEventBus, (String)"<set-?>");
        this.domainEventBus = domainEventBus;
    }

    @BeforeEach
    public void setup() {
        this.setCommandBus((CommandBus)Metrics.INSTANCE.metrizable((Object)this.createCommandBus()));
        this.setCommandGateway((CommandGateway)new DefaultCommandGateway((CommandWaitEndpoint)new SimpleCommandWaitEndpoint(""), this.getCommandBus(), this.idempotencyChecker, (WaitStrategyRegistrar)this.waitStrategyRegistrar, (Validator)NoOpValidator.INSTANCE));
        this.setEventStore(Metrics.INSTANCE.metrizable(this.createEventStore()));
        this.setSnapshotRepository(Metrics.INSTANCE.metrizable(this.createSnapshotRepository()));
        this.setStateAggregateRepository(this.createStateAggregateRepository(this.stateAggregateFactory, this.getSnapshotRepository(), this.getEventStore()));
        this.setCommandAggregateFactory(this.createCommandAggregateFactory(this.getEventStore()));
        this.setAggregateProcessorFactory((AggregateProcessorFactory)new RetryableAggregateProcessorFactory(this.stateAggregateFactory, this.getStateAggregateRepository(), this.getCommandAggregateFactory()));
        this.setDomainEventBus((DomainEventBus)Metrics.INSTANCE.metrizable((Object)this.createEventBus()));
    }

    @NotNull
    protected CommandBus createCommandBus() {
        return (CommandBus)new InMemoryCommandBus(null, 1, null);
    }

    @NotNull
    protected DomainEventBus createEventBus() {
        return (DomainEventBus)new InMemoryDomainEventBus(null, 1, null);
    }

    @NotNull
    protected EventStore createEventStore() {
        return (EventStore)new InMemoryEventStore();
    }

    @NotNull
    protected SnapshotRepository createSnapshotRepository() {
        return (SnapshotRepository)new InMemorySnapshotRepository();
    }

    @NotNull
    protected final StateAggregateRepository createStateAggregateRepository(@NotNull StateAggregateFactory stateAggregateFactory2, @NotNull SnapshotRepository snapshotRepository, @NotNull EventStore eventStore) {
        Intrinsics.checkNotNullParameter((Object)stateAggregateFactory2, (String)"stateAggregateFactory");
        Intrinsics.checkNotNullParameter((Object)snapshotRepository, (String)"snapshotRepository");
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"eventStore");
        return (StateAggregateRepository)new EventSourcingStateAggregateRepository(stateAggregateFactory2, snapshotRepository, eventStore);
    }

    @NotNull
    protected final CommandAggregateFactory createCommandAggregateFactory(@NotNull EventStore eventStore) {
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"eventStore");
        return (CommandAggregateFactory)new SimpleCommandAggregateFactory(eventStore);
    }

    @NotNull
    protected Mono<Void> onCommandSeek() {
        Mono mono = Mono.empty();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"empty(...)");
        return mono;
    }

    public final int getConcurrency() {
        return this.concurrency;
    }

    public final int getAggregateCount() {
        return this.aggregateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void run() {
        FilterChain chain = new FilterChainBuilder().addFilter((Filter)AggregateProcessorFilter.INSTANCE).addFilter((Filter)new SendDomainEventStreamFilter(this.getDomainEventBus())).addFilter((Filter)new ProcessedNotifierFilter((CommandWaitNotifier)new LocalCommandWaitNotifier((WaitStrategyRegistrar)this.waitStrategyRegistrar))).build();
        CommandDispatcher commandDispatcher = new CommandDispatcher(null, 0, SetsKt.setOf((Object)MaterializedNamedAggregateKt.materialize((NamedAggregate)((NamedAggregate)this.aggregateMetadata))), this.getCommandBus(), this.getAggregateProcessorFactory(), Metrics.INSTANCE.metrizable((CommandHandler)new DefaultCommandHandler(chain, null, 2, null)), this.serviceProvider, null, 131, null);
        AutoCloseable autoCloseable = (AutoCloseable)commandDispatcher;
        Throwable throwable = null;
        try {
            CommandDispatcher it = (CommandDispatcher)autoCloseable;
            boolean bl = false;
            it.run();
            this.onCommandSeek().block();
            this.warmUp();
            this.orchestra();
            this.getCommandBus().close();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final void warmUp() {
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateAsString(...)");
        String string2 = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"generateAsString(...)");
        MockCreateAggregate mockCreateAggregate = new MockCreateAggregate(string, string2);
        Mono mono = this.getCommandGateway().sendAndWaitForProcessed(CommandFactoryKt.toCommandMessage$default((Object)mockCreateAggregate, null, null, null, null, null, null, null, (long)0L, (int)255, null)).then();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"then(...)");
        StepVerifierExtensionsKt.test((Mono)mono).verifyComplete();
    }

    private final void orchestra() {
        List list;
        List $this$orchestra_u24lambda_u242 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        int n = this.aggregateCount;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl2 = false;
            String string = GlobalIdGenerator.INSTANCE.generateAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateAsString(...)");
            String string2 = GlobalIdGenerator.INSTANCE.generateAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"generateAsString(...)");
            $this$orchestra_u24lambda_u242.add(new MockCreateAggregate(string, string2));
        }
        List creates = CollectionsKt.build((List)list);
        Iterable $this$distinctBy$iv = creates;
        boolean $i$f$distinctBy22 = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        Object object = $this$distinctBy$iv.iterator();
        while (object.hasNext()) {
            Object e$iv = object.next();
            MockCreateAggregate it = (MockCreateAggregate)e$iv;
            boolean bl3 = false;
            String key$iv = it.getId();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        MatcherAssert.assertThat((Object)((List)list$iv).size(), (Matcher)Matchers.equalTo((Object)this.aggregateCount));
        System.out.println((Object)"------------- CreateAggregate -------------");
        Object object2 = FluxExtensionsKt.toFlux((Iterable)creates).subscribeOn(Schedulers.single()).name("test.create-aggregate").metrics().flatMap(arg_0 -> CommandDispatcherSpec.orchestra$lambda$4((Function1)new Function1<MockCreateAggregate, Publisher<? extends CommandResult>>(this){
            final /* synthetic */ CommandDispatcherSpec this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Publisher<? extends CommandResult> invoke(MockCreateAggregate it) {
                CommandGateway commandGateway = this.this$0.getCommandGateway();
                MockCreateAggregate mockCreateAggregate = it;
                Intrinsics.checkNotNull((Object)mockCreateAggregate);
                return (Publisher)commandGateway.sendAndWaitForProcessed(CommandFactoryKt.toCommandMessage$default((Object)mockCreateAggregate, null, null, null, null, null, null, null, (long)0L, (int)255, null));
            }
        }, arg_0), Integer.MAX_VALUE).doOnNext(arg_0 -> CommandDispatcherSpec.orchestra$lambda$5(orchestra.createdDuration.2.INSTANCE, arg_0)).timeout(Duration.ofMinutes(1L)).then();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"then(...)");
        Object $i$f$distinctBy22 = StepVerifierExtensionsKt.test((Mono)object2).verifyComplete();
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$distinctBy22, (String)"verifyComplete(...)");
        Duration createdDuration2 = $i$f$distinctBy22;
        $i$f$distinctBy22 = "------------- Aggregate Created Duration:[" + createdDuration2 + "] Throughput:[" + (double)creates.size() / (double)createdDuration2.toMillis() * (double)1000 + "/s]-------------";
        System.out.println($i$f$distinctBy22);
        LoggingMeterRegistryInitializer.INSTANCE.publishMeters();
        Object $this$orchestra_u24lambda_u247 = object = CollectionsKt.createListBuilder();
        boolean bl4 = false;
        int n3 = this.concurrency;
        int n4 = 0;
        while (n4 < n3) {
            int it = n4++;
            boolean bl5 = false;
            MockCreateAggregate randomCreate = (MockCreateAggregate)creates.get(ThreadLocalRandom.current().nextInt(0, this.aggregateCount));
            String string = randomCreate.getId();
            String string3 = GlobalIdGenerator.INSTANCE.generateAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"generateAsString(...)");
            $this$orchestra_u24lambda_u247.add(new MockChangeAggregate(string, string3));
        }
        Mono mono = FluxExtensionsKt.toFlux((Iterable)CollectionsKt.build((List)object)).subscribeOn(Schedulers.single()).flatMap(arg_0 -> CommandDispatcherSpec.orchestra$lambda$8((Function1)new Function1<MockChangeAggregate, Publisher<? extends CommandResult>>(this){
            final /* synthetic */ CommandDispatcherSpec this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Publisher<? extends CommandResult> invoke(MockChangeAggregate it) {
                return (Publisher)this.this$0.getCommandGateway().sendAndWaitForProcessed(CommandFactoryKt.toCommandMessage$default((Object)it, null, null, null, null, null, null, null, (long)0L, (int)255, null));
            }
        }, arg_0), Integer.MAX_VALUE).doOnNext(arg_0 -> CommandDispatcherSpec.orchestra$lambda$9(orchestra.changedDuration.3.INSTANCE, arg_0)).timeout(Duration.ofSeconds(30L)).then();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"then(...)");
        object2 = StepVerifierExtensionsKt.test((Mono)mono).verifyComplete();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"verifyComplete(...)");
        Object changedDuration2 = object2;
        object2 = "------- Aggregate Changed Duration:[" + (Duration)changedDuration2 + "]  Throughput:[" + (double)this.concurrency / (double)((Duration)changedDuration2).toMillis() * (double)1000 + "/s]-------";
        System.out.println(object2);
        LoggingMeterRegistryInitializer.INSTANCE.publishMeters();
    }

    private static final Publisher orchestra$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final void orchestra$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Publisher orchestra$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final void orchestra$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

