/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.tck.eventsourcing;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.command.CommandMessage;
import me.ahoo.wow.api.modeling.AggregateId;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.command.DuplicateRequestIdException;
import me.ahoo.wow.configuration.MetadataSearcherKt;
import me.ahoo.wow.event.DomainEventStream;
import me.ahoo.wow.event.DomainEventStreamFactoryKt;
import me.ahoo.wow.eventsourcing.DuplicateAggregateIdException;
import me.ahoo.wow.eventsourcing.EventStore;
import me.ahoo.wow.eventsourcing.EventVersionConflictException;
import me.ahoo.wow.id.GlobalIdGenerator;
import me.ahoo.wow.metrics.Metrics;
import me.ahoo.wow.modeling.DefaultAggregateId;
import me.ahoo.wow.modeling.DefaultAggregateIdKt;
import me.ahoo.wow.tck.event.MockDomainEventStreams;
import me.ahoo.wow.tck.metrics.LoggingMeterRegistryInitializer;
import me.ahoo.wow.tck.mock.MockAggregateCreated;
import me.ahoo.wow.test.aggregate.GivenInitializationCommand;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.kotlin.test.StepVerifierExtensionsKt;

@ExtendWith(value={LoggingMeterRegistryInitializer.class})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b'\u0018\u0000 !2\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000e\u001a\u00020\u000fH\u0017J\b\u0010\u0010\u001a\u00020\tH$J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0004J\b\u0010\u0015\u001a\u00020\u000fH\u0007J\b\u0010\u0016\u001a\u00020\u000fH\u0007J\b\u0010\u0017\u001a\u00020\u000fH\u0007J\b\u0010\u0018\u001a\u00020\u000fH\u0017J\b\u0010\u0019\u001a\u00020\u000fH\u0007J\b\u0010\u001a\u001a\u00020\u000fH\u0007J\b\u0010\u001b\u001a\u00020\u000fH\u0007J\b\u0010\u001c\u001a\u00020\u000fH\u0007J\b\u0010\u001d\u001a\u00020\u000fH\u0017J\b\u0010\u001e\u001a\u00020\u000fH\u0017J\b\u0010\u001f\u001a\u00020\u000fH\u0017J\b\u0010 \u001a\u00020\u000fH\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\""}, d2={"Lme/ahoo/wow/tck/eventsourcing/EventStoreSpec;", "", "<init>", "()V", "namedAggregate", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "getNamedAggregate", "()Lme/ahoo/wow/api/modeling/NamedAggregate;", "eventStore", "Lme/ahoo/wow/eventsourcing/EventStore;", "getEventStore", "()Lme/ahoo/wow/eventsourcing/EventStore;", "setEventStore", "(Lme/ahoo/wow/eventsourcing/EventStore;)V", "setup", "", "createEventStore", "generateEventStream", "Lme/ahoo/wow/event/DomainEventStream;", "aggregateId", "Lme/ahoo/wow/api/modeling/AggregateId;", "appendEventStream", "appendEventStreamWhenDuplicateAggregateId", "appendEventStreamWhenEventVersionConflict", "appendEventStreamWhenDuplicateRequestIdException", "appendEventStreamWhenParallel", "loadEventStreamWhenParallel", "loadEventStreamWhenNotFound", "loadEventStreamGivenHeadVersion", "loadEventStreamGivenWrongVersion", "tailCursorId", "archiveAggregateId", "scanAggregateId", "Companion", "wow-tck"})
public abstract class EventStoreSpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NamedAggregate namedAggregate = MetadataSearcherKt.requiredNamedAggregate(EventStoreSpec.class);
    public EventStore eventStore;
    public static final int TIMES = 4000;
    public static final int DEFAULT_PARALLELISM = 16;

    @NotNull
    public final NamedAggregate getNamedAggregate() {
        return this.namedAggregate;
    }

    @NotNull
    public final EventStore getEventStore() {
        EventStore eventStore = this.eventStore;
        if (eventStore != null) {
            return eventStore;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"eventStore");
        return null;
    }

    public final void setEventStore(@NotNull EventStore eventStore) {
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"<set-?>");
        this.eventStore = eventStore;
    }

    @BeforeEach
    public void setup() {
        this.setEventStore(Metrics.INSTANCE.metrizable(this.createEventStore()));
    }

    @NotNull
    protected abstract EventStore createEventStore();

    @NotNull
    protected final DomainEventStream generateEventStream(@NotNull AggregateId aggregateId) {
        Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
        return MockDomainEventStreams.generateEventStream$default(MockDomainEventStreams.INSTANCE, aggregateId, 0, 10, null, null, 26, null);
    }

    @NotNull
    protected final DomainEventStream generateEventStream() {
        return this.generateEventStream((AggregateId)DefaultAggregateIdKt.aggregateId$default((NamedAggregate)this.namedAggregate, null, null, (int)3, null));
    }

    @Test
    public final void appendEventStream() {
        DomainEventStream eventStream = this.generateEventStream();
        MatcherAssert.assertThat((Object)CollectionsKt.count((Iterable)((Iterable)eventStream)), (Matcher)CoreMatchers.equalTo((Object)eventStream.getSize()));
        StepVerifierExtensionsKt.test((Mono)this.getEventStore().append(eventStream)).verifyComplete();
        StepVerifierExtensionsKt.test((Flux)EventStore.load$default((EventStore)this.getEventStore(), (AggregateId)eventStream.getAggregateId(), (int)0, (int)0, (int)6, null)).expectNextMatches(arg_0 -> EventStoreSpec.appendEventStream$lambda$1(arg_0 -> EventStoreSpec.appendEventStream$lambda$0(eventStream, arg_0), arg_0)).verifyComplete();
    }

    @Test
    public final void appendEventStreamWhenDuplicateAggregateId() {
        EventStore eventStore = Metrics.INSTANCE.metrizable(this.createEventStore());
        DefaultAggregateId aggregateId = DefaultAggregateIdKt.aggregateId$default((NamedAggregate)this.namedAggregate, null, null, (int)3, null);
        DomainEventStream eventStream = this.generateEventStream((AggregateId)aggregateId);
        StepVerifierExtensionsKt.test((Mono)eventStore.append(eventStream)).verifyComplete();
        DomainEventStream conflictingStream = this.generateEventStream((AggregateId)aggregateId);
        StepVerifierExtensionsKt.test((Mono)eventStore.append(conflictingStream)).expectErrorMatches(arg_0 -> EventStoreSpec.appendEventStreamWhenDuplicateAggregateId$lambda$2(conflictingStream, arg_0)).verify();
        StepVerifierExtensionsKt.test((Flux)EventStore.load$default((EventStore)eventStore, (AggregateId)((AggregateId)aggregateId), (int)0, (int)0, (int)6, null)).consumeNextWith(arg_0 -> EventStoreSpec.appendEventStreamWhenDuplicateAggregateId$lambda$4(arg_0 -> EventStoreSpec.appendEventStreamWhenDuplicateAggregateId$lambda$3(eventStream, arg_0), arg_0)).verifyComplete();
    }

    @Test
    public final void appendEventStreamWhenEventVersionConflict() {
        DefaultAggregateId aggregateId = DefaultAggregateIdKt.aggregateId$default((NamedAggregate)this.namedAggregate, null, null, (int)3, null);
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateAsString(...)");
        DomainEventStream eventStream = DomainEventStreamFactoryKt.toDomainEventStream$default((Object)new MockAggregateCreated(string), (CommandMessage)((CommandMessage)new GivenInitializationCommand((AggregateId)aggregateId, null, null, false, false, null, 62, null)), (int)0, null, (int)4, null);
        StepVerifierExtensionsKt.test((Mono)this.getEventStore().append(eventStream)).verifyComplete();
        String string2 = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"generateAsString(...)");
        DomainEventStream changeStream = DomainEventStreamFactoryKt.toDomainEventStream$default((Object)new MockAggregateCreated(string2), (CommandMessage)((CommandMessage)new GivenInitializationCommand((AggregateId)aggregateId, null, null, false, false, null, 62, null)), (int)1, null, (int)4, null);
        StepVerifierExtensionsKt.test((Mono)this.getEventStore().append(changeStream)).verifyComplete();
        String string3 = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"generateAsString(...)");
        DomainEventStream conflictingStream = DomainEventStreamFactoryKt.toDomainEventStream$default((Object)new MockAggregateCreated(string3), (CommandMessage)((CommandMessage)new GivenInitializationCommand((AggregateId)aggregateId, null, null, false, false, null, 62, null)), (int)1, null, (int)4, null);
        StepVerifierExtensionsKt.test((Mono)this.getEventStore().append(conflictingStream)).expectErrorMatches(arg_0 -> EventStoreSpec.appendEventStreamWhenEventVersionConflict$lambda$5(conflictingStream, arg_0)).verify();
    }

    @Test
    public void appendEventStreamWhenDuplicateRequestIdException() {
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateAsString(...)");
        String requestId = string;
        DefaultAggregateId aggregateId = DefaultAggregateIdKt.aggregateId$default((NamedAggregate)this.namedAggregate, null, null, (int)3, null);
        String string2 = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"generateAsString(...)");
        DomainEventStream eventStream = DomainEventStreamFactoryKt.toDomainEventStream$default((Object)new MockAggregateCreated(string2), (CommandMessage)((CommandMessage)new GivenInitializationCommand((AggregateId)aggregateId, null, requestId, false, false, null, 58, null)), (int)0, null, (int)4, null);
        StepVerifierExtensionsKt.test((Mono)this.getEventStore().append(eventStream)).verifyComplete();
        String string3 = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"generateAsString(...)");
        DomainEventStream conflictingStream = DomainEventStreamFactoryKt.toDomainEventStream$default((Object)new MockAggregateCreated(string3), (CommandMessage)((CommandMessage)new GivenInitializationCommand((AggregateId)aggregateId, null, requestId, false, false, null, 58, null)), (int)1, null, (int)4, null);
        StepVerifierExtensionsKt.test((Mono)this.getEventStore().append(conflictingStream)).expectErrorMatches(arg_0 -> EventStoreSpec.appendEventStreamWhenDuplicateRequestIdException$lambda$6(conflictingStream, arg_0)).verify();
        StepVerifierExtensionsKt.test((Flux)EventStore.load$default((EventStore)this.getEventStore(), (AggregateId)((AggregateId)aggregateId), (int)0, (int)0, (int)6, null)).consumeNextWith(arg_0 -> EventStoreSpec.appendEventStreamWhenDuplicateRequestIdException$lambda$8(arg_0 -> EventStoreSpec.appendEventStreamWhenDuplicateRequestIdException$lambda$7(eventStream, arg_0), arg_0)).verifyComplete();
    }

    @Test
    public final void appendEventStreamWhenParallel() {
        EventStore eventStore = Metrics.INSTANCE.metrizable(this.createEventStore());
        Flux flux = Flux.range((int)0, (int)4000).parallel(16).runOn(Schedulers.parallel()).flatMap(arg_0 -> EventStoreSpec.appendEventStreamWhenParallel$lambda$10(arg_0 -> EventStoreSpec.appendEventStreamWhenParallel$lambda$9(eventStore, this, arg_0), arg_0)).sequential();
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"sequential(...)");
        StepVerifierExtensionsKt.test((Flux)flux).expectSubscription().expectNextCount(0L).verifyComplete();
    }

    @Test
    public final void loadEventStreamWhenParallel() {
        EventStore eventStore = Metrics.INSTANCE.metrizable(this.createEventStore());
        DomainEventStream eventStream = this.generateEventStream();
        StepVerifierExtensionsKt.test((Mono)eventStore.append(eventStream)).verifyComplete();
        Flux flux = Flux.range((int)0, (int)4000).parallel(16).runOn(Schedulers.parallel()).flatMap(arg_0 -> EventStoreSpec.loadEventStreamWhenParallel$lambda$12(arg_0 -> EventStoreSpec.loadEventStreamWhenParallel$lambda$11(eventStore, eventStream, arg_0), arg_0)).sequential();
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"sequential(...)");
        StepVerifierExtensionsKt.test((Flux)flux).expectSubscription().expectNextCount(4000L).verifyComplete();
    }

    @Test
    public final void loadEventStreamWhenNotFound() {
        EventStore eventStore = Metrics.INSTANCE.metrizable(this.createEventStore());
        StepVerifierExtensionsKt.test((Flux)EventStore.load$default((EventStore)eventStore, (AggregateId)((AggregateId)DefaultAggregateIdKt.aggregateId$default((NamedAggregate)this.namedAggregate, null, null, (int)3, null)), (int)0, (int)0, (int)6, null)).expectNextCount(0L).verifyComplete();
    }

    @Test
    public final void loadEventStreamGivenHeadVersion() {
        EventStore eventStore = Metrics.INSTANCE.metrizable(this.createEventStore());
        DomainEventStream eventStream = this.generateEventStream();
        StepVerifierExtensionsKt.test((Mono)eventStore.append(eventStream)).verifyComplete();
        int headVersion = 1;
        StepVerifierExtensionsKt.test((Flux)EventStore.load$default((EventStore)eventStore, (AggregateId)eventStream.getAggregateId(), (int)headVersion, (int)0, (int)4, null)).expectNextMatches(arg_0 -> EventStoreSpec.loadEventStreamGivenHeadVersion$lambda$14(arg_0 -> EventStoreSpec.loadEventStreamGivenHeadVersion$lambda$13(eventStream, arg_0), arg_0)).verifyComplete();
    }

    @Test
    public void loadEventStreamGivenWrongVersion() {
        EventStore eventStore = Metrics.INSTANCE.metrizable(this.createEventStore());
        DomainEventStream eventStream = this.generateEventStream();
        Assertions.assertThrows(IllegalArgumentException.class, () -> EventStoreSpec.loadEventStreamGivenWrongVersion$lambda$15(eventStore, eventStream));
        Assertions.assertThrows(IllegalArgumentException.class, () -> EventStoreSpec.loadEventStreamGivenWrongVersion$lambda$16(eventStore, eventStream));
    }

    @Test
    public void tailCursorId() {
        DomainEventStream eventStream = this.generateEventStream();
        StepVerifierExtensionsKt.test((Mono)this.getEventStore().append(eventStream)).verifyComplete();
        StepVerifierExtensionsKt.test((Mono)this.getEventStore().archiveAggregateId((NamedAggregate)eventStream.getAggregateId())).verifyComplete();
        StepVerifierExtensionsKt.test((Mono)this.getEventStore().tailCursorId(this.namedAggregate)).expectNext((Object)eventStream.getAggregateId().getId()).verifyComplete();
    }

    @Test
    public void archiveAggregateId() {
        DomainEventStream eventStream = this.generateEventStream();
        StepVerifierExtensionsKt.test((Mono)this.getEventStore().append(eventStream)).verifyComplete();
        StepVerifierExtensionsKt.test((Mono)this.getEventStore().archiveAggregateId((NamedAggregate)eventStream.getAggregateId(), "(0)")).verifyComplete();
    }

    @Test
    public void scanAggregateId() {
        DomainEventStream eventStream = this.generateEventStream();
        StepVerifierExtensionsKt.test((Mono)this.getEventStore().append(eventStream)).verifyComplete();
        DomainEventStream eventStream1 = this.generateEventStream();
        StepVerifierExtensionsKt.test((Mono)this.getEventStore().append(eventStream1)).verifyComplete();
        StepVerifierExtensionsKt.test((Flux)this.getEventStore().scanAggregateId((NamedAggregate)eventStream.getAggregateId(), eventStream.getAggregateId().getId(), 1)).expectNextCount(1L).verifyComplete();
        StepVerifierExtensionsKt.test((Flux)this.getEventStore().scanAggregateId((NamedAggregate)eventStream.getAggregateId(), eventStream1.getAggregateId().getId(), 1)).expectNextCount(0L).verifyComplete();
    }

    private static final boolean appendEventStream$lambda$0(DomainEventStream $eventStream, DomainEventStream it) {
        Intrinsics.checkNotNullParameter((Object)$eventStream, (String)"$eventStream");
        MatcherAssert.assertThat((Object)it.getAggregateId(), (Matcher)CoreMatchers.equalTo((Object)$eventStream.getAggregateId()));
        MatcherAssert.assertThat((Object)it.getVersion(), (Matcher)CoreMatchers.equalTo((Object)$eventStream.getVersion()));
        MatcherAssert.assertThat((Object)it.getSize(), (Matcher)CoreMatchers.equalTo((Object)$eventStream.getSize()));
        return true;
    }

    private static final boolean appendEventStream$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean appendEventStreamWhenDuplicateAggregateId$lambda$2(DomainEventStream $conflictingStream, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)$conflictingStream, (String)"$conflictingStream");
        MatcherAssert.assertThat((Object)it, (Matcher)CoreMatchers.instanceOf(DuplicateAggregateIdException.class));
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type me.ahoo.wow.eventsourcing.DuplicateAggregateIdException");
        DuplicateAggregateIdException conflictException = (DuplicateAggregateIdException)it;
        MatcherAssert.assertThat((Object)conflictException.getEventStream(), (Matcher)CoreMatchers.equalTo((Object)$conflictingStream));
        return true;
    }

    private static final Unit appendEventStreamWhenDuplicateAggregateId$lambda$3(DomainEventStream $eventStream, DomainEventStream it) {
        Intrinsics.checkNotNullParameter((Object)$eventStream, (String)"$eventStream");
        MatcherAssert.assertThat((Object)it.getSize(), (Matcher)CoreMatchers.equalTo((Object)$eventStream.getSize()));
        return Unit.INSTANCE;
    }

    private static final void appendEventStreamWhenDuplicateAggregateId$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean appendEventStreamWhenEventVersionConflict$lambda$5(DomainEventStream $conflictingStream, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)$conflictingStream, (String)"$conflictingStream");
        MatcherAssert.assertThat((Object)it, (Matcher)CoreMatchers.instanceOf(EventVersionConflictException.class));
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type me.ahoo.wow.eventsourcing.EventVersionConflictException");
        EventVersionConflictException conflictException = (EventVersionConflictException)it;
        MatcherAssert.assertThat((Object)conflictException.getEventStream(), (Matcher)CoreMatchers.equalTo((Object)$conflictingStream));
        return true;
    }

    private static final boolean appendEventStreamWhenDuplicateRequestIdException$lambda$6(DomainEventStream $conflictingStream, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)$conflictingStream, (String)"$conflictingStream");
        MatcherAssert.assertThat((Object)it, (Matcher)CoreMatchers.instanceOf(DuplicateRequestIdException.class));
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type me.ahoo.wow.command.DuplicateRequestIdException");
        DuplicateRequestIdException duplicateRequestIdException = (DuplicateRequestIdException)it;
        MatcherAssert.assertThat((Object)duplicateRequestIdException.getRequestId(), (Matcher)CoreMatchers.equalTo((Object)$conflictingStream.getRequestId()));
        return true;
    }

    private static final Unit appendEventStreamWhenDuplicateRequestIdException$lambda$7(DomainEventStream $eventStream, DomainEventStream it) {
        Intrinsics.checkNotNullParameter((Object)$eventStream, (String)"$eventStream");
        MatcherAssert.assertThat((Object)it.getSize(), (Matcher)CoreMatchers.equalTo((Object)$eventStream.getSize()));
        return Unit.INSTANCE;
    }

    private static final void appendEventStreamWhenDuplicateRequestIdException$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Publisher appendEventStreamWhenParallel$lambda$9(EventStore $eventStore, EventStoreSpec this$0, Integer it) {
        Intrinsics.checkNotNullParameter((Object)$eventStore, (String)"$eventStore");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return (Publisher)$eventStore.append(this$0.generateEventStream());
    }

    private static final Publisher appendEventStreamWhenParallel$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final Publisher loadEventStreamWhenParallel$lambda$11(EventStore $eventStore, DomainEventStream $eventStream, Integer it) {
        Intrinsics.checkNotNullParameter((Object)$eventStore, (String)"$eventStore");
        Intrinsics.checkNotNullParameter((Object)$eventStream, (String)"$eventStream");
        return (Publisher)EventStore.load$default((EventStore)$eventStore, (AggregateId)$eventStream.getAggregateId(), (int)0, (int)0, (int)6, null);
    }

    private static final Publisher loadEventStreamWhenParallel$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final boolean loadEventStreamGivenHeadVersion$lambda$13(DomainEventStream $eventStream, DomainEventStream actualStream) {
        Intrinsics.checkNotNullParameter((Object)$eventStream, (String)"$eventStream");
        Intrinsics.checkNotNullParameter((Object)actualStream, (String)"actualStream");
        MatcherAssert.assertThat((Object)actualStream.getAggregateId(), (Matcher)CoreMatchers.equalTo((Object)$eventStream.getAggregateId()));
        MatcherAssert.assertThat((Object)actualStream.getVersion(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)actualStream.getSize(), (Matcher)CoreMatchers.equalTo((Object)10));
        return true;
    }

    private static final boolean loadEventStreamGivenHeadVersion$lambda$14(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void loadEventStreamGivenWrongVersion$lambda$15(EventStore $eventStore, DomainEventStream $eventStream) {
        Intrinsics.checkNotNullParameter((Object)$eventStore, (String)"$eventStore");
        Intrinsics.checkNotNullParameter((Object)$eventStream, (String)"$eventStream");
        EventStore.load$default((EventStore)$eventStore, (AggregateId)$eventStream.getAggregateId(), (int)-1, (int)0, (int)4, null);
    }

    private static final void loadEventStreamGivenWrongVersion$lambda$16(EventStore $eventStore, DomainEventStream $eventStream) {
        Intrinsics.checkNotNullParameter((Object)$eventStore, (String)"$eventStore");
        Intrinsics.checkNotNullParameter((Object)$eventStream, (String)"$eventStream");
        $eventStore.load($eventStream.getAggregateId(), 5, 4);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lme/ahoo/wow/tck/eventsourcing/EventStoreSpec$Companion;", "", "<init>", "()V", "TIMES", "", "DEFAULT_PARALLELISM", "wow-tck"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

