/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.tck.prepare;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.wow.id.GlobalIdGenerator;
import me.ahoo.wow.infra.prepare.PrepareKey;
import me.ahoo.wow.infra.prepare.PrepareKeyFactory;
import me.ahoo.wow.infra.prepare.PreparedValue;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import reactor.core.publisher.Mono;
import reactor.kotlin.core.publisher.MonoExtensionsKt;
import reactor.kotlin.test.StepVerifierExtensionsKt;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH&J\r\u0010\u000f\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0013\u001a\u00020\u0014H\u0017J\b\u0010\u0015\u001a\u00020\u0014H\u0007J\b\u0010\u0016\u001a\u00020\u0014H\u0007J\b\u0010\u0017\u001a\u00020\u0014H\u0007J\b\u0010\u0018\u001a\u00020\u0014H\u0007J\b\u0010\u0019\u001a\u00020\u0014H\u0007J\b\u0010\u001a\u001a\u00020\u0014H\u0007J\b\u0010\u001b\u001a\u00020\u0014H\u0007J\b\u0010\u001c\u001a\u00020\u0014H\u0007J\b\u0010\u0007\u001a\u00020\u0014H\u0007R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lme/ahoo/wow/tck/prepare/PrepareKeySpec;", "V", "", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "valueType", "Ljava/lang/Class;", "getValueType", "()Ljava/lang/Class;", "createPrepareKeyFactory", "Lme/ahoo/wow/infra/prepare/PrepareKeyFactory;", "generateValue", "()Ljava/lang/Object;", "prepareKey", "Lme/ahoo/wow/infra/prepare/PrepareKey;", "setup", "", "prepare", "reprepare", "reprepareNewKey", "reprepareNewKeyNotFoundKey", "reprepareNewKeyEqKey", "prepareWithTtlAt", "rollback", "usingPrepare", "wow-tck"})
@SourceDebugExtension(value={"SMAP\nPrepareKeySpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrepareKeySpec.kt\nme/ahoo/wow/tck/prepare/PrepareKeySpec\n+ 2 Assertions.kt\norg/junit/jupiter/api/AssertionsKt\n*L\n1#1,258:1\n100#2,7:259\n*S KotlinDebug\n*F\n+ 1 PrepareKeySpec.kt\nme/ahoo/wow/tck/prepare/PrepareKeySpec\n*L\n179#1:259,7\n*E\n"})
public abstract class PrepareKeySpec<V> {
    private PrepareKey<V> prepareKey;

    @NotNull
    public abstract String getName();

    @NotNull
    public abstract Class<V> getValueType();

    @NotNull
    public abstract PrepareKeyFactory createPrepareKeyFactory();

    @NotNull
    public abstract V generateValue();

    @BeforeEach
    public void setup() {
        this.prepareKey = this.createPrepareKeyFactory().create(this.getName(), this.getValueType());
    }

    @Test
    public final void prepare() {
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateAsString(...)");
        String key = string;
        V value = this.generateValue();
        PrepareKey<V> prepareKey = this.prepareKey;
        if (prepareKey == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey.prepare(key, value)).expectNext((Object)true).verifyComplete();
        PrepareKey<V> prepareKey2 = this.prepareKey;
        if (prepareKey2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey2 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey2.prepare(key, value)).expectNext((Object)false).verifyComplete();
        PrepareKey<V> prepareKey3 = this.prepareKey;
        if (prepareKey3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey3 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey3.get(key)).expectNext(value).verifyComplete();
        PrepareKey<V> prepareKey4 = this.prepareKey;
        if (prepareKey4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey4 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey4.rollback(key)).expectNext((Object)true).verifyComplete();
        PrepareKey<V> prepareKey5 = this.prepareKey;
        if (prepareKey5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey5 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey5.get(key)).verifyComplete();
        PrepareKey<V> prepareKey6 = this.prepareKey;
        if (prepareKey6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey6 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey6.prepare(key, value)).expectNext((Object)true).verifyComplete();
        V newValue = this.generateValue();
        PrepareKey<V> prepareKey7 = this.prepareKey;
        if (prepareKey7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey7 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey7.reprepare(key, value, newValue)).expectNext((Object)true).verifyComplete();
        PrepareKey<V> prepareKey8 = this.prepareKey;
        if (prepareKey8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey8 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey8.get(key)).expectNext(newValue).verifyComplete();
        PrepareKey<V> prepareKey9 = this.prepareKey;
        if (prepareKey9 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey9 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey9.rollback(key)).expectNext((Object)true).verifyComplete();
    }

    @Test
    public final void reprepare() {
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateAsString(...)");
        String key = string;
        V value = this.generateValue();
        PrepareKey<V> prepareKey = this.prepareKey;
        if (prepareKey == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey.prepare(key, value)).expectNext((Object)true).verifyComplete();
        PrepareKey<V> prepareKey2 = this.prepareKey;
        if (prepareKey2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey2 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey2.get(key)).expectNext(value).verifyComplete();
        V newValue = this.generateValue();
        PrepareKey<V> prepareKey3 = this.prepareKey;
        if (prepareKey3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey3 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey3.reprepare(key, value, newValue)).expectNext((Object)true).verifyComplete();
        PrepareKey<V> prepareKey4 = this.prepareKey;
        if (prepareKey4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey4 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey4.get(key)).expectNext(newValue).verifyComplete();
        V newValue2 = this.generateValue();
        PrepareKey<V> prepareKey5 = this.prepareKey;
        if (prepareKey5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey5 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey5.reprepare(key, value, newValue2)).expectNext((Object)false).verifyComplete();
        PrepareKey<V> prepareKey6 = this.prepareKey;
        if (prepareKey6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey6 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey6.reprepare(key, newValue2)).expectNext((Object)true).verifyComplete();
        PrepareKey<V> prepareKey7 = this.prepareKey;
        if (prepareKey7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey7 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey7.get(key)).expectNext(newValue2).verifyComplete();
        PrepareKey<V> prepareKey8 = this.prepareKey;
        if (prepareKey8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey8 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey8.rollback(key)).expectNext((Object)true).verifyComplete();
    }

    @Test
    public final void reprepareNewKey() {
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateAsString(...)");
        String oldKey = string;
        V oldValue = this.generateValue();
        String string2 = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"generateAsString(...)");
        String key = string2;
        V value = this.generateValue();
        PrepareKey<V> prepareKey = this.prepareKey;
        if (prepareKey == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey.prepare(oldKey, oldValue)).expectNext((Object)true).verifyComplete();
        PrepareKey<V> prepareKey2 = this.prepareKey;
        if (prepareKey2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey2 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey2.reprepare(oldKey, oldValue, key, value)).expectNext((Object)true).verifyComplete();
        PrepareKey<V> prepareKey3 = this.prepareKey;
        if (prepareKey3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey3 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey3.get(key)).expectNext(value).verifyComplete();
        PrepareKey<V> prepareKey4 = this.prepareKey;
        if (prepareKey4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey4 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey4.reprepare(oldKey, oldValue, key, value)).expectNext((Object)false).verifyComplete();
    }

    @Test
    public final void reprepareNewKeyNotFoundKey() {
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateAsString(...)");
        String key = string;
        V value = this.generateValue();
        String string2 = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"generateAsString(...)");
        String notFoundKey = string2;
        PrepareKey<V> prepareKey = this.prepareKey;
        if (prepareKey == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey.reprepare(notFoundKey, value, key, value)).expectError(IllegalStateException.class).verify();
        PrepareKey<V> prepareKey2 = this.prepareKey;
        if (prepareKey2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey2 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey2.getValue(key)).verifyComplete();
    }

    @Test
    public final void reprepareNewKeyEqKey() {
        Throwable throwable;
        Throwable throwable2;
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateAsString(...)");
        String key = string;
        V value = this.generateValue();
        boolean $i$f$assertThrows = false;
        try {
            boolean bl = false;
            PrepareKey<V> prepareKey = this.prepareKey;
            if (prepareKey == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
                prepareKey = null;
            }
            prepareKey.reprepare(key, value, key, value);
            throwable2 = Unit.INSTANCE;
        }
        catch (Throwable caught$iv) {
            throwable2 = caught$iv;
        }
        if (!((throwable = throwable2) instanceof Throwable)) {
            throwable = null;
        }
        Throwable throwable$iv = throwable;
        Intrinsics.checkExpressionValueIsNotNull((Object)Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(throwable$iv){
            final /* synthetic */ Throwable $throwable;
            {
                this.$throwable = throwable;
            }

            public final void execute() {
                if (this.$throwable != null) {
                    throw this.$throwable;
                }
            }
        }), (String)"Assertions.assertThrows(\u2026throwable\n        }\n    }");
    }

    @Test
    public final void prepareWithTtlAt() {
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateAsString(...)");
        String key = string;
        Duration expireAfter = Duration.ofSeconds(2L);
        long ttlAt = System.currentTimeMillis() + expireAfter.toMillis();
        PreparedValue preparedValue = PreparedValue.Companion.toTtlAt(this.generateValue(), ttlAt);
        PrepareKey<V> prepareKey = this.prepareKey;
        if (prepareKey == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey.prepare(key, preparedValue)).expectNext((Object)true).verifyComplete();
        Thread.sleep(expireAfter.toMillis());
        PrepareKey<V> prepareKey2 = this.prepareKey;
        if (prepareKey2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey2 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey2.get(key)).verifyComplete();
        long ttlAt2 = System.currentTimeMillis() + expireAfter.toMillis();
        PreparedValue preparedValue2 = PreparedValue.Companion.toTtlAt(this.generateValue(), ttlAt2);
        PrepareKey<V> prepareKey3 = this.prepareKey;
        if (prepareKey3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey3 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey3.prepare(key, preparedValue2)).expectNext((Object)true).verifyComplete();
        PrepareKey<V> prepareKey4 = this.prepareKey;
        if (prepareKey4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey4 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey4.get(key)).expectNext(preparedValue2.getValue()).verifyComplete();
    }

    @Test
    public final void rollback() {
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateAsString(...)");
        String key = string;
        V value = this.generateValue();
        PrepareKey<V> prepareKey = this.prepareKey;
        if (prepareKey == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey.prepare(key, value)).expectNext((Object)true).verifyComplete();
        PrepareKey<V> prepareKey2 = this.prepareKey;
        if (prepareKey2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey2 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey2.rollback(key, value)).expectNext((Object)true).verifyComplete();
        PrepareKey<V> prepareKey3 = this.prepareKey;
        if (prepareKey3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey3 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey3.prepare(key, value)).expectNext((Object)true).verifyComplete();
        V otherValue = this.generateValue();
        PrepareKey<V> prepareKey4 = this.prepareKey;
        if (prepareKey4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey4 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey4.rollback(key, otherValue)).expectNext((Object)false).verifyComplete();
        PrepareKey<V> prepareKey5 = this.prepareKey;
        if (prepareKey5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey5 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey5.rollback(key, value)).expectNext((Object)true).verifyComplete();
    }

    @Test
    public final void usingPrepare() {
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateAsString(...)");
        String key = string;
        V value = this.generateValue();
        PrepareKey<V> prepareKey = this.prepareKey;
        if (prepareKey == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey.usingPrepare(key, value, PrepareKeySpec::usingPrepare$lambda$1)).expectError(RuntimeException.class).verify();
        PrepareKey<V> prepareKey2 = this.prepareKey;
        if (prepareKey2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey2 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey2.get(key)).verifyComplete();
    }

    @Test
    public final void getName() {
        PrepareKey<V> prepareKey = this.prepareKey;
        if (prepareKey == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey = null;
        }
        MatcherAssert.assertThat((Object)prepareKey.getName(), (Matcher)Matchers.equalTo((Object)this.getName()));
    }

    private static final Mono usingPrepare$lambda$1(boolean it) {
        if (!it) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return MonoExtensionsKt.toMono((Throwable)new RuntimeException());
    }
}

