/*
 * Copyright [2021-present] [ahoo wang <ahoowang@qq.com> (https://github.com/Ahoo-Wang)].
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package me.ahoo.wow.tck.container

import org.testcontainers.elasticsearch.ElasticsearchContainer
import org.testcontainers.utility.DockerImageName

object ElasticsearchLauncher {
    const val ELASTIC_PWD = "wow"
    val ELASTICSEARCH_CONTAINER: ElasticsearchContainer = ElasticsearchContainer(
        DockerImageName
            .parse("docker.elastic.co/elasticsearch/elasticsearch")
            .withTag("8.7.1"),
    )
        .withPassword(ELASTIC_PWD)
        .withNetworkAliases("elasticsearch")
        .withReuse(true)

    init {
        ELASTICSEARCH_CONTAINER.start()
    }

    val isRunning = ELASTICSEARCH_CONTAINER.isRunning
}
