/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.tck.prepare;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.id.GlobalIdGenerator;
import me.ahoo.wow.infra.prepare.PrepareKey;
import me.ahoo.wow.infra.prepare.PrepareKeyFactory;
import me.ahoo.wow.infra.prepare.PreparedValue;
import me.ahoo.wow.tck.prepare.PrepareKeySpec;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import reactor.core.publisher.Mono;
import reactor.kotlin.test.StepVerifierExtensionsKt;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u000e\u001a\u00020\u000fH&J\r\u0010\u0010\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0006\u001a\u00020\u0012H\u0007J\b\u0010\u0013\u001a\u00020\u0012H\u0007J\b\u0010\u0014\u001a\u00020\u0012H\u0007J\b\u0010\u0015\u001a\u00020\u0012H\u0007J\b\u0010\u0016\u001a\u00020\u0012H\u0007J\b\u0010\u0017\u001a\u00020\u0012H\u0017J\b\u0010\u0018\u001a\u00020\u0012H\u0007R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lme/ahoo/wow/tck/prepare/PrepareKeySpec;", "V", "", "()V", "name", "", "getName", "()Ljava/lang/String;", "prepareKey", "Lme/ahoo/wow/infra/prepare/PrepareKey;", "valueType", "Ljava/lang/Class;", "getValueType", "()Ljava/lang/Class;", "createPrepareKeyFactory", "Lme/ahoo/wow/infra/prepare/PrepareKeyFactory;", "generateValue", "()Ljava/lang/Object;", "", "prepare", "prepareWithTtlAt", "reprepare", "rollback", "setup", "usingPrepare", "wow-tck"})
public abstract class PrepareKeySpec<V> {
    private PrepareKey<V> prepareKey;

    @NotNull
    public abstract String getName();

    @NotNull
    public abstract Class<V> getValueType();

    @NotNull
    public abstract PrepareKeyFactory createPrepareKeyFactory();

    @NotNull
    public abstract V generateValue();

    @BeforeEach
    public void setup() {
        this.prepareKey = this.createPrepareKeyFactory().create(this.getName(), this.getValueType());
    }

    @Test
    public final void prepare() {
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateAsString(...)");
        String key = string;
        V value = this.generateValue();
        PrepareKey<V> prepareKey = this.prepareKey;
        if (prepareKey == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey.prepare(key, value)).expectNext((Object)true).verifyComplete();
        PrepareKey<V> prepareKey2 = this.prepareKey;
        if (prepareKey2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey2 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey2.prepare(key, value)).expectNext((Object)false).verifyComplete();
        PrepareKey<V> prepareKey3 = this.prepareKey;
        if (prepareKey3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey3 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey3.get(key)).expectNext(value).verifyComplete();
        PrepareKey<V> prepareKey4 = this.prepareKey;
        if (prepareKey4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey4 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey4.rollback(key)).expectNext((Object)true).verifyComplete();
        PrepareKey<V> prepareKey5 = this.prepareKey;
        if (prepareKey5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey5 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey5.get(key)).verifyComplete();
        PrepareKey<V> prepareKey6 = this.prepareKey;
        if (prepareKey6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey6 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey6.prepare(key, value)).expectNext((Object)true).verifyComplete();
        V newValue = this.generateValue();
        PrepareKey<V> prepareKey7 = this.prepareKey;
        if (prepareKey7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey7 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey7.reprepare(key, value, newValue)).expectNext((Object)true).verifyComplete();
        PrepareKey<V> prepareKey8 = this.prepareKey;
        if (prepareKey8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey8 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey8.get(key)).expectNext(newValue).verifyComplete();
        PrepareKey<V> prepareKey9 = this.prepareKey;
        if (prepareKey9 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey9 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey9.rollback(key)).expectNext((Object)true).verifyComplete();
    }

    @Test
    public final void reprepare() {
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateAsString(...)");
        String key = string;
        V value = this.generateValue();
        PrepareKey<V> prepareKey = this.prepareKey;
        if (prepareKey == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey.prepare(key, value)).expectNext((Object)true).verifyComplete();
        PrepareKey<V> prepareKey2 = this.prepareKey;
        if (prepareKey2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey2 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey2.get(key)).expectNext(value).verifyComplete();
        V newValue = this.generateValue();
        PrepareKey<V> prepareKey3 = this.prepareKey;
        if (prepareKey3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey3 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey3.reprepare(key, value, newValue)).expectNext((Object)true).verifyComplete();
        PrepareKey<V> prepareKey4 = this.prepareKey;
        if (prepareKey4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey4 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey4.get(key)).expectNext(newValue).verifyComplete();
        V newValue2 = this.generateValue();
        PrepareKey<V> prepareKey5 = this.prepareKey;
        if (prepareKey5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey5 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey5.reprepare(key, value, newValue2)).expectNext((Object)false).verifyComplete();
        PrepareKey<V> prepareKey6 = this.prepareKey;
        if (prepareKey6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey6 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey6.reprepare(key, newValue2)).expectNext((Object)true).verifyComplete();
        PrepareKey<V> prepareKey7 = this.prepareKey;
        if (prepareKey7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey7 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey7.get(key)).expectNext(newValue2).verifyComplete();
        PrepareKey<V> prepareKey8 = this.prepareKey;
        if (prepareKey8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey8 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey8.rollback(key)).expectNext((Object)true).verifyComplete();
    }

    @Test
    public final void prepareWithTtlAt() {
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateAsString(...)");
        String key = string;
        Duration expireAfter = Duration.ofSeconds(2L);
        long ttlAt = System.currentTimeMillis() + expireAfter.toMillis();
        PreparedValue preparedValue = PreparedValue.Companion.asTtlAt(this.generateValue(), ttlAt);
        PrepareKey<V> prepareKey = this.prepareKey;
        if (prepareKey == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey.prepare(key, preparedValue)).expectNext((Object)true).verifyComplete();
        Thread.sleep(expireAfter.toMillis());
        PrepareKey<V> prepareKey2 = this.prepareKey;
        if (prepareKey2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey2 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey2.get(key)).verifyComplete();
        long ttlAt2 = System.currentTimeMillis() + expireAfter.toMillis();
        PreparedValue preparedValue2 = PreparedValue.Companion.asTtlAt(this.generateValue(), ttlAt2);
        PrepareKey<V> prepareKey3 = this.prepareKey;
        if (prepareKey3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey3 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey3.prepare(key, preparedValue2)).expectNext((Object)true).verifyComplete();
        PrepareKey<V> prepareKey4 = this.prepareKey;
        if (prepareKey4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey4 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey4.get(key)).expectNext(preparedValue2.getValue()).verifyComplete();
    }

    @Test
    public final void rollback() {
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateAsString(...)");
        String key = string;
        V value = this.generateValue();
        PrepareKey<V> prepareKey = this.prepareKey;
        if (prepareKey == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey.prepare(key, value)).expectNext((Object)true).verifyComplete();
        PrepareKey<V> prepareKey2 = this.prepareKey;
        if (prepareKey2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey2 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey2.rollback(key, value)).expectNext((Object)true).verifyComplete();
        PrepareKey<V> prepareKey3 = this.prepareKey;
        if (prepareKey3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey3 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey3.prepare(key, value)).expectNext((Object)true).verifyComplete();
        V otherValue = this.generateValue();
        PrepareKey<V> prepareKey4 = this.prepareKey;
        if (prepareKey4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey4 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey4.rollback(key, otherValue)).expectNext((Object)false).verifyComplete();
        PrepareKey<V> prepareKey5 = this.prepareKey;
        if (prepareKey5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey5 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey5.rollback(key, value)).expectNext((Object)true).verifyComplete();
    }

    @Test
    public final void usingPrepare() {
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateAsString(...)");
        String key = string;
        V value = this.generateValue();
        PrepareKey<V> prepareKey = this.prepareKey;
        if (prepareKey == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey.usingPrepare(key, value, (Function1)usingPrepare.1.INSTANCE)).expectError(RuntimeException.class).verify();
        PrepareKey<V> prepareKey2 = this.prepareKey;
        if (prepareKey2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey2 = null;
        }
        StepVerifierExtensionsKt.test((Mono)prepareKey2.get(key)).verifyComplete();
    }

    @Test
    public final void getName() {
        PrepareKey<V> prepareKey = this.prepareKey;
        if (prepareKey == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prepareKey");
            prepareKey = null;
        }
        MatcherAssert.assertThat((Object)prepareKey.getName(), (Matcher)Matchers.equalTo((Object)this.getName()));
    }
}

