/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.tck.modeling.state;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.wow.api.modeling.AggregateId;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.command.CommandMessage;
import me.ahoo.wow.event.DomainEvent;
import me.ahoo.wow.event.DomainEventStream;
import me.ahoo.wow.event.DomainEventStreamFactoryKt;
import me.ahoo.wow.eventsourcing.EventStore;
import me.ahoo.wow.eventsourcing.InMemoryEventStore;
import me.ahoo.wow.id.GlobalIdGenerator;
import me.ahoo.wow.modeling.DefaultAggregateId;
import me.ahoo.wow.modeling.DefaultAggregateIdKt;
import me.ahoo.wow.modeling.MaterializedNamedAggregateKt;
import me.ahoo.wow.modeling.annotation.AggregateMetadataParserKt;
import me.ahoo.wow.modeling.matedata.AggregateMetadata;
import me.ahoo.wow.modeling.matedata.StateAggregateMetadata;
import me.ahoo.wow.modeling.state.ConstructorStateAggregateFactory;
import me.ahoo.wow.modeling.state.StateAggregate;
import me.ahoo.wow.modeling.state.StateAggregateFactory;
import me.ahoo.wow.modeling.state.StateAggregateRepository;
import me.ahoo.wow.tck.mock.MockAggregateChanged;
import me.ahoo.wow.tck.mock.MockCommandAggregate;
import me.ahoo.wow.tck.mock.MockStateAggregate;
import me.ahoo.wow.tck.modeling.state.StateAggregateRepositorySpec;
import me.ahoo.wow.test.aggregate.GivenInitializationCommand;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import reactor.core.publisher.Mono;
import reactor.kotlin.test.StepVerifierExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH$J\b\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u000f\u001a\u00020\u000eH\u0007J\b\u0010\u0010\u001a\u00020\u000eH\u0007J\b\u0010\u0011\u001a\u00020\u000eH\u0007R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lme/ahoo/wow/tck/modeling/state/StateAggregateRepositorySpec;", "", "()V", "aggregateMetadata", "Lme/ahoo/wow/modeling/matedata/AggregateMetadata;", "Lme/ahoo/wow/tck/mock/MockCommandAggregate;", "Lme/ahoo/wow/tck/mock/MockStateAggregate;", "createStateAggregateRepository", "Lme/ahoo/wow/modeling/state/StateAggregateRepository;", "aggregateFactory", "Lme/ahoo/wow/modeling/state/StateAggregateFactory;", "eventStore", "Lme/ahoo/wow/eventsourcing/EventStore;", "load", "", "loadWhenAggregateTypeNull", "loadWhenInitializedAndNoneEvent", "loadWhenNotFound", "Companion", "wow-tck"})
@SourceDebugExtension(value={"SMAP\nStateAggregateRepositorySpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StateAggregateRepositorySpec.kt\nme/ahoo/wow/tck/modeling/state/StateAggregateRepositorySpec\n+ 2 AggregateMetadataParser.kt\nme/ahoo/wow/modeling/annotation/AggregateMetadataParserKt\n*L\n1#1,121:1\n139#2:122\n*S KotlinDebug\n*F\n+ 1 StateAggregateRepositorySpec.kt\nme/ahoo/wow/tck/modeling/state/StateAggregateRepositorySpec\n*L\n42#1:122\n*E\n"})
public abstract class StateAggregateRepositorySpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AggregateMetadata<MockCommandAggregate, MockStateAggregate> aggregateMetadata;
    @NotNull
    private static final StateAggregateFactory TEST_AGGREGATE_FACTORY = (StateAggregateFactory)ConstructorStateAggregateFactory.INSTANCE;
    @NotNull
    private static final EventStore TEST_EVENT_STORE = (EventStore)new InMemoryEventStore();

    public StateAggregateRepositorySpec() {
        boolean $i$f$aggregateMetadata = false;
        this.aggregateMetadata = AggregateMetadataParserKt.asAggregateMetadata(MockCommandAggregate.class);
    }

    @NotNull
    protected abstract StateAggregateRepository createStateAggregateRepository(@NotNull StateAggregateFactory var1, @NotNull EventStore var2);

    @Test
    public final void load() {
        StateAggregateRepository aggregateRepository = this.createStateAggregateRepository(TEST_AGGREGATE_FACTORY, TEST_EVENT_STORE);
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateAsString(...)");
        DefaultAggregateId aggregateId = DefaultAggregateIdKt.asAggregateId$default(this.aggregateMetadata, (String)string, null, (int)2, null);
        GivenInitializationCommand command = new GivenInitializationCommand((AggregateId)aggregateId, null, null, false, false, null, 62, null);
        String string2 = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"generateAsString(...)");
        MockAggregateChanged stateChanged = new MockAggregateChanged(string2);
        DomainEventStream eventStream2 = DomainEventStreamFactoryKt.asDomainEventStream$default((Object)stateChanged, (CommandMessage)((CommandMessage)command), (int)0, null, (int)4, null);
        TEST_EVENT_STORE.append(eventStream2).block();
        Object object = aggregateRepository.load(this.aggregateMetadata.getState(), (AggregateId)aggregateId).block();
        Intrinsics.checkNotNull((Object)object);
        StateAggregate stateAggregate = (StateAggregate)object;
        MatcherAssert.assertThat((Object)stateAggregate, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)stateAggregate.getAggregateId(), (Matcher)Matchers.equalTo((Object)aggregateId));
        Object e = eventStream2.iterator().next();
        Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type me.ahoo.wow.event.DomainEvent<me.ahoo.wow.tck.mock.MockAggregateChanged>");
        DomainEvent domainEventMessage = (DomainEvent)e;
        MatcherAssert.assertThat((Object)stateAggregate.getVersion(), (Matcher)Matchers.equalTo((Object)domainEventMessage.getVersion()));
        MatcherAssert.assertThat((Object)((MockStateAggregate)stateAggregate.getState()).getData(), (Matcher)Matchers.equalTo((Object)((MockAggregateChanged)domainEventMessage.getBody()).getData()));
    }

    @Test
    public final void loadWhenNotFound() {
        StateAggregateRepository aggregateRepository = this.createStateAggregateRepository(TEST_AGGREGATE_FACTORY, TEST_EVENT_STORE);
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateAsString(...)");
        DefaultAggregateId aggregateId = DefaultAggregateIdKt.asAggregateId$default(this.aggregateMetadata, (String)string, null, (int)2, null);
        StepVerifierExtensionsKt.test((Mono)aggregateRepository.load((AggregateId)aggregateId)).consumeNextWith(arg_0 -> StateAggregateRepositorySpec.loadWhenNotFound$lambda$0(loadWhenNotFound.1.INSTANCE, arg_0)).verifyComplete();
    }

    @Test
    public final void loadWhenAggregateTypeNull() {
        StateAggregateRepository aggregateRepository = this.createStateAggregateRepository(TEST_AGGREGATE_FACTORY, TEST_EVENT_STORE);
        NamedAggregate namedAggregate = (NamedAggregate)MaterializedNamedAggregateKt.asNamedAggregate$default((String)"test.test", null, (int)1, null);
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateAsString(...)");
        DefaultAggregateId aggregateId = DefaultAggregateIdKt.asAggregateId$default((NamedAggregate)namedAggregate, (String)string, null, (int)2, null);
        Assertions.assertThrows(IllegalStateException.class, () -> StateAggregateRepositorySpec.loadWhenAggregateTypeNull$lambda$1(aggregateRepository, aggregateId));
    }

    @Test
    public final void loadWhenInitializedAndNoneEvent() {
        StateAggregateFactory stateAggregateFactory2 = new StateAggregateFactory(this){
            final /* synthetic */ StateAggregateRepositorySpec this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public <S> Mono<StateAggregate<S>> create(@NotNull StateAggregateMetadata<S> metadata, @NotNull AggregateId aggregateId) {
                Intrinsics.checkNotNullParameter(metadata, (String)"metadata");
                Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
                MockStateAggregate stateRoot = new MockStateAggregate(aggregateId.getId());
                StateAggregate stateAggregate = StateAggregate.Companion.asStateAggregate$default((StateAggregate.Companion)StateAggregate.Companion, (AggregateMetadata)StateAggregateRepositorySpec.access$getAggregateMetadata$p(this.this$0), (Object)stateRoot, (int)1, null, null, null, (long)0L, (long)0L, (boolean)false, (int)252, null);
                Intrinsics.checkNotNull((Object)stateAggregate, (String)"null cannot be cast to non-null type me.ahoo.wow.modeling.state.StateAggregate<S of me.ahoo.wow.tck.modeling.state.StateAggregateRepositorySpec.loadWhenInitializedAndNoneEvent.<no name provided>.create>");
                Mono mono = Mono.just((Object)stateAggregate);
                Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"just(...)");
                return mono;
            }
        };
        StateAggregateRepository aggregateRepository = this.createStateAggregateRepository(stateAggregateFactory2, TEST_EVENT_STORE);
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateAsString(...)");
        DefaultAggregateId aggregateId = DefaultAggregateIdKt.asAggregateId$default(this.aggregateMetadata, (String)string, null, (int)2, null);
        StepVerifierExtensionsKt.test((Mono)aggregateRepository.load(this.aggregateMetadata.getState(), (AggregateId)aggregateId)).assertNext(arg_0 -> StateAggregateRepositorySpec.loadWhenInitializedAndNoneEvent$lambda$2(loadWhenInitializedAndNoneEvent.1.INSTANCE, arg_0)).verifyComplete();
    }

    private static final void loadWhenNotFound$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void loadWhenAggregateTypeNull$lambda$1(StateAggregateRepository $aggregateRepository, DefaultAggregateId $aggregateId) {
        Intrinsics.checkNotNullParameter((Object)$aggregateRepository, (String)"$aggregateRepository");
        Intrinsics.checkNotNullParameter((Object)$aggregateId, (String)"$aggregateId");
        $aggregateRepository.load((AggregateId)$aggregateId);
    }

    private static final void loadWhenInitializedAndNoneEvent$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ AggregateMetadata access$getAggregateMetadata$p(StateAggregateRepositorySpec $this) {
        return $this.aggregateMetadata;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lme/ahoo/wow/tck/modeling/state/StateAggregateRepositorySpec$Companion;", "", "()V", "TEST_AGGREGATE_FACTORY", "Lme/ahoo/wow/modeling/state/StateAggregateFactory;", "getTEST_AGGREGATE_FACTORY", "()Lme/ahoo/wow/modeling/state/StateAggregateFactory;", "TEST_EVENT_STORE", "Lme/ahoo/wow/eventsourcing/EventStore;", "getTEST_EVENT_STORE", "()Lme/ahoo/wow/eventsourcing/EventStore;", "wow-tck"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final StateAggregateFactory getTEST_AGGREGATE_FACTORY() {
            return TEST_AGGREGATE_FACTORY;
        }

        @NotNull
        protected final EventStore getTEST_EVENT_STORE() {
            return TEST_EVENT_STORE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

