/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.tck.eventsourcing.snapshot;

import java.time.Clock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.modeling.AggregateId;
import me.ahoo.wow.command.CommandMessage;
import me.ahoo.wow.event.DomainEventStream;
import me.ahoo.wow.event.DomainEventStreamFactoryKt;
import me.ahoo.wow.eventsourcing.snapshot.SimpleSnapshot;
import me.ahoo.wow.eventsourcing.snapshot.Snapshot;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotRepository;
import me.ahoo.wow.id.GlobalIdGenerator;
import me.ahoo.wow.metrics.Metrics;
import me.ahoo.wow.modeling.DefaultAggregateId;
import me.ahoo.wow.modeling.DefaultAggregateIdKt;
import me.ahoo.wow.modeling.matedata.AggregateMetadata;
import me.ahoo.wow.modeling.matedata.StateAggregateMetadata;
import me.ahoo.wow.modeling.state.ConstructorStateAggregateFactory;
import me.ahoo.wow.modeling.state.ReadOnlyStateAggregate;
import me.ahoo.wow.modeling.state.StateAggregate;
import me.ahoo.wow.modeling.state.StateAggregateFactory;
import me.ahoo.wow.tck.mock.MockAggregateChanged;
import me.ahoo.wow.tck.mock.MockAggregateCreated;
import me.ahoo.wow.tck.mock.MockAggregateKt;
import me.ahoo.wow.tck.mock.MockCommandAggregate;
import me.ahoo.wow.tck.mock.MockStateAggregate;
import me.ahoo.wow.test.aggregate.GivenInitializationCommand;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import reactor.core.publisher.Mono;
import reactor.kotlin.test.StepVerifierExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH$J\b\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u000f\u001a\u00020\u000eH\u0007J\b\u0010\u0010\u001a\u00020\u000eH\u0007J\b\u0010\u0011\u001a\u00020\u000eH\u0017R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lme/ahoo/wow/tck/eventsourcing/snapshot/SnapshotRepositorySpec;", "", "()V", "aggregateMetadata", "Lme/ahoo/wow/modeling/matedata/AggregateMetadata;", "Lme/ahoo/wow/tck/mock/MockCommandAggregate;", "Lme/ahoo/wow/tck/mock/MockStateAggregate;", "getAggregateMetadata", "()Lme/ahoo/wow/modeling/matedata/AggregateMetadata;", "stateAggregateFactory", "Lme/ahoo/wow/modeling/state/StateAggregateFactory;", "createSnapshotRepository", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotRepository;", "load", "", "loadWhenNotFound", "save", "saveTwice", "wow-tck"})
public abstract class SnapshotRepositorySpec {
    @NotNull
    private final AggregateMetadata<MockCommandAggregate, MockStateAggregate> aggregateMetadata = MockAggregateKt.getMOCK_AGGREGATE_METADATA();
    @NotNull
    private final StateAggregateFactory stateAggregateFactory = (StateAggregateFactory)ConstructorStateAggregateFactory.INSTANCE;

    @NotNull
    protected final AggregateMetadata<MockCommandAggregate, MockStateAggregate> getAggregateMetadata() {
        return this.aggregateMetadata;
    }

    @NotNull
    protected abstract SnapshotRepository createSnapshotRepository();

    @Test
    public final void load() {
        SnapshotRepository snapshotRepository = Metrics.INSTANCE.metrizable(this.createSnapshotRepository());
        StateAggregateMetadata stateAggregateMetadata = this.aggregateMetadata.getState();
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateAsString(...)");
        Object object = this.stateAggregateFactory.create(stateAggregateMetadata, (AggregateId)DefaultAggregateIdKt.asAggregateId$default(this.aggregateMetadata, (String)string, null, (int)2, null)).block();
        Intrinsics.checkNotNull((Object)object);
        StateAggregate stateAggregate = (StateAggregate)object;
        GivenInitializationCommand command = new GivenInitializationCommand(stateAggregate.getAggregateId(), null, null, false, false, null, 62, null);
        MatcherAssert.assertThat((Object)stateAggregate, (Matcher)Matchers.notNullValue());
        String string2 = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"generateAsString(...)");
        MockAggregateCreated aggregateCreated = new MockAggregateCreated(string2);
        String string3 = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"generateAsString(...)");
        MockAggregateChanged changed = new MockAggregateChanged(string3);
        Object[] objectArray = new Object[]{aggregateCreated, changed};
        DomainEventStream eventStream2 = DomainEventStreamFactoryKt.asDomainEventStream$default((Object)CollectionsKt.listOf((Object[])objectArray), (CommandMessage)((CommandMessage)command), (int)stateAggregate.getVersion(), null, (int)4, null);
        stateAggregate.onSourcing(eventStream2);
        SimpleSnapshot snapshot = new SimpleSnapshot((ReadOnlyStateAggregate)stateAggregate, Clock.systemUTC().millis());
        StepVerifierExtensionsKt.test((Mono)snapshotRepository.save((Snapshot)snapshot)).verifyComplete();
        StepVerifierExtensionsKt.test((Mono)snapshotRepository.load(stateAggregate.getAggregateId())).consumeNextWith(arg_0 -> SnapshotRepositorySpec.load$lambda$0((Function1)new Function1<Snapshot<MockStateAggregate>, Unit>((StateAggregate<MockStateAggregate>)stateAggregate){
            final /* synthetic */ StateAggregate<MockStateAggregate> $stateAggregate;
            {
                this.$stateAggregate = $stateAggregate;
                super(1);
            }

            public final void invoke(Snapshot<MockStateAggregate> it) {
                MatcherAssert.assertThat((Object)it.getAggregateId(), (Matcher)Matchers.equalTo((Object)this.$stateAggregate.getAggregateId()));
                MatcherAssert.assertThat((Object)it.getVersion(), (Matcher)Matchers.equalTo((Object)this.$stateAggregate.getVersion()));
                MatcherAssert.assertThat((Object)((MockStateAggregate)it.getState()).getData(), (Matcher)Matchers.equalTo((Object)((MockStateAggregate)this.$stateAggregate.getState()).getData()));
            }
        }, arg_0)).verifyComplete();
    }

    @Test
    public final void loadWhenNotFound() {
        SnapshotRepository snapshotRepository = Metrics.INSTANCE.metrizable(this.createSnapshotRepository());
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateAsString(...)");
        DefaultAggregateId aggregateId = DefaultAggregateIdKt.asAggregateId$default(this.aggregateMetadata, (String)string, null, (int)2, null);
        StepVerifierExtensionsKt.test((Mono)snapshotRepository.load((AggregateId)aggregateId)).expectNextCount(0L).verifyComplete();
    }

    @Test
    public final void save() {
        SnapshotRepository snapshotRepository = Metrics.INSTANCE.metrizable(this.createSnapshotRepository());
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateAsString(...)");
        DefaultAggregateId aggregateId = DefaultAggregateIdKt.asAggregateId$default(this.aggregateMetadata, (String)string, null, (int)2, null);
        Object object = this.stateAggregateFactory.create(this.aggregateMetadata.getState(), (AggregateId)aggregateId).block();
        Intrinsics.checkNotNull((Object)object);
        StateAggregate stateAggregate = (StateAggregate)object;
        Snapshot snapshot = (Snapshot)new SimpleSnapshot((ReadOnlyStateAggregate)stateAggregate, Clock.systemUTC().millis());
        StepVerifierExtensionsKt.test((Mono)snapshotRepository.save(snapshot)).verifyComplete();
    }

    @Test
    public void saveTwice() {
        SnapshotRepository snapshotRepository = Metrics.INSTANCE.metrizable(this.createSnapshotRepository());
        StateAggregateMetadata stateAggregateMetadata = this.aggregateMetadata.getState();
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateAsString(...)");
        Object object = this.stateAggregateFactory.create(stateAggregateMetadata, (AggregateId)DefaultAggregateIdKt.asAggregateId$default(this.aggregateMetadata, (String)string, null, (int)2, null)).block();
        Intrinsics.checkNotNull((Object)object);
        StateAggregate stateAggregate = (StateAggregate)object;
        GivenInitializationCommand command = new GivenInitializationCommand(stateAggregate.getAggregateId(), null, null, false, false, null, 62, null);
        MatcherAssert.assertThat((Object)stateAggregate, (Matcher)Matchers.notNullValue());
        String string2 = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"generateAsString(...)");
        MockAggregateCreated aggregateCreated = new MockAggregateCreated(string2);
        String string3 = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"generateAsString(...)");
        MockAggregateChanged changed = new MockAggregateChanged(string3);
        Object[] objectArray = new Object[]{aggregateCreated, changed};
        DomainEventStream eventStream2 = DomainEventStreamFactoryKt.asDomainEventStream$default((Object)CollectionsKt.listOf((Object[])objectArray), (CommandMessage)((CommandMessage)command), (int)stateAggregate.getVersion(), null, (int)4, null);
        stateAggregate.onSourcing(eventStream2);
        SimpleSnapshot snapshot = new SimpleSnapshot((ReadOnlyStateAggregate)stateAggregate, Clock.systemUTC().millis());
        StepVerifierExtensionsKt.test((Mono)snapshotRepository.save((Snapshot)snapshot)).verifyComplete();
        Object[] objectArray2 = new Object[]{aggregateCreated, changed};
        DomainEventStream eventStream22 = DomainEventStreamFactoryKt.asDomainEventStream$default((Object)CollectionsKt.listOf((Object[])objectArray2), (CommandMessage)((CommandMessage)command), (int)stateAggregate.getVersion(), null, (int)4, null);
        stateAggregate.onSourcing(eventStream22);
        StepVerifierExtensionsKt.test((Mono)snapshotRepository.save((Snapshot)snapshot)).verifyComplete();
        StepVerifierExtensionsKt.test((Mono)snapshotRepository.load(stateAggregate.getAggregateId())).consumeNextWith(arg_0 -> SnapshotRepositorySpec.saveTwice$lambda$1((Function1)new Function1<Snapshot<MockStateAggregate>, Unit>((StateAggregate<MockStateAggregate>)stateAggregate){
            final /* synthetic */ StateAggregate<MockStateAggregate> $stateAggregate;
            {
                this.$stateAggregate = $stateAggregate;
                super(1);
            }

            public final void invoke(Snapshot<MockStateAggregate> it) {
                MatcherAssert.assertThat((Object)it.getAggregateId(), (Matcher)Matchers.equalTo((Object)this.$stateAggregate.getAggregateId()));
                MatcherAssert.assertThat((Object)it.getVersion(), (Matcher)Matchers.equalTo((Object)this.$stateAggregate.getVersion()));
                MatcherAssert.assertThat((Object)((MockStateAggregate)it.getState()).getData(), (Matcher)Matchers.equalTo((Object)((MockStateAggregate)this.$stateAggregate.getState()).getData()));
            }
        }, arg_0)).verifyComplete();
    }

    private static final void load$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void saveTwice$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

