/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.tck.command;

import jakarta.validation.Validator;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.wow.api.messaging.TopicKind;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.command.CommandBus;
import me.ahoo.wow.command.CommandFactoryKt;
import me.ahoo.wow.command.CommandGateway;
import me.ahoo.wow.command.CommandMessage;
import me.ahoo.wow.command.DefaultCommandGateway;
import me.ahoo.wow.command.ServerCommandExchange;
import me.ahoo.wow.command.validation.NoOpValidator;
import me.ahoo.wow.command.wait.CommandStage;
import me.ahoo.wow.command.wait.CommandWaitEndpoint;
import me.ahoo.wow.command.wait.SimpleCommandWaitEndpoint;
import me.ahoo.wow.command.wait.SimpleWaitSignal;
import me.ahoo.wow.command.wait.SimpleWaitStrategyRegistrar;
import me.ahoo.wow.command.wait.WaitSignal;
import me.ahoo.wow.command.wait.WaitStrategyRegistrar;
import me.ahoo.wow.configuration.MetadataSearcherKt;
import me.ahoo.wow.id.GlobalIdGenerator;
import me.ahoo.wow.infra.idempotency.BloomFilterIdempotencyChecker;
import me.ahoo.wow.infra.idempotency.IdempotencyChecker;
import me.ahoo.wow.tck.command.CommandGatewaySpec;
import me.ahoo.wow.tck.messaging.MessageBusSpec;
import me.ahoo.wow.tck.mock.MockCreateAggregate;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import reactor.core.publisher.Mono;
import reactor.kotlin.test.StepVerifierExtensionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u00002\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0016\u001a\u00020\u0017H$J\f\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0014J\b\u0010\u0019\u001a\u00020\u0004H\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0007J\b\u0010\u001c\u001a\u00020\u001bH\u0007J\b\u0010\u001d\u001a\u00020\u001bH\u0007J\b\u0010\u001e\u001a\u00020\u001bH\u0007R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001f"}, d2={"Lme/ahoo/wow/tck/command/CommandGatewaySpec;", "Lme/ahoo/wow/tck/messaging/MessageBusSpec;", "Lme/ahoo/wow/command/CommandMessage;", "Lme/ahoo/wow/command/ServerCommandExchange;", "Lme/ahoo/wow/command/CommandGateway;", "()V", "idempotencyChecker", "Lme/ahoo/wow/infra/idempotency/IdempotencyChecker;", "getIdempotencyChecker", "()Lme/ahoo/wow/infra/idempotency/IdempotencyChecker;", "namedAggregate", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "getNamedAggregate", "()Lme/ahoo/wow/api/modeling/NamedAggregate;", "topicKind", "Lme/ahoo/wow/api/messaging/TopicKind;", "getTopicKind", "()Lme/ahoo/wow/api/messaging/TopicKind;", "waitStrategyRegistrar", "Lme/ahoo/wow/command/wait/SimpleWaitStrategyRegistrar;", "getWaitStrategyRegistrar", "()Lme/ahoo/wow/command/wait/SimpleWaitStrategyRegistrar;", "createCommandBus", "Lme/ahoo/wow/command/CommandBus;", "createMessage", "createMessageBus", "sendAndWaitForProcessed", "", "sendAndWaitForSent", "sendGivenDuplicate", "sendThenWaitingForAggregate", "wow-tck"})
@SourceDebugExtension(value={"SMAP\nCommandGatewaySpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandGatewaySpec.kt\nme/ahoo/wow/tck/command/CommandGatewaySpec\n+ 2 MetadataSearcher.kt\nme/ahoo/wow/configuration/MetadataSearcherKt\n*L\n1#1,140:1\n113#2:141\n*S KotlinDebug\n*F\n+ 1 CommandGatewaySpec.kt\nme/ahoo/wow/tck/command/CommandGatewaySpec\n*L\n49#1:141\n*E\n"})
public abstract class CommandGatewaySpec
extends MessageBusSpec<CommandMessage<?>, ServerCommandExchange<?>, CommandGateway> {
    @NotNull
    private final SimpleWaitStrategyRegistrar waitStrategyRegistrar = SimpleWaitStrategyRegistrar.INSTANCE;
    @NotNull
    private final IdempotencyChecker idempotencyChecker;

    public CommandGatewaySpec() {
        Duration duration2 = Duration.ofSeconds(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
        this.idempotencyChecker = (IdempotencyChecker)new BloomFilterIdempotencyChecker(duration2, (Function0)idempotencyChecker.1.INSTANCE);
    }

    @NotNull
    public TopicKind getTopicKind() {
        return TopicKind.COMMAND;
    }

    @Override
    @NotNull
    public NamedAggregate getNamedAggregate() {
        boolean $i$f$requiredNamedAggregate = false;
        return MetadataSearcherKt.asRequiredNamedAggregate(MockCreateAggregate.class);
    }

    @Override
    @NotNull
    protected CommandMessage<?> createMessage() {
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateAsString(...)");
        String string2 = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"generateAsString(...)");
        return CommandFactoryKt.asCommandMessage$default((Object)new MockCreateAggregate(string, string2), null, null, null, null, null, null, null, (long)0L, (int)255, null);
    }

    @NotNull
    protected final SimpleWaitStrategyRegistrar getWaitStrategyRegistrar() {
        return this.waitStrategyRegistrar;
    }

    @NotNull
    protected final IdempotencyChecker getIdempotencyChecker() {
        return this.idempotencyChecker;
    }

    @NotNull
    protected abstract CommandBus createCommandBus();

    @Override
    @NotNull
    protected CommandGateway createMessageBus() {
        return (CommandGateway)new DefaultCommandGateway((CommandWaitEndpoint)new SimpleCommandWaitEndpoint(""), this.createCommandBus(), this.idempotencyChecker, (WaitStrategyRegistrar)this.waitStrategyRegistrar, (Validator)NoOpValidator.INSTANCE);
    }

    @Test
    public final void sendAndWaitForSent() {
        CommandMessage<?> message = this.createMessage();
        this.verify((Function1)new Function1<CommandGateway, Unit>(message){
            final /* synthetic */ CommandMessage<?> $message;
            {
                this.$message = $message;
                super(1);
            }

            public final void invoke(@NotNull CommandGateway $this$verify) {
                Intrinsics.checkNotNullParameter((Object)$this$verify, (String)"$this$verify");
                StepVerifierExtensionsKt.test((Mono)$this$verify.sendAndWaitForSent(this.$message)).expectNextCount(1L).verifyComplete();
            }
        });
    }

    @Test
    public final void sendAndWaitForProcessed() {
        CommandMessage<?> message = this.createMessage();
        this.verify((Function1)new Function1<CommandGateway, Unit>(message){
            final /* synthetic */ CommandMessage<?> $message;
            {
                this.$message = $message;
                super(1);
            }

            public final void invoke(@NotNull CommandGateway $this$verify) {
                Intrinsics.checkNotNullParameter((Object)$this$verify, (String)"$this$verify");
                Mono mono = $this$verify.sendAndWaitForProcessed(this.$message).timeout(Duration.ofMillis(100L));
                Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"timeout(...)");
                StepVerifierExtensionsKt.test((Mono)mono).verifyTimeout(Duration.ofMillis(150L));
            }
        });
    }

    @Test
    public final void sendGivenDuplicate() {
        CommandMessage<?> message = this.createMessage();
        this.verify((Function1)new Function1<CommandGateway, Unit>(message){
            final /* synthetic */ CommandMessage<?> $message;
            {
                this.$message = $message;
                super(1);
            }

            public final void invoke(@NotNull CommandGateway $this$verify) {
                Intrinsics.checkNotNullParameter((Object)$this$verify, (String)"$this$verify");
                StepVerifierExtensionsKt.test((Mono)$this$verify.sendAndWaitForSent(this.$message)).expectNextCount(1L).verifyComplete();
                StepVerifierExtensionsKt.test((Mono)$this$verify.sendAndWaitForSent(this.$message)).consumeNextWith(arg_0 -> sendGivenDuplicate.1.invoke$lambda$0(sendGivenDuplicate.1.INSTANCE, arg_0)).verifyComplete();
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        });
    }

    @Test
    public final void sendThenWaitingForAggregate() {
        CommandMessage<?> message = this.createMessage();
        this.verify((Function1)new Function1<CommandGateway, Unit>(message, this){
            final /* synthetic */ CommandMessage<?> $message;
            final /* synthetic */ CommandGatewaySpec this$0;
            {
                this.$message = $message;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull CommandGateway $this$verify) {
                Intrinsics.checkNotNullParameter((Object)$this$verify, (String)"$this$verify");
                Mono mono = $this$verify.sendAndWaitForProcessed(this.$message).doOnRequest(arg_0 -> sendThenWaitingForAggregate.1.invoke$lambda$1(this.this$0, this.$message, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doOnRequest(...)");
                StepVerifierExtensionsKt.test((Mono)mono).expectNextCount(1L).verifyComplete();
            }

            private static final Boolean invoke$lambda$1$lambda$0(CommandGatewaySpec this$0, CommandMessage $message) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
                return this$0.getWaitStrategyRegistrar().next((WaitSignal)new SimpleWaitSignal($message.getCommandId(), CommandStage.PROCESSED, $message.getContextName(), "", false, null, null, 112, null));
            }

            private static final void invoke$lambda$1(CommandGatewaySpec this$0, CommandMessage $message, long it) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
                Mono.fromCallable(() -> sendThenWaitingForAggregate.1.invoke$lambda$1$lambda$0(this$0, $message)).delaySubscription(Duration.ofMillis(10L)).subscribe();
            }
        });
    }
}

