/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.tck.eventsourcing;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.modeling.AggregateId;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.command.CommandMessage;
import me.ahoo.wow.command.DuplicateRequestIdException;
import me.ahoo.wow.configuration.MetadataSearcherKt;
import me.ahoo.wow.event.DomainEventStream;
import me.ahoo.wow.event.DomainEventStreamFactoryKt;
import me.ahoo.wow.eventsourcing.DuplicateAggregateIdException;
import me.ahoo.wow.eventsourcing.EventStore;
import me.ahoo.wow.eventsourcing.EventVersionConflictException;
import me.ahoo.wow.id.GlobalIdGenerator;
import me.ahoo.wow.metrics.Metrics;
import me.ahoo.wow.modeling.DefaultAggregateId;
import me.ahoo.wow.modeling.DefaultAggregateIdKt;
import me.ahoo.wow.tck.event.MockDomainEventStreams;
import me.ahoo.wow.tck.metrics.LoggingMeterRegistryInitializer;
import me.ahoo.wow.tck.mock.MockAggregateCreated;
import me.ahoo.wow.test.aggregate.GivenInitializationCommand;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.kotlin.test.StepVerifierExtensionsKt;

@ExtendWith(value={LoggingMeterRegistryInitializer.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b'\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u000f\u001a\u00020\u000eH\u0007J\b\u0010\u0010\u001a\u00020\u000eH\u0017J\b\u0010\u0011\u001a\u00020\u000eH\u0007J\b\u0010\u0012\u001a\u00020\u000eH\u0007J\b\u0010\u0013\u001a\u00020\u0004H$J\b\u0010\u0014\u001a\u00020\u0015H\u0004J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0004J\b\u0010\u0018\u001a\u00020\u000eH\u0007J\b\u0010\u0019\u001a\u00020\u000eH\u0017J\b\u0010\u001a\u001a\u00020\u000eH\u0007J\b\u0010\u001b\u001a\u00020\u000eH\u0007J\b\u0010\u001c\u001a\u00020\u000eH\u0017J\b\u0010\u001d\u001a\u00020\u000eH\u0017R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Lme/ahoo/wow/tck/eventsourcing/EventStoreSpec;", "", "()V", "eventStore", "Lme/ahoo/wow/eventsourcing/EventStore;", "getEventStore", "()Lme/ahoo/wow/eventsourcing/EventStore;", "setEventStore", "(Lme/ahoo/wow/eventsourcing/EventStore;)V", "namedAggregate", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "getNamedAggregate", "()Lme/ahoo/wow/api/modeling/NamedAggregate;", "appendEventStream", "", "appendEventStreamWhenDuplicateAggregateId", "appendEventStreamWhenDuplicateRequestIdException", "appendEventStreamWhenEventVersionConflict", "appendEventStreamWhenParallel", "createEventStore", "generateEventStream", "Lme/ahoo/wow/event/DomainEventStream;", "aggregateId", "Lme/ahoo/wow/api/modeling/AggregateId;", "loadEventStreamGivenHeadVersion", "loadEventStreamGivenWrongVersion", "loadEventStreamWhenNotFound", "loadEventStreamWhenParallel", "scanAggregateId", "setup", "Companion", "wow-tck"})
public abstract class EventStoreSpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NamedAggregate namedAggregate = MetadataSearcherKt.asRequiredNamedAggregate(EventStoreSpec.class);
    public EventStore eventStore;
    public static final int TIMES = 4000;
    public static final int DEFAULT_PARALLELISM = 16;

    @NotNull
    public final NamedAggregate getNamedAggregate() {
        return this.namedAggregate;
    }

    @NotNull
    public final EventStore getEventStore() {
        EventStore eventStore = this.eventStore;
        if (eventStore != null) {
            return eventStore;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"eventStore");
        return null;
    }

    public final void setEventStore(@NotNull EventStore eventStore) {
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"<set-?>");
        this.eventStore = eventStore;
    }

    @BeforeEach
    public void setup() {
        this.setEventStore(Metrics.INSTANCE.metrizable(this.createEventStore()));
    }

    @NotNull
    protected abstract EventStore createEventStore();

    @NotNull
    protected final DomainEventStream generateEventStream(@NotNull AggregateId aggregateId) {
        Intrinsics.checkNotNullParameter((Object)aggregateId, (String)"aggregateId");
        return MockDomainEventStreams.generateEventStream$default(MockDomainEventStreams.INSTANCE, aggregateId, 0, 10, null, null, 26, null);
    }

    @NotNull
    protected final DomainEventStream generateEventStream() {
        return this.generateEventStream((AggregateId)DefaultAggregateIdKt.asAggregateId$default((NamedAggregate)this.namedAggregate, null, null, (int)3, null));
    }

    @Test
    public final void appendEventStream() {
        DomainEventStream eventStream2 = this.generateEventStream();
        MatcherAssert.assertThat((Object)CollectionsKt.count((Iterable)((Iterable)eventStream2)), (Matcher)CoreMatchers.equalTo((Object)eventStream2.getSize()));
        StepVerifierExtensionsKt.test((Mono)this.getEventStore().append(eventStream2)).verifyComplete();
        StepVerifierExtensionsKt.test((Flux)EventStore.load$default((EventStore)this.getEventStore(), (AggregateId)eventStream2.getAggregateId(), (int)0, (int)0, (int)6, null)).expectNextMatches(arg_0 -> EventStoreSpec.appendEventStream$lambda$0((Function1)new Function1<DomainEventStream, Boolean>(eventStream2){
            final /* synthetic */ DomainEventStream $eventStream;
            {
                this.$eventStream = $eventStream;
                super(1);
            }

            @NotNull
            public final Boolean invoke(DomainEventStream it) {
                MatcherAssert.assertThat((Object)it.getAggregateId(), (Matcher)CoreMatchers.equalTo((Object)this.$eventStream.getAggregateId()));
                MatcherAssert.assertThat((Object)it.getVersion(), (Matcher)CoreMatchers.equalTo((Object)this.$eventStream.getVersion()));
                MatcherAssert.assertThat((Object)it.getSize(), (Matcher)CoreMatchers.equalTo((Object)this.$eventStream.getSize()));
                return true;
            }
        }, arg_0)).verifyComplete();
    }

    @Test
    public final void appendEventStreamWhenDuplicateAggregateId() {
        EventStore eventStore = Metrics.INSTANCE.metrizable(this.createEventStore());
        DefaultAggregateId aggregateId = DefaultAggregateIdKt.asAggregateId$default((NamedAggregate)this.namedAggregate, null, null, (int)3, null);
        DomainEventStream eventStream2 = this.generateEventStream((AggregateId)aggregateId);
        StepVerifierExtensionsKt.test((Mono)eventStore.append(eventStream2)).verifyComplete();
        DomainEventStream conflictingStream = this.generateEventStream((AggregateId)aggregateId);
        StepVerifierExtensionsKt.test((Mono)eventStore.append(conflictingStream)).expectErrorMatches(arg_0 -> EventStoreSpec.appendEventStreamWhenDuplicateAggregateId$lambda$1(conflictingStream, arg_0)).verify();
        StepVerifierExtensionsKt.test((Flux)EventStore.load$default((EventStore)eventStore, (AggregateId)((AggregateId)aggregateId), (int)0, (int)0, (int)6, null)).consumeNextWith(arg_0 -> EventStoreSpec.appendEventStreamWhenDuplicateAggregateId$lambda$2((Function1)new Function1<DomainEventStream, Unit>(eventStream2){
            final /* synthetic */ DomainEventStream $eventStream;
            {
                this.$eventStream = $eventStream;
                super(1);
            }

            public final void invoke(DomainEventStream it) {
                MatcherAssert.assertThat((Object)it.getSize(), (Matcher)CoreMatchers.equalTo((Object)this.$eventStream.getSize()));
            }
        }, arg_0)).verifyComplete();
    }

    @Test
    public final void appendEventStreamWhenEventVersionConflict() {
        DefaultAggregateId aggregateId = DefaultAggregateIdKt.asAggregateId$default((NamedAggregate)this.namedAggregate, null, null, (int)3, null);
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GlobalIdGenerator.generateAsString()");
        DomainEventStream eventStream2 = DomainEventStreamFactoryKt.asDomainEventStream$default((Object)new MockAggregateCreated(string), (CommandMessage)((CommandMessage)new GivenInitializationCommand((AggregateId)aggregateId, null, null, false, false, null, 62, null)), (int)0, null, (int)4, null);
        StepVerifierExtensionsKt.test((Mono)this.getEventStore().append(eventStream2)).verifyComplete();
        String string2 = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GlobalIdGenerator.generateAsString()");
        DomainEventStream changeStream = DomainEventStreamFactoryKt.asDomainEventStream$default((Object)new MockAggregateCreated(string2), (CommandMessage)((CommandMessage)new GivenInitializationCommand((AggregateId)aggregateId, null, null, false, false, null, 62, null)), (int)1, null, (int)4, null);
        StepVerifierExtensionsKt.test((Mono)this.getEventStore().append(changeStream)).verifyComplete();
        String string3 = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"GlobalIdGenerator.generateAsString()");
        DomainEventStream conflictingStream = DomainEventStreamFactoryKt.asDomainEventStream$default((Object)new MockAggregateCreated(string3), (CommandMessage)((CommandMessage)new GivenInitializationCommand((AggregateId)aggregateId, null, null, false, false, null, 62, null)), (int)1, null, (int)4, null);
        StepVerifierExtensionsKt.test((Mono)this.getEventStore().append(conflictingStream)).expectErrorMatches(arg_0 -> EventStoreSpec.appendEventStreamWhenEventVersionConflict$lambda$3(conflictingStream, arg_0)).verify();
    }

    @Test
    public void appendEventStreamWhenDuplicateRequestIdException() {
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GlobalIdGenerator.generateAsString()");
        String requestId = string;
        DefaultAggregateId aggregateId = DefaultAggregateIdKt.asAggregateId$default((NamedAggregate)this.namedAggregate, null, null, (int)3, null);
        String string2 = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GlobalIdGenerator.generateAsString()");
        DomainEventStream eventStream2 = DomainEventStreamFactoryKt.asDomainEventStream$default((Object)new MockAggregateCreated(string2), (CommandMessage)((CommandMessage)new GivenInitializationCommand((AggregateId)aggregateId, null, requestId, false, false, null, 58, null)), (int)0, null, (int)4, null);
        StepVerifierExtensionsKt.test((Mono)this.getEventStore().append(eventStream2)).verifyComplete();
        String string3 = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"GlobalIdGenerator.generateAsString()");
        DomainEventStream conflictingStream = DomainEventStreamFactoryKt.asDomainEventStream$default((Object)new MockAggregateCreated(string3), (CommandMessage)((CommandMessage)new GivenInitializationCommand((AggregateId)aggregateId, null, requestId, false, false, null, 58, null)), (int)1, null, (int)4, null);
        StepVerifierExtensionsKt.test((Mono)this.getEventStore().append(conflictingStream)).expectErrorMatches(arg_0 -> EventStoreSpec.appendEventStreamWhenDuplicateRequestIdException$lambda$4(conflictingStream, arg_0)).verify();
        StepVerifierExtensionsKt.test((Flux)EventStore.load$default((EventStore)this.getEventStore(), (AggregateId)((AggregateId)aggregateId), (int)0, (int)0, (int)6, null)).consumeNextWith(arg_0 -> EventStoreSpec.appendEventStreamWhenDuplicateRequestIdException$lambda$5((Function1)new Function1<DomainEventStream, Unit>(eventStream2){
            final /* synthetic */ DomainEventStream $eventStream;
            {
                this.$eventStream = $eventStream;
                super(1);
            }

            public final void invoke(DomainEventStream it) {
                MatcherAssert.assertThat((Object)it.getSize(), (Matcher)CoreMatchers.equalTo((Object)this.$eventStream.getSize()));
            }
        }, arg_0)).verifyComplete();
    }

    @Test
    public final void appendEventStreamWhenParallel() {
        EventStore eventStore = Metrics.INSTANCE.metrizable(this.createEventStore());
        Flux flux = Flux.range((int)0, (int)4000).parallel(16).runOn(Schedulers.parallel()).flatMap(arg_0 -> EventStoreSpec.appendEventStreamWhenParallel$lambda$6((Function1)new Function1<Integer, Publisher<? extends Void>>(eventStore, this){
            final /* synthetic */ EventStore $eventStore;
            final /* synthetic */ EventStoreSpec this$0;
            {
                this.$eventStore = $eventStore;
                this.this$0 = $receiver;
                super(1);
            }

            public final Publisher<? extends Void> invoke(Integer it) {
                return (Publisher)this.$eventStore.append(this.this$0.generateEventStream());
            }
        }, arg_0)).sequential();
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"@Test\n    fun appendEven\u2026  .verifyComplete()\n    }");
        StepVerifierExtensionsKt.test((Flux)flux).expectSubscription().expectNextCount(0L).verifyComplete();
    }

    @Test
    public final void loadEventStreamWhenParallel() {
        EventStore eventStore = Metrics.INSTANCE.metrizable(this.createEventStore());
        DomainEventStream eventStream2 = this.generateEventStream();
        StepVerifierExtensionsKt.test((Mono)eventStore.append(eventStream2)).verifyComplete();
        Flux flux = Flux.range((int)0, (int)4000).parallel(16).runOn(Schedulers.parallel()).flatMap(arg_0 -> EventStoreSpec.loadEventStreamWhenParallel$lambda$7((Function1)new Function1<Integer, Publisher<? extends DomainEventStream>>(eventStore, eventStream2){
            final /* synthetic */ EventStore $eventStore;
            final /* synthetic */ DomainEventStream $eventStream;
            {
                this.$eventStore = $eventStore;
                this.$eventStream = $eventStream;
                super(1);
            }

            public final Publisher<? extends DomainEventStream> invoke(Integer it) {
                return (Publisher)EventStore.load$default((EventStore)this.$eventStore, (AggregateId)this.$eventStream.getAggregateId(), (int)0, (int)0, (int)6, null);
            }
        }, arg_0)).sequential();
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"eventStore = createEvent\u2026            .sequential()");
        StepVerifierExtensionsKt.test((Flux)flux).expectSubscription().expectNextCount(4000L).verifyComplete();
    }

    @Test
    public final void loadEventStreamWhenNotFound() {
        EventStore eventStore = Metrics.INSTANCE.metrizable(this.createEventStore());
        StepVerifierExtensionsKt.test((Flux)EventStore.load$default((EventStore)eventStore, (AggregateId)((AggregateId)DefaultAggregateIdKt.asAggregateId$default((NamedAggregate)this.namedAggregate, null, null, (int)3, null)), (int)0, (int)0, (int)6, null)).expectNextCount(0L).verifyComplete();
    }

    @Test
    public final void loadEventStreamGivenHeadVersion() {
        EventStore eventStore = Metrics.INSTANCE.metrizable(this.createEventStore());
        DomainEventStream eventStream2 = this.generateEventStream();
        StepVerifierExtensionsKt.test((Mono)eventStore.append(eventStream2)).verifyComplete();
        int headVersion = 1;
        StepVerifierExtensionsKt.test((Flux)EventStore.load$default((EventStore)eventStore, (AggregateId)eventStream2.getAggregateId(), (int)headVersion, (int)0, (int)4, null)).expectNextMatches(arg_0 -> EventStoreSpec.loadEventStreamGivenHeadVersion$lambda$8((Function1)new Function1<DomainEventStream, Boolean>(eventStream2){
            final /* synthetic */ DomainEventStream $eventStream;
            {
                this.$eventStream = $eventStream;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull DomainEventStream actualStream) {
                Intrinsics.checkNotNullParameter((Object)actualStream, (String)"actualStream");
                MatcherAssert.assertThat((Object)actualStream.getAggregateId(), (Matcher)CoreMatchers.equalTo((Object)this.$eventStream.getAggregateId()));
                MatcherAssert.assertThat((Object)actualStream.getVersion(), (Matcher)CoreMatchers.equalTo((Object)1));
                MatcherAssert.assertThat((Object)actualStream.getSize(), (Matcher)CoreMatchers.equalTo((Object)10));
                return true;
            }
        }, arg_0)).verifyComplete();
    }

    @Test
    public void loadEventStreamGivenWrongVersion() {
        EventStore eventStore = Metrics.INSTANCE.metrizable(this.createEventStore());
        DomainEventStream eventStream2 = this.generateEventStream();
        Assertions.assertThrows(IllegalArgumentException.class, () -> EventStoreSpec.loadEventStreamGivenWrongVersion$lambda$9(eventStore, eventStream2));
        Assertions.assertThrows(IllegalArgumentException.class, () -> EventStoreSpec.loadEventStreamGivenWrongVersion$lambda$10(eventStore, eventStream2));
    }

    @Test
    public void scanAggregateId() {
        DomainEventStream eventStream2 = this.generateEventStream();
        StepVerifierExtensionsKt.test((Mono)this.getEventStore().append(eventStream2)).verifyComplete();
        DomainEventStream eventStream1 = this.generateEventStream();
        StepVerifierExtensionsKt.test((Mono)this.getEventStore().append(eventStream1)).verifyComplete();
        StepVerifierExtensionsKt.test((Flux)this.getEventStore().scanAggregateId((NamedAggregate)eventStream2.getAggregateId(), eventStream2.getAggregateId().getId(), 1)).expectNextCount(1L).verifyComplete();
        StepVerifierExtensionsKt.test((Flux)this.getEventStore().scanAggregateId((NamedAggregate)eventStream2.getAggregateId(), eventStream1.getAggregateId().getId(), 1)).expectNextCount(0L).verifyComplete();
    }

    private static final boolean appendEventStream$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean appendEventStreamWhenDuplicateAggregateId$lambda$1(DomainEventStream $conflictingStream, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)$conflictingStream, (String)"$conflictingStream");
        MatcherAssert.assertThat((Object)it, (Matcher)CoreMatchers.instanceOf(DuplicateAggregateIdException.class));
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type me.ahoo.wow.eventsourcing.DuplicateAggregateIdException");
        DuplicateAggregateIdException conflictException = (DuplicateAggregateIdException)it;
        MatcherAssert.assertThat((Object)conflictException.getEventStream(), (Matcher)CoreMatchers.equalTo((Object)$conflictingStream));
        return true;
    }

    private static final void appendEventStreamWhenDuplicateAggregateId$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean appendEventStreamWhenEventVersionConflict$lambda$3(DomainEventStream $conflictingStream, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)$conflictingStream, (String)"$conflictingStream");
        MatcherAssert.assertThat((Object)it, (Matcher)CoreMatchers.instanceOf(EventVersionConflictException.class));
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type me.ahoo.wow.eventsourcing.EventVersionConflictException");
        EventVersionConflictException conflictException = (EventVersionConflictException)it;
        MatcherAssert.assertThat((Object)conflictException.getEventStream(), (Matcher)CoreMatchers.equalTo((Object)$conflictingStream));
        return true;
    }

    private static final boolean appendEventStreamWhenDuplicateRequestIdException$lambda$4(DomainEventStream $conflictingStream, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)$conflictingStream, (String)"$conflictingStream");
        MatcherAssert.assertThat((Object)it, (Matcher)CoreMatchers.instanceOf(DuplicateRequestIdException.class));
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type me.ahoo.wow.command.DuplicateRequestIdException");
        DuplicateRequestIdException duplicateRequestIdException = (DuplicateRequestIdException)it;
        MatcherAssert.assertThat((Object)duplicateRequestIdException.getRequestId(), (Matcher)CoreMatchers.equalTo((Object)$conflictingStream.getRequestId()));
        return true;
    }

    private static final void appendEventStreamWhenDuplicateRequestIdException$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Publisher appendEventStreamWhenParallel$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final Publisher loadEventStreamWhenParallel$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final boolean loadEventStreamGivenHeadVersion$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void loadEventStreamGivenWrongVersion$lambda$9(EventStore $eventStore, DomainEventStream $eventStream) {
        Intrinsics.checkNotNullParameter((Object)$eventStore, (String)"$eventStore");
        Intrinsics.checkNotNullParameter((Object)$eventStream, (String)"$eventStream");
        EventStore.load$default((EventStore)$eventStore, (AggregateId)$eventStream.getAggregateId(), (int)-1, (int)0, (int)4, null);
    }

    private static final void loadEventStreamGivenWrongVersion$lambda$10(EventStore $eventStore, DomainEventStream $eventStream) {
        Intrinsics.checkNotNullParameter((Object)$eventStore, (String)"$eventStore");
        Intrinsics.checkNotNullParameter((Object)$eventStream, (String)"$eventStream");
        $eventStore.load($eventStream.getAggregateId(), 5, 4);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/wow/tck/eventsourcing/EventStoreSpec$Companion;", "", "()V", "DEFAULT_PARALLELISM", "", "TIMES", "wow-tck"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

