/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.tck.eventsourcing.snapshot;

import java.time.Clock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.ahoo.wow.api.command.CommandMessage;
import me.ahoo.wow.api.modeling.AggregateId;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.event.DomainEventStream;
import me.ahoo.wow.event.DomainEventStreamKt;
import me.ahoo.wow.eventsourcing.snapshot.SimpleSnapshot;
import me.ahoo.wow.eventsourcing.snapshot.Snapshot;
import me.ahoo.wow.eventsourcing.snapshot.SnapshotRepository;
import me.ahoo.wow.id.GlobalIdGenerator;
import me.ahoo.wow.metrics.Metrics;
import me.ahoo.wow.modeling.DefaultAggregateId;
import me.ahoo.wow.modeling.DefaultAggregateIdKt;
import me.ahoo.wow.modeling.annotation.AggregateMetadataParserKt;
import me.ahoo.wow.modeling.matedata.AggregateMetadata;
import me.ahoo.wow.modeling.matedata.StateAggregateMetadata;
import me.ahoo.wow.modeling.state.ConstructorStateAggregateFactory;
import me.ahoo.wow.modeling.state.StateAggregate;
import me.ahoo.wow.modeling.state.StateAggregateFactory;
import me.ahoo.wow.tck.modeling.AggregateChanged;
import me.ahoo.wow.tck.modeling.AggregateCreated;
import me.ahoo.wow.tck.modeling.MockAggregate;
import me.ahoo.wow.test.aggregate.GivenInitializationCommand;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.kotlin.test.StepVerifierExtensionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH$J\b\u0010\f\u001a\u00020\rH\u0007J\b\u0010\u000e\u001a\u00020\rH\u0007J\b\u0010\u000f\u001a\u00020\rH\u0007J\b\u0010\u0010\u001a\u00020\rH\u0017J\b\u0010\u0011\u001a\u00020\rH\u0017R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lme/ahoo/wow/tck/eventsourcing/snapshot/SnapshotRepositorySpec;", "", "()V", "aggregateMetadata", "Lme/ahoo/wow/modeling/matedata/AggregateMetadata;", "Lme/ahoo/wow/tck/modeling/MockAggregate;", "getAggregateMetadata", "()Lme/ahoo/wow/modeling/matedata/AggregateMetadata;", "stateAggregateFactory", "Lme/ahoo/wow/modeling/state/StateAggregateFactory;", "createSnapshotRepository", "Lme/ahoo/wow/eventsourcing/snapshot/SnapshotRepository;", "load", "", "loadWhenNotFound", "save", "saveTwice", "scrollAggregateId", "wow-tck"})
@SourceDebugExtension(value={"SMAP\nSnapshotRepositorySpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SnapshotRepositorySpec.kt\nme/ahoo/wow/tck/eventsourcing/snapshot/SnapshotRepositorySpec\n+ 2 AggregateMetadataParser.kt\nme/ahoo/wow/modeling/annotation/AggregateMetadataParserKt\n*L\n1#1,183:1\n139#2:184\n*S KotlinDebug\n*F\n+ 1 SnapshotRepositorySpec.kt\nme/ahoo/wow/tck/eventsourcing/snapshot/SnapshotRepositorySpec\n*L\n39#1:184\n*E\n"})
public abstract class SnapshotRepositorySpec {
    @NotNull
    private final AggregateMetadata<MockAggregate, MockAggregate> aggregateMetadata;
    @NotNull
    private final StateAggregateFactory stateAggregateFactory;

    public SnapshotRepositorySpec() {
        boolean $i$f$aggregateMetadata = false;
        this.aggregateMetadata = AggregateMetadataParserKt.asAggregateMetadata(MockAggregate.class);
        this.stateAggregateFactory = (StateAggregateFactory)ConstructorStateAggregateFactory.INSTANCE;
    }

    @NotNull
    protected final AggregateMetadata<MockAggregate, MockAggregate> getAggregateMetadata() {
        return this.aggregateMetadata;
    }

    @NotNull
    protected abstract SnapshotRepository createSnapshotRepository();

    @Test
    public final void load() {
        SnapshotRepository snapshotRepository = Metrics.INSTANCE.metrizable(this.createSnapshotRepository());
        StateAggregateMetadata stateAggregateMetadata = this.aggregateMetadata.getState();
        NamedAggregate namedAggregate = (NamedAggregate)this.aggregateMetadata;
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GlobalIdGenerator.generateAsString()");
        Object object = this.stateAggregateFactory.create(stateAggregateMetadata, (AggregateId)DefaultAggregateIdKt.asAggregateId$default((NamedAggregate)namedAggregate, (String)string, null, (int)2, null)).block();
        Intrinsics.checkNotNull((Object)object);
        StateAggregate stateAggregate = (StateAggregate)object;
        GivenInitializationCommand command = new GivenInitializationCommand(stateAggregate.getAggregateId(), null, null, false, false, 30, null);
        MatcherAssert.assertThat((Object)stateAggregate, (Matcher)Matchers.notNullValue());
        String string2 = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GlobalIdGenerator.generateAsString()");
        AggregateCreated aggregateCreated = new AggregateCreated(string2);
        String string3 = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"GlobalIdGenerator.generateAsString()");
        AggregateChanged changed = new AggregateChanged(string3);
        Object[] objectArray = new Object[]{aggregateCreated, changed};
        DomainEventStream eventStream2 = DomainEventStreamKt.asDomainEventStream$default((Object)CollectionsKt.listOf((Object[])objectArray), (CommandMessage)((CommandMessage)command), (int)stateAggregate.getVersion(), null, (int)4, null);
        stateAggregate.onSourcing(eventStream2);
        SimpleSnapshot snapshot = new SimpleSnapshot(stateAggregate, Clock.systemUTC().millis());
        StepVerifierExtensionsKt.test((Mono)snapshotRepository.save((Snapshot)snapshot)).verifyComplete();
        StepVerifierExtensionsKt.test((Mono)snapshotRepository.load(stateAggregate.getAggregateId())).consumeNextWith(arg_0 -> SnapshotRepositorySpec.load$lambda$0((Function1)new Function1<Snapshot<MockAggregate>, Unit>((StateAggregate<MockAggregate>)stateAggregate){
            final /* synthetic */ StateAggregate<MockAggregate> $stateAggregate;
            {
                this.$stateAggregate = $stateAggregate;
                super(1);
            }

            public final void invoke(Snapshot<MockAggregate> it) {
                MatcherAssert.assertThat((Object)it.getAggregateId(), (Matcher)Matchers.equalTo((Object)this.$stateAggregate.getAggregateId()));
                MatcherAssert.assertThat((Object)it.getVersion(), (Matcher)Matchers.equalTo((Object)this.$stateAggregate.getVersion()));
                MatcherAssert.assertThat((Object)((MockAggregate)it.getStateRoot()).state(), (Matcher)Matchers.equalTo((Object)((MockAggregate)this.$stateAggregate.getStateRoot()).state()));
            }
        }, arg_0)).verifyComplete();
    }

    @Test
    public final void loadWhenNotFound() {
        SnapshotRepository snapshotRepository = Metrics.INSTANCE.metrizable(this.createSnapshotRepository());
        NamedAggregate namedAggregate = (NamedAggregate)this.aggregateMetadata;
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GlobalIdGenerator.generateAsString()");
        DefaultAggregateId aggregateId = DefaultAggregateIdKt.asAggregateId$default((NamedAggregate)namedAggregate, (String)string, null, (int)2, null);
        StepVerifierExtensionsKt.test((Mono)snapshotRepository.load((AggregateId)aggregateId)).expectNextCount(0L).verifyComplete();
    }

    @Test
    public final void save() {
        SnapshotRepository snapshotRepository = Metrics.INSTANCE.metrizable(this.createSnapshotRepository());
        NamedAggregate namedAggregate = (NamedAggregate)this.aggregateMetadata;
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GlobalIdGenerator.generateAsString()");
        DefaultAggregateId aggregateId = DefaultAggregateIdKt.asAggregateId$default((NamedAggregate)namedAggregate, (String)string, null, (int)2, null);
        Object object = this.stateAggregateFactory.create(this.aggregateMetadata.getState(), (AggregateId)aggregateId).block();
        Intrinsics.checkNotNull((Object)object);
        StateAggregate stateAggregate = (StateAggregate)object;
        Snapshot snapshot = (Snapshot)new SimpleSnapshot(stateAggregate, Clock.systemUTC().millis());
        StepVerifierExtensionsKt.test((Mono)snapshotRepository.save(snapshot)).verifyComplete();
    }

    @Test
    public void saveTwice() {
        SnapshotRepository snapshotRepository = Metrics.INSTANCE.metrizable(this.createSnapshotRepository());
        StateAggregateMetadata stateAggregateMetadata = this.aggregateMetadata.getState();
        NamedAggregate namedAggregate = (NamedAggregate)this.aggregateMetadata;
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GlobalIdGenerator.generateAsString()");
        Object object = this.stateAggregateFactory.create(stateAggregateMetadata, (AggregateId)DefaultAggregateIdKt.asAggregateId$default((NamedAggregate)namedAggregate, (String)string, null, (int)2, null)).block();
        Intrinsics.checkNotNull((Object)object);
        StateAggregate stateAggregate = (StateAggregate)object;
        GivenInitializationCommand command = new GivenInitializationCommand(stateAggregate.getAggregateId(), null, null, false, false, 30, null);
        MatcherAssert.assertThat((Object)stateAggregate, (Matcher)Matchers.notNullValue());
        String string2 = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GlobalIdGenerator.generateAsString()");
        AggregateCreated aggregateCreated = new AggregateCreated(string2);
        String string3 = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"GlobalIdGenerator.generateAsString()");
        AggregateChanged changed = new AggregateChanged(string3);
        Object[] objectArray = new Object[]{aggregateCreated, changed};
        DomainEventStream eventStream2 = DomainEventStreamKt.asDomainEventStream$default((Object)CollectionsKt.listOf((Object[])objectArray), (CommandMessage)((CommandMessage)command), (int)stateAggregate.getVersion(), null, (int)4, null);
        stateAggregate.onSourcing(eventStream2);
        SimpleSnapshot snapshot = new SimpleSnapshot(stateAggregate, Clock.systemUTC().millis());
        StepVerifierExtensionsKt.test((Mono)snapshotRepository.save((Snapshot)snapshot)).verifyComplete();
        Object[] objectArray2 = new Object[]{aggregateCreated, changed};
        DomainEventStream eventStream22 = DomainEventStreamKt.asDomainEventStream$default((Object)CollectionsKt.listOf((Object[])objectArray2), (CommandMessage)((CommandMessage)command), (int)stateAggregate.getVersion(), null, (int)4, null);
        stateAggregate.onSourcing(eventStream22);
        StepVerifierExtensionsKt.test((Mono)snapshotRepository.save((Snapshot)snapshot)).verifyComplete();
        StepVerifierExtensionsKt.test((Mono)snapshotRepository.load(stateAggregate.getAggregateId())).consumeNextWith(arg_0 -> SnapshotRepositorySpec.saveTwice$lambda$1((Function1)new Function1<Snapshot<MockAggregate>, Unit>((StateAggregate<MockAggregate>)stateAggregate){
            final /* synthetic */ StateAggregate<MockAggregate> $stateAggregate;
            {
                this.$stateAggregate = $stateAggregate;
                super(1);
            }

            public final void invoke(Snapshot<MockAggregate> it) {
                MatcherAssert.assertThat((Object)it.getAggregateId(), (Matcher)Matchers.equalTo((Object)this.$stateAggregate.getAggregateId()));
                MatcherAssert.assertThat((Object)it.getVersion(), (Matcher)Matchers.equalTo((Object)this.$stateAggregate.getVersion()));
                MatcherAssert.assertThat((Object)((MockAggregate)it.getStateRoot()).state(), (Matcher)Matchers.equalTo((Object)((MockAggregate)this.$stateAggregate.getStateRoot()).state()));
            }
        }, arg_0)).verifyComplete();
    }

    @Test
    public void scrollAggregateId() {
        SnapshotRepository snapshotRepository = Metrics.INSTANCE.metrizable(this.createSnapshotRepository());
        NamedAggregate namedAggregate = (NamedAggregate)this.aggregateMetadata;
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GlobalIdGenerator.generateAsString()");
        DefaultAggregateId aggregateId = DefaultAggregateIdKt.asAggregateId$default((NamedAggregate)namedAggregate, (String)string, null, (int)2, null);
        Object object = this.stateAggregateFactory.create(this.aggregateMetadata.getState(), (AggregateId)aggregateId).block();
        Intrinsics.checkNotNull((Object)object);
        StateAggregate stateAggregate = (StateAggregate)object;
        Snapshot snapshot = (Snapshot)new SimpleSnapshot(stateAggregate, Clock.systemUTC().millis());
        StepVerifierExtensionsKt.test((Mono)snapshotRepository.save(snapshot)).verifyComplete();
        StepVerifierExtensionsKt.test((Flux)SnapshotRepository.scrollAggregateId$default((SnapshotRepository)snapshotRepository, (NamedAggregate)((NamedAggregate)aggregateId), null, (int)1, (int)2, null)).expectNextCount(1L).verifyComplete();
    }

    private static final void load$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void saveTwice$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

