/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.tck.event;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.messaging.Message;
import me.ahoo.wow.api.modeling.AggregateId;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.configuration.MetadataSearcherKt;
import me.ahoo.wow.event.DomainEventBus;
import me.ahoo.wow.event.DomainEventStream;
import me.ahoo.wow.id.GlobalIdGenerator;
import me.ahoo.wow.messaging.MessageBusKt;
import me.ahoo.wow.metrics.Metrics;
import me.ahoo.wow.modeling.DefaultAggregateIdKt;
import me.ahoo.wow.tck.event.DomainEventBusSpec;
import me.ahoo.wow.tck.event.MockDomainEventBusReceiveEvent;
import me.ahoo.wow.tck.event.MockDomainEventBusSendEvent;
import me.ahoo.wow.tck.eventsourcing.MockDomainEventStreams;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;
import reactor.core.scheduler.Schedulers;
import reactor.kotlin.test.StepVerifierExtensionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH$J\b\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\r\u001a\u00020\fH\u0007J\b\u0010\u000e\u001a\u00020\fH\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lme/ahoo/wow/tck/event/DomainEventBusSpec;", "", "()V", "namedAggregateForReceive", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "getNamedAggregateForReceive", "()Lme/ahoo/wow/api/modeling/NamedAggregate;", "namedAggregateForSend", "getNamedAggregateForSend", "createEventBus", "Lme/ahoo/wow/event/DomainEventBus;", "receive", "", "send", "sendPerformance", "Companion", "wow-tck"})
public abstract class DomainEventBusSpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NamedAggregate namedAggregateForSend = MetadataSearcherKt.asRequiredNamedAggregate(MockDomainEventBusSendEvent.class);
    @NotNull
    private final NamedAggregate namedAggregateForReceive = MetadataSearcherKt.asRequiredNamedAggregate(MockDomainEventBusReceiveEvent.class);
    private static final Logger log = LoggerFactory.getLogger(DomainEventBusSpec.class);

    @NotNull
    protected final NamedAggregate getNamedAggregateForSend() {
        return this.namedAggregateForSend;
    }

    @NotNull
    protected final NamedAggregate getNamedAggregateForReceive() {
        return this.namedAggregateForReceive;
    }

    @NotNull
    protected abstract DomainEventBus createEventBus();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void send() {
        AutoCloseable autoCloseable = (AutoCloseable)Metrics.INSTANCE.metrizable(this.createEventBus());
        Throwable throwable = null;
        try {
            DomainEventBus eventBus = (DomainEventBus)autoCloseable;
            boolean bl = false;
            String string = GlobalIdGenerator.INSTANCE.generateAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GlobalIdGenerator.generateAsString()");
            DomainEventStream eventStream2 = MockDomainEventStreams.generateEventStream$default(MockDomainEventStreams.INSTANCE, (AggregateId)DefaultAggregateIdKt.asAggregateId$default((NamedAggregate)this.namedAggregateForSend, (String)string, null, (int)2, null), 0, 1, send.1.eventStream.1.INSTANCE, null, 18, null);
            Duration duration2 = StepVerifierExtensionsKt.test((Mono)eventBus.send((Message)eventStream2)).verifyComplete();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Test
    public final void receive() {
        DomainEventBus eventBus = Metrics.INSTANCE.metrizable(this.createEventBus());
        Flux flux = eventBus.receive(SetsKt.setOf((Object)this.namedAggregateForReceive));
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GlobalIdGenerator.generateAsString()");
        StepVerifierExtensionsKt.test((Flux)MessageBusKt.writeReceiverGroup((Flux)flux, (String)string)).consumeSubscriptionWith(arg_0 -> DomainEventBusSpec.receive$lambda$1((Function1)new Function1<Subscription, Unit>(this, eventBus){
            final /* synthetic */ DomainEventBusSpec this$0;
            final /* synthetic */ DomainEventBus $eventBus;
            {
                this.this$0 = $receiver;
                this.$eventBus = $eventBus;
                super(1);
            }

            public final void invoke(Subscription it) {
                Flux.range((int)0, (int)10).flatMap(arg_0 -> receive.1.invoke$lambda$0((Function1)new Function1<Integer, Publisher<? extends Void>>(this.this$0, this.$eventBus){
                    final /* synthetic */ DomainEventBusSpec this$0;
                    final /* synthetic */ DomainEventBus $eventBus;
                    {
                        this.this$0 = $receiver;
                        this.$eventBus = $eventBus;
                        super(1);
                    }

                    public final Publisher<? extends Void> invoke(Integer it) {
                        NamedAggregate namedAggregate = this.this$0.getNamedAggregateForReceive();
                        String string = GlobalIdGenerator.INSTANCE.generateAsString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GlobalIdGenerator.generateAsString()");
                        DomainEventStream eventStream2 = MockDomainEventStreams.generateEventStream$default(MockDomainEventStreams.INSTANCE, (AggregateId)DefaultAggregateIdKt.asAggregateId$default((NamedAggregate)namedAggregate, (String)string, null, (int)2, null), 0, 1, receive.eventStream.1.INSTANCE, null, 18, null);
                        return (Publisher)this.$eventBus.send((Message)eventStream2);
                    }
                }, arg_0)).delaySubscription(Duration.ofSeconds(1L)).subscribe();
            }

            private static final Publisher invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Publisher)$tmp0.invoke(p0);
            }
        }, arg_0)).expectNextCount(10L).verifyTimeout(Duration.ofSeconds(2L));
    }

    @Test
    public final void sendPerformance() {
        DomainEventBus eventBus = Metrics.INSTANCE.metrizable(this.createEventBus());
        int maxTimes = 20000;
        Flux flux = Flux.generate(DomainEventBusSpec::sendPerformance$lambda$2, (arg_0, arg_1) -> DomainEventBusSpec.sendPerformance$lambda$3(maxTimes, this, arg_0, arg_1)).subscribeOn(Schedulers.boundedElastic()).flatMap(arg_0 -> DomainEventBusSpec.sendPerformance$lambda$4((Function1)new Function1<DomainEventStream, Publisher<? extends Void>>(eventBus){
            final /* synthetic */ DomainEventBus $eventBus;
            {
                this.$eventBus = $eventBus;
                super(1);
            }

            public final Publisher<? extends Void> invoke(DomainEventStream it) {
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                return (Publisher)this.$eventBus.send((Message)it);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"eventBus = createEventBu\u2026us.send(it)\n            }");
        Duration duration2 = StepVerifierExtensionsKt.test((Flux)flux).verifyComplete();
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"eventBus = createEventBu\u2026        .verifyComplete()");
        Duration duration3 = duration2;
        log.info('[' + this.getClass().getSimpleName() + "] sendPerformance - duration:{}", (Object)duration3);
    }

    private static final void receive$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Integer sendPerformance$lambda$2() {
        return 0;
    }

    private static final Integer sendPerformance$lambda$3(int $maxTimes, DomainEventBusSpec this$0, Integer state, SynchronousSink sink) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)state, (String)"state");
        if (state < $maxTimes) {
            NamedAggregate namedAggregate = this$0.namedAggregateForReceive;
            String string = GlobalIdGenerator.INSTANCE.generateAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GlobalIdGenerator.generateAsString()");
            DomainEventStream eventStream2 = MockDomainEventStreams.generateEventStream$default(MockDomainEventStreams.INSTANCE, (AggregateId)DefaultAggregateIdKt.asAggregateId$default((NamedAggregate)namedAggregate, (String)string, null, (int)2, null), 0, 1, sendPerformance.duration.2.eventStream.1.INSTANCE, null, 18, null);
            sink.next((Object)eventStream2);
        } else {
            sink.complete();
        }
        return state + 1;
    }

    private static final Publisher sendPerformance$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/wow/tck/event/DomainEventBusSpec$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "wow-tck"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

