/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.tck.command;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import javax.validation.Validator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.command.CommandMessage;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.command.CommandBus;
import me.ahoo.wow.command.CommandGateway;
import me.ahoo.wow.command.CommandResult;
import me.ahoo.wow.command.DefaultCommandGateway;
import me.ahoo.wow.command.ServerCommandExchange;
import me.ahoo.wow.command.SimpleCommandMessageKt;
import me.ahoo.wow.command.validation.NoOpValidator;
import me.ahoo.wow.command.wait.CommandStage;
import me.ahoo.wow.command.wait.CommandWaitEndpoint;
import me.ahoo.wow.command.wait.SimpleCommandWaitEndpoint;
import me.ahoo.wow.command.wait.SimpleWaitSignal;
import me.ahoo.wow.command.wait.SimpleWaitStrategyRegistrar;
import me.ahoo.wow.command.wait.WaitSignal;
import me.ahoo.wow.command.wait.WaitStrategyRegistrar;
import me.ahoo.wow.configuration.MetadataSearcherKt;
import me.ahoo.wow.id.GlobalIdGenerator;
import me.ahoo.wow.infra.idempotency.BloomFilterIdempotencyChecker;
import me.ahoo.wow.infra.idempotency.IdempotencyChecker;
import me.ahoo.wow.metrics.Metrics;
import me.ahoo.wow.tck.command.CommandGatewaySpec;
import me.ahoo.wow.tck.command.MockSendCommand;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.kotlin.test.StepVerifierExtensionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001b\u001a\u00020\u0004H$J\b\u0010\u001c\u001a\u00020\u001dH\u0007J\b\u0010\u001e\u001a\u00020\u001dH\u0007J\b\u0010\u001f\u001a\u00020\u001dH\u0007J\b\u0010 \u001a\u00020\u001dH\u0007J\b\u0010!\u001a\u00020\u001dH\u0007J\b\u0010\"\u001a\u00020\u001dH\u0007R\u001a\u0010\u0003\u001a\u00020\u0004X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006#"}, d2={"Lme/ahoo/wow/tck/command/CommandGatewaySpec;", "", "()V", "commandBus", "Lme/ahoo/wow/command/CommandBus;", "getCommandBus", "()Lme/ahoo/wow/command/CommandBus;", "setCommandBus", "(Lme/ahoo/wow/command/CommandBus;)V", "commandGateway", "Lme/ahoo/wow/command/CommandGateway;", "getCommandGateway", "()Lme/ahoo/wow/command/CommandGateway;", "setCommandGateway", "(Lme/ahoo/wow/command/CommandGateway;)V", "idempotencyChecker", "Lme/ahoo/wow/infra/idempotency/IdempotencyChecker;", "getIdempotencyChecker", "()Lme/ahoo/wow/infra/idempotency/IdempotencyChecker;", "namedAggregate", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "getNamedAggregate", "()Lme/ahoo/wow/api/modeling/NamedAggregate;", "waitStrategyRegistrar", "Lme/ahoo/wow/command/wait/SimpleWaitStrategyRegistrar;", "getWaitStrategyRegistrar", "()Lme/ahoo/wow/command/wait/SimpleWaitStrategyRegistrar;", "createCommandBus", "receive", "", "send", "sendGivenDuplicate", "sendGivenTimeout", "sendThenWaitingForAggregate", "setup", "wow-tck"})
public abstract class CommandGatewaySpec {
    @NotNull
    private final NamedAggregate namedAggregate = MetadataSearcherKt.asRequiredNamedAggregate(MockSendCommand.class);
    @NotNull
    private final SimpleWaitStrategyRegistrar waitStrategyRegistrar = SimpleWaitStrategyRegistrar.INSTANCE;
    @NotNull
    private final IdempotencyChecker idempotencyChecker;
    protected CommandBus commandBus;
    protected CommandGateway commandGateway;

    public CommandGatewaySpec() {
        Duration duration2 = Duration.ofSeconds(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(1)");
        this.idempotencyChecker = (IdempotencyChecker)new BloomFilterIdempotencyChecker(duration2, (Function0)idempotencyChecker.1.INSTANCE);
    }

    @NotNull
    protected final NamedAggregate getNamedAggregate() {
        return this.namedAggregate;
    }

    @NotNull
    protected final SimpleWaitStrategyRegistrar getWaitStrategyRegistrar() {
        return this.waitStrategyRegistrar;
    }

    @NotNull
    protected final IdempotencyChecker getIdempotencyChecker() {
        return this.idempotencyChecker;
    }

    @NotNull
    protected final CommandBus getCommandBus() {
        CommandBus commandBus = this.commandBus;
        if (commandBus != null) {
            return commandBus;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"commandBus");
        return null;
    }

    protected final void setCommandBus(@NotNull CommandBus commandBus) {
        Intrinsics.checkNotNullParameter((Object)commandBus, (String)"<set-?>");
        this.commandBus = commandBus;
    }

    @NotNull
    protected final CommandGateway getCommandGateway() {
        CommandGateway commandGateway = this.commandGateway;
        if (commandGateway != null) {
            return commandGateway;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"commandGateway");
        return null;
    }

    protected final void setCommandGateway(@NotNull CommandGateway commandGateway) {
        Intrinsics.checkNotNullParameter((Object)commandGateway, (String)"<set-?>");
        this.commandGateway = commandGateway;
    }

    @NotNull
    protected abstract CommandBus createCommandBus();

    @BeforeEach
    public final void setup() {
        this.setCommandBus(Metrics.INSTANCE.metrizable(this.createCommandBus()));
        this.setCommandGateway((CommandGateway)new DefaultCommandGateway((CommandWaitEndpoint)new SimpleCommandWaitEndpoint(""), this.getCommandBus(), this.idempotencyChecker, (WaitStrategyRegistrar)this.waitStrategyRegistrar, (Validator)NoOpValidator.INSTANCE));
    }

    @Test
    public final void send() {
        Schedulers.single().schedule(() -> CommandGatewaySpec.send$lambda$0(this));
        CommandGateway commandGateway = this.getCommandGateway();
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GlobalIdGenerator.generateAsString()");
        StepVerifierExtensionsKt.test((Mono)commandGateway.sendAndWaitForSent(SimpleCommandMessageKt.asCommandMessage$default((Object)new MockSendCommand(string), null, null, null, null, null, null, null, (long)0L, (int)255, null))).expectNextCount(1L).verifyComplete();
    }

    @Test
    public final void sendGivenTimeout() {
        CommandGateway commandGateway = this.getCommandGateway();
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GlobalIdGenerator.generateAsString()");
        Mono mono = commandGateway.sendAndWaitForProcessed(SimpleCommandMessageKt.asCommandMessage$default((Object)new MockSendCommand(string), null, null, null, null, null, null, null, (long)0L, (int)255, null)).timeout(Duration.ofMillis(100L));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"commandGateway.sendAndWa\u2026t(Duration.ofMillis(100))");
        StepVerifierExtensionsKt.test((Mono)mono).verifyTimeout(Duration.ofMillis(150L));
    }

    @Test
    public final void sendGivenDuplicate() {
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GlobalIdGenerator.generateAsString()");
        CommandMessage commandMessage = SimpleCommandMessageKt.asCommandMessage$default((Object)new MockSendCommand(string), null, null, null, null, null, null, null, (long)0L, (int)255, null);
        Schedulers.single().schedule(() -> CommandGatewaySpec.sendGivenDuplicate$lambda$1(this));
        StepVerifierExtensionsKt.test((Mono)this.getCommandGateway().sendAndWaitForSent(commandMessage)).expectNextCount(1L).verifyComplete();
        StepVerifierExtensionsKt.test((Mono)this.getCommandGateway().sendAndWaitForSent(commandMessage)).consumeNextWith(arg_0 -> CommandGatewaySpec.sendGivenDuplicate$lambda$2(sendGivenDuplicate.2.INSTANCE, arg_0)).verifyComplete();
    }

    @Test
    public final void sendThenWaitingForAggregate() {
        Schedulers.single().schedule(() -> CommandGatewaySpec.sendThenWaitingForAggregate$lambda$4(this));
        CommandGateway commandGateway = this.getCommandGateway();
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GlobalIdGenerator.generateAsString()");
        StepVerifierExtensionsKt.test((Mono)commandGateway.sendAndWaitForProcessed(SimpleCommandMessageKt.asCommandMessage$default((Object)new MockSendCommand(string), null, null, null, null, null, null, null, (long)0L, (int)255, null))).expectNextCount(1L).verifyComplete();
    }

    @Test
    public final void receive() {
        StepVerifierExtensionsKt.test((Flux)this.getCommandGateway().receive(SetsKt.setOf((Object)this.namedAggregate))).consumeSubscriptionWith(arg_0 -> CommandGatewaySpec.receive$lambda$5((Function1)new Function1<Subscription, Unit>(this){
            final /* synthetic */ CommandGatewaySpec this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Subscription it) {
                Schedulers.single().schedule(() -> receive.1.invoke$lambda$1(this.this$0), 10L, TimeUnit.MILLISECONDS);
            }

            private static final Publisher invoke$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Publisher)$tmp0.invoke(p0);
            }

            private static final void invoke$lambda$1(CommandGatewaySpec this$0) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Flux.range((int)0, (int)10).flatMap(arg_0 -> receive.1.invoke$lambda$1$lambda$0((Function1)new Function1<Integer, Publisher<? extends CommandResult>>(this$0){
                    final /* synthetic */ CommandGatewaySpec this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final Publisher<? extends CommandResult> invoke(Integer it) {
                        CommandGateway commandGateway = this.this$0.getCommandGateway();
                        String string = GlobalIdGenerator.INSTANCE.generateAsString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GlobalIdGenerator.generateAsString()");
                        return (Publisher)commandGateway.sendAndWaitForSent(SimpleCommandMessageKt.asCommandMessage$default((Object)new MockSendCommand(string), null, null, null, null, null, null, null, (long)0L, (int)255, null));
                    }
                }, arg_0)).subscribe();
            }
        }, arg_0)).expectNextCount(10L).verifyTimeout(Duration.ofSeconds(2L));
    }

    private static final void send$lambda$0(CommandGatewaySpec this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.getCommandGateway().receive(SetsKt.setOf((Object)this$0.namedAggregate)).subscribe();
    }

    private static final void sendGivenDuplicate$lambda$1(CommandGatewaySpec this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.getCommandBus().receive(SetsKt.setOf((Object)this$0.namedAggregate)).subscribe();
    }

    private static final void sendGivenDuplicate$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void sendThenWaitingForAggregate$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void sendThenWaitingForAggregate$lambda$4(CommandGatewaySpec this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.getCommandGateway().receive(SetsKt.setOf((Object)this$0.namedAggregate)).doOnNext(arg_0 -> CommandGatewaySpec.sendThenWaitingForAggregate$lambda$4$lambda$3((Function1)new Function1<ServerCommandExchange<Object>, Unit>(this$0){
            final /* synthetic */ CommandGatewaySpec this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(ServerCommandExchange<Object> it) {
                Schedulers.boundedElastic().schedule(() -> sendThenWaitingForAggregate.1.1.invoke$lambda$0(this.this$0, it), 10L, TimeUnit.MILLISECONDS);
            }

            private static final void invoke$lambda$0(CommandGatewaySpec this$0, ServerCommandExchange $it) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                this$0.getWaitStrategyRegistrar().next((WaitSignal)new SimpleWaitSignal(((CommandMessage)$it.getMessage()).getCommandId(), CommandStage.PROCESSED, false, null, null, 28, null));
            }
        }, arg_0)).subscribe();
    }

    private static final void receive$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

