/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.wow.tck.command;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.ahoo.wow.api.command.CommandMessage;
import me.ahoo.wow.api.messaging.Message;
import me.ahoo.wow.api.modeling.NamedAggregate;
import me.ahoo.wow.command.CommandBus;
import me.ahoo.wow.command.SimpleCommandMessageKt;
import me.ahoo.wow.configuration.MetadataSearcherKt;
import me.ahoo.wow.id.GlobalIdGenerator;
import me.ahoo.wow.messaging.MessageBusKt;
import me.ahoo.wow.metrics.Metrics;
import me.ahoo.wow.tck.command.CommandBusSpec;
import me.ahoo.wow.tck.command.MockReceiveCommand;
import me.ahoo.wow.tck.command.MockSendCommand;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfEnvironmentVariable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.kotlin.test.StepVerifierExtensionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b&\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH$J\b\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\r\u001a\u00020\fH\u0007J\b\u0010\u000e\u001a\u00020\fH\u0007J \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\n2\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\fH\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lme/ahoo/wow/tck/command/CommandBusSpec;", "", "()V", "namedAggregateForReceive", "Lme/ahoo/wow/api/modeling/NamedAggregate;", "getNamedAggregateForReceive", "()Lme/ahoo/wow/api/modeling/NamedAggregate;", "namedAggregateForSend", "getNamedAggregateForSend", "createCommandBus", "Lme/ahoo/wow/command/CommandBus;", "receive", "", "receivePerformance", "send", "sendLoop", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "commandBus", "maxCount", "", "sendPerformance", "Companion", "wow-tck"})
public abstract class CommandBusSpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NamedAggregate namedAggregateForSend = MetadataSearcherKt.asRequiredNamedAggregate(MockSendCommand.class);
    @NotNull
    private final NamedAggregate namedAggregateForReceive = MetadataSearcherKt.asRequiredNamedAggregate(MockReceiveCommand.class);
    private static final Logger log = LoggerFactory.getLogger(CommandBusSpec.class);

    @NotNull
    protected final NamedAggregate getNamedAggregateForSend() {
        return this.namedAggregateForSend;
    }

    @NotNull
    protected final NamedAggregate getNamedAggregateForReceive() {
        return this.namedAggregateForReceive;
    }

    @NotNull
    protected abstract CommandBus createCommandBus();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public final void send() {
        AutoCloseable autoCloseable = (AutoCloseable)Metrics.INSTANCE.metrizable(this.createCommandBus());
        Throwable throwable = null;
        try {
            CommandBus commandBus = (CommandBus)autoCloseable;
            boolean bl = false;
            String string = GlobalIdGenerator.INSTANCE.generateAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GlobalIdGenerator.generateAsString()");
            CommandMessage commandMessage = SimpleCommandMessageKt.asCommandMessage$default((Object)new MockSendCommand(string), null, null, null, null, null, null, null, (long)0L, (int)255, null);
            Schedulers.single().schedule(() -> CommandBusSpec.send$lambda$1$lambda$0(commandBus, this));
            Duration duration2 = StepVerifierExtensionsKt.test((Mono)commandBus.send((Message)commandMessage)).verifyComplete();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Test
    public final void receive() {
        CommandBus commandBus = Metrics.INSTANCE.metrizable(this.createCommandBus());
        Flux flux = commandBus.receive(SetsKt.setOf((Object)this.namedAggregateForReceive));
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GlobalIdGenerator.generateAsString()");
        StepVerifierExtensionsKt.test((Flux)MessageBusKt.writeReceiverGroup((Flux)flux, (String)string)).consumeSubscriptionWith(arg_0 -> CommandBusSpec.receive$lambda$2((Function1)new Function1<Subscription, Unit>(commandBus){
            final /* synthetic */ CommandBus $commandBus;
            {
                this.$commandBus = $commandBus;
                super(1);
            }

            public final void invoke(Subscription it) {
                Flux.range((int)0, (int)10).publishOn(Schedulers.boundedElastic()).map(arg_0 -> receive.1.invoke$lambda$0((Function1)new Function1<Integer, Disposable>(this.$commandBus){
                    final /* synthetic */ CommandBus $commandBus;
                    {
                        this.$commandBus = $commandBus;
                        super(1);
                    }

                    public final Disposable invoke(Integer it) {
                        String string = GlobalIdGenerator.INSTANCE.generateAsString();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GlobalIdGenerator.generateAsString()");
                        CommandMessage commandMessage = SimpleCommandMessageKt.asCommandMessage$default((Object)new MockReceiveCommand(string), null, null, null, null, null, null, null, (long)0L, (int)255, null);
                        return this.$commandBus.send((Message)commandMessage).subscribe();
                    }
                }, arg_0)).delaySubscription(Duration.ofSeconds(1L)).subscribe();
            }

            private static final Disposable invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Disposable)$tmp0.invoke(p0);
            }
        }, arg_0)).expectNextCount(10L).verifyTimeout(Duration.ofSeconds(2L));
    }

    @Test
    public final void sendPerformance() {
        CommandBus commandBus = Metrics.INSTANCE.metrizable(this.createCommandBus());
        Duration duration2 = StepVerifierExtensionsKt.test((Mono)CommandBusSpec.sendLoop$default(this, commandBus, 0, 2, null)).verifyComplete();
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"sendLoop(commandBus = co\u2026        .verifyComplete()");
        Duration duration3 = duration2;
        log.info('[' + this.getClass().getSimpleName() + "] sendPerformance - duration:{}", (Object)duration3);
    }

    private final Mono<Void> sendLoop(CommandBus commandBus, int maxCount) {
        Mono mono = Flux.range((int)0, (int)maxCount).publishOn(Schedulers.boundedElastic()).map(arg_0 -> CommandBusSpec.sendLoop$lambda$3(sendLoop.1.INSTANCE, arg_0)).flatMap(arg_0 -> CommandBusSpec.sendLoop$lambda$4((Function1)new Function1<CommandMessage<MockSendCommand>, Publisher<? extends Void>>(commandBus){
            final /* synthetic */ CommandBus $commandBus;
            {
                this.$commandBus = $commandBus;
                super(1);
            }

            public final Publisher<? extends Void> invoke(CommandMessage<MockSendCommand> it) {
                Intrinsics.checkNotNullExpressionValue(it, (String)"it");
                return (Publisher)this.$commandBus.send((Message)it);
            }
        }, arg_0)).then();
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"commandBus: CommandBus, \u2026(it)\n            }.then()");
        return mono;
    }

    static /* synthetic */ Mono sendLoop$default(CommandBusSpec commandBusSpec, CommandBus commandBus, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sendLoop");
        }
        if ((n2 & 2) != 0) {
            n = 2000;
        }
        return commandBusSpec.sendLoop(commandBus, n);
    }

    @DisabledIfEnvironmentVariable(named="CI", matches=".*")
    @Test
    public final void receivePerformance() {
        CommandBus commandBus = Metrics.INSTANCE.metrizable(this.createCommandBus());
        long maxCount = 2000L;
        Flux flux = commandBus.receive(SetsKt.setOf((Object)this.namedAggregateForSend));
        String string = GlobalIdGenerator.INSTANCE.generateAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GlobalIdGenerator.generateAsString()");
        Duration duration2 = StepVerifierExtensionsKt.test((Flux)MessageBusKt.writeReceiverGroup((Flux)flux, (String)string)).consumeSubscriptionWith(arg_0 -> CommandBusSpec.receivePerformance$lambda$5((Function1)new Function1<Subscription, Unit>(this, commandBus, maxCount){
            final /* synthetic */ CommandBusSpec this$0;
            final /* synthetic */ CommandBus $commandBus;
            final /* synthetic */ long $maxCount;
            {
                this.this$0 = $receiver;
                this.$commandBus = $commandBus;
                this.$maxCount = $maxCount;
                super(1);
            }

            public final void invoke(Subscription it) {
                CommandBusSpec.access$sendLoop(this.this$0, this.$commandBus, (int)this.$maxCount).delaySubscription(Duration.ofSeconds(1L)).subscribe();
            }
        }, arg_0)).expectNextCount(maxCount).verifyTimeout(Duration.ofSeconds(2L));
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"@DisabledIfEnvironmentVa\u2026tion:{}\", duration)\n    }");
        Duration duration3 = duration2;
        log.info('[' + this.getClass().getSimpleName() + "] receivePerformance - duration:{}", (Object)duration3);
    }

    private static final void send$lambda$1$lambda$0(CommandBus $commandBus, CommandBusSpec this$0) {
        Intrinsics.checkNotNullParameter((Object)$commandBus, (String)"$commandBus");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $commandBus.receive(SetsKt.setOf((Object)this$0.namedAggregateForSend)).subscribe();
    }

    private static final void receive$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final CommandMessage sendLoop$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CommandMessage)$tmp0.invoke(p0);
    }

    private static final Publisher sendLoop$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final void receivePerformance$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Mono access$sendLoop(CommandBusSpec $this, CommandBus commandBus, int maxCount) {
        return $this.sendLoop(commandBus, maxCount);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lme/ahoo/wow/tck/command/CommandBusSpec$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "wow-tck"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

