/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.simba.spring.redis;

import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import me.ahoo.simba.core.MutexContendService;
import me.ahoo.simba.core.MutexContendServiceFactory;
import me.ahoo.simba.core.MutexContender;
import me.ahoo.simba.spring.redis.SpringRedisMutexContendService;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;

public class SpringRedisMutexContendServiceFactory
implements MutexContendServiceFactory {
    private final Duration ttl;
    private final Duration transition;
    private final StringRedisTemplate redisTemplate;
    private final RedisMessageListenerContainer listenerContainer;
    private final Executor handleExecutor;
    private final ScheduledExecutorService scheduledExecutorService;

    public SpringRedisMutexContendServiceFactory(Duration ttl, Duration transition, StringRedisTemplate redisTemplate, RedisMessageListenerContainer listenerContainer) {
        this(ttl, transition, redisTemplate, listenerContainer, ForkJoinPool.commonPool(), Executors.newScheduledThreadPool(1));
    }

    public SpringRedisMutexContendServiceFactory(Duration ttl, Duration transition, StringRedisTemplate redisTemplate, RedisMessageListenerContainer listenerContainer, Executor handleExecutor, ScheduledExecutorService scheduledExecutorService) {
        this.ttl = ttl;
        this.transition = transition;
        this.redisTemplate = redisTemplate;
        this.listenerContainer = listenerContainer;
        this.handleExecutor = handleExecutor;
        this.scheduledExecutorService = scheduledExecutorService;
    }

    public MutexContendService createMutexContendService(MutexContender mutexContender) {
        return new SpringRedisMutexContendService(mutexContender, this.handleExecutor, this.ttl, this.transition, this.redisTemplate, this.listenerContainer, this.scheduledExecutorService);
    }
}

