/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.simba.spring.redis;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import me.ahoo.simba.core.AbstractMutexContendService;
import me.ahoo.simba.core.ContendPeriod;
import me.ahoo.simba.core.MutexContender;
import me.ahoo.simba.core.MutexOwner;
import me.ahoo.simba.spring.redis.AcquireResult;
import me.ahoo.simba.spring.redis.OwnerEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;

public class SpringRedisMutexContendService
extends AbstractMutexContendService {
    private static final Logger log = LoggerFactory.getLogger(SpringRedisMutexContendService.class);
    private static final Resource ACQUIRE_RESOURCE = new ClassPathResource("mutex_acquire.lua");
    private static final RedisScript<String> SCRIPT_ACQUIRE = RedisScript.of((Resource)ACQUIRE_RESOURCE, String.class);
    private static final Resource RELEASE_RESOURCE = new ClassPathResource("mutex_release.lua");
    private static final RedisScript<Boolean> SCRIPT_RELEASE = RedisScript.of((Resource)RELEASE_RESOURCE, Boolean.class);
    private static final Resource GUARD_RESOURCE = new ClassPathResource("mutex_guard.lua");
    private static final RedisScript<String> SCRIPT_GUARD = RedisScript.of((Resource)GUARD_RESOURCE, String.class);
    private final List<String> keys;
    private final String mutexChannel;
    private final String contenderChannel;
    private final List<ChannelTopic> listenTopics;
    private final Duration ttl;
    private final Duration transition;
    private final ContendPeriod contendPeriod;
    private final StringRedisTemplate redisTemplate;
    private final RedisMessageListenerContainer listenerContainer;
    private final MutexMessageListener mutexMessageListener;
    private final ScheduledExecutorService scheduledExecutorService;
    private ScheduledFuture<MutexOwner> scheduleFuture;

    protected SpringRedisMutexContendService(MutexContender contender, Executor handleExecutor, Duration ttl, Duration transition, StringRedisTemplate redisTemplate, RedisMessageListenerContainer listenerContainer, ScheduledExecutorService scheduledExecutorService) {
        super(contender, handleExecutor);
        this.keys = Lists.newArrayList((Object[])new String[]{"{" + contender.getMutex() + "}"});
        this.mutexChannel = Strings.lenientFormat((String)"%s:{%s}", (Object[])new Object[]{"simba", contender.getMutex()});
        this.contenderChannel = Strings.lenientFormat((String)"%s:%s", (Object[])new Object[]{this.mutexChannel, contender.getContenderId()});
        this.scheduledExecutorService = scheduledExecutorService;
        this.listenTopics = Arrays.asList(new ChannelTopic(this.mutexChannel), new ChannelTopic(this.contenderChannel));
        this.ttl = ttl;
        this.transition = transition;
        this.redisTemplate = redisTemplate;
        this.listenerContainer = listenerContainer;
        this.contendPeriod = new ContendPeriod(this.getContenderId());
        this.mutexMessageListener = new MutexMessageListener();
    }

    protected void startContend() {
        this.startSubscribe();
        this.nextSchedule(0L);
    }

    private void startSubscribe() {
        this.listenerContainer.addMessageListener((MessageListener)this.mutexMessageListener, this.listenTopics);
    }

    private void nextSchedule(long nextDelay) {
        if (log.isDebugEnabled()) {
            log.debug("nextSchedule - mutex:[{}] contenderId:[{}] - nextDelay:[{}].", new Object[]{this.getMutex(), this.getContenderId(), nextDelay});
        }
        this.scheduleFuture = this.scheduledExecutorService.schedule(() -> {
            if (this.isOwner()) {
                return this.guard();
            }
            return this.acquire();
        }, nextDelay, TimeUnit.MILLISECONDS);
    }

    private MutexOwner notifyOwnerAndScheduleNext(String resultStr) {
        try {
            AcquireResult result = AcquireResult.of(resultStr);
            MutexOwner mutexOwner = this.newMutexOwner(result);
            this.notifyOwner(mutexOwner);
            long nextDelay = this.contendPeriod.ensureNextDelay(mutexOwner);
            this.nextSchedule(nextDelay);
            return mutexOwner;
        }
        catch (Throwable throwable) {
            if (log.isErrorEnabled()) {
                log.error(throwable.getMessage(), throwable);
            }
            this.nextSchedule(this.ttl.toMillis());
            return MutexOwner.NONE;
        }
    }

    private MutexOwner guard() {
        String message = (String)this.redisTemplate.execute(SCRIPT_GUARD, this.keys, new Object[]{this.getContenderId(), String.valueOf(this.ttl.toMillis())});
        return this.notifyOwnerAndScheduleNext(message);
    }

    private MutexOwner acquire() {
        String message = (String)this.redisTemplate.execute(SCRIPT_ACQUIRE, this.keys, new Object[]{this.getContenderId(), String.valueOf(this.ttl.toMillis() + this.transition.toMillis())});
        return this.notifyOwnerAndScheduleNext(message);
    }

    private MutexOwner newMutexOwner(AcquireResult result) {
        return this.newMutexOwner(result.getOwnerId(), result.getTransitionAt());
    }

    private MutexOwner newMutexOwner(String ownerId, long transitionAt) {
        long ttlAt = transitionAt - this.transition.toMillis();
        long acquiredAt = ttlAt - this.ttl.toMillis();
        return new MutexOwner(ownerId, acquiredAt, ttlAt, transitionAt);
    }

    private long getTransitionAt(OwnerEvent message) {
        return message.getEventAt() + this.ttl.toMillis() + this.transition.toMillis();
    }

    protected void stopContend() {
        this.stopSubscribe();
        this.disposeSchedule();
        this.release();
    }

    private void stopSubscribe() {
        this.listenerContainer.removeMessageListener((MessageListener)this.mutexMessageListener, this.listenTopics);
    }

    private void disposeSchedule() {
        if (this.scheduleFuture == null || this.scheduleFuture.isDone()) {
            return;
        }
        this.scheduleFuture.cancel(true);
    }

    private void release() {
        block2: {
            Boolean succeed = (Boolean)this.redisTemplate.execute(SCRIPT_RELEASE, this.keys, new Object[]{this.getContenderId()});
            try {
                this.notifyOwner(MutexOwner.NONE);
            }
            catch (Throwable throwable) {
                if (!log.isWarnEnabled()) break block2;
                log.warn("stopContend - mutex:[{}] - contenderId:[{}] - message:[{}]", new Object[]{this.getMutex(), this.getContenderId(), throwable.getMessage()});
            }
        }
    }

    public class MutexMessageListener
    implements MessageListener {
        public void onMessage(Message message, byte[] pattern) {
            String channel = new String(message.getChannel(), StandardCharsets.UTF_8);
            String body = new String(message.getBody(), StandardCharsets.UTF_8);
            if (log.isDebugEnabled()) {
                log.debug("onMessage - mutex:[{}] - ownerId:[{}] - channel:[{}] - message:[{}].", new Object[]{SpringRedisMutexContendService.this.getMutex(), SpringRedisMutexContendService.this.getContenderId(), channel, body});
            }
            OwnerEvent ownerEvent = OwnerEvent.of(body);
            switch (ownerEvent.getEvent()) {
                case "released": {
                    SpringRedisMutexContendService.this.notifyOwner(MutexOwner.NONE);
                    SpringRedisMutexContendService.this.acquire();
                    break;
                }
                case "acquired": {
                    SpringRedisMutexContendService.this.notifyOwner(SpringRedisMutexContendService.this.newMutexOwner(ownerEvent.getOwnerId(), SpringRedisMutexContendService.this.getTransitionAt(ownerEvent)));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + ownerEvent.getEvent());
                }
            }
        }
    }
}

