/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.simba.spring.redis;

import com.google.common.base.Strings;

public class OwnerEvent {
    public static final String EVENT_RELEASED = "released";
    public static final String EVENT_ACQUIRED = "acquired";
    public static final String DELIMITER = "@@";
    private final String event;
    private final String ownerId;
    private final long eventAt = System.currentTimeMillis();

    public OwnerEvent(String event, String ownerId) {
        this.event = event;
        this.ownerId = ownerId;
    }

    public long getEventAt() {
        return this.eventAt;
    }

    public String getEvent() {
        return this.event;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public static OwnerEvent of(String message) {
        String[] msgs = message.split(DELIMITER);
        if (msgs.length != 2) {
            throw new IllegalStateException(Strings.lenientFormat((String)"Incorrect message format:[%s]", (Object[])new Object[]{message}));
        }
        return new OwnerEvent(msgs[0], msgs[1]);
    }
}

